/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.fir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationWithFile;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.fir.ContextCollectingDiagnosticCollectorVisitor;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/fir/PersistenceContextCollector;", "", "()V", "collectContext", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "low-level-api-fir"})
public final class PersistenceContextCollector {
    @NotNull
    public static final PersistenceContextCollector INSTANCE = new PersistenceContextCollector();

    private PersistenceContextCollector() {
    }

    @NotNull
    public final CheckerContext collectContext(@NotNull SessionHolder sessionHolder, @NotNull FirFile firFile, @NotNull FirDeclaration declaration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sessionHolder, (String)"sessionHolder");
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirClassLikeDeclaration) {
            bl = ((FirClassLikeDeclaration)declaration).getSymbol().getClassId().isLocal();
        } else if (firDeclaration instanceof FirCallableDeclaration) {
            bl = ((FirCallableDeclaration)declaration).getSymbol().getCallableId().isLocal();
        } else if (firDeclaration instanceof FirDanglingModifierList) {
            Object object = ClassMembersKt.containingClass((FirDanglingModifierList)declaration);
            bl = object != null && (object = ((ConeClassLikeLookupTag)object).getClassId()) != null ? ((ClassId)object).isLocal() : false;
        } else {
            throw new IllegalStateException(("Unsupported declaration " + UtilsKt.renderWithType(declaration)).toString());
        }
        boolean isLocal2 = bl;
        if (!(!isLocal2)) {
            boolean bl2 = false;
            String string2 = "Cannot collect context for local declaration " + UtilsKt.renderWithType(declaration);
            throw new IllegalArgumentException(string2.toString());
        }
        FirDesignationWithFile designation2 = FirDesignationKt.collectDesignation(declaration, firFile);
        return ContextCollectingDiagnosticCollectorVisitor.Companion.collect(sessionHolder, designation2);
    }
}

