/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedArrayType;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001c\u001a\u00020\u001dR*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u0004j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/builtins/UnsignedTypes;", "", "()V", "arrayClassIdToUnsignedClassId", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lkotlin/collections/HashMap;", "arrayClassesShortNames", "", "Lorg/jetbrains/kotlin/name/Name;", "unsignedArrayTypeNames", "unsignedArrayTypeToArrayCall", "Lorg/jetbrains/kotlin/builtins/UnsignedArrayType;", "getUnsignedArrayTypeToArrayCall", "()Ljava/util/HashMap;", "unsignedClassIdToArrayClassId", "unsignedTypeNames", "getUnsignedArrayClassIdByUnsignedClassId", "arrayClassId", "getUnsignedClassIdByArrayClassId", "isShortNameOfUnsignedArray", "", "name", "isShortNameOfUnsignedType", "isUnsignedArrayClass", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isUnsignedArrayType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isUnsignedClass", "isUnsignedType", "toUnsignedArrayType", "toUnsignedType", "Lorg/jetbrains/kotlin/builtins/UnsignedType;", "descriptors"})
public final class UnsignedTypes {
    @NotNull
    public static final UnsignedTypes INSTANCE;
    @NotNull
    private static final Set<Name> unsignedTypeNames;
    @NotNull
    private static final Set<Name> unsignedArrayTypeNames;
    @NotNull
    private static final HashMap<ClassId, ClassId> arrayClassIdToUnsignedClassId;
    @NotNull
    private static final HashMap<ClassId, ClassId> unsignedClassIdToArrayClassId;
    @NotNull
    private static final HashMap<UnsignedArrayType, Name> unsignedArrayTypeToArrayCall;
    @NotNull
    private static final Set<Name> arrayClassesShortNames;

    private UnsignedTypes() {
    }

    @NotNull
    public final HashMap<UnsignedArrayType, Name> getUnsignedArrayTypeToArrayCall() {
        return unsignedArrayTypeToArrayCall;
    }

    public final boolean isShortNameOfUnsignedArray(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return arrayClassesShortNames.contains(name2);
    }

    public final boolean isShortNameOfUnsignedType(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return unsignedTypeNames.contains(name2);
    }

    @Nullable
    public final ClassId getUnsignedClassIdByArrayClassId(@NotNull ClassId arrayClassId) {
        Intrinsics.checkNotNullParameter((Object)arrayClassId, (String)"arrayClassId");
        return arrayClassIdToUnsignedClassId.get(arrayClassId);
    }

    @Nullable
    public final ClassId getUnsignedArrayClassIdByUnsignedClassId(@NotNull ClassId arrayClassId) {
        Intrinsics.checkNotNullParameter((Object)arrayClassId, (String)"arrayClassId");
        return unsignedClassIdToArrayClassId.get(arrayClassId);
    }

    @JvmStatic
    public static final boolean isUnsignedType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (TypeUtils.noExpectedType(type2)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        return INSTANCE.isUnsignedClass(descriptor2);
    }

    @Nullable
    public final UnsignedType toUnsignedType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return KotlinBuiltIns.isUByte(type2) ? UnsignedType.UBYTE : (KotlinBuiltIns.isUShort(type2) ? UnsignedType.USHORT : (KotlinBuiltIns.isUInt(type2) ? UnsignedType.UINT : (KotlinBuiltIns.isULong(type2) ? UnsignedType.ULONG : null)));
    }

    public final boolean isUnsignedClass(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        return container instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)container).getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && unsignedTypeNames.contains(descriptor2.getName());
    }

    @JvmStatic
    public static final boolean isUnsignedArrayType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (TypeUtils.noExpectedType(type2)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        return INSTANCE.isUnsignedArrayClass(descriptor2);
    }

    @JvmStatic
    @Nullable
    public static final UnsignedArrayType toUnsignedArrayType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return KotlinBuiltIns.isUByteArray(type2) ? UnsignedArrayType.UBYTEARRAY : (KotlinBuiltIns.isUShortArray(type2) ? UnsignedArrayType.USHORTARRAY : (KotlinBuiltIns.isUIntArray(type2) ? UnsignedArrayType.UINTARRAY : (KotlinBuiltIns.isULongArray(type2) ? UnsignedArrayType.ULONGARRAY : null)));
    }

    @JvmStatic
    @Nullable
    public static final UnsignedArrayType toUnsignedArrayType(@NotNull DeclarationDescriptor descriptor2) {
        UnsignedArrayType unsignedArrayType;
        block17: {
            block16: {
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                if (INSTANCE.isUnsignedArrayClass(descriptor2)) break block16;
                unsignedArrayType = null;
                break block17;
            }
            switch (descriptor2.getName().asString()) {
                case "UByteArray": {
                    unsignedArrayType = UnsignedArrayType.UBYTEARRAY;
                    break;
                }
                case "UShortArray": {
                    unsignedArrayType = UnsignedArrayType.USHORTARRAY;
                    break;
                }
                case "UIntArray": {
                    unsignedArrayType = UnsignedArrayType.UINTARRAY;
                    break;
                }
                case "ULongArray": {
                    unsignedArrayType = UnsignedArrayType.ULONGARRAY;
                    break;
                }
                default: {
                    unsignedArrayType = null;
                }
            }
        }
        return unsignedArrayType;
    }

    public final boolean isUnsignedArrayClass(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        return container instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)container).getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && unsignedArrayTypeNames.contains(descriptor2.getName());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_2;
        void $this$mapTo$iv;
        Enum it;
        Collection collection;
        Enum[] $this$mapTo$iv$iv;
        INSTANCE = new UnsignedTypes();
        Enum[] $this$map$iv = UnsignedType.values();
        boolean $i$f$map = false;
        UnsignedType[] unsignedTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Enum item$iv$iv : $this$mapTo$iv$iv) {
            void var8_16 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((UnsignedType)it).getTypeName());
        }
        unsignedTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = UnsignedArrayType.values();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n = $this$mapTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            Enum item$iv$iv;
            it = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((UnsignedArrayType)it).getTypeName());
        }
        unsignedArrayTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        arrayClassIdToUnsignedClassId = new HashMap();
        unsignedClassIdToArrayClassId = new HashMap();
        $this$map$iv = new Pair[]{TuplesKt.to((Object)((Object)UnsignedArrayType.UBYTEARRAY), (Object)Name.identifier("ubyteArrayOf")), TuplesKt.to((Object)((Object)UnsignedArrayType.USHORTARRAY), (Object)Name.identifier("ushortArrayOf")), TuplesKt.to((Object)((Object)UnsignedArrayType.UINTARRAY), (Object)Name.identifier("uintArrayOf")), TuplesKt.to((Object)((Object)UnsignedArrayType.ULONGARRAY), (Object)Name.identifier("ulongArrayOf"))};
        unsignedArrayTypeToArrayCall = MapsKt.hashMapOf((Pair[])$this$map$iv);
        $this$map$iv = UnsignedType.values();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo2 = false;
        int n2 = ((void)$this$mapTo$iv).length;
        for (int destination$iv$iv2 = 0; destination$iv$iv2 < n2; ++destination$iv$iv2) {
            void it2;
            void item$iv;
            void var6_13 = item$iv = $this$mapTo$iv[destination$iv$iv2];
            collection = destination$iv;
            boolean bl = false;
            collection.add(it2.getArrayClassId().getShortClassName());
        }
        arrayClassesShortNames = (Set)var1_2;
        for (UnsignedType unsignedType : UnsignedType.values()) {
            ((Map)arrayClassIdToUnsignedClassId).put(unsignedType.getArrayClassId(), unsignedType.getClassId());
            ((Map)unsignedClassIdToArrayClassId).put(unsignedType.getClassId(), unsignedType.getArrayClassId());
        }
    }
}

