/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtVariableLikeSymbol;
import org.jetbrains.kotlin.analysis.providers.KotlinPsiDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinPsiDeclarationProviderKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/DecompiledPsiDeclarationProvider;", "", "()V", "findPsi", "Lcom/intellij/psi/PsiElement;", "ktSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "project", "Lcom/intellij/openapi/project/Project;", "providePsiForClass", "classLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "providePsiForConstructor", "constructorSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtConstructorSymbol;", "providePsiForEnumEntry", "enumEntrySymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtEnumEntrySymbol;", "providePsiForFunction", "functionLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "providePsiForProperty", "variableLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "symbol-light-classes"})
public final class DecompiledPsiDeclarationProvider {
    @NotNull
    public static final DecompiledPsiDeclarationProvider INSTANCE = new DecompiledPsiDeclarationProvider();

    private DecompiledPsiDeclarationProvider() {
    }

    @Nullable
    public final PsiElement findPsi(@NotNull KtSymbol ktSymbol, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)ktSymbol, (String)"ktSymbol");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtSymbol ktSymbol2 = ktSymbol;
        return ktSymbol2 instanceof KtConstructorSymbol ? this.providePsiForConstructor((KtConstructorSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtFunctionLikeSymbol ? this.providePsiForFunction((KtFunctionLikeSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtEnumEntrySymbol ? this.providePsiForEnumEntry((KtEnumEntrySymbol)ktSymbol, project) : (ktSymbol2 instanceof KtVariableLikeSymbol ? this.providePsiForProperty((KtVariableLikeSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtClassLikeSymbol ? this.providePsiForClass((KtClassLikeSymbol)ktSymbol, project) : null))));
    }

    private final PsiElement providePsiForConstructor(KtConstructorSymbol constructorSymbol, Project project) {
        PsiClass psiClass;
        Collection<PsiClass> collection;
        ClassId classId = constructorSymbol.getContainingClassIdIfNonLocal();
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, this.scope(constructorSymbol, project));
        if (kotlinPsiDeclarationProvider == null || (collection = kotlinPsiDeclarationProvider.getClassesByClassId(classId2)) == null || (psiClass = (PsiClass)CollectionsKt.firstOrNull((Iterable)collection)) == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        PsiMethod[] psiMethodArray = psiClass2.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"psiClass.constructors");
        return (PsiElement)ArraysKt.firstOrNull((Object[])psiMethodArray);
    }

    private final PsiElement providePsiForFunction(KtFunctionLikeSymbol functionLikeSymbol, Project project) {
        PsiMethod psiMethod;
        CallableId callableId = functionLikeSymbol.getCallableIdIfNonLocal();
        if (callableId != null) {
            Collection<PsiMethod> collection;
            CallableId it = callableId;
            boolean bl = false;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, INSTANCE.scope(functionLikeSymbol, project));
            psiMethod = kotlinPsiDeclarationProvider != null && (collection = kotlinPsiDeclarationProvider.getFunctions(it)) != null ? (PsiMethod)CollectionsKt.firstOrNull((Iterable)collection) : null;
        } else {
            psiMethod = null;
        }
        return (PsiElement)psiMethod;
    }

    private final PsiElement providePsiForProperty(KtVariableLikeSymbol variableLikeSymbol, Project project) {
        PsiMember psiMember;
        CallableId callableId = variableLikeSymbol.getCallableIdIfNonLocal();
        if (callableId != null) {
            Collection<PsiMember> collection;
            CallableId it = callableId;
            boolean bl = false;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, INSTANCE.scope(variableLikeSymbol, project));
            psiMember = kotlinPsiDeclarationProvider != null && (collection = kotlinPsiDeclarationProvider.getProperties(it)) != null ? (PsiMember)CollectionsKt.firstOrNull((Iterable)collection) : null;
        } else {
            psiMember = null;
        }
        return (PsiElement)psiMember;
    }

    private final PsiElement providePsiForClass(KtClassLikeSymbol classLikeSymbol, Project project) {
        PsiClass psiClass;
        ClassId classId = classLikeSymbol.getClassIdIfNonLocal();
        if (classId != null) {
            Collection<PsiClass> collection;
            ClassId it = classId;
            boolean bl = false;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, INSTANCE.scope(classLikeSymbol, project));
            psiClass = kotlinPsiDeclarationProvider != null && (collection = kotlinPsiDeclarationProvider.getClassesByClassId(it)) != null ? (PsiClass)CollectionsKt.firstOrNull((Iterable)collection) : null;
        } else {
            psiClass = null;
        }
        return (PsiElement)psiClass;
    }

    private final PsiElement providePsiForEnumEntry(KtEnumEntrySymbol enumEntrySymbol, Project project) {
        Object object;
        block3: {
            PsiClass psiClass;
            Object[] objectArray;
            ClassId classId = enumEntrySymbol.getContainingEnumClassIdIfNonLocal();
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, this.scope(enumEntrySymbol, project));
            if (kotlinPsiDeclarationProvider == null || (objectArray = kotlinPsiDeclarationProvider.getClassesByClassId(classId2)) == null || (psiClass = (PsiClass)CollectionsKt.firstOrNull((Iterable)((Iterable)objectArray))) == null) {
                return null;
            }
            PsiClass psiClass2 = psiClass;
            PsiField[] psiFieldArray = psiClass2.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"psiClass.fields");
            for (Object object2 : (Object[])psiFieldArray) {
                PsiField it = (PsiField)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)enumEntrySymbol.getName().asString())) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    private final GlobalSearchScope scope(KtSymbol $this$scope, Project project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
        return globalSearchScope;
    }
}

