/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtStarProjectionTypeArgument;
import org.jetbrains.kotlin.analysis.api.KtTypeArgument;
import org.jetbrains.kotlin.analysis.api.KtTypeArgumentWithVariance;
import org.jetbrains.kotlin.analysis.api.components.KtClassTypeBuilder;
import org.jetbrains.kotlin.analysis.api.components.KtTypeCreator;
import org.jetbrains.kotlin.analysis.api.components.KtTypeParameterTypeBuilder;
import org.jetbrains.kotlin.analysis.api.descriptors.Fe10AnalysisContext;
import org.jetbrains.kotlin.analysis.api.descriptors.KtFe10AnalysisSession;
import org.jetbrains.kotlin.analysis.api.descriptors.components.base.Fe10KtAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.descriptors.symbols.descriptorBased.base.Kt1DescUtilsKt;
import org.jetbrains.kotlin.analysis.api.descriptors.types.KtFe10ClassErrorType;
import org.jetbrains.kotlin.analysis.api.descriptors.types.KtFe10UsualClassType;
import org.jetbrains.kotlin.analysis.api.descriptors.types.base.KtFe10Type;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.types.KtClassType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.api.types.KtTypeNullability;
import org.jetbrains.kotlin.analysis.api.types.KtTypeParameterType;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeProjectionBase;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/components/KtFe10TypeCreator;", "Lorg/jetbrains/kotlin/analysis/api/components/KtTypeCreator;", "Lorg/jetbrains/kotlin/analysis/api/descriptors/components/base/Fe10KtAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "buildClassType", "Lorg/jetbrains/kotlin/analysis/api/types/KtClassType;", "builder", "Lorg/jetbrains/kotlin/analysis/api/components/KtClassTypeBuilder;", "buildTypeParameterType", "Lorg/jetbrains/kotlin/analysis/api/types/KtTypeParameterType;", "Lorg/jetbrains/kotlin/analysis/api/components/KtTypeParameterTypeBuilder;", "analysis-api-fe10"})
public final class KtFe10TypeCreator
extends KtTypeCreator
implements Fe10KtAnalysisSessionComponent {
    @NotNull
    private final KtFe10AnalysisSession analysisSession;

    public KtFe10TypeCreator(@NotNull KtFe10AnalysisSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        this.analysisSession = analysisSession;
    }

    @Override
    @NotNull
    public KtFe10AnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.getAnalysisSession().getToken();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KtClassType buildClassType(@NotNull KtClassTypeBuilder builder2) {
        KotlinType kotlinType;
        ClassDescriptor classDescriptor;
        Object fqName2;
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        KtClassTypeBuilder ktClassTypeBuilder = builder2;
        if (ktClassTypeBuilder instanceof KtClassTypeBuilder.ByClassId) {
            Object v2;
            block14: {
                void $this$firstIsInstanceOrNull$iv;
                FqName fqName3 = ((KtClassTypeBuilder.ByClassId)builder2).getClassId().asSingleFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"builder.classId.asSingleFqName()");
                fqName2 = fqName3;
                Collection<ClassifierDescriptor> collection = this.getAnalysisContext().getResolveSession().getTopLevelClassifierDescriptors((FqName)fqName2, NoLookupLocation.FROM_IDE);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"analysisContext.resolveS\u2026oLookupLocation.FROM_IDE)");
                Iterable iterable = collection;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof ClassDescriptor)) continue;
                    v2 = element$iv;
                    break block14;
                }
                v2 = null;
            }
            classDescriptor = v2;
        } else if (ktClassTypeBuilder instanceof KtClassTypeBuilder.BySymbol) {
            fqName2 = Kt1DescUtilsKt.getSymbolDescriptor(((KtClassTypeBuilder.BySymbol)builder2).getSymbol());
            classDescriptor = fqName2 instanceof ClassDescriptor ? (ClassDescriptor)fqName2 : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ClassDescriptor descriptor2 = classDescriptor;
        if (descriptor2 == null) {
            fqName2 = new String[]{builder2.toString()};
            ErrorType kotlinType2 = ErrorUtils.createErrorType(ErrorTypeKind.NOT_FOUND_DESCRIPTOR_FOR_CLASS, fqName2);
            return new KtFe10ClassErrorType(kotlinType2, this.getAnalysisContext());
        }
        List<TypeParameterDescriptor> list2 = descriptor2.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.typeConstructor.parameters");
        List<TypeParameterDescriptor> typeParameters2 = list2;
        if (typeParameters2.size() == builder2.getArguments().size()) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = builder2.getArguments();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                TypeProjectionBase typeProjectionBase;
                void arg;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                KtTypeArgument ktTypeArgument = (KtTypeArgument)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var19_21 = arg;
                if (var19_21 instanceof KtStarProjectionTypeArgument) {
                    void index2;
                    TypeParameterDescriptor typeParameterDescriptor = typeParameters2.get((int)index2);
                    Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"typeParameters[index]");
                    typeProjectionBase = new StarProjectionImpl(typeParameterDescriptor);
                } else if (var19_21 instanceof KtTypeArgumentWithVariance) {
                    Variance variance = ((KtTypeArgumentWithVariance)arg).getVariance();
                    KtType ktType = ((KtTypeArgumentWithVariance)arg).getType();
                    Intrinsics.checkNotNull((Object)ktType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.descriptors.types.base.KtFe10Type");
                    typeProjectionBase = new TypeProjectionImpl(variance, ((KtFe10Type)((Object)ktType)).getType());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(typeProjectionBase);
            }
            List projections = (List)destination$iv$iv;
            kotlinType = TypeUtils.substituteProjectionsForParameters(descriptor2, projections);
        } else {
            kotlinType = descriptor2.getDefaultType();
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"if (typeParameters.size \u2026tor.defaultType\n        }");
        KotlinType type2 = kotlinType;
        KotlinType kotlinType3 = TypeUtils.makeNullableAsSpecified(type2, builder2.getNullability() == KtTypeNullability.NULLABLE);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"makeNullableAsSpecified(\u2026TypeNullability.NULLABLE)");
        KotlinType typeWithNullability = kotlinType3;
        return new KtFe10UsualClassType((SimpleType)typeWithNullability, descriptor2, this.getAnalysisContext());
    }

    @Override
    @NotNull
    public KtTypeParameterType buildTypeParameterType(@NotNull KtTypeParameterTypeBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        if (builder2 instanceof KtTypeParameterTypeBuilder.BySymbol) {
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DeclarationDescriptor declarationDescriptor = Kt1DescUtilsKt.getSymbolDescriptor(((KtTypeParameterTypeBuilder.BySymbol)builder2).getSymbol());
        TypeParameterDescriptor descriptor2 = declarationDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)declarationDescriptor : null;
        Annotated annotated = descriptor2;
        if (annotated == null || (annotated = annotated.getDefaultType()) == null) {
            String[] stringArray = new String[]{builder2.toString()};
            annotated = ErrorUtils.createErrorType(ErrorTypeKind.NOT_FOUND_DESCRIPTOR_FOR_TYPE_PARAMETER, stringArray);
        }
        Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"descriptor?.defaultType\n\u2026ETER, builder.toString())");
        Annotated kotlinType = annotated;
        KtType ktType = Kt1DescUtilsKt.toKtType((KotlinType)kotlinType, this.getAnalysisContext());
        Intrinsics.checkNotNull((Object)ktType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.types.KtTypeParameterType");
        return (KtTypeParameterType)ktType;
    }

    @Override
    @NotNull
    public Fe10AnalysisContext getAnalysisContext() {
        return Fe10KtAnalysisSessionComponent.DefaultImpls.getAnalysisContext(this);
    }
}

