/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import com.intellij.psi.PsiModifierList;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclarationKt;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.asJava.elements.KtLightMember;
import org.jetbrains.kotlin.asJava.elements.KtLightMemberImplKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightModifierList;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u001b\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0000H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/asJava/elements/KtLightMemberModifierList;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightModifierList;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMember;", "owner", "dummyDelegate", "Lcom/intellij/psi/PsiModifierList;", "(Lorg/jetbrains/kotlin/asJava/elements/KtLightMember;Lcom/intellij/psi/PsiModifierList;)V", "copy", "hasExplicitModifier", "", "name", "", "hasModifierProperty", "isImplementationInInterface", "isMethodOverride", "light-classes"})
final class KtLightMemberModifierList
extends KtLightModifierList<KtLightMember<?>> {
    @Nullable
    private final PsiModifierList dummyDelegate;

    public KtLightMemberModifierList(@NotNull KtLightMember<?> owner, @Nullable PsiModifierList dummyDelegate) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        super((KtLightElement)owner);
        this.dummyDelegate = dummyDelegate;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean hasModifierProperty(@NotNull String name2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (Intrinsics.areEqual((Object)name2, (Object)"abstract") && this.isImplementationInInterface()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)name2, (Object)"default") && this.isImplementationInInterface()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)name2, (Object)"final")) {
            KtLightClass ktLightClass = ((KtLightMember)this.getOwner()).getContainingClass();
            KtLightClassForSourceDeclaration ktLightClassForSourceDeclaration = ktLightClass instanceof KtLightClassForSourceDeclaration ? (KtLightClassForSourceDeclaration)ktLightClass : null;
            if (ktLightClassForSourceDeclaration != null ? KtLightClassForSourceDeclarationKt.isPossiblyAffectedByAllOpen(ktLightClassForSourceDeclaration) : false) {
                bl = this.getClsDelegate().hasModifierProperty(name2);
                return bl;
            }
        }
        if (this.dummyDelegate == null) {
            bl = this.getClsDelegate().hasModifierProperty(name2);
            return bl;
        }
        if (ArraysKt.contains((Object[])KtLightMemberImplKt.access$getVisibilityModifiers$p(), (Object)name2) && this.isMethodOverride()) {
            bl = this.getClsDelegate().hasModifierProperty(name2);
            return bl;
        }
        bl = this.dummyDelegate.hasModifierProperty(name2);
        return bl;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Intrinsics.areEqual((Object)name2, (Object)"default") ? false : super.hasExplicitModifier(name2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMethodOverride() {
        if (!(this.getOwner() instanceof KtLightMethod)) return false;
        KtDeclaration ktDeclaration = (KtDeclaration)((KtLightMember)this.getOwner()).getKotlinOrigin();
        if (ktDeclaration == null) return false;
        boolean bl = ktDeclaration.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isImplementationInInterface() {
        if (!((KtLightMember)this.getOwner()).getContainingClass().isInterface()) return false;
        if (!(this.getOwner() instanceof KtLightMethod)) return false;
        KtDeclaration ktDeclaration = (KtDeclaration)((KtLightMember)this.getOwner()).getKotlinOrigin();
        if (ktDeclaration == null) return false;
        boolean bl = KtPsiUtilKt.hasBody(ktDeclaration);
        if (!bl) return false;
        return true;
    }

    @NotNull
    public KtLightMemberModifierList copy() {
        return new KtLightMemberModifierList((KtLightMember)this.getOwner(), this.dummyDelegate);
    }
}

