/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.KtDeclarationAndFirDeclarationEqualityChecker;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.FirDeclarationForCompiledElementSearcherKt;
import org.jetbrains.kotlin.analysis.utils.printer.PsiUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/FirDeclarationForCompiledElementSearcher;", "", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "(Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;)V", "findConstructorOfNonLocalClass", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "findNonLocalClassLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "findNonLocalDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "findNonLocalEnumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "findNonLocalFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "findNonLocalProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "low-level-api-fir"})
public final class FirDeclarationForCompiledElementSearcher {
    @NotNull
    private final FirSymbolProvider symbolProvider;

    public FirDeclarationForCompiledElementSearcher(@NotNull FirSymbolProvider symbolProvider2) {
        Intrinsics.checkNotNullParameter((Object)symbolProvider2, (String)"symbolProvider");
        this.symbolProvider = symbolProvider2;
    }

    @NotNull
    public final FirDeclaration findNonLocalDeclaration(@NotNull KtDeclaration ktDeclaration) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)ktDeclaration, (String)"ktDeclaration");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        if (ktDeclaration2 instanceof KtEnumEntry) {
            firDeclaration = this.findNonLocalEnumEntry((KtEnumEntry)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtClassLikeDeclaration) {
            firDeclaration = this.findNonLocalClassLikeDeclaration((KtClassLikeDeclaration)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtConstructor) {
            firDeclaration = this.findConstructorOfNonLocalClass((KtConstructor)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtNamedFunction) {
            firDeclaration = this.findNonLocalFunction((KtNamedFunction)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtProperty) {
            firDeclaration = this.findNonLocalProperty((KtProperty)ktDeclaration);
        } else {
            throw new IllegalStateException(("Unsupported compiled declaration of type " + Reflection.getOrCreateKotlinClass(ktDeclaration.getClass()) + ": " + PsiUtilsKt.getElementTextInContext(ktDeclaration)).toString());
        }
        return firDeclaration;
    }

    private final FirEnumEntry findNonLocalEnumEntry(KtEnumEntry declaration) {
        FirDeclaration firDeclaration;
        if (!(!declaration.isLocal())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Object object = KtPsiUtilKt.getContainingClassOrObject(declaration);
        if (object == null || (object = ((KtClassOrObject)object).getClassId()) == null) {
            throw new IllegalStateException(("Non-local class should have classId. The class is " + PsiUtilsKt.getElementTextInContext(declaration)).toString());
        }
        Object classId = object;
        FirClassLikeSymbol<?> firClassLikeSymbol = this.symbolProvider.getClassLikeSymbolByClassId((ClassId)classId);
        if (firClassLikeSymbol == null) {
            throw new IllegalStateException(("We should be able to find a symbol for " + classId).toString());
        }
        FirClassLikeSymbol<?> classCandidate = firClassLikeSymbol;
        Object e = classCandidate.getFir();
        Object object2 = e instanceof FirRegularClass ? (FirRegularClass)e : null;
        if (object2 != null && (object2 = ((FirRegularClass)object2).getDeclarations()) != null) {
            Object element$iv2;
            block6: {
                Iterable $this$first$iv = (Iterable)object2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv2;
                    boolean bl = false;
                    if (!(it instanceof FirEnumEntry && Intrinsics.areEqual((Object)((FirEnumEntry)it).getName(), (Object)declaration.getNameAsName()))) continue;
                    break block6;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            firDeclaration = (FirDeclaration)element$iv2;
        } else {
            firDeclaration = null;
        }
        Intrinsics.checkNotNull(firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
        return (FirEnumEntry)firDeclaration;
    }

    private final FirClassLikeDeclaration findNonLocalClassLikeDeclaration(KtClassLikeDeclaration declaration) {
        ClassId classId = declaration.getClassId();
        if (classId == null) {
            throw new IllegalStateException(("Non-local class should have classId. The class is " + PsiUtilsKt.getElementTextInContext(declaration)).toString());
        }
        ClassId classId2 = classId;
        FirClassLikeSymbol<?> firClassLikeSymbol = this.symbolProvider.getClassLikeSymbolByClassId(classId2);
        if (firClassLikeSymbol == null) {
            throw new IllegalStateException(("We should be able to find a symbol for " + classId2).toString());
        }
        FirClassLikeSymbol<?> classCandidate = firClassLikeSymbol;
        return (FirClassLikeDeclaration)classCandidate.getFir();
    }

    /*
     * WARNING - void declaration
     */
    private final FirConstructor findConstructorOfNonLocalClass(KtConstructor<?> declaration) {
        Object v2;
        block6: {
            void $this$singleOrNull$iv;
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(declaration);
            if (ktClassOrObject == null) {
                throw new IllegalStateException(("Constructor must have outer class: " + PsiUtilsKt.getElementTextInContext(declaration)).toString());
            }
            KtClassOrObject containingClass = ktClassOrObject;
            if (!(!containingClass.isLocal())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            ClassId classId = containingClass.getClassId();
            if (classId == null) {
                throw new IllegalStateException(("Non-local class should have classId. The class is " + PsiUtilsKt.getElementTextInContext(containingClass)).toString());
            }
            ClassId classId2 = classId;
            Iterable iterable = FirSymbolProviderKt.getClassDeclaredConstructors(this.symbolProvider, classId2);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                FirConstructorSymbol it = (FirConstructorSymbol)element$iv;
                boolean bl = false;
                if (!FirDeclarationForCompiledElementSearcherKt.access$representSameConstructor(declaration, (FirConstructor)it.getFir())) continue;
                if (found$iv) {
                    v2 = null;
                    break block6;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        FirConstructorSymbol firConstructorSymbol = v2;
        if (firConstructorSymbol == null) {
            throw new IllegalStateException(("We should be able to find a constructor: " + PsiUtilsKt.getElementTextInContext(declaration)).toString());
        }
        FirConstructorSymbol constructorCandidate = firConstructorSymbol;
        return (FirConstructor)constructorCandidate.getFir();
    }

    /*
     * WARNING - void declaration
     */
    private final FirFunction findNonLocalFunction(KtNamedFunction declaration) {
        Object v0;
        block4: {
            void $this$singleOrNull$iv;
            if (!(!declaration.isLocal())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            Iterable iterable = FirDeclarationForCompiledElementSearcherKt.access$findFunctionCandidates(this.symbolProvider, declaration);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                FirFunctionSymbol it = (FirFunctionSymbol)element$iv;
                boolean bl = false;
                if (!KtDeclarationAndFirDeclarationEqualityChecker.INSTANCE.representsTheSameDeclaration(declaration, (FirCallableDeclaration)it.getFir())) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        FirFunctionSymbol firFunctionSymbol = v0;
        if (firFunctionSymbol == null) {
            throw new IllegalStateException(("We should be able to find a symbol for function " + declaration.getName() + ": " + PsiUtilsKt.getElementTextInContext(declaration)).toString());
        }
        FirFunctionSymbol functionCandidate = firFunctionSymbol;
        return (FirFunction)functionCandidate.getFir();
    }

    /*
     * WARNING - void declaration
     */
    private final FirProperty findNonLocalProperty(KtProperty declaration) {
        Object v0;
        block4: {
            void $this$singleOrNull$iv;
            if (!(!declaration.isLocal())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            Iterable iterable = FirDeclarationForCompiledElementSearcherKt.access$findPropertyCandidates(this.symbolProvider, declaration);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                FirPropertySymbol it = (FirPropertySymbol)element$iv;
                boolean bl = false;
                if (!KtDeclarationAndFirDeclarationEqualityChecker.INSTANCE.representsTheSameDeclaration(declaration, (FirCallableDeclaration)it.getFir())) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        FirPropertySymbol firPropertySymbol = v0;
        if (firPropertySymbol == null) {
            throw new IllegalStateException(("We should be able to find a symbol for property " + declaration.getName() + ": " + PsiUtilsKt.getElementTextInContext(declaration)).toString());
        }
        FirPropertySymbol propertyCandidate = firPropertySymbol;
        return (FirProperty)propertyCandidate.getFir();
    }
}

