/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.KtDeclarationRendererOptions;
import org.jetbrains.kotlin.analysis.api.components.RendererModifier;
import org.jetbrains.kotlin.analysis.api.descriptors.Fe10AnalysisContext;
import org.jetbrains.kotlin.analysis.api.descriptors.symbols.descriptorBased.base.Kt1DescUtilsKt;
import org.jetbrains.kotlin.analysis.api.descriptors.utils.KtFe10Renderer;
import org.jetbrains.kotlin.analysis.api.descriptors.utils.KtFe10TypeRenderer;
import org.jetbrains.kotlin.analysis.api.descriptors.utils.PublicApproximatorConfiguration;
import org.jetbrains.kotlin.analysis.api.descriptors.utils.RenderAnnotationsKt;
import org.jetbrains.kotlin.analysis.utils.printer.PrettyPrinter;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DeserializedDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 V2\u00020\u0001:\u0001VB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\b\b\u0000\u0010 *\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u001fH\u0002J.\u0010\"\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u001d\u001a\u00020#2\u0014\b\u0002\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00070%H\u0002J\u0018\u0010'\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0018\u0010*\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u0018\u0010/\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0018\u00100\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u00105\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\n\b\u0002\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0018\u0010;\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u0018\u0010<\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u0018\u0010=\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020>H\u0002J\u0018\u0010?\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020(H\u0002J\u0018\u0010B\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0010\u0010C\u001a\u00020\u0015*\u00060\u0018j\u0002`\u0019H\u0002J\"\u0010D\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010E\u001a\u00020\u0007H\u0002J\u0018\u0010F\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020GH\u0002J\u0018\u0010H\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020IH\u0002J\u001e\u0010J\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\f\u0010K\u001a\b\u0012\u0004\u0012\u00020I0\u001fH\u0002J\"\u0010L\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020M2\b\b\u0002\u0010N\u001a\u00020OH\u0002J\u001e\u0010P\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020M0\u001fH\u0002J\u0018\u0010R\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\u0006\u0010\u000f\u001a\u00020SH\u0002J\u001e\u0010T\u001a\u00020\u0015*\u00060\u0018j\u0002`\u00192\f\u0010U\u001a\b\u0012\u0004\u0012\u00020I0\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/utils/KtFe10Renderer;", "", "analysisContext", "Lorg/jetbrains/kotlin/analysis/api/descriptors/Fe10AnalysisContext;", "options", "Lorg/jetbrains/kotlin/analysis/api/components/KtDeclarationRendererOptions;", "isDebugText", "", "(Lorg/jetbrains/kotlin/analysis/api/descriptors/Fe10AnalysisContext;Lorg/jetbrains/kotlin/analysis/api/components/KtDeclarationRendererOptions;Z)V", "typeApproximator", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "typeRenderer", "Lorg/jetbrains/kotlin/analysis/api/descriptors/utils/KtFe10TypeRenderer;", "getDefaultModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "needsParenthesis", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "render", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "consumer", "Lorg/jetbrains/kotlin/analysis/utils/printer/PrettyPrinter;", "Lorg/jetbrains/kotlin/analysis/api/descriptors/utils/KtFe10RendererConsumer;", "shouldRenderNestedDeclaration", "owner", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "declaration", "sortDeclarations", "", "T", "declarations", "renderAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/ClassId;", "renderCallable", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "renderClass", "renderClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "renderConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "renderDeclaration", "renderEnumEntry", "renderFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "renderLocalVariable", "Lorg/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor;", "renderModality", "renderModifier", "text", "", "state", "modifier", "Lorg/jetbrains/kotlin/analysis/api/components/RendererModifier;", "renderModifiers", "renderName", "renderProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "renderPropertyAccessor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "renderReceiver", "renderSupertypes", "renderSyntheticFieldDescriptor", "renderType", "shouldApproximate", "renderTypeAlias", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "renderTypeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "renderTypeParameters", "typeParameters", "renderValueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "name", "Lorg/jetbrains/kotlin/name/Name;", "renderValueParameters", "valueParameters", "renderVisibility", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "renderWhereSuffix", "descriptors", "Companion", "analysis-api-fe10"})
public final class KtFe10Renderer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Fe10AnalysisContext analysisContext;
    @NotNull
    private final KtDeclarationRendererOptions options;
    @NotNull
    private final KtFe10TypeRenderer typeRenderer;
    @NotNull
    private final TypeApproximator typeApproximator;
    @Deprecated
    @NotNull
    private static final Set<Visibility> IGNORED_VISIBILITIES;
    @Deprecated
    @NotNull
    private static final Set<ClassId> IGNORED_SUPERTYPES;

    public KtFe10Renderer(@NotNull Fe10AnalysisContext analysisContext, @NotNull KtDeclarationRendererOptions options, boolean isDebugText) {
        Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.analysisContext = analysisContext;
        this.options = options;
        this.typeRenderer = new KtFe10TypeRenderer(this.options.getTypeRendererOptions(), isDebugText);
        KotlinBuiltIns kotlinBuiltIns = this.analysisContext.getBuiltIns();
        LanguageVersionSettings languageVersionSettings2 = this.analysisContext.getResolveSession().getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings2, (String)"analysisContext.resolveS\u2026n.languageVersionSettings");
        this.typeApproximator = new TypeApproximator(kotlinBuiltIns, languageVersionSettings2);
    }

    public /* synthetic */ KtFe10Renderer(Fe10AnalysisContext fe10AnalysisContext, KtDeclarationRendererOptions ktDeclarationRendererOptions, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(fe10AnalysisContext, ktDeclarationRendererOptions, bl);
    }

    public final void render(@NotNull DeclarationDescriptor descriptor2, @NotNull PrettyPrinter consumer) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.renderDeclaration(consumer, descriptor2);
    }

    private final void renderType(PrettyPrinter $this$renderType, KotlinType type2, boolean shouldApproximate) {
        if (shouldApproximate) {
            KotlinType kotlinType;
            UnwrappedType unwrappedType = this.typeApproximator.approximateToSuperType(type2.unwrap(), (TypeApproximatorConfiguration)PublicApproximatorConfiguration.INSTANCE);
            if (unwrappedType != null) {
                kotlinType = unwrappedType;
            } else {
                KotlinType kotlinType2;
                KotlinType it = kotlinType2 = type2;
                boolean bl = false;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                kotlinType = !Intrinsics.areEqual((Object)(classifierDescriptor != null ? classifierDescriptor.getName() : null), (Object)SpecialNames.NO_NAME_PROVIDED) ? kotlinType2 : null;
                if (kotlinType == null) {
                    SimpleType simpleType2 = this.analysisContext.getBuiltIns().getAnyType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"analysisContext.builtIns.anyType");
                    kotlinType = simpleType2;
                }
            }
            KotlinType approximatedType = kotlinType;
            this.renderType($this$renderType, approximatedType, false);
            return;
        }
        this.typeRenderer.render(type2, $this$renderType);
    }

    static /* synthetic */ void renderType$default(KtFe10Renderer ktFe10Renderer, PrettyPrinter prettyPrinter, KotlinType kotlinType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        ktFe10Renderer.renderType(prettyPrinter, kotlinType, bl);
    }

    private final boolean needsParenthesis(KotlinType type2) {
        if (!type2.getAnnotations().isEmpty()) {
            return true;
        }
        if (this.options.getTypeRendererOptions().getRenderFunctionType() && FunctionTypesKt.isFunctionType(type2)) {
            return true;
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        return descriptor2 instanceof FunctionClassDescriptor && ((FunctionClassDescriptor)descriptor2).getFunctionKind().isSuspendType();
    }

    private final void renderDeclaration(PrettyPrinter $this$renderDeclaration, DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ClassifierDescriptor) {
            this.renderClassifier($this$renderDeclaration, (ClassifierDescriptor)descriptor2);
        } else if (declarationDescriptor instanceof CallableDescriptor) {
            this.renderCallable($this$renderDeclaration, (CallableDescriptor)descriptor2);
        } else {
            throw new IllegalStateException(("Unexpected descriptor kind: " + descriptor2).toString());
        }
    }

    private final void renderClassifier(PrettyPrinter $this$renderClassifier, ClassifierDescriptor descriptor2) {
        ClassifierDescriptor classifierDescriptor = descriptor2;
        if (classifierDescriptor instanceof TypeAliasDescriptor) {
            this.renderTypeAlias($this$renderClassifier, (TypeAliasDescriptor)descriptor2);
        } else if (classifierDescriptor instanceof TypeParameterDescriptor) {
            this.renderTypeParameter($this$renderClassifier, (TypeParameterDescriptor)descriptor2);
        } else if (classifierDescriptor instanceof ClassDescriptor) {
            if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                this.renderEnumEntry($this$renderClassifier, (ClassDescriptor)descriptor2);
            } else {
                this.renderClass($this$renderClassifier, (ClassDescriptor)descriptor2);
            }
        } else {
            throw new IllegalStateException(("Unexpected descriptor kind: " + descriptor2).toString());
        }
    }

    private final void renderTypeAlias(PrettyPrinter $this$renderTypeAlias, TypeAliasDescriptor descriptor2) {
        if (this.options.getRenderDeclarationHeader()) {
            KtFe10Renderer.renderAnnotations$default(this, $this$renderTypeAlias, descriptor2, null, 2, null);
            this.renderModifiers($this$renderTypeAlias, descriptor2);
            $this$renderTypeAlias.append("typealias ");
        }
        this.renderName($this$renderTypeAlias, descriptor2);
        List<TypeParameterDescriptor> list2 = descriptor2.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.declaredTypeParameters");
        this.renderTypeParameters($this$renderTypeAlias, list2);
        $this$renderTypeAlias.append(" = ");
        KtFe10Renderer.renderType$default(this, $this$renderTypeAlias, descriptor2.getExpandedType(), false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeParameters(PrettyPrinter $this$renderTypeParameters, List<? extends TypeParameterDescriptor> typeParameters2) {
        if (!((Collection)typeParameters2).isEmpty()) {
            $this$renderTypeParameters.append('<');
        }
        String separator$iv = ", ";
        String prefix$iv = "";
        String postfix$iv = "";
        boolean $i$f$printCollection = false;
        $this$renderTypeParameters.append(prefix$iv);
        Iterator iterator$iv = ((Iterable)typeParameters2).iterator();
        while (iterator$iv.hasNext()) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)iterator$iv.next();
            PrettyPrinter $this$renderTypeParameters_u24lambda_u241 = $this$renderTypeParameters;
            boolean bl = false;
            this.renderTypeParameter($this$renderTypeParameters_u24lambda_u241, (TypeParameterDescriptor)it);
            if (!iterator$iv.hasNext()) continue;
            $this$renderTypeParameters.append(separator$iv);
        }
        $this$renderTypeParameters.append(postfix$iv);
        if (!((Collection)typeParameters2).isEmpty()) {
            $this$renderTypeParameters.append('>');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeParameter(PrettyPrinter $this$renderTypeParameter, TypeParameterDescriptor descriptor2) {
        void $this$filterNotTo$iv$iv;
        KtFe10Renderer.renderModifier$default(this, $this$renderTypeParameter, "reified", descriptor2.isReified(), null, 4, null);
        String variance = descriptor2.getVariance().getLabel();
        KtFe10Renderer.renderModifier$default(this, $this$renderTypeParameter, variance, ((CharSequence)variance).length() > 0, null, 4, null);
        KtFe10Renderer.renderAnnotations$default(this, $this$renderTypeParameter, descriptor2, null, 2, null);
        this.renderName($this$renderTypeParameter, descriptor2);
        List<KotlinType> list2 = descriptor2.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.upperBounds");
        Iterable $this$filterNot$iv = list2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (TypeUtilsKt.isNullableAny(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List upperBounds2 = (List)destination$iv$iv;
        if (!((Collection)upperBounds2).isEmpty()) {
            $this$renderTypeParameter.append(" : ");
            Object object = CollectionsKt.first((List)upperBounds2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"upperBounds.first()");
            KtFe10Renderer.renderType$default(this, $this$renderTypeParameter, (KotlinType)object, false, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderClass(PrettyPrinter $this$renderClass, ClassDescriptor descriptor2) {
        boolean shouldRenderName;
        if (this.options.getRenderDeclarationHeader()) {
            KtFe10Renderer.renderAnnotations$default(this, $this$renderClass, descriptor2, null, 2, null);
            this.renderModifiers($this$renderClass, descriptor2);
            if (DescriptorUtils.isAnonymousObject(descriptor2)) {
                $this$renderClass.append("object");
            } else {
                String string2;
                switch (WhenMappings.$EnumSwitchMapping$0[descriptor2.getKind().ordinal()]) {
                    case 1: {
                        string2 = "class";
                        break;
                    }
                    case 2: {
                        string2 = "interface";
                        break;
                    }
                    case 3: {
                        string2 = "enum class";
                        break;
                    }
                    case 4: {
                        throw new IllegalStateException("enum entries should not be rendered via renderClass".toString());
                    }
                    case 5: {
                        string2 = "annotation class";
                        break;
                    }
                    case 6: {
                        string2 = "object";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                String classKeyword = string2;
                $this$renderClass.append(classKeyword);
            }
        }
        boolean bl = shouldRenderName = !descriptor2.getName().isSpecial() && (!descriptor2.isCompanionObject() || !Intrinsics.areEqual((Object)descriptor2.getName(), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT));
        if (shouldRenderName) {
            $this$renderClass.append(' ');
            this.renderName($this$renderClass, descriptor2);
        }
        List<TypeParameterDescriptor> list2 = descriptor2.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.declaredTypeParameters");
        this.renderTypeParameters($this$renderClass, list2);
        this.renderSupertypes($this$renderClass, descriptor2);
        List<TypeParameterDescriptor> list3 = descriptor2.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"descriptor.declaredTypeParameters");
        this.renderWhereSuffix($this$renderClass, list3);
        if (this.options.getRenderClassMembers()) {
            PrettyPrinter $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object element$iv2;
            void $this$partition$iv;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            MemberScope memberScope2 = descriptor2.getUnsubstitutedMemberScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"descriptor.unsubstitutedMemberScope");
            Iterable iterable = ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, null, null, 3, null);
            boolean $i$f$filter = false;
            void var7_8 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                boolean bl2 = false;
                if (!this.shouldRenderNestedDeclaration(descriptor2, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Iterable<Object> second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv2;
                boolean bl3 = false;
                if (it instanceof ClassDescriptor && ((ClassDescriptor)it).getKind() == ClassKind.ENUM_ENTRY) {
                    first$iv.add(element$iv2);
                    continue;
                }
                second$iv.add(element$iv2);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List enumEntries = (List)pair.component1();
            List otherDeclarations = (List)pair.component2();
            Collection<ClassConstructorDescriptor> collection = descriptor2.getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"descriptor.constructors");
            second$iv = collection;
            boolean $i$f$filter2 = false;
            element$iv2 = $this$filter$iv;
            Object destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            Iterator bl2 = $this$filterTo$iv$iv.iterator();
            while (bl2.hasNext()) {
                Object element$iv$iv = bl2.next();
                ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!this.shouldRenderNestedDeclaration(descriptor2, it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List constructors2 = (List)destination$iv$iv2;
            if (!((Collection)enumEntries).isEmpty() || !((Collection)otherDeclarations).isEmpty() || !((Collection)constructors2).isEmpty()) {
                DeclarationDescriptor it;
                Iterable collection$iv;
                void before$iv$iv;
                void this_$iv$iv;
                $this$renderClass.append(' ');
                PrettyPrinter this_$iv = $this$renderClass;
                boolean $i$f$withIndentInBraces = false;
                $this$filterTo$iv$iv = this_$iv;
                destination$iv$iv2 = "{";
                String after$iv$iv = "}";
                boolean $i$f$withIndentWrapped = false;
                this_$iv$iv.append((CharSequence)before$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)((Appendable)this_$iv$iv).append('\n'), (String)"append('\\n')");
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$withIndent = false;
                this_$iv$iv$iv.setIndent(this_$iv$iv$iv.getIndent() + 1);
                void $this$renderClass_u24lambda_u248 = this_$iv$iv$iv;
                boolean bl5 = false;
                Iterable iterable2 = this.sortDeclarations(enumEntries);
                String separator$iv = ",\n";
                String prefix$iv = "";
                String postfix$iv = "";
                boolean $i$f$printCollection = false;
                $this$renderClass_u24lambda_u248.append(prefix$iv);
                Iterator iterator$iv = collection$iv.iterator();
                while (iterator$iv.hasNext()) {
                    DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)iterator$iv.next();
                    void $this$renderClass_u24lambda_u248_u24lambda_u246 = $this$renderClass_u24lambda_u248;
                    boolean bl6 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    this.renderEnumEntry((PrettyPrinter)$this$renderClass_u24lambda_u248_u24lambda_u246, (ClassDescriptor)it);
                    if (!iterator$iv.hasNext()) continue;
                    $this$renderClass_u24lambda_u248.append(separator$iv);
                }
                $this$renderClass_u24lambda_u248.append(postfix$iv);
                if (!((Collection)enumEntries).isEmpty() && (!((Collection)constructors2).isEmpty() || !((Collection)otherDeclarations).isEmpty())) {
                    Appendable appendable = ((Appendable)$this$renderClass_u24lambda_u248).append(";\n");
                    Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
                }
                collection$iv = this.sortDeclarations(CollectionsKt.plus((Collection)constructors2, (Iterable)otherDeclarations));
                separator$iv = "\n\n";
                prefix$iv = "";
                postfix$iv = "";
                $i$f$printCollection = false;
                $this$renderClass_u24lambda_u248.append(prefix$iv);
                iterator$iv = collection$iv.iterator();
                while (iterator$iv.hasNext()) {
                    it = (DeclarationDescriptor)iterator$iv.next();
                    void $this$renderClass_u24lambda_u248_u24lambda_u247 = $this$renderClass_u24lambda_u248;
                    boolean bl7 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.renderDeclaration((PrettyPrinter)$this$renderClass_u24lambda_u248_u24lambda_u247, it);
                    if (!iterator$iv.hasNext()) continue;
                    $this$renderClass_u24lambda_u248.append(separator$iv);
                }
                $this$renderClass_u24lambda_u248.append(postfix$iv);
                this_$iv$iv$iv.setIndent(this_$iv$iv$iv.getIndent() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)((Appendable)this_$iv$iv).append('\n'), (String)"append('\\n')");
                this_$iv$iv.append(after$iv$iv);
            }
        }
    }

    private final boolean shouldRenderNestedDeclaration(ClassDescriptor owner, DeclarationDescriptor declaration) {
        if (declaration instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)declaration).getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            return false;
        }
        if (declaration instanceof ConstructorDescriptor && !DescriptorUtils.isAnonymousObject(((ConstructorDescriptor)declaration).getConstructedClass()) && ((ConstructorDescriptor)declaration).isPrimary() && ((ConstructorDescriptor)declaration).getValueParameters().isEmpty() && declaration.getAnnotations().isEmpty()) {
            if (Intrinsics.areEqual((Object)((ConstructorDescriptor)declaration).getVisibility(), (Object)DescriptorVisibilities.DEFAULT_VISIBILITY)) {
                return false;
            }
            if (owner.getKind() == ClassKind.OBJECT || owner.getKind() == ClassKind.ENUM_CLASS) {
                return false;
            }
        }
        if (declaration instanceof FunctionDescriptor && owner.getKind() == ClassKind.ENUM_CLASS) {
            if (Intrinsics.areEqual((Object)((FunctionDescriptor)declaration).getName().asString(), (Object)"valueOf")) {
                List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)declaration).getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"declaration.valueParameters");
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list2);
                if (KotlinBuiltIns.isString(valueParameterDescriptor != null ? valueParameterDescriptor.getType() : null)) {
                    return false;
                }
            }
            if (Intrinsics.areEqual((Object)((FunctionDescriptor)declaration).getName().asString(), (Object)"values") && ((FunctionDescriptor)declaration).getValueParameters().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private final <T extends DeclarationDescriptor> List<T> sortDeclarations(List<? extends T> declarations2) {
        if (!this.options.getSortNestedDeclarations()) {
            return declarations2;
        }
        return CollectionsKt.sortedWith((Iterable)declarations2, (arg_0, arg_1) -> KtFe10Renderer.sortDeclarations$lambda$11(this, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSupertypes(PrettyPrinter $this$renderSupertypes, ClassDescriptor descriptor2) {
        KotlinType it;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv;
        Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)DescriptorUtilsKt.getSuperClassNotAny(descriptor2)), (Iterable)DescriptorUtilsKt.getSuperInterfaces(descriptor2));
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            ClassDescriptor it2 = (ClassDescriptor)element$iv;
            boolean bl = false;
            if (!(!CollectionsKt.contains((Iterable)IGNORED_SUPERTYPES, (Object)Kt1DescUtilsKt.getClassId(it2)))) continue;
            destination$iv.add(element$iv);
        }
        HashSet allowedSuperClasses = (HashSet)destination$iv;
        Collection<KotlinType> collection = descriptor2.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"descriptor.typeConstructor.supertypes");
        Object $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KotlinType)element$iv$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)allowedSuperClasses, (Object)it.getConstructor().getDeclarationDescriptor())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List supertypes2 = (List)destination$iv$iv;
        $this$filter$iv = ", ";
        String prefix$iv = " : ";
        String postfix$iv = "";
        boolean $i$f$printCollectionIfNotEmpty = false;
        if (((Iterable)supertypes2).iterator().hasNext()) {
            PrettyPrinter this_$iv$iv = $this$renderSupertypes;
            boolean $i$f$printCollection = false;
            this_$iv$iv.append(prefix$iv);
            Iterator iterator$iv$iv = ((Iterable)supertypes2).iterator();
            while (iterator$iv$iv.hasNext()) {
                void separator$iv;
                it = (KotlinType)iterator$iv$iv.next();
                PrettyPrinter $this$renderSupertypes_u24lambda_u2414 = this_$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                KtFe10Renderer.renderType$default(this, $this$renderSupertypes_u24lambda_u2414, it, false, 2, null);
                if (!iterator$iv$iv.hasNext()) continue;
                this_$iv$iv.append((CharSequence)separator$iv);
            }
            this_$iv$iv.append(postfix$iv);
        }
    }

    private final void renderCallable(PrettyPrinter $this$renderCallable, CallableDescriptor descriptor2) {
        CallableDescriptor callableDescriptor = descriptor2;
        if (callableDescriptor instanceof SyntheticFieldDescriptor) {
            this.renderSyntheticFieldDescriptor($this$renderCallable);
        } else if (callableDescriptor instanceof PropertyGetterDescriptor) {
            this.renderPropertyAccessor($this$renderCallable, (PropertyAccessorDescriptor)descriptor2);
        } else if (callableDescriptor instanceof PropertySetterDescriptor) {
            this.renderPropertyAccessor($this$renderCallable, (PropertyAccessorDescriptor)descriptor2);
        } else if (callableDescriptor instanceof PropertyDescriptor) {
            this.renderProperty($this$renderCallable, (PropertyDescriptor)descriptor2);
        } else if (callableDescriptor instanceof ConstructorDescriptor) {
            this.renderConstructor($this$renderCallable, (ConstructorDescriptor)descriptor2);
        } else if (callableDescriptor instanceof FunctionDescriptor) {
            this.renderFunction($this$renderCallable, (FunctionDescriptor)descriptor2);
        } else if (callableDescriptor instanceof ValueParameterDescriptor) {
            KtFe10Renderer.renderValueParameter$default(this, $this$renderCallable, (ValueParameterDescriptor)descriptor2, null, 2, null);
        } else if (callableDescriptor instanceof LocalVariableDescriptor) {
            this.renderLocalVariable($this$renderCallable, (LocalVariableDescriptor)descriptor2);
        } else {
            throw new IllegalStateException(("Unexpected descriptor kind: " + descriptor2).toString());
        }
    }

    private final void renderSyntheticFieldDescriptor(PrettyPrinter $this$renderSyntheticFieldDescriptor) {
        $this$renderSyntheticFieldDescriptor.append("field");
    }

    private final void renderPropertyAccessor(PrettyPrinter $this$renderPropertyAccessor, PropertyAccessorDescriptor descriptor2) {
        PropertyAccessorDescriptor propertyAccessorDescriptor;
        if (this.options.getRenderDeclarationHeader()) {
            KtFe10Renderer.renderAnnotations$default(this, $this$renderPropertyAccessor, descriptor2, null, 2, null);
            this.renderModifiers($this$renderPropertyAccessor, descriptor2);
        }
        if ((propertyAccessorDescriptor = descriptor2) instanceof PropertyGetterDescriptor) {
            $this$renderPropertyAccessor.append("get()");
        } else if (propertyAccessorDescriptor instanceof PropertySetterDescriptor) {
            $this$renderPropertyAccessor.append("set(");
            List<ValueParameterDescriptor> list2 = ((PropertySetterDescriptor)descriptor2).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
            ValueParameterDescriptor valueParameter2 = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list2);
            if (valueParameter2 != null) {
                Name name2;
                Name it = name2 = valueParameter2.getName();
                boolean bl = false;
                Name name3 = !it.isSpecial() ? name2 : null;
                if (name3 == null) {
                    name3 = Name.identifier("value");
                }
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"valueParameter.name.take\u2026 Name.identifier(\"value\")");
                Name name4 = name3;
                this.renderValueParameter($this$renderPropertyAccessor, valueParameter2, name4);
            }
            $this$renderPropertyAccessor.append(")");
        }
    }

    private final void renderEnumEntry(PrettyPrinter $this$renderEnumEntry, ClassDescriptor descriptor2) {
        boolean bl;
        boolean bl2 = bl = descriptor2.getKind() == ClassKind.ENUM_ENTRY;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.renderName($this$renderEnumEntry, descriptor2);
    }

    private final void renderLocalVariable(PrettyPrinter $this$renderLocalVariable, LocalVariableDescriptor descriptor2) {
        if (this.options.getRenderDeclarationHeader()) {
            KtFe10Renderer.renderAnnotations$default(this, $this$renderLocalVariable, descriptor2, null, 2, null);
            $this$renderLocalVariable.append(descriptor2.isVar() ? "var" : "val").append(' ');
        }
        this.renderName($this$renderLocalVariable, descriptor2);
        $this$renderLocalVariable.append(": ");
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
        this.renderType($this$renderLocalVariable, kotlinType, this.options.getApproximateTypes());
    }

    private final void renderProperty(PrettyPrinter $this$renderProperty, PropertyDescriptor descriptor2) {
        if (this.options.getRenderDeclarationHeader()) {
            KtFe10Renderer.renderAnnotations$default(this, $this$renderProperty, descriptor2, null, 2, null);
            this.renderModifiers($this$renderProperty, descriptor2);
            $this$renderProperty.append(descriptor2.isVar() ? "var" : "val").append(' ');
            List<TypeParameterDescriptor> list2 = descriptor2.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.typeParameters");
            this.renderTypeParameters($this$renderProperty, list2);
            List<TypeParameterDescriptor> list3 = descriptor2.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"descriptor.typeParameters");
            if (!((Collection)list3).isEmpty()) {
                $this$renderProperty.append(' ');
            }
        }
        this.renderReceiver($this$renderProperty, descriptor2);
        this.renderName($this$renderProperty, descriptor2);
        $this$renderProperty.append(": ");
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
        this.renderType($this$renderProperty, kotlinType, this.options.getApproximateTypes());
        List<TypeParameterDescriptor> list4 = descriptor2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"descriptor.typeParameters");
        this.renderWhereSuffix($this$renderProperty, list4);
        if (this.options.getRenderClassMembers()) {
            boolean shouldRenderAccessors;
            PropertyGetterDescriptor getter2 = descriptor2.getGetter();
            PropertySetterDescriptor setter2 = descriptor2.getSetter();
            boolean bl = shouldRenderAccessors = getter2 != null && KtFe10Renderer.renderProperty$shouldRenderAccessor(descriptor2, getter2) || setter2 != null && KtFe10Renderer.renderProperty$shouldRenderAccessor(descriptor2, setter2);
            if (shouldRenderAccessors) {
                PrettyPrinter this_$iv = $this$renderProperty;
                boolean $i$f$withIndent = false;
                this_$iv.setIndent(this_$iv.getIndent() + 1);
                PrettyPrinter $this$renderProperty_u24lambda_u2416 = this_$iv;
                boolean bl2 = false;
                if (getter2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)((Appendable)$this$renderProperty_u24lambda_u2416).append('\n'), (String)"append('\\n')");
                    this.renderPropertyAccessor($this$renderProperty_u24lambda_u2416, getter2);
                }
                if (setter2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)((Appendable)$this$renderProperty_u24lambda_u2416).append('\n'), (String)"append('\\n')");
                    this.renderPropertyAccessor($this$renderProperty_u24lambda_u2416, setter2);
                }
                this_$iv.setIndent(this_$iv.getIndent() - 1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void renderReceiver(PrettyPrinter $this$renderReceiver, CallableDescriptor descriptor) {
        v0 = descriptor.getExtensionReceiverParameter();
        if (v0 == null) {
            return;
        }
        extensionReceiver = v0;
        if (!extensionReceiver.getAnnotations().isEmpty()) ** GOTO lbl-1000
        v1 = extensionReceiver.getType();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"extensionReceiver.type");
        if (this.needsParenthesis(v1)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = needsParentheses = false;
        }
        if (needsParentheses) {
            $this$renderReceiver.append('(');
        }
        v3 = extensionReceiver.getType();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"extensionReceiver.type");
        KtFe10Renderer.renderType$default(this, $this$renderReceiver, v3, false, 2, null);
        if (needsParentheses) {
            $this$renderReceiver.append(')');
        }
        $this$renderReceiver.append('.');
    }

    private final void renderConstructor(PrettyPrinter $this$renderConstructor, ConstructorDescriptor descriptor2) {
        if (this.options.getRenderDeclarationHeader()) {
            KtFe10Renderer.renderAnnotations$default(this, $this$renderConstructor, descriptor2, null, 2, null);
        }
        $this$renderConstructor.append("constructor");
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
        this.renderValueParameters($this$renderConstructor, list2);
    }

    private final void renderFunction(PrettyPrinter $this$renderFunction, FunctionDescriptor descriptor2) {
        if (this.options.getRenderDeclarationHeader()) {
            KtFe10Renderer.renderAnnotations$default(this, $this$renderFunction, descriptor2, null, 2, null);
            this.renderModifiers($this$renderFunction, descriptor2);
            $this$renderFunction.append("fun ");
            List<TypeParameterDescriptor> list2 = descriptor2.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.typeParameters");
            this.renderTypeParameters($this$renderFunction, list2);
            List<TypeParameterDescriptor> list3 = descriptor2.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"descriptor.typeParameters");
            if (!((Collection)list3).isEmpty()) {
                $this$renderFunction.append(" ");
            }
        }
        this.renderReceiver($this$renderFunction, descriptor2);
        this.renderName($this$renderFunction, descriptor2);
        List<ValueParameterDescriptor> list4 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"descriptor.valueParameters");
        this.renderValueParameters($this$renderFunction, list4);
        KotlinType returnType2 = descriptor2.getReturnType();
        if (returnType2 != null && !TypeUtilsKt.isUnit(returnType2)) {
            $this$renderFunction.append(": ");
            this.renderType($this$renderFunction, returnType2, this.options.getApproximateTypes());
        }
        List<TypeParameterDescriptor> list5 = descriptor2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list5, (String)"descriptor.typeParameters");
        this.renderWhereSuffix($this$renderFunction, list5);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderWhereSuffix(PrettyPrinter $this$renderWhereSuffix, List<? extends TypeParameterDescriptor> descriptors) {
        ArrayList upperBoundStrings = new ArrayList(0);
        for (TypeParameterDescriptor typeParameterDescriptor : descriptors) {
            void $this$mapTo$iv;
            List<KotlinType> list2 = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"typeParameter.upperBounds");
            Iterable iterable = CollectionsKt.drop((Iterable)list2, (int)1);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void $this$renderWhereSuffix_u24lambda_u2418_u24lambda_u2417;
                void it;
                PrettyPrinter prettyPrinter;
                KotlinType kotlinType = (KotlinType)item$iv;
                Collection collection = upperBoundStrings;
                boolean bl = false;
                StringBuilder stringBuilder2 = new StringBuilder();
                Name name2 = typeParameterDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"typeParameter.name");
                boolean $i$f$prettyPrint = false;
                PrettyPrinter prettyPrinter2 = prettyPrinter = new PrettyPrinter(0, 1, null);
                StringBuilder stringBuilder3 = stringBuilder2.append(RenderingUtilsKt.render(name2)).append(" : ");
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                KtFe10Renderer.renderType$default(this, (PrettyPrinter)$this$renderWhereSuffix_u24lambda_u2418_u24lambda_u2417, (KotlinType)it, false, 2, null);
                collection.add(stringBuilder3.append(prettyPrinter.toString()).toString());
            }
        }
        if (!((Collection)upperBoundStrings).isEmpty()) {
            $this$renderWhereSuffix.append(" where ");
            CollectionsKt.joinTo$default((Iterable)upperBoundStrings, (Appendable)$this$renderWhereSuffix, (CharSequence)", ", null, null, (int)0, null, null, (int)124, null);
            $this$renderWhereSuffix.append(' ');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderValueParameters(PrettyPrinter $this$renderValueParameters, List<? extends ValueParameterDescriptor> valueParameters2) {
        void prefix$iv;
        void this_$iv;
        PrettyPrinter prettyPrinter = $this$renderValueParameters;
        String string2 = ", ";
        String string3 = "(";
        String postfix$iv = ")";
        boolean $i$f$printCollection = false;
        this_$iv.append((CharSequence)prefix$iv);
        Iterator iterator$iv = ((Iterable)valueParameters2).iterator();
        while (iterator$iv.hasNext()) {
            void separator$iv;
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)iterator$iv.next();
            void $this$renderValueParameters_u24lambda_u2419 = this_$iv;
            boolean bl = false;
            KtFe10Renderer.renderValueParameter$default(this, (PrettyPrinter)$this$renderValueParameters_u24lambda_u2419, (ValueParameterDescriptor)it, null, 2, null);
            if (!iterator$iv.hasNext()) continue;
            this_$iv.append((CharSequence)separator$iv);
        }
        this_$iv.append(postfix$iv);
    }

    private final void renderValueParameter(PrettyPrinter $this$renderValueParameter, ValueParameterDescriptor descriptor2, Name name2) {
        if (this.options.getRenderDeclarationHeader()) {
            KtFe10Renderer.renderAnnotations$default(this, $this$renderValueParameter, descriptor2, null, 2, null);
        }
        this.renderModifiers($this$renderValueParameter, descriptor2);
        $this$renderValueParameter.append(RenderingUtilsKt.render(name2));
        $this$renderValueParameter.append(": ");
        KotlinType kotlinType = descriptor2.getVarargElementType();
        if (kotlinType == null) {
            KotlinType kotlinType2 = descriptor2.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"descriptor.type");
        }
        KtFe10Renderer.renderType$default(this, $this$renderValueParameter, kotlinType, false, 2, null);
        if (this.options.getRenderDefaultParameterValue() && ArgumentsUtilsKt.hasDefaultValue(descriptor2)) {
            $this$renderValueParameter.append(" = ...");
        }
    }

    static /* synthetic */ void renderValueParameter$default(KtFe10Renderer ktFe10Renderer, PrettyPrinter prettyPrinter, ValueParameterDescriptor valueParameterDescriptor, Name name2, int n, Object object) {
        if ((n & 2) != 0) {
            Name name3 = valueParameterDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"descriptor.name");
            name2 = name3;
        }
        ktFe10Renderer.renderValueParameter(prettyPrinter, valueParameterDescriptor, name2);
    }

    private final void renderName(PrettyPrinter $this$renderName, DeclarationDescriptor descriptor2) {
        Name name2 = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"descriptor.name");
        $this$renderName.append(RenderingUtilsKt.render(name2));
    }

    private final void renderAnnotations(PrettyPrinter $this$renderAnnotations, Annotated declaration, Function1<? super ClassId, Boolean> predicate) {
        if (!this.options.getModifiers().contains((Object)RendererModifier.ANNOTATIONS)) {
            return;
        }
        boolean isSingleLineAnnotations = declaration instanceof ValueParameterDescriptor || declaration instanceof TypeParameterDescriptor;
        RenderAnnotationsKt.renderFe10Annotations($this$renderAnnotations, declaration.getAnnotations(), isSingleLineAnnotations, this.options.getTypeRendererOptions().getShortQualifiedNames(), predicate);
    }

    static /* synthetic */ void renderAnnotations$default(KtFe10Renderer ktFe10Renderer, PrettyPrinter prettyPrinter, Annotated annotated, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = renderAnnotations.1.INSTANCE;
        }
        ktFe10Renderer.renderAnnotations(prettyPrinter, annotated, (Function1<? super ClassId, Boolean>)function1);
    }

    private final void renderModifiers(PrettyPrinter $this$renderModifiers, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof MemberDescriptor) {
            this.renderVisibility($this$renderModifiers, (DeclarationDescriptorWithVisibility)descriptor2);
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            this.renderModifier($this$renderModifiers, "const", ((PropertyDescriptor)descriptor2).isConst(), RendererModifier.CONST);
            this.renderModifier($this$renderModifiers, "lateinit", ((PropertyDescriptor)descriptor2).isLateInit(), RendererModifier.LATEINIT);
        }
        if (descriptor2 instanceof ValueParameterDescriptor) {
            KtFe10Renderer.renderModifier$default(this, $this$renderModifiers, "crossinline", ((ValueParameterDescriptor)descriptor2).isCrossinline(), null, 4, null);
            KtFe10Renderer.renderModifier$default(this, $this$renderModifiers, "noinline", ((ValueParameterDescriptor)descriptor2).isNoinline(), null, 4, null);
        }
        if (descriptor2 instanceof MemberDescriptor) {
            KtFe10Renderer.renderModifier$default(this, $this$renderModifiers, "external", ((MemberDescriptor)descriptor2).isExternal(), null, 4, null);
            this.renderModifier($this$renderModifiers, "expect", ((MemberDescriptor)descriptor2).isExpect(), RendererModifier.EXPECT);
            this.renderModifier($this$renderModifiers, "actual", ((MemberDescriptor)descriptor2).isActual(), RendererModifier.ACTUAL);
            this.renderModality($this$renderModifiers, (MemberDescriptor)descriptor2);
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            this.renderModifier($this$renderModifiers, "override", !(descriptor2 instanceof DeserializedDescriptor) && Kt1DescUtilsKt.isExplicitOverride((CallableMemberDescriptor)descriptor2), RendererModifier.OVERRIDE);
        }
        if (descriptor2 instanceof ValueParameterDescriptor) {
            KtFe10Renderer.renderModifier$default(this, $this$renderModifiers, "vararg", ArgumentsUtilsKt.isVararg((ValueParameterDescriptor)descriptor2), null, 4, null);
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            KtFe10Renderer.renderModifier$default(this, $this$renderModifiers, "tailrec", ((FunctionDescriptor)descriptor2).isTailrec(), null, 4, null);
            KtFe10Renderer.renderModifier$default(this, $this$renderModifiers, "suspend", ((FunctionDescriptor)descriptor2).isSuspend(), null, 4, null);
            this.renderModifier($this$renderModifiers, "inline", ((FunctionDescriptor)descriptor2).isInline(), RendererModifier.INLINE);
            KtFe10Renderer.renderModifier$default(this, $this$renderModifiers, "infix", ((FunctionDescriptor)descriptor2).isInfix(), null, 4, null);
            this.renderModifier($this$renderModifiers, "operator", ((FunctionDescriptor)descriptor2).isOperator(), RendererModifier.OPERATOR);
        }
        if (descriptor2 instanceof ClassDescriptor) {
            this.renderModifier($this$renderModifiers, "inner", ((ClassDescriptor)descriptor2).isInner(), RendererModifier.INNER);
            this.renderModifier($this$renderModifiers, "data", ((ClassDescriptor)descriptor2).isData(), RendererModifier.DATA);
            this.renderModifier($this$renderModifiers, "inline", ((ClassDescriptor)descriptor2).isInline(), RendererModifier.INNER);
            this.renderModifier($this$renderModifiers, "fun", ((ClassDescriptor)descriptor2).isFun(), RendererModifier.FUN);
            KtFe10Renderer.renderModifier$default(this, $this$renderModifiers, "companion", ((ClassDescriptor)descriptor2).isCompanionObject(), null, 4, null);
        }
    }

    private final void renderVisibility(PrettyPrinter $this$renderVisibility, DeclarationDescriptorWithVisibility descriptor2) {
        Visibility visibility2 = Kt1DescUtilsKt.getKtVisibility(descriptor2);
        this.renderModifier($this$renderVisibility, visibility2.getInternalDisplayName(), !IGNORED_VISIBILITIES.contains(visibility2), RendererModifier.VISIBILITY);
    }

    private final void renderModality(PrettyPrinter $this$renderModality, MemberDescriptor descriptor2) {
        if (descriptor2 instanceof PropertyAccessorDescriptor || descriptor2 instanceof CallableMemberDescriptor && Kt1DescUtilsKt.isExplicitOverride((CallableMemberDescriptor)descriptor2)) {
            return;
        }
        Modality modality = Kt1DescUtilsKt.getKtModality(descriptor2);
        this.renderModifier($this$renderModality, CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(modality.name()), modality != this.getDefaultModality(descriptor2), RendererModifier.MODALITY);
    }

    private final Modality getDefaultModality(MemberDescriptor descriptor2) {
        MemberDescriptor memberDescriptor = descriptor2;
        if (memberDescriptor instanceof ClassDescriptor) {
            return ((ClassDescriptor)descriptor2).getKind() == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
        }
        if (memberDescriptor instanceof CallableMemberDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            DeclarationDescriptor containingDeclaration = declarationDescriptor;
            if (!(containingDeclaration instanceof ClassDescriptor)) {
                return Modality.FINAL;
            }
            if (Kt1DescUtilsKt.isExplicitOverride((CallableMemberDescriptor)descriptor2) && Kt1DescUtilsKt.getKtModality((MemberDescriptor)containingDeclaration) != Modality.FINAL) {
                return Modality.OPEN;
            }
            if (((ClassDescriptor)containingDeclaration).getKind() == ClassKind.INTERFACE && !Intrinsics.areEqual((Object)((CallableMemberDescriptor)descriptor2).getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
                return Kt1DescUtilsKt.getKtModality(descriptor2) == Modality.ABSTRACT || ((CallableMemberDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.DELEGATION ? Modality.ABSTRACT : Modality.OPEN;
            }
            return Modality.FINAL;
        }
        return Modality.FINAL;
    }

    private final void renderModifier(PrettyPrinter $this$renderModifier, String text2, boolean state, RendererModifier modifier) {
        if (state && (modifier == null || this.options.getModifiers().contains((Object)modifier))) {
            $this$renderModifier.append(text2).append(' ');
        }
    }

    static /* synthetic */ void renderModifier$default(KtFe10Renderer ktFe10Renderer, PrettyPrinter prettyPrinter, String string2, boolean bl, RendererModifier rendererModifier, int n, Object object) {
        if ((n & 4) != 0) {
            rendererModifier = null;
        }
        ktFe10Renderer.renderModifier(prettyPrinter, string2, bl, rendererModifier);
    }

    private static final int sortDeclarations$getDeclarationKind(DeclarationDescriptor declaration) {
        DeclarationDescriptor declarationDescriptor = declaration;
        return declarationDescriptor instanceof ConstructorDescriptor ? (((ConstructorDescriptor)declaration).isPrimary() ? 1 : 2) : (declarationDescriptor instanceof PropertyDescriptor ? 3 : (declarationDescriptor instanceof FunctionDescriptor ? 4 : 5));
    }

    private static final int sortDeclarations$lambda$11(KtFe10Renderer this$0, DeclarationDescriptor left, DeclarationDescriptor right) {
        PrettyPrinter prettyPrinter;
        PrettyPrinter prettyPrinter2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)left, (String)"left");
        int n = KtFe10Renderer.sortDeclarations$getDeclarationKind(left);
        Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
        int kindResult = n - KtFe10Renderer.sortDeclarations$getDeclarationKind(right);
        if (kindResult != 0) {
            return kindResult;
        }
        String string2 = left.getName().asString();
        String string3 = right.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"right.name.asString()");
        int nameResult = string2.compareTo(string3);
        if (nameResult != 0) {
            return nameResult;
        }
        boolean $i$f$prettyPrint = false;
        PrettyPrinter $this$sortDeclarations_u24lambda_u2411_u24lambda_u249 = prettyPrinter2 = new PrettyPrinter(0, 1, null);
        boolean bl = false;
        this$0.renderDeclaration($this$sortDeclarations_u24lambda_u2411_u24lambda_u249, left);
        String leftString = prettyPrinter2.toString();
        boolean $i$f$prettyPrint2 = false;
        PrettyPrinter $this$sortDeclarations_u24lambda_u2411_u24lambda_u2410 = prettyPrinter = new PrettyPrinter(0, 1, null);
        boolean bl2 = false;
        this$0.renderDeclaration($this$sortDeclarations_u24lambda_u2411_u24lambda_u2410, right);
        String rightString = prettyPrinter.toString();
        return leftString.compareTo(rightString);
    }

    private static final boolean renderProperty$shouldRenderAccessor(PropertyDescriptor $descriptor, PropertyAccessorDescriptor accessor) {
        return !accessor.getAnnotations().isEmpty() || !Intrinsics.areEqual((Object)accessor.getVisibility(), (Object)$descriptor.getVisibility());
    }

    static {
        Object[] objectArray = new Visibility[]{Visibilities.Local.INSTANCE, Visibilities.PrivateToThis.INSTANCE, Visibilities.InvisibleFake.INSTANCE, Visibilities.Inherited.INSTANCE, Visibilities.Unknown.INSTANCE, Visibilities.INSTANCE.getDEFAULT_VISIBILITY()};
        IGNORED_VISIBILITIES = SetsKt.setOf((Object[])objectArray);
        objectArray = new ClassId[]{StandardClassIds.INSTANCE.getEnum(), StandardClassIds.INSTANCE.getAnnotation()};
        IGNORED_SUPERTYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/utils/KtFe10Renderer$Companion;", "", "()V", "IGNORED_SUPERTYPES", "", "Lorg/jetbrains/kotlin/name/ClassId;", "getIGNORED_SUPERTYPES", "()Ljava/util/Set;", "IGNORED_VISIBILITIES", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "getIGNORED_VISIBILITIES", "analysis-api-fe10"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Visibility> getIGNORED_VISIBILITIES() {
            return IGNORED_VISIBILITIES;
        }

        @NotNull
        public final Set<ClassId> getIGNORED_SUPERTYPES() {
            return IGNORED_SUPERTYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

