/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u00a6\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H&\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "", "()V", "computeOnlyClassStatus", "", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "endComputing", "get", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$StatusComputationStatus;", "startComputing", "ForLocalClassResolution", "Regular", "StatusComputationStatus", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$ForLocalClassResolution;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$Regular;", "resolve"})
public abstract class StatusComputationSession {
    private StatusComputationSession() {
    }

    @NotNull
    public abstract StatusComputationStatus get(@NotNull FirClass var1);

    @NotNull
    public abstract StatusComputationStatus startComputing(@NotNull FirClass var1);

    public abstract void endComputing(@NotNull FirClass var1);

    public abstract void computeOnlyClassStatus(@NotNull FirClass var1);

    public /* synthetic */ StatusComputationSession(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$StatusComputationStatus;", "", "requiresComputation", "", "(Ljava/lang/String;IZ)V", "getRequiresComputation", "()Z", "NotComputed", "Computing", "ComputedOnlyClassStatus", "Computed", "resolve"})
    public static final class StatusComputationStatus
    extends Enum<StatusComputationStatus> {
        private final boolean requiresComputation;
        public static final /* enum */ StatusComputationStatus NotComputed = new StatusComputationStatus(true);
        public static final /* enum */ StatusComputationStatus Computing = new StatusComputationStatus(false);
        public static final /* enum */ StatusComputationStatus ComputedOnlyClassStatus = new StatusComputationStatus(true);
        public static final /* enum */ StatusComputationStatus Computed = new StatusComputationStatus(false);
        private static final /* synthetic */ StatusComputationStatus[] $VALUES;

        private StatusComputationStatus(boolean requiresComputation) {
            this.requiresComputation = requiresComputation;
        }

        public final boolean getRequiresComputation() {
            return this.requiresComputation;
        }

        public static StatusComputationStatus[] values() {
            return (StatusComputationStatus[])$VALUES.clone();
        }

        public static StatusComputationStatus valueOf(String value2) {
            return Enum.valueOf(StatusComputationStatus.class, value2);
        }

        static {
            $VALUES = statusComputationStatusArray = new StatusComputationStatus[]{StatusComputationStatus.NotComputed, StatusComputationStatus.Computing, StatusComputationStatus.ComputedOnlyClassStatus, StatusComputationStatus.Computed};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0011\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0096\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$Regular;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "()V", "statusMap", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$StatusComputationStatus;", "computeOnlyClassStatus", "", "klass", "endComputing", "get", "startComputing", "resolve"})
    public static final class Regular
    extends StatusComputationSession {
        @NotNull
        private final Map<FirClass, StatusComputationStatus> statusMap = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), (Function1)statusMap.1.INSTANCE);

        public Regular() {
            super(null);
        }

        @Override
        @NotNull
        public StatusComputationStatus get(@NotNull FirClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            return (StatusComputationStatus)((Object)MapsKt.getValue(this.statusMap, (Object)klass));
        }

        @Override
        @NotNull
        public StatusComputationStatus startComputing(@NotNull FirClass klass) {
            StatusComputationStatus statusComputationStatus;
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            Map<FirClass, StatusComputationStatus> $this$getOrPut$iv = this.statusMap;
            boolean $i$f$getOrPut = false;
            StatusComputationStatus value$iv = $this$getOrPut$iv.get(klass);
            if (value$iv == null) {
                boolean bl = false;
                StatusComputationStatus answer$iv = StatusComputationStatus.Computing;
                $this$getOrPut$iv.put(klass, answer$iv);
                statusComputationStatus = answer$iv;
            } else {
                statusComputationStatus = value$iv;
            }
            return statusComputationStatus;
        }

        @Override
        public void endComputing(@NotNull FirClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            this.statusMap.put(klass, StatusComputationStatus.Computed);
        }

        @Override
        public void computeOnlyClassStatus(@NotNull FirClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            StatusComputationStatus existedStatus = (StatusComputationStatus)((Object)MapsKt.getValue(this.statusMap, (Object)klass));
            if (existedStatus.compareTo((Enum)StatusComputationStatus.ComputedOnlyClassStatus) < 0) {
                this.statusMap.put(klass, StatusComputationStatus.ComputedOnlyClassStatus);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$ForLocalClassResolution;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "localClasses", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "(Ljava/util/Set;)V", "delegate", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$Regular;", "computeOnlyClassStatus", "", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "endComputing", "get", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$StatusComputationStatus;", "startComputing", "resolve"})
    public static final class ForLocalClassResolution
    extends StatusComputationSession {
        @NotNull
        private final Set<FirClassLikeDeclaration> localClasses;
        @NotNull
        private final Regular delegate;

        public ForLocalClassResolution(@NotNull Set<? extends FirClassLikeDeclaration> localClasses) {
            Intrinsics.checkNotNullParameter(localClasses, (String)"localClasses");
            super(null);
            this.localClasses = localClasses;
            this.delegate = new Regular();
        }

        @Override
        @NotNull
        public StatusComputationStatus get(@NotNull FirClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            if (!this.localClasses.contains(klass)) {
                return StatusComputationStatus.Computed;
            }
            return this.delegate.get(klass);
        }

        @Override
        @NotNull
        public StatusComputationStatus startComputing(@NotNull FirClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            return this.delegate.startComputing(klass);
        }

        @Override
        public void endComputing(@NotNull FirClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            this.delegate.endComputing(klass);
        }

        @Override
        public void computeOnlyClassStatus(@NotNull FirClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            this.delegate.computeOnlyClassStatus(klass);
        }
    }
}

