/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirValueClassRepresentationKt;
import org.jetbrains.kotlin.fir.declarations.ValueClassesUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.AbstractFirStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0014J\f\u0010\u0017\u001a\u00020\u0015*\u00020\u0016H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "statusComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "designationMapForLocalClasses", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "scopeForLocalClass", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "data", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "needResolveMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "needResolveNestedClassifiers", "resolve"})
public class FirStatusResolveTransformer
extends AbstractFirStatusResolveTransformer {
    public FirStatusResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull StatusComputationSession statusComputationSession, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses, @Nullable FirScope scopeForLocalClass) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)statusComputationSession, (String)"statusComputationSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, (String)"designationMapForLocalClasses");
        super(session2, scopeSession, statusComputationSession, designationMapForLocalClasses, scopeForLocalClass);
    }

    public /* synthetic */ FirStatusResolveTransformer(FirSession firSession, ScopeSession scopeSession, StatusComputationSession statusComputationSession, Map map, FirScope firScope2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            firScope2 = null;
        }
        this(firSession, scopeSession, statusComputationSession, map, firScope2);
    }

    @Override
    protected boolean needResolveMembers(@NotNull FirDeclaration $this$needResolveMembers) {
        Intrinsics.checkNotNullParameter((Object)$this$needResolveMembers, (String)"<this>");
        if ($this$needResolveMembers instanceof FirRegularClass) {
            return this.getStatusComputationSession().get((FirClass)$this$needResolveMembers) != StatusComputationSession.StatusComputationStatus.Computed;
        }
        return true;
    }

    @Override
    protected boolean needResolveNestedClassifiers(@NotNull FirDeclaration $this$needResolveNestedClassifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$needResolveNestedClassifiers, (String)"<this>");
        return true;
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable FirResolvedDeclarationStatus data) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        StatusComputationSession.StatusComputationStatus computationStatus = this.getStatusComputationSession().startComputing(regularClass);
        this.forceResolveStatusesOfSupertypes(regularClass);
        if (computationStatus != StatusComputationSession.StatusComputationStatus.Computed) {
            regularClass.transformStatus(this, this.getStatusResolver().resolveStatus(regularClass, this.getContainingClass(), false));
            if (regularClass.getStatus().isInline()) {
                FirValueClassRepresentationKt.setValueClassRepresentation(regularClass, ValueClassesUtilsKt.computeValueClassRepresentation(regularClass, this.getSession()));
            }
        }
        FirStatement it = firStatement = this.transformClass((FirClass)regularClass, data);
        boolean bl = false;
        this.getStatusComputationSession().endComputing(regularClass);
        return firStatement;
    }
}

