/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.ModuleFileCache;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R/\u0010\u0005\u001a#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCacheImpl;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/ModuleFileCache;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "ktFileToFirFile", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/annotations/NotNull;", "getModuleComponents", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "fileCached", "file", "createValue", "Lkotlin/Function0;", "getCachedFirFile", "ktFile", "getContainerFirFile", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "low-level-api-fir"})
public final class ModuleFileCacheImpl
extends ModuleFileCache {
    @NotNull
    private final LLFirModuleResolveComponents moduleComponents;
    @NotNull
    private final ConcurrentMap<KtFile, FirFile> ktFileToFirFile;

    public ModuleFileCacheImpl(@NotNull LLFirModuleResolveComponents moduleComponents) {
        Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
        this.moduleComponents = moduleComponents;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentIdentityMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentIdentityMap<KtFile, FirFile>()");
        this.ktFileToFirFile = concurrentMap;
    }

    @Override
    @NotNull
    public LLFirModuleResolveComponents getModuleComponents() {
        return this.moduleComponents;
    }

    @Override
    @NotNull
    public FirFile fileCached(@NotNull KtFile file2, @NotNull Function0<? extends FirFile> createValue) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(createValue, (String)"createValue");
        FirFile firFile = this.ktFileToFirFile.computeIfAbsent(file2, arg_0 -> ModuleFileCacheImpl.fileCached$lambda$0(createValue, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)firFile, (String)"ktFileToFirFile.computeI\u2026t(file) { createValue() }");
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getCachedFirFile(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        return (FirFile)this.ktFileToFirFile.get(ktFile);
    }

    @Override
    @Nullable
    public FirFile getContainerFirFile(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        PsiElement psiElement = UtilsKt.getPsi(declaration);
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        return this.getCachedFirFile(ktFile2);
    }

    private static final FirFile fileCached$lambda$0(Function0 $createValue, KtFile it) {
        Intrinsics.checkNotNullParameter((Object)$createValue, (String)"$createValue");
        return (FirFile)$createValue.invoke();
    }
}

