/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationIndex;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProvider;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "index", "Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationIndex;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationIndex;Lcom/intellij/psi/search/GlobalSearchScope;)V", "inScope", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "getInScope", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "findFilesForFacade", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "facadeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getClassNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "packageFqName", "getClassesByClassId", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFacadeFilesInPackage", "getFunctionsNamesInPackage", "getPropertyNamesInPackage", "getTopLevelFunctions", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "getTopLevelProperties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getTypeAliasNamesInPackage", "getTypeAliasesByClassId", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "analysis-api-providers"})
public final class KotlinStaticDeclarationProvider
extends KotlinDeclarationProvider {
    @NotNull
    private final KotlinStaticDeclarationIndex index;
    @NotNull
    private final GlobalSearchScope scope;

    public KotlinStaticDeclarationProvider(@NotNull KotlinStaticDeclarationIndex index2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.index = index2;
        this.scope = scope2;
    }

    private final boolean getInScope(KtElement $this$inScope) {
        return this.scope.contains($this$inScope.getContainingKtFile().getVirtualFile());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtClassOrObject> getClassesByClassId(@NotNull ClassId classId) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Set<KtClassOrObject> set = this.index.getClassMap$analysis_api_providers().get(classId.getPackageFqName());
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtClassOrObject ktClassOrObject = (KtClassOrObject)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)ktClassOrObject.getClassId(), (Object)classId) && this.getInScope(ktClassOrObject))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtTypeAlias> getTypeAliasesByClassId(@NotNull ClassId classId) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Set<KtTypeAlias> set = this.index.getTypeAliasMap$analysis_api_providers().get(classId.getPackageFqName());
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtTypeAlias ktTypeAlias = (KtTypeAlias)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)ktTypeAlias.getClassId(), (Object)classId) && this.getInScope(ktTypeAlias))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName packageFqName) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Set<KtClassOrObject> set2 = this.index.getClassMap$analysis_api_providers().get(packageFqName);
        if (set2 != null) {
            void $this$mapNotNullTo$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set2;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtClassOrObject ktClassOrObject = (KtClassOrObject)element$iv$iv;
                boolean bl = false;
                if (!this.getInScope(ktClassOrObject)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl2 = false;
                if (it.getNameAsName() == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            set = (Set)destination$iv;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Name> getTypeAliasNamesInPackage(@NotNull FqName packageFqName) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Set<KtTypeAlias> set2 = this.index.getTypeAliasMap$analysis_api_providers().get(packageFqName);
        if (set2 != null) {
            void $this$mapNotNullTo$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set2;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtTypeAlias ktTypeAlias = (KtTypeAlias)element$iv$iv;
                boolean bl = false;
                if (!this.getInScope(ktTypeAlias)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                KtTypeAlias it = (KtTypeAlias)element$iv;
                boolean bl2 = false;
                if (it.getNameAsName() == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            set = (Set)destination$iv;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Name> getPropertyNamesInPackage(@NotNull FqName packageFqName) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Set<KtProperty> set2 = this.index.getTopLevelPropertyMap$analysis_api_providers().get(packageFqName);
        if (set2 != null) {
            void $this$mapNotNullTo$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set2;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtProperty ktProperty = (KtProperty)element$iv$iv;
                boolean bl = false;
                if (!this.getInScope(ktProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                KtProperty it = (KtProperty)element$iv;
                boolean bl2 = false;
                if (it.getNameAsName() == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            set = (Set)destination$iv;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Name> getFunctionsNamesInPackage(@NotNull FqName packageFqName) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Set<KtNamedFunction> set2 = this.index.getTopLevelFunctionMap$analysis_api_providers().get(packageFqName);
        if (set2 != null) {
            void $this$mapNotNullTo$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set2;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtNamedFunction ktNamedFunction = (KtNamedFunction)element$iv$iv;
                boolean bl = false;
                if (!this.getInScope(ktNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                KtNamedFunction it = (KtNamedFunction)element$iv;
                boolean bl2 = false;
                if (it.getNameAsName() == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            set = (Set)destination$iv;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtFile> getFacadeFilesInPackage(@NotNull FqName packageFqName) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Set<KtFile> set = this.index.getFacadeFileMap$analysis_api_providers().get(packageFqName);
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtFile ktFile = (KtFile)element$iv$iv;
                boolean bl = false;
                if (!this.scope.contains(ktFile.getVirtualFile())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtFile> findFilesForFacade(@NotNull FqName facadeFqName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)facadeFqName, (String)"facadeFqName");
        if (facadeFqName.shortNameOrSpecial().isSpecial()) {
            return CollectionsKt.emptyList();
        }
        FqName fqName2 = facadeFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"facadeFqName.parent()");
        Iterable $this$filter$iv = this.getFacadeFilesInPackage(fqName2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)JvmFileClassUtilKt.getJavaFileFacadeFqName(it), (Object)facadeFqName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtProperty> getTopLevelProperties(@NotNull CallableId callableId) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        Set<KtProperty> set = this.index.getTopLevelPropertyMap$analysis_api_providers().get(callableId.getPackageName());
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtProperty ktProperty = (KtProperty)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)ktProperty.getNameAsName(), (Object)callableId.getCallableName()) && this.getInScope(ktProperty))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtNamedFunction> getTopLevelFunctions(@NotNull CallableId callableId) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        Set<KtNamedFunction> set = this.index.getTopLevelFunctionMap$analysis_api_providers().get(callableId.getPackageName());
        if (set != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtNamedFunction ktNamedFunction = (KtNamedFunction)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)ktNamedFunction.getNameAsName(), (Object)callableId.getCallableName()) && this.getInScope(ktNamedFunction))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }
}

