/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/AbstractDeclarationFromLibraryModuleProvider;", "", "jarFileSystem", "Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "getJarFileSystem", "()Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "findRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "rootPath", "Ljava/nio/file/Path;", "fs", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "isCompiledFile", "", "virtualFile", "relativeFqName", "", "root", "virtualFilesFromModule", "", "libraryModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtLibraryModule;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "isPackageName", "analysis-api-providers"})
public interface AbstractDeclarationFromLibraryModuleProvider {
    @NotNull
    public GlobalSearchScope getScope();

    @NotNull
    public CoreJarFileSystem getJarFileSystem();

    @NotNull
    public Collection<VirtualFile> virtualFilesFromModule(@NotNull KtLibraryModule var1, @NotNull FqName var2, boolean var3);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Collection<VirtualFile> virtualFilesFromModule(@NotNull AbstractDeclarationFromLibraryModuleProvider $this, @NotNull KtLibraryModule libraryModule, @NotNull FqName fqName2, boolean isPackageName) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)libraryModule, (String)"libraryModule");
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            String string2 = fqName2.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.asString()");
            String fqNameString = string2;
            VirtualFileSystem fs = StandardFileSystems.local();
            Iterable $this$flatMap$iv = libraryModule.getBinaryRoots();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Set set;
                Path rootPath = (Path)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)fs, (String)"fs");
                if (DefaultImpls.findRoot($this, rootPath, fs) == null) {
                    set = SetsKt.emptySet();
                } else {
                    VirtualFile root2;
                    Set files2 = new LinkedHashSet();
                    VfsUtilCore.iterateChildrenRecursively((VirtualFile)root2, arg_0 -> DefaultImpls.virtualFilesFromModule$lambda-2$lambda-0(root2, $this, fqNameString, isPackageName, arg_0), arg_0 -> DefaultImpls.virtualFilesFromModule$lambda-2$lambda-1($this, files2, arg_0));
                    set = files2;
                }
                Iterable list$iv$iv = set;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private static VirtualFile findRoot(AbstractDeclarationFromLibraryModuleProvider $this, Path rootPath, VirtualFileSystem fs) {
            return rootPath.toFile().isDirectory() ? fs.findFileByPath(((Object)rootPath.toAbsolutePath()).toString()) : $this.getJarFileSystem().refreshAndFindFileByPath(rootPath.toAbsolutePath() + "!/");
        }

        private static String relativeFqName(AbstractDeclarationFromLibraryModuleProvider $this, VirtualFile root2, VirtualFile virtualFile) {
            String string2;
            if (root2.isDirectory()) {
                List list2;
                List $this$relativeFqName_u24lambda_u2d3 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                VirtualFile cur = virtualFile;
                while (!Intrinsics.areEqual((Object)cur, (Object)root2)) {
                    $this$relativeFqName_u24lambda_u2d3.add(cur.getNameWithoutExtension());
                    Intrinsics.checkNotNullExpressionValue((Object)cur.getParent(), (String)"cur.parent");
                }
                List fragments2 = CollectionsKt.build((List)list2);
                string2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)fragments2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            } else {
                String string3 = virtualFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"virtualFile.path");
                String[] stringArray = new String[]{"!/"};
                string2 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                if (string2 == null || (string2 = StringsKt.replace$default((String)string2, (String)"/", (String)".", (boolean)false, (int)4, null)) == null) {
                    string2 = "!/";
                }
            }
            return string2;
        }

        private static boolean isCompiledFile(AbstractDeclarationFromLibraryModuleProvider $this, VirtualFile virtualFile) {
            boolean bl;
            String string2 = virtualFile.getExtension();
            if (string2 != null) {
                String string3 = JavaClassFileType.INSTANCE.getDefaultExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"INSTANCE.defaultExtension");
                bl = StringsKt.endsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null);
            } else {
                bl = false;
            }
            return bl;
        }

        private static boolean virtualFilesFromModule$lambda-2$lambda-0(VirtualFile $root, AbstractDeclarationFromLibraryModuleProvider this$0, String $fqNameString, boolean $isPackageName, VirtualFile it) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$fqNameString, (String)"$fqNameString");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (Intrinsics.areEqual((Object)it, (Object)$root)) {
                return true;
            }
            String relativeFqName = DefaultImpls.relativeFqName(this$0, $root, it);
            if (it.isDirectory() && StringsKt.startsWith$default((String)$fqNameString, (String)relativeFqName, (boolean)false, (int)2, null)) {
                return true;
            }
            if ($isPackageName) {
                VirtualFile virtualFile = it.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it.parent");
                bl = StringsKt.endsWith$default((String)DefaultImpls.relativeFqName(this$0, $root, virtualFile), (String)$fqNameString, (boolean)false, (int)2, null);
            } else {
                bl = Intrinsics.areEqual((Object)relativeFqName, (Object)$fqNameString);
            }
            return bl;
        }

        private static boolean virtualFilesFromModule$lambda-2$lambda-1(AbstractDeclarationFromLibraryModuleProvider this$0, Set $files, VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (!it.isDirectory() && DefaultImpls.isCompiledFile(this$0, it) && this$0.getScope().contains(it)) {
                $files.add(it);
            }
            return true;
        }
    }
}

