/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.KtDeclarationAndFirDeclarationEqualityChecker;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a&\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0007*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"representSameConstructor", "", "psiConstructor", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "firConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "findCallableCandidates", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "isTopLevel", "findFunctionCandidates", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "findPropertyCandidates", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "low-level-api-fir"})
public final class FirDeclarationForCompiledElementSearcherKt {
    /*
     * WARNING - void declaration
     */
    private static final List<FirFunctionSymbol<?>> findFunctionCandidates(FirSymbolProvider $this$findFunctionCandidates, KtNamedFunction function2) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = FirDeclarationForCompiledElementSearcherKt.findCallableCandidates($this$findFunctionCandidates, function2, function2.isTopLevel());
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirFunctionSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<FirPropertySymbol> findPropertyCandidates(FirSymbolProvider $this$findPropertyCandidates, KtProperty property2) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = FirDeclarationForCompiledElementSearcherKt.findCallableCandidates($this$findPropertyCandidates, property2, property2.isTopLevel());
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<FirCallableSymbol<?>> findCallableCandidates(FirSymbolProvider $this$findCallableCandidates, KtCallableDeclaration declaration, boolean isTopLevel) {
        if (isTopLevel) {
            FqName fqName2 = declaration.getContainingKtFile().getPackageFqName();
            Name name2 = declaration.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"declaration.nameAsSafeName");
            return $this$findCallableCandidates.getTopLevelCallableSymbols(fqName2, name2);
        }
        Object object = KtPsiUtilKt.getContainingClassOrObject(declaration);
        if (object == null || (object = ((KtClassOrObject)object).getClassId()) == null) {
            throw new IllegalStateException(("No containing non-local declaration found for " + UtilsKt.getElementTextInContext(declaration)).toString());
        }
        Object containerClassId = object;
        Name name3 = declaration.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"declaration.nameAsSafeName");
        Collection collection = FirSymbolProviderKt.getClassDeclaredFunctionSymbols($this$findCallableCandidates, (ClassId)containerClassId, name3);
        Name name4 = declaration.getNameAsSafeName();
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"declaration.nameAsSafeName");
        return CollectionsKt.plus((Collection)collection, (Iterable)FirSymbolProviderKt.getClassDeclaredPropertySymbols($this$findCallableCandidates, (ClassId)containerClassId, name4));
    }

    private static final boolean representSameConstructor(KtConstructor<?> psiConstructor, FirConstructor firConstructor) {
        if (firConstructor.isPrimary() != psiConstructor instanceof KtPrimaryConstructor) {
            return false;
        }
        return KtDeclarationAndFirDeclarationEqualityChecker.INSTANCE.representsTheSameDeclaration(psiConstructor, firConstructor);
    }

    public static final /* synthetic */ List access$findFunctionCandidates(FirSymbolProvider $receiver, KtNamedFunction function2) {
        return FirDeclarationForCompiledElementSearcherKt.findFunctionCandidates($receiver, function2);
    }

    public static final /* synthetic */ List access$findPropertyCandidates(FirSymbolProvider $receiver, KtProperty property2) {
        return FirDeclarationForCompiledElementSearcherKt.findPropertyCandidates($receiver, property2);
    }

    public static final /* synthetic */ boolean access$representSameConstructor(KtConstructor psiConstructor, FirConstructor firConstructor) {
        return FirDeclarationForCompiledElementSearcherKt.representSameConstructor(psiConstructor, firConstructor);
    }
}

