/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a'\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u000e\b\u0004\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\f\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000bH\u0002\u001a\n\u0010\u000f\u001a\u00020\u000e*\u00020\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0010"}, d2={"findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "script", "Lkotlin/script/experimental/api/SourceCode;", "runReadAction", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "isKotlinFileType", "", "isNonScript", "kotlin-scripting-compiler-impl"})
public final class DefinitionsKt {
    public static final <T> T runReadAction(@NotNull Function0<? extends T> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        boolean $i$f$runReadAction = false;
        return (T)ApplicationManager.getApplication().runReadAction(new Computable(runnable){
            final /* synthetic */ Function0<T> $runnable;
            {
                this.$runnable = $runnable;
            }

            public final T compute() {
                return (T)this.$runnable.invoke();
            }
        });
    }

    @Nullable
    public static final ScriptDefinition findScriptDefinition(@NotNull PsiFile $this$findScriptDefinition) {
        Intrinsics.checkNotNullParameter((Object)$this$findScriptDefinition, (String)"<this>");
        if (!($this$findScriptDefinition instanceof KtFile)) {
            return null;
        }
        VirtualFile virtualFile = ((KtFile)$this$findScriptDefinition).getVirtualFile();
        if (virtualFile == null) {
            virtualFile = ((KtFile)$this$findScriptDefinition).getOriginalFile().getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (DefinitionsKt.isNonScript(virtualFile2)) {
            return null;
        }
        Project project = ((KtFile)$this$findScriptDefinition).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return DefinitionsKt.findScriptDefinition(project, new KtFileScriptSource((KtFile)$this$findScriptDefinition, null, 2, null));
    }

    @Deprecated(message="Use PsiFile.findScriptDefinition() instead")
    @Nullable
    public static final ScriptDefinition findScriptDefinition(@NotNull VirtualFile $this$findScriptDefinition, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$findScriptDefinition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!$this$findScriptDefinition.isValid() || DefinitionsKt.isNonScript($this$findScriptDefinition)) {
            return null;
        }
        boolean $i$f$runReadAction = false;
        if (ApplicationManager.getApplication().runReadAction(new Computable(project, $this$findScriptDefinition){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ VirtualFile $this_findScriptDefinition$inlined;
            {
                this.$project$inlined = project;
                this.$this_findScriptDefinition$inlined = virtualFile;
            }

            public final T compute() {
                boolean bl = false;
                PsiFile psiFile = PsiManager.getInstance((Project)this.$project$inlined).findFile(this.$this_findScriptDefinition$inlined);
                return (T)(psiFile instanceof KtFile ? (KtFile)psiFile : null);
            }
        }) == null) {
            return null;
        }
        return DefinitionsKt.findScriptDefinition(project, new VirtualFileScriptSource($this$findScriptDefinition, null, 2, null));
    }

    @Nullable
    public static final ScriptDefinition findScriptDefinition(@NotNull Project project, @NotNull SourceCode script) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance(project);
        if (scriptDefinitionProvider == null) {
            throw new IllegalStateException("Unable to get script definition: ScriptDefinitionProvider is not configured.");
        }
        ScriptDefinitionProvider scriptDefinitionProvider2 = scriptDefinitionProvider;
        ScriptDefinition scriptDefinition = scriptDefinitionProvider2.findDefinition(script);
        if (scriptDefinition == null) {
            scriptDefinition = scriptDefinitionProvider2.getDefaultDefinition();
        }
        return scriptDefinition;
    }

    public static final boolean isNonScript(@NotNull VirtualFile $this$isNonScript) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonScript, (String)"<this>");
        return $this$isNonScript.isDirectory() || Intrinsics.areEqual((Object)$this$isNonScript.getExtension(), (Object)"kt") || Intrinsics.areEqual((Object)$this$isNonScript.getExtension(), (Object)JavaClassFileType.INSTANCE.getDefaultExtension()) || !DefinitionsKt.isKotlinFileType($this$isNonScript);
    }

    private static final boolean isKotlinFileType(VirtualFile $this$isKotlinFileType) {
        if (Intrinsics.areEqual((Object)$this$isKotlinFileType.getExtension(), (Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX)) {
            return true;
        }
        FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
        return Intrinsics.areEqual((Object)typeRegistry.getFileTypeByFile($this$isKotlinFileType), (Object)((Object)KotlinFileType.INSTANCE)) || Intrinsics.areEqual((Object)typeRegistry.getFileTypeByFileName($this$isKotlinFileType.getName()), (Object)((Object)KotlinFileType.INSTANCE));
    }
}

