/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirIntegerLiteralOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerConstantOperatorScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001a\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0016J)\u0010 \u001a\u0002H!\"\b\b\u0000\u0010!*\u00020\"2\u0006\u0010#\u001a\u0002H!2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010$J\u001a\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "toLongSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getToLongSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "toLongSymbol$delegate", "Lkotlin/Lazy;", "toULongSymbol", "getToULongSymbol", "toULongSymbol$delegate", "findConversionFunction", "receiverType", "Lorg/jetbrains/kotlin/fir/types/impl/FirImplicitBuiltinTypeRef;", "name", "Lorg/jetbrains/kotlin/name/Name;", "transformConstExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "T", "constExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "data", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformIntegerLiteralOperatorCall", "integerLiteralOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirIntegerLiteralOperatorCall;", "Companion", "resolve"})
public final class IntegerLiteralAndOperatorApproximationTransformer
extends FirTransformer<ConeKotlinType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final Lazy toLongSymbol$delegate;
    @NotNull
    private final Lazy toULongSymbol$delegate;
    @NotNull
    private static final Name TO_LONG;
    @NotNull
    private static final Name TO_U_LONG;

    public IntegerLiteralAndOperatorApproximationTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.session = session2;
        this.scopeSession = scopeSession;
        this.toLongSymbol$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FirNamedFunctionSymbol>(this){
            final /* synthetic */ IntegerLiteralAndOperatorApproximationTransformer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FirNamedFunctionSymbol invoke() {
                return IntegerLiteralAndOperatorApproximationTransformer.access$findConversionFunction(this.this$0, this.this$0.getSession().getBuiltinTypes().getIntType(), IntegerLiteralAndOperatorApproximationTransformer.access$getTO_LONG$cp());
            }
        }));
        this.toULongSymbol$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FirNamedFunctionSymbol>(this){
            final /* synthetic */ IntegerLiteralAndOperatorApproximationTransformer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FirNamedFunctionSymbol invoke() {
                return IntegerLiteralAndOperatorApproximationTransformer.access$findConversionFunction(this.this$0, this.this$0.getSession().getBuiltinTypes().getUIntType(), IntegerLiteralAndOperatorApproximationTransformer.access$getTO_U_LONG$cp());
            }
        }));
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    private final FirNamedFunctionSymbol getToLongSymbol() {
        Lazy lazy = this.toLongSymbol$delegate;
        return (FirNamedFunctionSymbol)lazy.getValue();
    }

    private final FirNamedFunctionSymbol getToULongSymbol() {
        Lazy lazy = this.toULongSymbol$delegate;
        return (FirNamedFunctionSymbol)lazy.getValue();
    }

    private final FirNamedFunctionSymbol findConversionFunction(FirImplicitBuiltinTypeRef receiverType, Name name2) {
        FirTypeScope firTypeScope = ScopeUtilsKt.scope((ConeKotlinType)receiverType.getType(), this.session, this.scopeSession, FakeOverrideTypeCalculator.DoNothing.INSTANCE);
        Intrinsics.checkNotNull((Object)firTypeScope);
        return (FirNamedFunctionSymbol)CollectionsKt.single(FirScopeKt.getFunctions(firTypeScope, name2));
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable ConeKotlinType data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    @Override
    @NotNull
    public <T> FirStatement transformConstExpression(@NotNull FirConstExpression<T> constExpression, @Nullable ConeKotlinType data) {
        Intrinsics.checkNotNullParameter(constExpression, (String)"constExpression");
        FirExpression $this$resultType$iv = constExpression;
        boolean $i$f$getResultType = false;
        FirPureAbstractElement $this$coneTypeSafe$iv = $this$resultType$iv.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeIntegerLiteralType)) {
            coneKotlinType = null;
        }
        ConeIntegerLiteralType coneIntegerLiteralType = (ConeIntegerLiteralType)((ConeKotlinType)((ConeIntegerLiteralType)coneKotlinType));
        if (coneIntegerLiteralType == null) {
            return constExpression;
        }
        ConeIntegerLiteralType type2 = coneIntegerLiteralType;
        ConeClassLikeType approximatedType = type2.getApproximatedType(data);
        $this$coneTypeSafe$iv = constExpression;
        FirExpression $this$resultType$iv2 = constExpression;
        boolean $i$f$getResultType2 = false;
        FirTypeRef type$iv = CopyUtilsKt.resolvedTypeFromPrototype($this$resultType$iv2.getTypeRef(), approximatedType);
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceTypeRef(type$iv);
        ConstantValueKind<?> constantValueKind = FirTypeUtilsKt.toConstKind(approximatedType);
        Intrinsics.checkNotNull(constantValueKind, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.ConstantValueKind<T of org.jetbrains.kotlin.fir.resolve.transformers.IntegerLiteralAndOperatorApproximationTransformer.transformConstExpression>");
        ConstantValueKind<?> kind = constantValueKind;
        constExpression.replaceKind(kind);
        return constExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformIntegerLiteralOperatorCall(@NotNull FirIntegerLiteralOperatorCall integerLiteralOperatorCall, @Nullable ConeKotlinType data) {
        void $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2_u24lambda_u2d1;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Intrinsics.checkNotNullParameter((Object)integerLiteralOperatorCall, (String)"integerLiteralOperatorCall");
        FirIntegerLiteralOperatorCall call2 = integerLiteralOperatorCall;
        FirExpression $this$resultType$iv = call2;
        boolean $i$f$getResultType = false;
        FirPureAbstractElement $this$coneTypeSafe$iv = $this$resultType$iv.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeIntegerLiteralType)) {
            coneKotlinType = null;
        }
        ConeIntegerLiteralType coneIntegerLiteralType = (ConeIntegerLiteralType)((ConeKotlinType)((ConeIntegerLiteralType)coneKotlinType));
        if (coneIntegerLiteralType == null) {
            return call2;
        }
        ConeIntegerLiteralType operatorType = coneIntegerLiteralType;
        ConeClassLikeType approximatedType = operatorType.getApproximatedType(data);
        call2.transformDispatchReceiver(this, null);
        call2.transformExtensionReceiver(this, null);
        call2.getArgumentList().transformArguments(this, null);
        $this$coneTypeSafe$iv = call2;
        FirExpression $this$resultType$iv2 = call2;
        boolean $i$f$getResultType2 = false;
        FirTypeRef type$iv = CopyUtilsKt.resolvedTypeFromPrototype($this$resultType$iv2.getTypeRef(), approximatedType);
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceTypeRef(type$iv);
        FirNamedReference calleeReference = call2.getCalleeReference();
        if (calleeReference instanceof FirResolvedNamedReference) {
            void $this$transformIntegerLiteralOperatorCall_u24lambda_u2d0;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2;
            FirBasedSymbol<?> firBasedSymbol = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
            Intrinsics.checkNotNull(firBasedSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
            FirNamedFunctionSymbol wrappedFunctionSymbol = (FirNamedFunctionSymbol)firBasedSymbol;
            FirNamedFunctionSymbol firNamedFunctionSymbol = FirIntegerConstantOperatorScopeKt.getOriginalForWrappedIntegerOperator((FirSimpleFunction)wrappedFunctionSymbol.getFir());
            Intrinsics.checkNotNull((Object)firNamedFunctionSymbol);
            FirNamedFunctionSymbol originalFunctionSymbol = firNamedFunctionSymbol;
            boolean $i$f$buildResolvedNamedReference = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder3 = firResolvedNamedReferenceBuilder2 = new FirResolvedNamedReferenceBuilder();
            FirIntegerLiteralOperatorCall firIntegerLiteralOperatorCall = call2;
            boolean bl = false;
            $this$transformIntegerLiteralOperatorCall_u24lambda_u2d0.setName(calleeReference.getName());
            $this$transformIntegerLiteralOperatorCall_u24lambda_u2d0.setSource(calleeReference.getSource());
            $this$transformIntegerLiteralOperatorCall_u24lambda_u2d0.setResolvedSymbol(originalFunctionSymbol);
            firIntegerLiteralOperatorCall.replaceCalleeReference(firResolvedNamedReferenceBuilder2.build());
        }
        if (ConeBuiltinTypeUtilsKt.isInt(approximatedType) || ConeBuiltinTypeUtilsKt.isUInt(approximatedType)) {
            return call2;
        }
        FirImplicitBuiltinTypeRef typeBeforeConversion = operatorType.isUnsigned() ? (FirImplicitBuiltinTypeRef)this.session.getBuiltinTypes().getUIntType() : this.session.getBuiltinTypes().getIntType();
        call2.replaceTypeRef(typeBeforeConversion);
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = call2.getSource();
        $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.IntToLongConversion.INSTANCE) : null);
        $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2.setTypeRef(this.session.getBuiltinTypes().getLongType());
        $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2.setExplicitReceiver(call2);
        $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2.setDispatchReceiver(call2);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder4 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2;
        boolean bl2 = false;
        if (operatorType.isUnsigned()) {
            $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2_u24lambda_u2d1.setName(TO_U_LONG);
            $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2_u24lambda_u2d1.setResolvedSymbol(this.getToULongSymbol());
        } else {
            $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2_u24lambda_u2d1.setName(TO_LONG);
            $this$transformIntegerLiteralOperatorCall_u24lambda_u2d2_u24lambda_u2d1.setResolvedSymbol(this.getToLongSymbol());
        }
        firFunctionCallBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firFunctionCallBuilder.build();
    }

    public static final /* synthetic */ FirNamedFunctionSymbol access$findConversionFunction(IntegerLiteralAndOperatorApproximationTransformer $this, FirImplicitBuiltinTypeRef receiverType, Name name2) {
        return $this.findConversionFunction(receiverType, name2);
    }

    public static final /* synthetic */ Name access$getTO_LONG$cp() {
        return TO_LONG;
    }

    public static final /* synthetic */ Name access$getTO_U_LONG$cp() {
        return TO_U_LONG;
    }

    static {
        Name name2 = Name.identifier("toLong");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"toLong\")");
        TO_LONG = name2;
        Name name3 = Name.identifier("toULong");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"toULong\")");
        TO_U_LONG = name3;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer$Companion;", "", "()V", "TO_LONG", "Lorg/jetbrains/kotlin/name/Name;", "TO_U_LONG", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

