/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConstChecksKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u0011H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationClassMember", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "checkCyclesInParameters", "annotation", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "isAllowedArray", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isAllowedClassKind", "cone", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "primaryConstructorSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "CycleChecker", "checkers"})
public final class FirAnnotationClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirAnnotationClassDeclarationChecker INSTANCE = new FirAnnotationClassDeclarationChecker();

    private FirAnnotationClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (declaration.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirClassLikeDeclaration $this$isLocal$iv = declaration;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getLOCAL_ANNOTATION_CLASS_ERROR(), (DiagnosticContext)context, null, 8, null);
        }
        if (declaration.getSuperTypeRefs().size() != 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getSUPERTYPES_FOR_ANNOTATION_CLASS(), (DiagnosticContext)context, null, 8, null);
        }
        for (FirDeclaration member2 : declaration.getDeclarations()) {
            this.checkAnnotationClassMember(member2, context, reporter2);
        }
        if (FirAnnotationHelpersKt.getRetention(declaration) != AnnotationRetention.SOURCE && FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration).contains((Object)KotlinTarget.EXPRESSION)) {
            FirElement firElement;
            FirAnnotation firAnnotation = FirAnnotationHelpersKt.getRetentionAnnotation(declaration);
            if (firAnnotation != null) {
                firElement = firAnnotation;
            } else {
                FirAnnotation firAnnotation2 = FirAnnotationHelpersKt.getTargetAnnotation(declaration);
                firElement = firAnnotation2 != null ? (FirElement)firAnnotation2 : (FirElement)declaration;
            }
            FirElement target = firElement;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)((FirPureAbstractElement)target).getSource(), FirErrors.INSTANCE.getRESTRICTED_RETENTION_FOR_EXPRESSION_ANNOTATION(), (DiagnosticContext)context, null, 8, null);
        }
        this.checkCyclesInParameters(declaration.getSymbol(), context, reporter2);
    }

    private final void checkAnnotationClassMember(FirDeclaration member2, CheckerContext context, DiagnosticReporter reporter2) {
        block12: {
            block14: {
                block13: {
                    block11: {
                        if (!(member2 instanceof FirConstructor) || !((FirConstructor)member2).isPrimary()) break block11;
                        for (FirValueParameter parameter2 : ((FirConstructor)member2).getValueParameters()) {
                            ClassId classId;
                            ConeLookupTagBasedType coneType;
                            FirTypeRef typeRef;
                            KtSourceElement source;
                            if (parameter2.getSource() == null) continue;
                            if (!LightTreePositioningStrategiesKt.hasValOrVar(source)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER(), (DiagnosticContext)context, null, 8, null);
                            } else if (LightTreePositioningStrategiesKt.hasVar(source)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER(), (DiagnosticContext)context, null, 8, null);
                            }
                            FirExpression defaultValue = parameter2.getDefaultValue();
                            if (defaultValue != null && FirConstChecksKt.checkConstantArguments(defaultValue, context.getSession()) != null) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)defaultValue.getSource(), FirErrors.INSTANCE.getANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT(), (DiagnosticContext)context, null, 8, null);
                            }
                            FirTypeRef $this$coneTypeSafe$iv = typeRef = parameter2.getReturnTypeRef();
                            boolean $i$f$coneTypeSafe = false;
                            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                            if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                                coneKotlinType = null;
                            }
                            ConeLookupTagBasedType coneLookupTagBasedType = coneType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType));
                            ClassId classId2 = classId = coneLookupTagBasedType != null ? ConeTypeUtilsKt.getClassId(coneLookupTagBasedType) : null;
                            if (coneType == null || Intrinsics.areEqual((Object)classId, (Object)ClassId.fromString("<error>"))) continue;
                            if (ConeTypeUtilsKt.isNullable(coneType)) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_TYPE_OF_ANNOTATION_MEMBER(), (DiagnosticContext)context, null, 8, null);
                                continue;
                            }
                            if (ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive(coneType) || ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(coneType) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getKClass()) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getString()) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values(), (Object)classId) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getUnsignedArrayTypeByElementType().values(), (Object)classId)) continue;
                            if (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getArray())) {
                                if (this.isAllowedArray(typeRef, context.getSession())) continue;
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), (DiagnosticContext)context, null, 8, null);
                                continue;
                            }
                            if (this.isAllowedClassKind(coneType, context.getSession())) continue;
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), (DiagnosticContext)context, null, 8, null);
                        }
                        break block12;
                    }
                    if (member2 instanceof FirRegularClass) break block12;
                    if (!(member2 instanceof FirProperty)) break block13;
                    KtSourceElement ktSourceElement = member2.getSource();
                    if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.VALUE_PARAMETER)) break block12;
                }
                if (!(member2 instanceof FirSimpleFunction)) break block14;
                KtSourceElement ktSourceElement = member2.getSource();
                if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.FUN)) break block12;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)member2.getSource(), FirErrors.INSTANCE.getANNOTATION_CLASS_MEMBER(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean isAllowedClassKind(ConeLookupTagBasedType cone, FirSession session2) {
        FirRegularClassSymbol firRegularClassSymbol;
        Object object = LookupTagUtilsKt.toSymbol(cone.getLookupTag(), session2);
        FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol = object instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)object : null;
        if (firRegularClassSymbol == null || (object = firRegularClassSymbol.getClassKind()) == null) {
            return false;
        }
        Object typeRefClassKind = object;
        return typeRefClassKind == ClassKind.ANNOTATION_CLASS || typeRefClassKind == ClassKind.ENUM_CLASS;
    }

    private final boolean isAllowedArray(FirTypeRef typeRef, FirSession session2) {
        ConeKotlinTypeProjection coneKotlinTypeProjection;
        ConeTypeProjection[] typeArguments2 = FirTypeUtilsKt.getConeType(typeRef).getTypeArguments();
        if (typeArguments2.length != 1) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = typeArguments2[0];
        ConeKotlinTypeProjection coneKotlinTypeProjection2 = coneKotlinTypeProjection = coneTypeProjection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)coneTypeProjection : null;
        if (coneKotlinTypeProjection == null || (coneTypeProjection = coneKotlinTypeProjection.getType()) == null) {
            return false;
        }
        ConeTypeProjection arrayType = coneTypeProjection;
        if (ConeTypeUtilsKt.isNullable((ConeKotlinType)arrayType)) {
            return false;
        }
        ClassId arrayTypeClassId = ConeTypeUtilsKt.getClassId((ConeKotlinType)arrayType);
        if (Intrinsics.areEqual((Object)arrayTypeClassId, (Object)StandardClassIds.INSTANCE.getKClass())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)arrayTypeClassId, (Object)StandardClassIds.INSTANCE.getString())) {
            return true;
        }
        return this.isAllowedClassKind((ConeLookupTagBasedType)arrayType, session2);
    }

    private final void checkCyclesInParameters(FirRegularClassSymbol annotation2, CheckerContext context, DiagnosticReporter reporter2) {
        FirConstructorSymbol firConstructorSymbol = this.primaryConstructorSymbol(annotation2);
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol primaryConstructor2 = firConstructorSymbol;
        CycleChecker checker = new CycleChecker(annotation2, context.getSession());
        for (FirValueParameterSymbol valueParameter2 : primaryConstructor2.getValueParameterSymbols()) {
            if (!checker.parameterHasCycle(annotation2, valueParameter2)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getCYCLE_IN_ANNOTATION_PARAMETER(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final FirConstructorSymbol primaryConstructorSymbol(FirRegularClassSymbol $this$primaryConstructorSymbol) {
        for (FirBasedSymbol<?> declarationSymbol : $this$primaryConstructorSymbol.getDeclarationSymbols()) {
            if (!(declarationSymbol instanceof FirConstructorSymbol) || !((FirConstructorSymbol)declarationSymbol).isPrimary()) continue;
            return (FirConstructorSymbol)declarationSymbol;
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker$CycleChecker;", "", "targetAnnotation", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/FirSession;)V", "annotationsWithCycle", "", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getTargetAnnotation", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "visitedAnnotations", "annotationHasCycle", "", "annotation", "parameterHasCycle", "ownedAnnotation", "parameter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "typeHasCycle", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
    private static final class CycleChecker {
        @NotNull
        private final FirRegularClassSymbol targetAnnotation;
        @NotNull
        private final FirSession session;
        @NotNull
        private final Set<FirRegularClassSymbol> visitedAnnotations;
        @NotNull
        private final Set<FirRegularClassSymbol> annotationsWithCycle;

        public CycleChecker(@NotNull FirRegularClassSymbol targetAnnotation, @NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)targetAnnotation, (String)"targetAnnotation");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            this.targetAnnotation = targetAnnotation;
            this.session = session2;
            Object[] objectArray = new FirRegularClassSymbol[]{this.targetAnnotation};
            this.visitedAnnotations = SetsKt.mutableSetOf((Object[])objectArray);
            objectArray = new FirRegularClassSymbol[]{this.targetAnnotation};
            this.annotationsWithCycle = SetsKt.mutableSetOf((Object[])objectArray);
        }

        @NotNull
        public final FirRegularClassSymbol getTargetAnnotation() {
            return this.targetAnnotation;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        public final boolean annotationHasCycle(@NotNull FirRegularClassSymbol annotation2) {
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            FirConstructorSymbol firConstructorSymbol = INSTANCE.primaryConstructorSymbol(annotation2);
            if (firConstructorSymbol == null) {
                return false;
            }
            FirConstructorSymbol primaryConstructor2 = firConstructorSymbol;
            for (FirValueParameterSymbol valueParameter2 : primaryConstructor2.getValueParameterSymbols()) {
                if (!this.parameterHasCycle(annotation2, valueParameter2)) continue;
                return true;
            }
            return false;
        }

        public final boolean parameterHasCycle(@NotNull FirRegularClassSymbol ownedAnnotation, @NotNull FirValueParameterSymbol parameter2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)ownedAnnotation, (String)"ownedAnnotation");
            Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
            ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(parameter2.getResolvedReturnTypeRef());
            if (!(returnType2.getTypeArguments().length == 0)) {
                if (Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(returnType2), (Object)StandardClassIds.INSTANCE.getKClass())) {
                    return false;
                }
                for (ConeTypeProjection argument2 : returnType2.getTypeArguments()) {
                    ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(argument2);
                    if (coneKotlinType == null || !this.typeHasCycle(ownedAnnotation, coneKotlinType)) continue;
                    return true;
                }
                bl = false;
            } else {
                bl = this.typeHasCycle(ownedAnnotation, returnType2);
            }
            return bl;
        }

        public final boolean typeHasCycle(@NotNull FirRegularClassSymbol ownedAnnotation, @NotNull ConeKotlinType type2) {
            FirRegularClassSymbol firRegularClassSymbol;
            block7: {
                block6: {
                    FirRegularClassSymbol firRegularClassSymbol2;
                    Intrinsics.checkNotNullParameter((Object)ownedAnnotation, (String)"ownedAnnotation");
                    Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                    FirRegularClassSymbol firRegularClassSymbol3 = FirHelpersKt.toRegularClassSymbol(TypeExpansionUtilsKt.fullyExpandedType(type2, this.session), this.session);
                    if (firRegularClassSymbol3 == null) break block6;
                    FirRegularClassSymbol it = firRegularClassSymbol2 = firRegularClassSymbol3;
                    boolean bl = false;
                    FirRegularClassSymbol firRegularClassSymbol4 = firRegularClassSymbol = it.getClassKind() == ClassKind.ANNOTATION_CLASS ? firRegularClassSymbol2 : null;
                    if (firRegularClassSymbol != null) break block7;
                }
                return false;
            }
            FirRegularClassSymbol referencedAnnotation = firRegularClassSymbol;
            if (!this.visitedAnnotations.add(referencedAnnotation)) {
                boolean bl;
                boolean it = bl = this.annotationsWithCycle.contains(referencedAnnotation);
                boolean bl2 = false;
                if (it) {
                    ((Collection)this.annotationsWithCycle).add(ownedAnnotation);
                }
                return bl;
            }
            if (Intrinsics.areEqual((Object)referencedAnnotation, (Object)this.targetAnnotation)) {
                ((Collection)this.annotationsWithCycle).add(ownedAnnotation);
                return true;
            }
            return this.annotationHasCycle(referencedAnnotation);
        }
    }
}

