/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J(\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0014\u0010\u0018\u001a\u00020\t*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FakeInliningLocalVariablesLowering;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineReferenceLocator;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "data", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitInlineLambda", "argument", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "callee", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "scope", "addFakeLocalVariable", "name", "", "backend.jvm.lower"})
public final class FakeInliningLocalVariablesLowering
extends IrInlineReferenceLocator
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public FakeInliningLocalVariablesLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.accept(this, null);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable IrDeclaration data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super.visitFunction(declaration, data);
        if (declaration.isInline() && !declaration.getOrigin().isSynthetic() && declaration.getBody() != null && !JvmIrInlineUtilsKt.isInlineOnly(declaration)) {
            String currentFunctionName = MethodSignatureMapper.mapFunctionName$default(this.context.getMethodSignatureMapper(), declaration, false, 2, null);
            String localName = "$i$f$" + currentFunctionName;
            this.addFakeLocalVariable(declaration, localName);
        }
    }

    @Override
    public void visitInlineLambda(@NotNull IrFunctionReference argument2, @NotNull IrFunction callee, @NotNull IrValueParameter parameter2, @NotNull IrDeclaration scope2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)callee, (String)"callee");
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        IrFunction lambda2 = ((IrFunctionSymbol)argument2.getSymbol()).getOwner();
        String argumentToFunctionName = MethodSignatureMapper.mapFunctionName$default(this.context.getMethodSignatureMapper(), callee, false, 2, null);
        Type type2 = this.context.getLocalClassType(argument2);
        Intrinsics.checkNotNull((Object)type2);
        String string2 = type2.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getLocalClassType(argument)!!.internalName");
        String lambdaReferenceName = StringsKt.substringAfterLast$default((String)string2, (String)"/", null, (int)2, null);
        String localName = "$i$a$-" + argumentToFunctionName + '-' + lambdaReferenceName;
        this.addFakeLocalVariable(lambda2, localName);
    }

    /*
     * WARNING - void declaration
     */
    private final void addFakeLocalVariable(IrFunction $this$addFakeLocalVariable, String name2) {
        void $this$addFakeLocalVariable_u24lambda_u2d1;
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)$this$addFakeLocalVariable.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var9_9 = this_$iv$iv;
        IrFunction irFunction2 = $this$addFakeLocalVariable;
        boolean bl = false;
        IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)$this$addFakeLocalVariable_u24lambda_u2d1, (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$addFakeLocalVariable_u24lambda_u2d1, 0, null, 2, null), StringsKt.removeSuffix((String)name2, (CharSequence)"$$forInline"), false, (IrDeclarationOrigin)IrDeclarationOrigin.DEFINED.INSTANCE, null, 20, null);
        IrBody oldBody = $this$addFakeLocalVariable.getBody();
        if (oldBody instanceof IrExpressionBody) {
            $this$addFakeLocalVariable_u24lambda_u2d1.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$addFakeLocalVariable_u24lambda_u2d1, ((IrExpressionBody)oldBody).getExpression()));
        } else if (oldBody instanceof IrBlockBody) {
            Iterable $this$forEach$iv = ((IrBlockBody)oldBody).getStatements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement it = (IrStatement)element$iv;
                boolean bl2 = false;
                $this$addFakeLocalVariable_u24lambda_u2d1.unaryPlus(it);
            }
        } else {
            throw new AssertionError((Object)("Unexpected body:\n" + DumpIrTreeKt.dump$default($this$addFakeLocalVariable, false, false, 3, null)));
        }
        irFunction2.setBody(this_$iv$iv.doBuild());
    }
}

