/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analysis.project.structure.impl.KtSourceModuleByCompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/impl/ProjectStructureProviderByCompilerConfiguration;", "Lorg/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider;", "compilerConfig", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "jarFileSystem", "Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;)V", "libraryModules", "", "Lorg/jetbrains/kotlin/analysis/project/structure/KtLibraryModule;", "getLibraryModules", "()Ljava/util/Collection;", "libraryModules$delegate", "Lkotlin/Lazy;", "sourceModule", "Lorg/jetbrains/kotlin/analysis/project/structure/impl/KtSourceModuleByCompilerConfiguration;", "getKtLibraryModules", "getKtModuleForKtElement", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "element", "Lcom/intellij/psi/PsiElement;", "analysis-api-standalone"})
public final class ProjectStructureProviderByCompilerConfiguration
extends ProjectStructureProvider {
    @NotNull
    private final KtSourceModuleByCompilerConfiguration sourceModule;
    @NotNull
    private final Lazy libraryModules$delegate;

    public ProjectStructureProviderByCompilerConfiguration(@NotNull CompilerConfiguration compilerConfig, @NotNull Project project, @NotNull List<? extends KtFile> ktFiles, @NotNull CoreJarFileSystem jarFileSystem) {
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        Intrinsics.checkNotNullParameter((Object)jarFileSystem, (String)"jarFileSystem");
        this.sourceModule = new KtSourceModuleByCompilerConfiguration(compilerConfig, project, ktFiles, jarFileSystem);
        this.libraryModules$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends KtLibraryModule>>(this){
            final /* synthetic */ ProjectStructureProviderByCompilerConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<KtLibraryModule> invoke() {
                return ProjectStructureProviderByCompilerConfiguration.access$getSourceModule$p(this.this$0).getDirectRegularDependencies();
            }
        }));
    }

    private final Collection<KtLibraryModule> getLibraryModules() {
        Lazy lazy = this.libraryModules$delegate;
        return (Collection)lazy.getValue();
    }

    @Override
    @NotNull
    public KtModule getKtModuleForKtElement(@NotNull PsiElement element) {
        KtModule ktModule;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile containingFile = element.getContainingFile().getVirtualFile();
        if (this.sourceModule.getContentScope().contains(containingFile)) {
            ktModule = this.sourceModule;
        } else {
            Object v1;
            block4: {
                Iterable iterable = this.sourceModule.getDirectRegularDependencies();
                for (Object t : iterable) {
                    KtLibraryModule libModule = (KtLibraryModule)t;
                    boolean bl = false;
                    if (!libModule.getContentScope().contains(containingFile)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            KtLibraryModule ktLibraryModule = v1;
            if (ktLibraryModule == null) {
                throw new IllegalStateException(("Can't find module for " + containingFile.getPath()).toString());
            }
            ktModule = ktLibraryModule;
        }
        return ktModule;
    }

    @Override
    @NotNull
    public Collection<KtLibraryModule> getKtLibraryModules() {
        return this.getLibraryModules();
    }

    public static final /* synthetic */ KtSourceModuleByCompilerConfiguration access$getSourceModule$p(ProjectStructureProviderByCompilerConfiguration $this) {
        return $this.sourceModule;
    }
}

