/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH$J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/AbstractLocalRedeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "(Lorg/jetbrains/kotlin/resolve/OverloadChecker;)V", "getOverloadChecker", "()Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "checkBeforeAddingToScope", "", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "newDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "handleConflictingOverloads", "first", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "second", "handleRedeclaration", "frontend"})
public abstract class AbstractLocalRedeclarationChecker
implements LocalRedeclarationChecker {
    @NotNull
    private final OverloadChecker overloadChecker;

    public AbstractLocalRedeclarationChecker(@NotNull OverloadChecker overloadChecker) {
        Intrinsics.checkNotNullParameter((Object)overloadChecker, (String)"overloadChecker");
        this.overloadChecker = overloadChecker;
    }

    @NotNull
    public final OverloadChecker getOverloadChecker() {
        return this.overloadChecker;
    }

    @Override
    public void checkBeforeAddingToScope(@NotNull LexicalScope scope2, @NotNull DeclarationDescriptor newDescriptor2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)newDescriptor2, (String)"newDescriptor");
        Name name2 = newDescriptor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"newDescriptor.name");
        Name name3 = name2;
        NoLookupLocation location = NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS;
        DeclarationDescriptor declarationDescriptor = newDescriptor2;
        if (declarationDescriptor instanceof ClassifierDescriptor ? true : declarationDescriptor instanceof VariableDescriptor) {
            DeclarationDescriptorNonRoot otherDescriptor;
            ClassifierDescriptor classifierDescriptor = scope2.getContributedClassifier(name3, location);
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot = otherDescriptor = classifierDescriptor != null ? (DeclarationDescriptorNonRoot)classifierDescriptor : (DeclarationDescriptorNonRoot)CollectionsKt.firstOrNull((Iterable)scope2.getContributedVariables(name3, location));
            if (otherDescriptor != null) {
                this.handleRedeclaration(otherDescriptor, newDescriptor2);
            }
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            Collection collection;
            Collection otherFunctions = scope2.getContributedFunctions(name3, location);
            ClassifierDescriptor otherClass = scope2.getContributedClassifier(name3, location);
            if (otherClass instanceof ClassDescriptor) {
                Collection<ClassConstructorDescriptor> collection2 = ((ClassDescriptor)otherClass).getConstructors();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"otherClass.constructors");
                collection = CollectionsKt.plus(otherFunctions, (Iterable)collection2);
            } else {
                collection = otherFunctions;
            }
            Collection potentiallyConflictingOverloads = collection;
            for (FunctionDescriptor overloadedDescriptor : potentiallyConflictingOverloads) {
                Intrinsics.checkNotNullExpressionValue((Object)overloadedDescriptor, (String)"overloadedDescriptor");
                if (this.overloadChecker.isOverloadable(overloadedDescriptor, newDescriptor2)) continue;
                this.handleConflictingOverloads((CallableMemberDescriptor)newDescriptor2, overloadedDescriptor);
                break;
            }
        } else {
            throw new IllegalStateException("Unexpected type of descriptor: " + newDescriptor2.getClass().getName() + ", descriptor: " + newDescriptor2);
        }
    }

    protected abstract void handleRedeclaration(@NotNull DeclarationDescriptor var1, @NotNull DeclarationDescriptor var2);

    protected abstract void handleConflictingOverloads(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
}

