/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.serialization;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.mangle.SpecialDeclarationType;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureDescriptor;
import org.jetbrains.kotlin.backend.jvm.serialization.JvmIdSignatureDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.load.java.descriptors.JavaForKotlinOverridePropertyDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00060\u0006R\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIdSignatureDescriptor;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;)V", "createSignatureBuilder", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor$DescriptorBasedSignatureBuilder;", "type", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;", "JvmDescriptorBasedSignatureBuilder", "ir.serialization.jvm"})
public final class JvmIdSignatureDescriptor
extends IdSignatureDescriptor {
    @NotNull
    private final KotlinMangler.DescriptorMangler mangler;

    public JvmIdSignatureDescriptor(@NotNull KotlinMangler.DescriptorMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        super(mangler);
        this.mangler = mangler;
    }

    @Override
    @NotNull
    protected IdSignatureDescriptor.DescriptorBasedSignatureBuilder createSignatureBuilder(@NotNull SpecialDeclarationType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return new JvmDescriptorBasedSignatureBuilder(this.mangler, type2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u001aH\u0014J\f\u0010\b\u001a\u00020\t*\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIdSignatureDescriptor$JvmDescriptorBasedSignatureBuilder;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor$DescriptorBasedSignatureBuilder;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureDescriptor;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "type", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;", "(Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIdSignatureDescriptor;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;)V", "isCapturingTypeParameter", "", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isKotlinPackage", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "keepTrackOfOverridesForPossiblyClashingFakeOverride", "", "platformSpecificFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "platformSpecificGetter", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "platformSpecificModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "platformSpecificProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "platformSpecificSetter", "Lorg/jetbrains/kotlin/descriptors/PropertySetterDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "ir.serialization.jvm"})
    private final class JvmDescriptorBasedSignatureBuilder
    extends IdSignatureDescriptor.DescriptorBasedSignatureBuilder {
        public JvmDescriptorBasedSignatureBuilder(@NotNull KotlinMangler.DescriptorMangler mangler, SpecialDeclarationType type2) {
            Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            super(mangler, type2);
        }

        @Override
        protected void platformSpecificFunction(@NotNull FunctionDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride(descriptor2);
        }

        @Override
        protected boolean isKotlinPackage(@NotNull PackageFragmentDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            return !(descriptor2 instanceof LazyJavaPackageFragment);
        }

        @Override
        protected void platformSpecificProperty(@NotNull PropertyDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.setSpecialJavaProperty(descriptor2 instanceof JavaForKotlinOverridePropertyDescriptor);
            this.setSyntheticJavaProperty(descriptor2 instanceof SyntheticJavaPropertyDescriptor);
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride(descriptor2);
        }

        @Override
        protected void platformSpecificGetter(@NotNull PropertyGetterDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride(descriptor2);
        }

        @Override
        protected void platformSpecificSetter(@NotNull PropertySetterDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.keepTrackOfOverridesForPossiblyClashingFakeOverride(descriptor2);
        }

        @Override
        protected void platformSpecificModule(@NotNull ModuleDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        }

        private final void keepTrackOfOverridesForPossiblyClashingFakeOverride(CallableMemberDescriptor descriptor2) {
            Collection<CallableMemberDescriptor> collection;
            if (descriptor2.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor containingClass = classDescriptor;
            declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
                MemberScope memberScope2 = containingClass.getUnsubstitutedMemberScope();
                Name name2 = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty().getName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"descriptor.correspondingProperty.name");
                collection = memberScope2.getContributedVariables(name2, NoLookupLocation.FROM_BACKEND);
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                MemberScope memberScope3 = containingClass.getUnsubstitutedMemberScope();
                Name name3 = ((PropertyDescriptor)descriptor2).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"descriptor.name");
                collection = memberScope3.getContributedVariables(name3, NoLookupLocation.FROM_BACKEND);
            } else if (declarationDescriptor instanceof FunctionDescriptor) {
                MemberScope memberScope4 = containingClass.getUnsubstitutedMemberScope();
                Name name4 = ((FunctionDescriptor)descriptor2).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"descriptor.name");
                collection = memberScope4.getContributedFunctions(name4, NoLookupLocation.FROM_BACKEND);
            } else {
                throw new AssertionError((Object)("Unexpected CallableMemberDescriptor: " + descriptor2));
            }
            Collection<? extends PropertyDescriptor> possiblyClashingMembers = collection;
            if (possiblyClashingMembers.size() <= 1) {
                return;
            }
            List capturingOverrides2 = SequencesKt.toList((Sequence)SequencesKt.filter(DescriptorUtilsKt.overriddenTreeAsSequence(descriptor2, true), (Function1)((Function1)new Function1<CallableMemberDescriptor, Boolean>(this){
                final /* synthetic */ JvmDescriptorBasedSignatureBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CallableMemberDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && JvmDescriptorBasedSignatureBuilder.access$isCapturingTypeParameter(this.this$0, it);
                }
            })));
            if (!((Collection)capturingOverrides2).isEmpty()) {
                Iterable $this$sortedBy$iv = capturingOverrides2;
                boolean $i$f$sortedBy = false;
                this.setOverridden(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)a;
                        boolean bl = false;
                        DeclarationDescriptor $this$cast$iv = it.getContainingDeclaration();
                        boolean $i$f$cast = false;
                        DeclarationDescriptor declarationDescriptor = $this$cast$iv;
                        if (declarationDescriptor == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        it = (CallableMemberDescriptor)b;
                        Comparable comparable = (Comparable)((Object)DescriptorUtilsKt.getFqNameUnsafe((ClassDescriptor)declarationDescriptor).asString());
                        bl = false;
                        $this$cast$iv = it.getContainingDeclaration();
                        $i$f$cast = false;
                        DeclarationDescriptor declarationDescriptor2 = $this$cast$iv;
                        if (declarationDescriptor2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)DescriptorUtilsKt.getFqNameUnsafe((ClassDescriptor)declarationDescriptor2).asString())));
                    }
                }));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isCapturingTypeParameter(CallableMemberDescriptor member2) {
            ValueParameterDescriptor it;
            boolean bl;
            ReceiverParameterDescriptor receiverParameterDescriptor = member2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor != null) {
                if (this.isCapturingTypeParameter(receiverParameterDescriptor)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            List<ValueParameterDescriptor> list2 = member2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"member.valueParameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (ValueParameterDescriptor)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            } while (!this.isCapturingTypeParameter(it));
            return true;
        }

        private final boolean isCapturingTypeParameter(ParameterDescriptor $this$isCapturingTypeParameter) {
            KotlinType kotlinType = $this$isCapturingTypeParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
            return TypeUtilsKt.contains(kotlinType, (Function1<? super UnwrappedType, Boolean>)((Function1)isCapturingTypeParameter.2.INSTANCE));
        }

        public static final /* synthetic */ boolean access$isCapturingTypeParameter(JvmDescriptorBasedSignatureBuilder $this, CallableMemberDescriptor member2) {
            return $this.isCapturingTypeParameter(member2);
        }
    }
}

