/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutineFunctionTransformer;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.declaration.InlineCoroutineUtilKt;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00102\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00112\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "()V", "functionName", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "", "getFunctionName", "()Ljava/util/Map;", "endVisit", "", "x", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "visit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "js.translator"})
public final class CoroutineTransformer
extends JsVisitorWithContextImpl {
    @NotNull
    private final Map<JsFunction, String> functionName;

    public CoroutineTransformer() {
        boolean bl = false;
        this.functionName = new LinkedHashMap();
    }

    @NotNull
    public final Map<JsFunction, String> getFunctionName() {
        return this.functionName;
    }

    public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<?> ctx2) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        JsExpression jsExpression = x.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
        JsExpression expression2 = jsExpression;
        Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(expression2);
        if (assignment != null) {
            Pair<JsExpression, JsExpression> pair = assignment;
            JsExpression lhs = (JsExpression)pair.component1();
            JsExpression rhs = (JsExpression)pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)rhs, (String)"rhs");
            FunctionWithWrapper functionWithWrapper = InlineMetadata.Companion.tryExtractFunction(rhs);
            if (functionWithWrapper != null) {
                FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                boolean bl = false;
                boolean bl2 = false;
                FunctionWithWrapper wrapper = functionWithWrapper2;
                boolean bl3 = false;
                JsFunction function2 = wrapper.getFunction();
                JsNameRef jsNameRef = lhs instanceof JsNameRef ? (JsNameRef)lhs : null;
                JsName jsName = jsNameRef == null ? null : jsNameRef.getName();
                Object object = jsName == null ? function2.getName() : jsName;
                String name2 = object == null ? null : ((JsName)object).getIdent();
                object = this.getFunctionName();
                boolean bl4 = false;
                object.put(function2, name2);
            }
        } else if (expression2 instanceof JsFunction) {
            Map<JsFunction, String> map = this.functionName;
            JsExpression jsExpression2 = expression2;
            Object object = ((JsFunction)expression2).getName();
            object = object == null ? null : ((JsName)object).getIdent();
            boolean bl = false;
            map.put((JsFunction)jsExpression2, (String)object);
        }
        return super.visit(x, ctx2);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx2) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        if (MetadataProperties.isInlineableCoroutineBody(x)) {
            x.setBody((JsBlock)InlineCoroutineUtilKt.transformCoroutineMetadataToSpecialFunctions((JsNode)x.getBody()));
        }
        if (MetadataProperties.getCoroutineMetadata(x) != null) {
            this.getLastStatementLevelContext().addPrevious(new CoroutineFunctionTransformer(x, this.functionName.get(x)).transform());
            MetadataProperties.setCoroutineMetadata(x, null);
        }
    }

    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx2) {
        FunctionWithWrapper functionWithWrapper;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        JsExpression initExpression = x.getInitExpression();
        if (initExpression != null && (functionWithWrapper = InlineMetadata.Companion.tryExtractFunction(initExpression)) != null) {
            FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
            boolean bl = false;
            boolean bl2 = false;
            FunctionWithWrapper wrapper = functionWithWrapper2;
            boolean bl3 = false;
            Map<JsFunction, String> map = this.getFunctionName();
            JsFunction jsFunction = wrapper.getFunction();
            String string2 = x.getName().getIdent();
            boolean bl4 = false;
            map.put(jsFunction, string2);
        }
        return super.visit(x, ctx2);
    }
}

