/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KParameterProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeProxy;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KParameterState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.ReflectionState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\u0018J\u0006\u0010\"\u001a\u00020\u0018J\u0006\u0010#\u001a\u00020\u0018J\u0006\u0010$\u001a\u00020\u0018J\u0006\u0010%\u001a\u00020\u0018J\u0006\u0010&\u001a\u00020\u0018J\b\u0010'\u001a\u00020(H\u0016R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KPropertyState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "receiver", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "(Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;Lorg/jetbrains/kotlin/ir/interpreter/state/State;)V", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/interpreter/state/State;)V", "_parameters", "", "Lkotlin/reflect/KParameter;", "_returnType", "Lkotlin/reflect/KType;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getProperty", "()Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getReceiver", "()Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "equals", "", "other", "", "getParameters", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "getReturnType", "hashCode", "", "isKMutableProperty0", "isKMutableProperty1", "isKMutableProperty2", "isKProperty0", "isKProperty1", "isKProperty2", "toString", "", "ir.interpreter"})
public final class KPropertyState
extends ReflectionState {
    @NotNull
    private final IrProperty property;
    @NotNull
    private final IrClass irClass;
    @Nullable
    private final State receiver;
    @Nullable
    private List<? extends KParameter> _parameters;
    @Nullable
    private KType _returnType;

    public KPropertyState(@NotNull IrProperty property2, @NotNull IrClass irClass2, @Nullable State receiver) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        this.property = property2;
        this.irClass = irClass2;
        this.receiver = receiver;
    }

    public /* synthetic */ KPropertyState(IrProperty irProperty2, IrClass irClass2, State state2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            state2 = null;
        }
        this(irProperty2, irClass2, state2);
    }

    @NotNull
    public final IrProperty getProperty() {
        return this.property;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Nullable
    public final State getReceiver() {
        return this.receiver;
    }

    public KPropertyState(@NotNull IrPropertyReference propertyReference, @Nullable State receiver) {
        Intrinsics.checkNotNullParameter((Object)propertyReference, (String)"propertyReference");
        IrProperty irProperty2 = (IrProperty)((IrPropertySymbol)propertyReference.getSymbol()).getOwner();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(propertyReference.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this(irProperty2, (IrClass)irClassSymbol.getOwner(), receiver);
    }

    @NotNull
    public final List<KParameter> getParameters(@NotNull CallInterceptor callInterceptor) {
        KParameterProxy kParameterProxy;
        int n;
        IrValueParameter irValueParameter;
        IrValueParameter it;
        boolean bl;
        boolean bl2;
        IrValueParameter irValueParameter2;
        IrDeclarationBase irDeclarationBase;
        KParameterProxy kParameterProxy2;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._parameters != null) {
            List<KParameter> list2 = this._parameters;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        IrClass kParameterIrClass = this.getIrClassOfReflectionFromList(this.getIrClass(), "parameters");
        int index2 = 0;
        IrSimpleFunction irSimpleFunction = this.property.getGetter();
        if (irSimpleFunction == null) {
            kParameterProxy2 = null;
        } else {
            irDeclarationBase = irSimpleFunction.getDispatchReceiverParameter();
            if (irDeclarationBase == null) {
                kParameterProxy2 = null;
            } else {
                irValueParameter2 = irDeclarationBase;
                bl2 = false;
                bl = false;
                it = irValueParameter2;
                boolean bl3 = false;
                IrValueParameter irValueParameter3 = irValueParameter = this.getReceiver() == null ? irValueParameter2 : null;
                if (irValueParameter == null) {
                    kParameterProxy2 = null;
                } else {
                    irValueParameter2 = irValueParameter;
                    bl2 = false;
                    bl = false;
                    it = irValueParameter2;
                    boolean bl4 = false;
                    n = index2;
                    index2 = n + 1;
                    KParameterProxy kParameterProxy3 = new KParameterProxy(new KParameterState(kParameterIrClass, it, n, KParameter.Kind.INSTANCE), callInterceptor);
                    kParameterProxy2 = kParameterProxy3;
                }
            }
        }
        KParameterProxy instanceParameter = kParameterProxy2;
        irDeclarationBase = this.property.getGetter();
        if (irDeclarationBase == null) {
            kParameterProxy = null;
        } else {
            irValueParameter = ((IrFunction)irDeclarationBase).getExtensionReceiverParameter();
            if (irValueParameter == null) {
                kParameterProxy = null;
            } else {
                irValueParameter2 = irValueParameter;
                bl2 = false;
                bl = false;
                it = irValueParameter2;
                boolean bl5 = false;
                n = index2;
                index2 = n + 1;
                KParameterProxy kParameterProxy4 = new KParameterProxy(new KParameterState(kParameterIrClass, it, n, KParameter.Kind.EXTENSION_RECEIVER), callInterceptor);
                kParameterProxy = kParameterProxy4;
            }
        }
        KParameterProxy extensionParameter = kParameterProxy;
        irDeclarationBase = new KParameterProxy[]{instanceParameter, extensionParameter};
        this._parameters = CollectionsKt.listOfNotNull((Object[])irDeclarationBase);
        List<KParameter> list3 = this._parameters;
        Intrinsics.checkNotNull(list3);
        return list3;
    }

    @NotNull
    public final KType getReturnType(@NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._returnType != null) {
            KType kType = this._returnType;
            Intrinsics.checkNotNull((Object)kType);
            return kType;
        }
        IrClass kTypeIrClass = this.getIrClassOfReflection(this.getIrClass(), "returnType");
        IrSimpleFunction irSimpleFunction = this.property.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        KType kType = this._returnType = (KType)new KTypeProxy(new KTypeState(irSimpleFunction.getReturnType(), kTypeIrClass), callInterceptor);
        Intrinsics.checkNotNull((Object)kType);
        return kType;
    }

    public final boolean isKProperty0() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KProperty0");
    }

    public final boolean isKProperty1() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KProperty1");
    }

    public final boolean isKProperty2() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KProperty2");
    }

    public final boolean isKMutableProperty0() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KMutableProperty0");
    }

    public final boolean isKMutableProperty1() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KMutableProperty1");
    }

    public final boolean isKMutableProperty2() {
        return Intrinsics.areEqual((Object)this.getIrClass().getName().asString(), (Object)"KMutableProperty2");
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState");
        }
        KPropertyState cfr_ignored_0 = (KPropertyState)other;
        if (!Intrinsics.areEqual((Object)this.property, (Object)((KPropertyState)other).property)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.receiver, (Object)((KPropertyState)other).receiver);
    }

    public int hashCode() {
        int n;
        int result2 = this.property.hashCode();
        State state2 = this.receiver;
        result2 = 31 * result2 + (state2 == null ? 0 : (n = state2.hashCode()));
        return result2;
    }

    @NotNull
    public String toString() {
        return this.renderProperty(this.property);
    }
}

