/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirImportsChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorImport;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.scopes.impl.FirClassDeclaredMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010\u001a\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001cH\u0002J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u0017*\u00020\u001f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010 \u001a\u00020\u0016*\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkAllUnderFromEnumEntry", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "checkCanBeImported", "checkConflictingImports", "imports", "", "checkOperatorRename", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "canBeImported", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "name", "Lorg/jetbrains/kotlin/name/Name;", "hasFunction", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "resolveToClass", "Lorg/jetbrains/kotlin/name/ClassId;", "resolvesToClass", "checkers"})
public final class FirImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirImportsChecker INSTANCE = new FirImportsChecker();

    private FirImportsChecker() {
    }

    @Override
    public void check(@NotNull FirFile declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        Iterable $this$forEach$iv = declaration2.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirImport firImport = (FirImport)element$iv;
            boolean bl = false;
            if (firImport instanceof FirErrorImport) continue;
            if (firImport.isAllUnder() && !(firImport instanceof FirResolvedImport)) {
                INSTANCE.checkAllUnderFromEnumEntry(firImport, context2, reporter2);
            }
            if (firImport.isAllUnder()) continue;
            INSTANCE.checkCanBeImported(firImport, context2, reporter2);
            if (!(firImport instanceof FirResolvedImport)) continue;
            INSTANCE.checkOperatorRename((FirResolvedImport)firImport, context2, reporter2);
        }
        this.checkConflictingImports(declaration2.getImports(), context2, reporter2);
    }

    private final void checkAllUnderFromEnumEntry(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter2) {
        FqName fqName2 = firImport.getImportedFqName();
        if (fqName2 == null) {
            return;
        }
        FqName fqName3 = fqName2;
        if (fqName3.isRoot() || fqName3.parent().isRoot()) {
            return;
        }
        ClassId classId = ClassId.topLevel(fqName3.parent());
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(fqName.parent())");
        ClassId classId2 = classId;
        FirRegularClass firRegularClass = this.resolveToClass(classId2, context2);
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass classFir = firRegularClass;
        FirClass $this$isEnumClass$iv = classFir;
        boolean $i$f$isEnumClass = false;
        if ($this$isEnumClass$iv.getClassKind() == ClassKind.ENUM_CLASS) {
            boolean bl;
            block8: {
                Iterable $this$any$iv = FirDeclarationUtilKt.collectEnumEntries(classFir);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirEnumEntry it = (FirEnumEntry)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)fqName3.shortName())) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                DiagnosticReporterKt.reportOn$default(reporter2, firImport.getSource(), FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), classFir.getName(), context2, null, 16, null);
            }
        }
    }

    private final void checkCanBeImported(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter2) {
        block16: {
            Object object;
            FqName importedFqName;
            block18: {
                block17: {
                    Name importedName;
                    block15: {
                        ClassId classId;
                        block14: {
                            block13: {
                                FqName fqName2 = firImport.getImportedFqName();
                                if (fqName2 == null) {
                                    return;
                                }
                                importedFqName = fqName2;
                                Object object2 = importedFqName.shortName();
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"importedFqName.shortName()");
                                importedName = object2;
                                if (importedName.isSpecial()) break block13;
                                object2 = importedName.getIdentifier();
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"importedName.identifier");
                                object2 = (CharSequence)object2;
                                boolean bl = false;
                                if (!(object2.length() == 0)) break block14;
                            }
                            return;
                        }
                        FirResolvedImport firResolvedImport = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
                        ClassId classId2 = classId = firResolvedImport == null ? null : firResolvedImport.getResolvedClassId();
                        if (classId == null) break block15;
                        FirRegularClass firRegularClass = this.resolveToClass(classId, context2);
                        if (firRegularClass == null) {
                            return;
                        }
                        FirRegularClass classFir = firRegularClass;
                        if (classFir.getClassKind().isSingleton()) {
                            return;
                        }
                        if (!this.canBeImported(classFir, context2, importedName)) {
                            DiagnosticReporterKt.reportOn$default(reporter2, firImport.getSource(), FirErrors.INSTANCE.getCANNOT_BE_IMPORTED(), importedName, context2, null, 16, null);
                        }
                        break block16;
                    }
                    object = ClassId.topLevel(importedFqName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(importedFqName)");
                    ClassId importedClassId = object;
                    if (this.resolveToClass(importedClassId, context2) != null) break block17;
                    FirSymbolProvider firSymbolProvider = MainSessionComponentsKt.getSymbolProvider(context2.getSession());
                    object = importedFqName.parent();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"importedFqName.parent()");
                    object = firSymbolProvider.getTopLevelCallableSymbols((FqName)object, importedName);
                    boolean bl = false;
                    if (!(!object.isEmpty())) break block18;
                }
                return;
            }
            object = MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getPackage(importedFqName);
            if (object != null) {
                Object object3 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object3;
                boolean bl3 = false;
                DiagnosticReporterKt.reportOn$default(reporter2, firImport.getSource(), FirErrors.INSTANCE.getPACKAGE_CANNOT_BE_IMPORTED(), context2, null, 8, null);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkConflictingImports(List<? extends FirImport> imports, CheckerContext context, DiagnosticReporter reporter) {
        var5_4 = imports;
        $i$f$filterIsInstance = false;
        var7_6 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirResolvedImport)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            import = (FirResolvedImport)element$iv$iv;
            $i$a$-filter-FirImportsChecker$checkConflictingImports$interestingImports$1 = false;
            if (import.isAllUnder()) ** GOTO lbl-1000
            var14_17 = import.getImportedName();
            if (var14_17 == null) {
                v0 = false;
            } else {
                var15_18 = var14_17.getIdentifierOrNullIfSpecial();
                if (var15_18 == null) {
                    v0 = false;
                } else {
                    var16_19 = var15_18;
                    var17_21 = false;
                    v0 = var16_19.length() > 0 == true;
                }
            }
            if (v0 && FirImportsChecker.INSTANCE.resolvesToClass(import, context)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        interestingImports = (List)destination$iv$iv;
        $this$filter$iv = interestingImports;
        $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (T element$iv$iv : $this$groupByTo$iv$iv) {
            it = (FirResolvedImport)element$iv$iv;
            $i$a$-groupBy-FirImportsChecker$checkConflictingImports$1 = false;
            var14_17 = it.getAliasName();
            if (var14_17 == null) {
                v2 = it.getImportedName();
                v3 = v2;
                Intrinsics.checkNotNull((Object)v2);
            } else {
                v3 = var14_17;
            }
            key$iv$iv = v3;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v4 /* !! */  = answer$iv$iv$iv;
            } else {
                v4 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v4 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            $i$a$-filter-FirImportsChecker$checkConflictingImports$2 = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            conflicts = (List)element$iv;
            $i$a$-forEach-FirImportsChecker$checkConflictingImports$3 = false;
            $this$forEach$iv = conflicts;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (FirResolvedImport)element$iv;
                $i$a$-forEach-FirImportsChecker$checkConflictingImports$3$1 = false;
                v5 = it.getSource();
                v6 = FirErrors.INSTANCE.getCONFLICTING_IMPORT();
                v7 = it.getImportedName();
                Intrinsics.checkNotNull((Object)v7);
                DiagnosticReporterKt.reportOn$default(reporter, v5, v6, v7, context, null, 16, null);
            }
        }
    }

    private final void checkOperatorRename(FirResolvedImport firResolvedImport, CheckerContext context2, DiagnosticReporter reporter2) {
        boolean illegalRename2;
        block10: {
            boolean bl;
            Name name2 = firResolvedImport.getAliasName();
            if (name2 == null) {
                return;
            }
            Name alias = name2;
            Name name3 = firResolvedImport.getImportedName();
            if (name3 == null) {
                return;
            }
            Name importedName = name3;
            if (!OperatorConventions.isConventionName(alias)) {
                return;
            }
            ClassId classId = firResolvedImport.getResolvedClassId();
            if (classId != null) {
                FirRegularClass firRegularClass = this.resolveToClass(classId, context2);
                if (firRegularClass == null) {
                    return;
                }
                FirRegularClass classFir = firRegularClass;
                bl = classFir.getClassKind().isSingleton() && this.hasFunction(classFir, context2, importedName, (Function1<? super FirSimpleFunction, Boolean>)((Function1)checkOperatorRename.illegalRename.1.INSTANCE));
            } else {
                Iterable $this$any$iv = MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getTopLevelFunctionSymbols(firResolvedImport.getPackageFqName(), importedName);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirNamedFunctionSymbol it = (FirNamedFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        FirMemberDeclaration $this$isOperator$iv = (FirMemberDeclaration)it.getFir();
                        boolean $i$f$isOperator = false;
                        if (!$this$isOperator$iv.getStatus().isOperator()) continue;
                        bl = true;
                        break block10;
                    }
                    bl = illegalRename2 = false;
                }
            }
        }
        if (illegalRename2) {
            DiagnosticReporterKt.reportOn$default(reporter2, firResolvedImport.getSource(), FirErrors.INSTANCE.getOPERATOR_RENAMED_ON_IMPORT(), context2, null, 8, null);
        }
    }

    private final boolean resolvesToClass(FirResolvedImport $this$resolvesToClass, CheckerContext context2) {
        if ($this$resolvesToClass.getResolvedClassId() != null) {
            if ($this$resolvesToClass.isAllUnder()) {
                return true;
            }
            ClassId classId = $this$resolvesToClass.getResolvedClassId();
            Intrinsics.checkNotNull((Object)classId);
            ClassId parentClass = classId;
            FqName fqName2 = $this$resolvesToClass.getRelativeClassName();
            if (fqName2 == null) {
                return false;
            }
            FqName relativeClassName = fqName2;
            Name name2 = $this$resolvesToClass.getImportedName();
            if (name2 == null) {
                return false;
            }
            Name importedName = name2;
            ClassId innerClassId = new ClassId(parentClass.getPackageFqName(), relativeClassName.child(importedName), false);
            return this.resolveToClass(innerClassId, context2) != null;
        }
        FqName relativeClassName = $this$resolvesToClass.getImportedFqName();
        if (relativeClassName == null) {
            return false;
        }
        FqName importedFqName = relativeClassName;
        if (importedFqName.isRoot()) {
            return false;
        }
        ClassId classId = ClassId.topLevel(importedFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(importedFqName)");
        ClassId importedClassId = classId;
        return this.resolveToClass(importedClassId, context2) != null;
    }

    private final FirRegularClass resolveToClass(ClassId $this$resolveToClass, CheckerContext context2) {
        FirClassLikeDeclaration<?> firClassLikeDeclaration;
        FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName($this$resolveToClass);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        FirRegularClass firRegularClass = (firClassLikeSymbol = classSymbol) instanceof FirRegularClassSymbol ? (FirRegularClass)((FirRegularClassSymbol)classSymbol).getFir() : (firClassLikeSymbol instanceof FirTypeAliasSymbol ? ((firClassLikeDeclaration = FirHelpersKt.followAllAlias((FirClassLikeDeclaration)((FirTypeAliasSymbol)classSymbol).getFir(), context2.getSession())) instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null) : null);
        return firRegularClass;
    }

    private final boolean hasFunction(FirRegularClass $this$hasFunction, CheckerContext context2, Name name2, Function1<? super FirSimpleFunction, Boolean> predicate) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$hasFunction).processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(result2, predicate){
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ Function1<FirSimpleFunction, Boolean> $predicate;
            {
                this.$result = $result;
                this.$predicate = $predicate;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol sym) {
                Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
                if (!this.$result.element) {
                    this.$result.element = (Boolean)this.$predicate.invoke(sym.getFir());
                }
            }
        }));
        return result2.element;
    }

    private final boolean canBeImported(FirRegularClass $this$canBeImported, CheckerContext context2, Name name2) {
        Ref.BooleanRef hasStatic = new Ref.BooleanRef();
        Ref.BooleanRef hasIllegal = new Ref.BooleanRef();
        FirClassDeclaredMemberScope scope2 = FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$canBeImported);
        scope2.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(hasStatic, hasIllegal){
            final /* synthetic */ Ref.BooleanRef $hasStatic;
            final /* synthetic */ Ref.BooleanRef $hasIllegal;
            {
                this.$hasStatic = $hasStatic;
                this.$hasIllegal = $hasIllegal;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol sym) {
                Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
                if (FirCallableSymbolKt.isStatic(sym)) {
                    this.$hasStatic.element = true;
                } else {
                    this.$hasIllegal.element = true;
                }
            }
        }));
        if (hasStatic.element) {
            return true;
        }
        if (hasIllegal.element) {
            return false;
        }
        scope2.processPropertiesByName(name2, (Function1)new Function1<FirVariableSymbol<?>, Unit>(hasStatic, hasIllegal){
            final /* synthetic */ Ref.BooleanRef $hasStatic;
            final /* synthetic */ Ref.BooleanRef $hasIllegal;
            {
                this.$hasStatic = $hasStatic;
                this.$hasIllegal = $hasIllegal;
                super(1);
            }

            public final void invoke(@NotNull FirVariableSymbol<?> sym) {
                Intrinsics.checkNotNullParameter(sym, (String)"sym");
                if (FirCallableSymbolKt.isStatic((FirCallableSymbol)sym)) {
                    this.$hasStatic.element = true;
                } else {
                    this.$hasIllegal.element = true;
                }
            }
        });
        return hasStatic.element || !hasIllegal.element;
    }
}

