/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.cfg.UnreachableCode;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies$DOT_BY_QUALIFIED$1$mark$lambda-1$;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies$VALUE_ARGUMENTS$1$mark$;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u0083\u0001\u0084\u0001\u0085\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010~\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0015\u0010\u007f\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u0081\u00010\u0080\u0001\"\u00030\u0081\u0001H\u0007\u00a2\u0006\u0003\u0010\u0082\u0001R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000bR\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u000bR\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u000bR\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020G0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010J\u001a\b\u0012\u0004\u0012\u00020K0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u000bR\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020N0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u000bR\u0017\u0010S\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\u000bR\u0017\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\u000bR\u0017\u0010W\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u000bR\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020Z0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010]\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010\u000bR\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020C0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010\u000bR\u0016\u0010d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020g0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010h\u001a\b\u0012\u0004\u0012\u00020g0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010j\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010k\u001a\b\u0012\u0004\u0012\u00020l0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010o\u001a\b\u0012\u0004\u0012\u00020p0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010q\u001a\b\u0012\u0004\u0012\u00020r0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010\u000bR\u0013\u0010u\u001a\u00070v\u00a2\u0006\u0002\bwX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010x\u001a\u00070v\u00a2\u0006\u0002\bwX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010y\u001a\u0004\u0018\u00010z*\n\u0012\u0006\b\u0001\u0012\u00020\u00070{8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b|\u0010}\u00a8\u0006\u0086\u0001"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies;", "", "()V", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "ACTUAL_DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "ANNOTATION_USE_SITE", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "getANNOTATION_USE_SITE", "()Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "ARRAY_ACCESS", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "ASSIGNMENT_LHS", "Lcom/intellij/psi/PsiElement;", "getASSIGNMENT_LHS", "AS_TYPE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "CALL_ELEMENT", "CALL_EXPRESSION", "COMPANION_OBJECT", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "CONST_MODIFIER", "CUT_CHAR_QUOTES", "Lorg/jetbrains/kotlin/psi/KtElement;", "DECLARATION_NAME", "DECLARATION_RETURN_TYPE", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "DECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "DECLARATION_START_TO_NAME", "DECLARATION_WITH_BODY", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "DEFAULT", "DELEGATOR_SUPER_CALL", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "DOT_BY_QUALIFIED", "getDOT_BY_QUALIFIED", "ELSE_ENTRY", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "FOR_REDECLARATION", "FOR_UNRESOLVED_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "FUNCTION_PARAMETERS", "Lorg/jetbrains/kotlin/psi/KtFunction;", "FUN_INTERFACE", "FUN_MODIFIER", "IF_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "IMPORT_ALIAS", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "IMPORT_LAST_NAME", "getIMPORT_LAST_NAME", "INCOMPATIBLE_DECLARATION", "INLINE_OR_VALUE_MODIFIER", "INNER_MODIFIER", "LATEINIT_MODIFIER", "LONG_LITERAL_SUFFIX", "MODALITY_MODIFIER", "NAME_OF_NAMED_ARGUMENT", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT", "NULLABLE_TYPE", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "OPEN_MODIFIER", "OPERATOR", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getOPERATOR", "OVERRIDE_MODIFIER", "PARAMETER_DEFAULT_VALUE", "Lorg/jetbrains/kotlin/psi/KtParameter;", "PARAMETER_VARARG_MODIFIER", "PRIVATE_MODIFIER", "PROPERTY_INITIALIZER", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getPROPERTY_INITIALIZER", "QUESTION_MARK_BY_TYPE", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "RECEIVER", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "REFERENCED_NAME_BY_QUALIFIED", "getREFERENCED_NAME_BY_QUALIFIED", "REFERENCE_BY_QUALIFIED", "getREFERENCE_BY_QUALIFIED", "REIFIED_MODIFIER", "getREIFIED_MODIFIER", "RESERVED_UNDERSCORE", "getRESERVED_UNDERSCORE", "RETURN_WITH_LABEL", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "SAFE_ACCESS", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "SELECTOR_BY_QUALIFIED", "getSELECTOR_BY_QUALIFIED", "SPECIAL_CONSTRUCT_TOKEN", "SUPERTYPES_LIST", "SUSPEND_MODIFIER", "TYPE_PARAMETERS_LIST", "getTYPE_PARAMETERS_LIST", "TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE", "UNREACHABLE_CODE", "UNUSED_VALUE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "USELESS_ELVIS", "VALUE_ARGUMENTS", "VAL_OR_VAR_NODE", "VARIANCE_IN_PROJECTION", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "VARIANCE_MODIFIER", "VISIBILITY_MODIFIER", "WHEN_CONDITION_IN_RANGE", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "WHEN_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "WHOLE_ELEMENT", "getWHOLE_ELEMENT", "classKindTokens", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "propertyKindTokens", "firstIncompatibility", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectedActualResolver$Compatibility$Incompatible;", "Lorg/jetbrains/kotlin/diagnostics/ParametrizedDiagnostic;", "getFirstIncompatibility", "(Lorg/jetbrains/kotlin/diagnostics/ParametrizedDiagnostic;)Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectedActualResolver$Compatibility$Incompatible;", "modifierSetPosition", "tokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "DeclarationHeader", "FindReferencePositioningStrategy", "ModifierSetBasedPositioningStrategy", "frontend"})
public final class PositioningStrategies {
    @NotNull
    public static final PositioningStrategies INSTANCE = new PositioningStrategies();
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT = new PositioningStrategy<PsiElement>(){

        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element;
            if (psiElement instanceof KtObjectLiteralExpression) {
                KtObjectDeclaration ktObjectDeclaration = ((KtObjectLiteralExpression)element).getObjectDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"element.objectDeclaration");
                KtObjectDeclaration objectDeclaration = ktObjectDeclaration;
                PsiElement psiElement2 = objectDeclaration.getObjectKeyword();
                Intrinsics.checkNotNull((Object)psiElement2);
                PsiElement objectKeyword = psiElement2;
                KtSuperTypeList ktSuperTypeList = objectDeclaration.getSuperTypeList();
                if (ktSuperTypeList == null) {
                    return PositioningStrategyKt.markElement(objectKeyword);
                }
                KtSuperTypeList delegationSpecifierList = ktSuperTypeList;
                return PositioningStrategyKt.markRange(objectKeyword, (PsiElement)delegationSpecifierList);
            }
            if (psiElement instanceof KtObjectDeclaration) {
                PsiElement psiElement3;
                PsiElement psiElement4 = ((KtObjectDeclaration)element).getObjectKeyword();
                Intrinsics.checkNotNull((Object)psiElement4);
                PsiElement psiElement5 = ((KtObjectDeclaration)element).getNameIdentifier();
                if (psiElement5 == null) {
                    PsiElement psiElement6 = ((KtObjectDeclaration)element).getObjectKeyword();
                    psiElement3 = psiElement6;
                    Intrinsics.checkNotNull((Object)psiElement6);
                } else {
                    psiElement3 = psiElement5;
                }
                PsiElement psiElement7 = psiElement3;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement7, (String)"element.nameIdentifier ?\u2026ment.getObjectKeyword()!!");
                return PositioningStrategyKt.markRange(psiElement4, psiElement7);
            }
            if (psiElement instanceof KtConstructorDelegationCall) {
                return PositioningStrategies.SECONDARY_CONSTRUCTOR_DELEGATION_CALL.mark(element);
            }
            return super.mark(element);
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SUPERTYPES_LIST = new PositioningStrategy<PsiElement>(){

        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            KtClass ktClass;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            KtClass ktClass2 = ktClass = element instanceof KtClass ? (KtClass)element : null;
            if (ktClass == null) {
                return PositioningStrategyKt.markElement(element);
            }
            List<KtSuperTypeListEntry> supertypes2 = ktClass.getSuperTypeListEntries();
            return supertypes2.isEmpty() ? PositioningStrategyKt.markElement(element) : PositioningStrategyKt.markRange((PsiElement)supertypes2.get(0), (PsiElement)CollectionsKt.last(supertypes2));
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_RETURN_TYPE = new PositioningStrategy<KtDeclaration>(){

        @NotNull
        public List<TextRange> mark(@NotNull KtDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return PositioningStrategyKt.markElement(this.getElementToMark(element));
        }

        public boolean isValid(@NotNull KtDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element));
        }

        private final PsiElement getElementToMark(KtDeclaration declaration2) {
            KtDeclaration ktDeclaration = declaration2;
            Pair pair = ktDeclaration instanceof KtCallableDeclaration ? new Pair((Object)((KtCallableDeclaration)declaration2).getTypeReference(), (Object)((KtCallableDeclaration)declaration2).getNameIdentifier()) : (ktDeclaration instanceof KtPropertyAccessor ? new Pair((Object)((KtPropertyAccessor)declaration2).getReturnTypeReference(), (Object)((KtPropertyAccessor)declaration2).getNamePlaceholder()) : new Pair(null, null));
            KtTypeReference returnTypeRef = (KtTypeReference)pair.component1();
            PsiElement nameIdentifierOrPlaceholder = (PsiElement)pair.component2();
            if (returnTypeRef != null) {
                return returnTypeRef;
            }
            if (nameIdentifierOrPlaceholder != null) {
                return nameIdentifierOrPlaceholder;
            }
            return declaration2;
        }
    };
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> ACTUAL_DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

        @NotNull
        public List<TextRange> mark(@NotNull KtNamedDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement nameIdentifier = element.getNameIdentifier();
            return nameIdentifier != null ? PositioningStrategyKt.markElement(nameIdentifier) : (element instanceof KtNamedFunction ? PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element)) : PositioningStrategies.DEFAULT.mark(element));
        }
    };
    @NotNull
    private static final TokenSet propertyKindTokens;
    @NotNull
    private static final TokenSet classKindTokens;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> INCOMPATIBLE_DECLARATION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_START_TO_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ABSTRACT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OPEN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OVERRIDE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> PRIVATE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> LATEINIT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VARIANCE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> CONST_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> FUN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> SUSPEND_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtArrayAccessExpression> ARRAY_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SAFE_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VISIBILITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> MODALITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INLINE_OR_VALUE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> INNER_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeProjection> VARIANCE_IN_PROJECTION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_DEFAULT_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_VARARG_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtValueArgument> NAME_OF_NAMED_ARGUMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclarationWithBody> DECLARATION_WITH_BODY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> VAL_OR_VAR_NODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenEntry> ELSE_ENTRY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenExpression> WHEN_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtIfExpression> IF_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtExpression> SPECIAL_CONSTRUCT_TOKEN;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNullableType> NULLABLE_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeReference> QUESTION_MARK_BY_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtFunction> FUNCTION_PARAMETERS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> CUT_CHAR_QUOTES;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> LONG_LITERAL_SUFFIX;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> UNREACHABLE_CODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpressionWithTypeRHS> AS_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtObjectDeclaration> COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtEnumEntry> DELEGATOR_SUPER_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> UNUSED_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> USELESS_ELVIS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtImportDirective> IMPORT_ALIAS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReturnExpression> RETURN_WITH_LABEL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtCallableDeclaration> RECEIVER;
    @NotNull
    private static final PositioningStrategy<KtExpression> OPERATOR;
    @NotNull
    private static final PositioningStrategy<PsiElement> DOT_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> SELECTOR_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> RESERVED_UNDERSCORE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> FUN_INTERFACE;
    @NotNull
    private static final PositioningStrategy<PsiElement> REFERENCE_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<PsiElement> REFERENCED_NAME_BY_QUALIFIED;
    @NotNull
    private static final PositioningStrategy<KtModifierListOwner> REIFIED_MODIFIER;
    @NotNull
    private static final PositioningStrategy<KtProperty> PROPERTY_INITIALIZER;
    @NotNull
    private static final PositioningStrategy<KtElement> WHOLE_ELEMENT;
    @NotNull
    private static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_LIST;
    @NotNull
    private static final PositioningStrategy<KtAnnotationEntry> ANNOTATION_USE_SITE;
    @NotNull
    private static final PositioningStrategy<PsiElement> ASSIGNMENT_LHS;
    @NotNull
    private static final PositioningStrategy<PsiElement> IMPORT_LAST_NAME;

    private PositioningStrategies() {
    }

    private final ExpectedActualResolver.Compatibility.Incompatible getFirstIncompatibility(ParametrizedDiagnostic<? extends KtNamedDeclaration> $this$firstIncompatibility) {
        Map map;
        DiagnosticFactory<?> diagnosticFactory = $this$firstIncompatibility.getFactory();
        if (Intrinsics.areEqual(diagnosticFactory, Errors.NO_ACTUAL_FOR_EXPECT)) {
            map = (Map)((DiagnosticWithParameters3)Errors.NO_ACTUAL_FOR_EXPECT.cast((UnboundDiagnostic)$this$firstIncompatibility)).getC();
        } else if (Intrinsics.areEqual(diagnosticFactory, Errors.ACTUAL_WITHOUT_EXPECT)) {
            map = (Map)((DiagnosticWithParameters2)Errors.ACTUAL_WITHOUT_EXPECT.cast((UnboundDiagnostic)$this$firstIncompatibility)).getB();
        } else {
            return null;
        }
        Map map2 = map;
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"when (factory) {\n       \u2026return null\n            }");
        Map map3 = map2;
        return (ExpectedActualResolver.Compatibility.Incompatible)CollectionsKt.firstOrNull((Iterable)map3.keySet());
    }

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> modifierSetPosition(KtModifierKeywordToken ... tokens) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        return new PositioningStrategy<KtModifierListOwner>(tokens){
            final /* synthetic */ KtModifierKeywordToken[] $tokens;
            {
                this.$tokens = $tokens;
            }

            @NotNull
            public List<TextRange> mark(@NotNull KtModifierListOwner element) {
                KtModifierKeywordToken[] ktModifierKeywordTokenArray;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtModifierKeywordToken[] $this$sure$iv = element.getModifierList();
                boolean $i$f$sure = false;
                KtModifierKeywordToken[] ktModifierKeywordTokenArray2 = $this$sure$iv;
                if (ktModifierKeywordTokenArray2 == null) {
                    String string2;
                    boolean bl = false;
                    String string3 = string2 = "No modifier list, but modifier has been found by the analyzer";
                    throw new AssertionError((Object)string3);
                }
                KtModifierKeywordToken[] modifierList2 = ktModifierKeywordTokenArray = ktModifierKeywordTokenArray2;
                for (KtModifierKeywordToken token : this.$tokens) {
                    PsiElement modifier = modifierList2.getModifier(token);
                    if (modifier == null) continue;
                    return PositioningStrategyKt.markElement(modifier);
                }
                throw new IllegalStateException(Intrinsics.stringPlus((String)"None of the modifiers is found: ", (Object)CollectionsKt.listOf((Object[])Arrays.copyOf(this.$tokens, this.$tokens.length))));
            }
        };
    }

    @NotNull
    public final PositioningStrategy<KtExpression> getOPERATOR() {
        return OPERATOR;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getDOT_BY_QUALIFIED() {
        return DOT_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getSELECTOR_BY_QUALIFIED() {
        return SELECTOR_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getRESERVED_UNDERSCORE() {
        return RESERVED_UNDERSCORE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getREFERENCE_BY_QUALIFIED() {
        return REFERENCE_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getREFERENCED_NAME_BY_QUALIFIED() {
        return REFERENCED_NAME_BY_QUALIFIED;
    }

    @NotNull
    public final PositioningStrategy<KtModifierListOwner> getREIFIED_MODIFIER() {
        return REIFIED_MODIFIER;
    }

    @NotNull
    public final PositioningStrategy<KtProperty> getPROPERTY_INITIALIZER() {
        return PROPERTY_INITIALIZER;
    }

    @NotNull
    public final PositioningStrategy<KtElement> getWHOLE_ELEMENT() {
        return WHOLE_ELEMENT;
    }

    @NotNull
    public final PositioningStrategy<KtDeclaration> getTYPE_PARAMETERS_LIST() {
        return TYPE_PARAMETERS_LIST;
    }

    @NotNull
    public final PositioningStrategy<KtAnnotationEntry> getANNOTATION_USE_SITE() {
        return ANNOTATION_USE_SITE;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getASSIGNMENT_LHS() {
        return ASSIGNMENT_LHS;
    }

    @NotNull
    public final PositioningStrategy<PsiElement> getIMPORT_LAST_NAME() {
        return IMPORT_LAST_NAME;
    }

    public static final /* synthetic */ ExpectedActualResolver.Compatibility.Incompatible access$getFirstIncompatibility(PositioningStrategies $this, ParametrizedDiagnostic $receiver) {
        return $this.getFirstIncompatibility($receiver);
    }

    public static final /* synthetic */ TokenSet access$getClassKindTokens$p() {
        return classKindTokens;
    }

    public static final /* synthetic */ TokenSet access$getPropertyKindTokens$p() {
        return propertyKindTokens;
    }

    static {
        Object object = new IElementType[]{KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD};
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = TokenSet.create((IElementType[])object);
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"create(KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD)");
        propertyKindTokens = ktModifierKeywordTokenArray;
        object = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        ktModifierKeywordTokenArray = TokenSet.create((IElementType[])object);
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"create(KtTokens.CLASS_KE\u2026Tokens.INTERFACE_KEYWORD)");
        classKindTokens = ktModifierKeywordTokenArray;
        INCOMPATIBLE_DECLARATION = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends KtNamedDeclaration> diagnostic) {
                List<TextRange> list2;
                KtTypeParameterListOwner ktTypeParameterListOwner;
                PsiElement psiElement;
                Object object;
                ExpectedActualResolver.Compatibility.Incompatible incompatibility;
                Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
                KtNamedDeclaration element = diagnostic.getPsiElement();
                KtCallableDeclaration callableDeclaration = element instanceof KtCallableDeclaration ? (KtCallableDeclaration)element : null;
                ExpectedActualResolver.Compatibility.Incompatible incompatible = incompatibility = PositioningStrategies.access$getFirstIncompatibility(PositioningStrategies.INSTANCE, diagnostic);
                if (((incompatible == null ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.Unknown.INSTANCE)) ? true : incompatible instanceof ExpectedActualResolver.Compatibility.Incompatible.ClassScopes) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.EnumEntries.INSTANCE)) {
                    object = null;
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ClassKind.INSTANCE)) {
                    KtModifierList endElement;
                    KtModifierList ktModifierList = element.getModifierList();
                    PsiElement psiElement2 = psiElement = ktModifierList == null ? null : ktModifierList.getModifier(KtTokens.ENUM_KEYWORD);
                    PsiElement startElement = psiElement == null ? ((ktModifierList = element.getModifierList()) == null ? null : ktModifierList.getModifier(KtTokens.ANNOTATION_KEYWORD)) : psiElement;
                    ASTNode aSTNode = element.getNode().findChildByType(PositioningStrategies.access$getClassKindTokens$p());
                    ktModifierList = aSTNode == null ? null : aSTNode.getPsi();
                    KtModifierList ktModifierList2 = endElement = ktModifierList == null ? element.getNameIdentifier() : ktModifierList;
                    if (startElement != null && endElement != null) {
                        return PositioningStrategyKt.markRange(startElement, (PsiElement)endElement);
                    }
                    object = endElement;
                } else if ((((Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.TypeParameterNames.INSTANCE) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.TypeParameterCount.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.TypeParameterUpperBounds.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.TypeParameterVariance.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.TypeParameterReified.INSTANCE)) {
                    ktTypeParameterListOwner = element instanceof KtTypeParameterListOwner ? (KtTypeParameterListOwner)element : null;
                    object = (PsiElement)(ktTypeParameterListOwner == null ? null : ktTypeParameterListOwner.getTypeParameterList());
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.CallableKind.INSTANCE)) {
                    psiElement = callableDeclaration instanceof KtNamedFunction ? (KtNamedFunction)callableDeclaration : null;
                    PsiElement psiElement3 = ktTypeParameterListOwner = psiElement == null ? null : psiElement.getFunKeyword();
                    if (ktTypeParameterListOwner == null) {
                        KtProperty ktProperty = psiElement = callableDeclaration instanceof KtProperty ? (KtProperty)callableDeclaration : null;
                        object = psiElement == null ? null : psiElement.getValOrVarKeyword();
                    } else {
                        object = ktTypeParameterListOwner;
                    }
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ParameterShape.INSTANCE)) {
                    KtElementImplStub ktElementImplStub;
                    ktTypeParameterListOwner = callableDeclaration;
                    if (ktTypeParameterListOwner == null) {
                        ktElementImplStub = null;
                    } else {
                        psiElement = ktTypeParameterListOwner;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiElement it = psiElement;
                        boolean bl3 = false;
                        KtTypeReference ktTypeReference = it.getReceiverTypeReference();
                        ktElementImplStub = ktTypeReference == null ? (KtElementImplStub)it.getValueParameterList() : (KtElementImplStub)ktTypeReference;
                    }
                    object = (PsiElement)ktElementImplStub;
                } else if (((((Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ParameterCount.INSTANCE) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ParameterTypes.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ParameterNames.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ValueParameterVararg.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ValueParameterNoinline.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ValueParameterCrossinline.INSTANCE)) {
                    ktTypeParameterListOwner = callableDeclaration;
                    object = (PsiElement)(ktTypeParameterListOwner == null ? null : ktTypeParameterListOwner.getValueParameterList());
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ReturnType.INSTANCE)) {
                    ktTypeParameterListOwner = callableDeclaration;
                    object = ktTypeParameterListOwner == null ? null : ktTypeParameterListOwner.getTypeReference();
                } else if (((Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.FunctionModifiersDifferent.INSTANCE) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.FunctionModifiersNotSubset.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.PropertyModifiers.INSTANCE)) ? true : Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.ClassModifiers.INSTANCE)) {
                    object = (PsiElement)element.getModifierList();
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.PropertyKind.INSTANCE)) {
                    ktTypeParameterListOwner = element.getNode().findChildByType(PositioningStrategies.access$getPropertyKindTokens$p());
                    object = ktTypeParameterListOwner == null ? null : ktTypeParameterListOwner.getPsi();
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.Supertypes.INSTANCE)) {
                    ktTypeParameterListOwner = element instanceof KtClassOrObject ? (KtClassOrObject)element : null;
                    object = (PsiElement)(ktTypeParameterListOwner == null ? null : ((KtClassOrObject)ktTypeParameterListOwner).getSuperTypeList());
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.Modality.INSTANCE)) {
                    object = KtPsiUtilKt.modalityModifier(element);
                } else if (Intrinsics.areEqual((Object)incompatible, (Object)ExpectedActualResolver.Compatibility.Incompatible.Visibility.INSTANCE)) {
                    object = KtPsiUtilKt.visibilityModifier(element);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                PsiElement psiElement4 = object;
                if (psiElement4 == null) {
                    list2 = null;
                } else {
                    incompatible = psiElement4;
                    boolean bl = false;
                    boolean bl4 = false;
                    ExpectedActualResolver.Compatibility.Incompatible it = incompatible;
                    boolean bl5 = false;
                    list2 = PositioningStrategyKt.markElement((PsiElement)it);
                }
                List<TextRange> list3 = list2;
                return list3 == null ? PositioningStrategies.ACTUAL_DECLARATION_NAME.mark((KtNamedDeclaration)((PsiElement)element)) : list3;
            }
        };
        DECLARATION_START_TO_NAME = new DeclarationHeader<KtDeclaration>(){

            private final PsiElement firstNonCommentNonAnnotationLeaf(PsiElement $this$firstNonCommentNonAnnotationLeaf) {
                PsiElement leaf;
                PsiElement psiElement = $this$firstNonCommentNonAnnotationLeaf.getFirstChild();
                if (psiElement == null) {
                    return $this$firstNonCommentNonAnnotationLeaf;
                }
                PsiElement child = psiElement;
                while (true) {
                    if (child instanceof PsiComment || child instanceof PsiWhiteSpace || child instanceof KtAnnotationEntry) {
                        child = child.getNextSibling();
                        continue;
                    }
                    if (child == null) {
                        return null;
                    }
                    leaf = this.firstNonCommentNonAnnotationLeaf(child);
                    if (leaf != null) break;
                    child = child.getNextSibling();
                }
                return leaf;
            }

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                PsiElement psiElement;
                PsiElement psiElement2;
                PsiElement nameIdentifier;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement3 = this.firstNonCommentNonAnnotationLeaf(element);
                PsiElement startElement = psiElement3 == null ? (PsiElement)element : psiElement3;
                KtDeclaration ktDeclaration = element instanceof KtNamedDeclaration ? (KtNamedDeclaration)element : null;
                PsiElement psiElement4 = nameIdentifier = ktDeclaration == null ? null : ktDeclaration.getNameIdentifier();
                return nameIdentifier != null ? PositioningStrategyKt.markRange(startElement, nameIdentifier) : ((ktDeclaration = element) instanceof KtConstructor ? PositioningStrategyKt.markRange(startElement, (psiElement2 = ((KtConstructor)element).getConstructorKeyword()) == null ? (PsiElement)element : psiElement2) : (ktDeclaration instanceof KtObjectDeclaration ? PositioningStrategyKt.markRange(startElement, (psiElement = ((KtObjectDeclaration)element).getObjectKeyword()) == null ? (PsiElement)element : psiElement) : PositioningStrategies.DEFAULT.mark(element)));
            }
        };
        DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNamedDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement nameIdentifier = element.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element instanceof KtClassOrObject) {
                        PsiElement psiElement;
                        PsiElement psiElement2;
                        PsiElement psiElement3;
                        KtModifierList ktModifierList = element.getModifierList();
                        PsiElement psiElement4 = psiElement3 = ktModifierList == null ? null : ktModifierList.getModifier(KtTokens.ENUM_KEYWORD);
                        if (psiElement3 == null) {
                            PsiElement psiElement5 = new PsiElement[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD};
                            ktModifierList = ((KtClassOrObject)element).getNode().findChildByType(TokenSet.create((IElementType[])psiElement5));
                            psiElement2 = ktModifierList == null ? (PsiElement)element : ((psiElement5 = ktModifierList.getPsi()) == null ? (PsiElement)element : psiElement5);
                        } else {
                            psiElement2 = psiElement3;
                        }
                        PsiElement startElement = psiElement = psiElement2;
                        return PositioningStrategyKt.markRange(startElement, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element instanceof KtNamedFunction) {
                    return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtConstructor) {
                    Object object;
                    PsiElement psiElement;
                    Object object2;
                    PsiElement psiElement2 = ((KtConstructor)element).getConstructorKeyword();
                    if (psiElement2 == null) {
                        object2 = (PsiElement)((KtConstructor)element).getValueParameterList();
                        if (object2 == null) {
                            return PositioningStrategyKt.markElement(element);
                        }
                        psiElement = object2;
                    } else {
                        psiElement = psiElement2;
                    }
                    PsiElement begin = psiElement;
                    object2 = ((KtConstructor)element).getValueParameterList();
                    if (object2 == null) {
                        PsiElement psiElement3 = ((KtConstructor)element).getConstructorKeyword();
                        if (psiElement3 == null) {
                            return PositioningStrategyKt.markElement(element);
                        }
                        object = psiElement3;
                    } else {
                        object = object2;
                    }
                    Object end = object;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (ktDeclaration instanceof KtFunction) {
                    PsiElement end;
                    PsiElement psiElement;
                    KtElementImplStub ktElementImplStub;
                    KtTypeReference ktTypeReference = ((KtFunction)element).getTypeReference();
                    PsiElement psiElement4 = ktTypeReference == null ? ((ktElementImplStub = (KtElementImplStub)((KtFunction)element).getValueParameterList()) == null ? ((psiElement = ((KtFunction)element).getNameIdentifier()) == null ? (PsiElement)element : psiElement) : (PsiElement)ktElementImplStub) : (PsiElement)ktTypeReference;
                    PsiElement endOfSignatureElement = end = psiElement4;
                    KtElement startElement = element instanceof KtFunctionLiteral ? (KtElement)((ktTypeReference = ((KtFunction)element).getReceiverTypeReference()) == null ? ((ktElementImplStub = (KtElementImplStub)((KtFunction)element).getValueParameterList()) == null ? (NavigatablePsiElement)element : (NavigatablePsiElement)ktElementImplStub) : (NavigatablePsiElement)ktTypeReference) : (KtElement)element;
                    return PositioningStrategyKt.markRange((PsiElement)startElement, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement;
                    PsiElement startElement;
                    KtTypeReference ktTypeReference = ((KtProperty)element).getTypeReference();
                    PsiElement endOfSignatureElement = startElement = ktTypeReference == null ? ((psiElement = ((KtProperty)element).getNameIdentifier()) == null ? (PsiElement)element : psiElement) : (PsiElement)ktTypeReference;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtPropertyAccessor) {
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtPropertyAccessor)element).getReturnTypeReference();
                    PsiElement startElement = ktTypeReference == null ? ((psiElement = ((KtPropertyAccessor)element).getRightParenthesis()) == null ? ((KtPropertyAccessor)element).getNamePlaceholder() : psiElement) : (PsiElement)ktTypeReference;
                    Intrinsics.checkNotNullExpressionValue((Object)startElement, (String)"element.returnTypeRefere\u2026: element.namePlaceholder");
                    PsiElement endOfSignatureElement = startElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtClass) {
                    PsiElement startElement;
                    Object object = ((KtClass)element).getNameIdentifier();
                    if (object == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement nameAsDeclaration = startElement = object;
                    object = ((KtClass)element).getPrimaryConstructorParameterList();
                    if (object == null) {
                        return PositioningStrategyKt.markElement(nameAsDeclaration);
                    }
                    Object primaryConstructorParameterList = object;
                    return PositioningStrategyKt.markRange(nameAsDeclaration, primaryConstructorParameterList);
                }
                if (ktDeclaration instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DECLARATION_NAME.mark((KtNamedDeclaration)element);
                }
                if (ktDeclaration instanceof KtClassInitializer) {
                    TextRange textRange = ((KtClassInitializer)element).getInitKeyword().getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.initKeyword.textRange");
                    return PositioningStrategyKt.markRange(textRange);
                }
                return super.mark((PsiElement)element);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)element) : PositioningStrategies.DEFAULT.mark(element);
            }

            public boolean isValid(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.isValid((KtDeclaration)element) : PositioningStrategies.DEFAULT.isValid(element);
            }
        };
        NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtClassOrObject) {
                    PsiElement psiElement2;
                    PsiElement psiElement3 = ((KtClassOrObject)element).getDeclarationKeyword();
                    psiElement = psiElement3 == null ? ((psiElement2 = ((KtClassOrObject)element).getNameIdentifier()) == null ? (PsiElement)element : psiElement2) : psiElement3;
                } else if (ktDeclaration instanceof KtNamedFunction) {
                    PsiElement psiElement4;
                    PsiElement psiElement5;
                    KtModifierList ktModifierList = ((KtNamedFunction)element).getModifierList();
                    PsiElement psiElement6 = psiElement5 = ktModifierList == null ? null : ktModifierList.getModifier(KtTokens.INLINE_KEYWORD);
                    psiElement = psiElement4 = psiElement5 == null ? ((ktModifierList = ((KtNamedFunction)element).getFunKeyword()) == null ? (PsiElement)element : ktModifierList) : psiElement5;
                } else {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                KtTypeParameterList jetTypeParameterList;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtTypeParameterListOwner && (jetTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement((PsiElement)jetTypeParameterList);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
            }
        };
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        ABSTRACT_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OPEN_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        OPEN_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        OVERRIDE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        PRIVATE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.LATEINIT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"LATEINIT_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        LATEINIT_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[2];
        object = KtTokens.IN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"IN_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        object = KtTokens.OUT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OUT_KEYWORD");
        ktModifierKeywordTokenArray[1] = object;
        VARIANCE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CONST_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        CONST_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.FUN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FUN_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        FUN_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SUSPEND_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        SUSPEND_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement nameIdentifier;
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement2 = element;
                if (psiElement2 instanceof KtNamedDeclaration) {
                    psiElement = ((KtNamedDeclaration)element).getNameIdentifier();
                } else if (psiElement2 instanceof KtFile) {
                    KtPackageDirective ktPackageDirective = ((KtFile)element).getPackageDirective();
                    Intrinsics.checkNotNull((Object)ktPackageDirective);
                    psiElement = ktPackageDirective.getNameIdentifier();
                } else {
                    psiElement = nameIdentifier = null;
                }
                if (nameIdentifier == null && element instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DEFAULT.mark(element);
                }
                psiElement2 = nameIdentifier;
                return PositioningStrategyKt.markElement(psiElement2 == null ? element : psiElement2);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<KtReferenceExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReferenceExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtArrayAccessExpression) {
                    List<TextRange> list2 = ((KtArrayAccessExpression)element).getBracketRanges();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"element.bracketRanges");
                    List<TextRange> ranges2 = list2;
                    if (!ranges2.isEmpty()) {
                        return ranges2;
                    }
                }
                return CollectionsKt.listOf((Object)element.getTextRange());
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<KtArrayAccessExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtArrayAccessExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtContainerNode ktContainerNode = element.getIndicesNode();
                Intrinsics.checkNotNullExpressionValue((Object)ktContainerNode, (String)"element.indicesNode");
                return PositioningStrategyKt.markElement((PsiElement)ktContainerNode);
            }
        };
        SAFE_ACCESS = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ASTNode aSTNode = element.getNode().findChildByType((IElementType)KtTokens.SAFE_ACCESS);
                return PositioningStrategyKt.markElement(aSTNode == null ? element : ((psiElement = aSTNode.getPsi()) == null ? element : psiElement));
            }
        };
        ktModifierKeywordTokenArray = KtTokens.VISIBILITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"VISIBILITY_MODIFIERS");
        VISIBILITY_MODIFIER = new ModifierSetBasedPositioningStrategy((TokenSet)ktModifierKeywordTokenArray);
        ktModifierKeywordTokenArray = KtTokens.MODALITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"MODALITY_MODIFIERS");
        MODALITY_MODIFIER = new ModifierSetBasedPositioningStrategy((TokenSet)ktModifierKeywordTokenArray);
        object = new IElementType[]{KtTokens.INLINE_KEYWORD, KtTokens.VALUE_KEYWORD};
        ktModifierKeywordTokenArray = TokenSet.create((IElementType[])object);
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"create(KtTokens.INLINE_K\u2026, KtTokens.VALUE_KEYWORD)");
        INLINE_OR_VALUE_MODIFIER = new ModifierSetBasedPositioningStrategy((TokenSet)ktModifierKeywordTokenArray);
        object = new IElementType[]{KtTokens.INNER_KEYWORD};
        ktModifierKeywordTokenArray = TokenSet.create((IElementType[])object);
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordTokenArray, (String)"create(KtTokens.INNER_KEYWORD)");
        INNER_MODIFIER = new ModifierSetBasedPositioningStrategy((TokenSet)ktModifierKeywordTokenArray);
        VARIANCE_IN_PROJECTION = new PositioningStrategy<KtTypeProjection>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeProjection element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getProjectionToken();
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement psiElement2 = psiElement;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.projectionToken!!");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element.getDefaultValue();
                Intrinsics.checkNotNull((Object)ktExpression);
                ASTNode aSTNode = ktExpression.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.defaultValue!!.node");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        PARAMETER_VARARG_MODIFIER = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtModifierList ktModifierList = element.getModifierList();
                Intrinsics.checkNotNull((Object)ktModifierList);
                PsiElement psiElement = ktModifierList.getModifier(KtTokens.VARARG_KEYWORD);
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement psiElement2 = psiElement;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.modifierList!!.g\u2026tTokens.VARARG_KEYWORD)!!");
                PsiElement varargModifier = psiElement2;
                psiElement2 = varargModifier.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"varargModifier.node");
                return PositioningStrategyKt.markNode((ASTNode)psiElement2);
            }
        };
        NAME_OF_NAMED_ARGUMENT = new PositioningStrategy<KtValueArgument>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtValueArgument element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtValueArgumentName ktValueArgumentName = element.getArgumentName();
                return PositioningStrategyKt.markElement((PsiElement)(ktValueArgumentName == null ? (KtElementImplStub)element : (KtElementImplStub)ktValueArgumentName));
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                KtExpression ktExpression;
                KtCallElement ktCallElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtCallElement ktCallElement2 = ktCallElement = element instanceof KtCallElement ? (KtCallElement)element : null;
                return PositioningStrategyKt.markElement(ktCallElement == null ? element : ((ktExpression = ktCallElement.getCalleeExpression()) == null ? element : (PsiElement)ktExpression));
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<KtDeclarationWithBody>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclarationWithBody element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtBlockExpression ktBlockExpression = element.getBodyBlockExpression();
                TextRange lastBracketRange = ktBlockExpression == null ? null : ktBlockExpression.getLastBracketRange();
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element);
            }

            public boolean isValid(@NotNull KtDeclarationWithBody element) {
                KtBlockExpression ktBlockExpression;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return super.isValid((PsiElement)element) && ((ktBlockExpression = element.getBodyBlockExpression()) == null ? null : ktBlockExpression.getLastBracketRange()) != null;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtParameter) {
                    PsiElement psiElement = ((KtParameter)element).getValOrVarKeyword();
                    PsiElement psiElement2 = psiElement == null ? (PsiElement)element : psiElement;
                    list2 = PositioningStrategyKt.markElement(psiElement2);
                } else if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.valOrVarKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration instanceof KtDestructuringDeclaration) {
                    PsiElement psiElement = ((KtDestructuringDeclaration)element).getValOrVarKeyword();
                    PsiElement psiElement3 = psiElement == null ? (PsiElement)element : psiElement;
                    list2 = PositioningStrategyKt.markElement(psiElement3);
                } else {
                    String string2 = Intrinsics.stringPlus((String)"Declaration is neither a parameter nor a property: ", (Object)PsiUtilsKt.getElementTextWithContext(element));
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                return list2;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<KtWhenEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenEntry element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getElseKeyword();
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement psiElement2 = psiElement;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.elseKeyword!!");
                return PositioningStrategyKt.markElement(psiElement2);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<KtWhenExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getWhenKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.whenKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        IF_EXPRESSION = new PositioningStrategy<KtIfExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtIfExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element.getIfKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.ifKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<KtWhenConditionInRange>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenConditionInRange element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                return PositioningStrategyKt.markElement((PsiElement)ktOperationReferenceExpression);
            }
        };
        SPECIAL_CONSTRUCT_TOKEN = new PositioningStrategy<KtExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtExpression element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element;
                if (ktExpression instanceof KtWhenExpression) {
                    PsiElement psiElement = ((KtWhenExpression)element).getWhenKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.whenKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtIfExpression) {
                    PsiElement psiElement = ((KtIfExpression)element).getIfKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.ifKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtOperationExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtOperationExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"element.operationReference");
                    list2 = PositioningStrategyKt.markElement((PsiElement)ktSimpleNameExpression);
                } else {
                    String string2 = Intrinsics.stringPlus((String)"Expression is not an if, when or operation expression: ", (Object)PsiUtilsKt.getElementTextWithContext((PsiElement)element));
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                return list2;
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<KtNullableType>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNullableType element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ASTNode aSTNode = element.getQuestionMarkNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.questionMarkNode");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        QUESTION_MARK_BY_TYPE = new PositioningStrategy<KtTypeReference>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeReference element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtTypeElement typeElement = element.getTypeElement();
                if (typeElement instanceof KtNullableType) {
                    ASTNode aSTNode = ((KtNullableType)typeElement).getQuestionMarkNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"typeElement.questionMarkNode");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return super.mark((PsiElement)element);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallExpression) {
                    KtElement ktElement;
                    KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)element).getTypeArgumentList();
                    return PositioningStrategyKt.markRange(element, (PsiElement)(ktTypeArgumentList == null ? ((ktElement = (KtElement)((KtCallExpression)element).getCalleeExpression()) == null ? (KtElement)element : ktElement) : (KtElement)ktTypeArgumentList));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                PsiElement psiElement;
                KtElement ktElement;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtElement ktElement2 = element;
                KtElement qualifiedAccess = ktElement2 instanceof KtQualifiedExpression ? (KtElement)((ktElement = ((KtQualifiedExpression)element).getSelectorExpression()) == null ? (KtExpression)element : ktElement) : element;
                PsiElement $this$findDescendantOfType_u24default$iv = (PsiElement)qualifiedAccess;
                Function1 predicate$iv = VALUE_ARGUMENTS$1$mark$$inlined$findDescendantOfType$default$1.INSTANCE;
                boolean $i$f$findDescendantOfType = false;
                PsiElement $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
                boolean $i$f$findDescendantOfType2 = false;
                Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
                $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    final /* synthetic */ Ref.ObjectRef $result;
                    {
                        this.$predicate = $predicate;
                        this.$result = $result;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        if (element instanceof KtValueArgumentList && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                            this.$result.element = element;
                            this.stopWalking();
                            return;
                        }
                        PsiElement it = element;
                        boolean bl = false;
                        super.visitElement(element);
                    }
                });
                ktElement = (KtValueArgumentList)((PsiElement)result$iv$iv.element);
                ktElement2 = ktElement == null ? (PsiElement)qualifiedAccess : ((psiElement = ((KtValueArgumentList)ktElement).getRightParenthesis()) == null ? (PsiElement)qualifiedAccess : psiElement);
                return PositioningStrategyKt.markElement((PsiElement)ktElement2);
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<KtFunction>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtFunction element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtParameterList valueParameterList = element.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement((PsiElement)valueParameterList);
                }
                if (element instanceof KtFunctionLiteral) {
                    ASTNode aSTNode = ((KtFunctionLiteral)element).getLBrace().getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.lBrace.node");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE_OR_DEFAULT.mark(element);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual((Object)((KtConstantExpression)element).getNode().getElementType(), (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
                    TextRange elementTextRange = element.getTextRange();
                    TextRange textRange = TextRange.create((int)(elementTextRange.getStartOffset() + 1), (int)(elementTextRange.getEndOffset() - 1));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(elementTextRange.\u2026tTextRange.endOffset - 1)");
                    return CollectionsKt.listOf((Object)textRange);
                }
                return PositioningStrategyKt.markElement((PsiElement)element);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual((Object)((KtConstantExpression)element).getNode().getElementType(), (Object)KtNodeTypes.INTEGER_CONSTANT)) {
                    int endOffset = PsiUtilsKt.getEndOffset((PsiElement)element);
                    TextRange textRange = TextRange.create((int)(endOffset - 1), (int)endOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(endOffset - 1, endOffset)");
                    return CollectionsKt.listOf((Object)textRange);
                }
                return PositioningStrategyKt.markElement((PsiElement)element);
            }
        };
        UNREACHABLE_CODE = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends PsiElement> diagnostic) {
                Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
                DiagnosticWithParameters2 unreachableCode = (DiagnosticWithParameters2)Errors.UNREACHABLE_CODE.cast((UnboundDiagnostic)diagnostic);
                Object object = unreachableCode.getPsiElement();
                Intrinsics.checkNotNullExpressionValue(object, (String)"unreachableCode.psiElement");
                KtElement ktElement = (KtElement)object;
                object = unreachableCode.getA();
                Intrinsics.checkNotNullExpressionValue(object, (String)"unreachableCode.a");
                Set set = (Set)object;
                object = unreachableCode.getB();
                Intrinsics.checkNotNullExpressionValue(object, (String)"unreachableCode.b");
                return UnreachableCode.Companion.getUnreachableTextRanges(ktElement, set, (Set)object);
            }
        };
        AS_TYPE = new PositioningStrategy<KtBinaryExpressionWithTypeRHS>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpressionWithTypeRHS element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtSimpleNameExpression ktSimpleNameExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"element.operationReference");
                return PositioningStrategyKt.markRange((PsiElement)ktSimpleNameExpression, (PsiElement)element);
            }
        };
        COMPANION_OBJECT = new PositioningStrategy<KtObjectDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtObjectDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element.hasModifier(KtTokens.COMPANION_KEYWORD)) {
                    KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.COMPANION_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"COMPANION_KEYWORD");
                    ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
                    return PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray).mark((KtModifierListOwner)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement = element;
                if (psiElement instanceof KtSecondaryConstructor) {
                    KtParameterList ktParameterList = ((KtSecondaryConstructor)element).getValueParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    KtParameterList valueParameterList = ktParameterList;
                    PsiElement psiElement2 = ((KtSecondaryConstructor)element).getConstructorKeyword();
                    ktParameterList = valueParameterList.getLastChild();
                    Intrinsics.checkNotNullExpressionValue((Object)ktParameterList, (String)"valueParameterList.lastChild");
                    list2 = PositioningStrategyKt.markRange(psiElement2, (PsiElement)ktParameterList);
                } else if (psiElement instanceof KtConstructorDelegationCall) {
                    if (((KtConstructorDelegationCall)element).isImplicit()) {
                        PsiElement $this$getStrictParentOfType$iv = element;
                        boolean $i$f$getStrictParentOfType = false;
                        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtSecondaryConstructor.class, (boolean)true);
                        Intrinsics.checkNotNull((Object)psiElement3);
                        KtSecondaryConstructor constructor2 = (KtSecondaryConstructor)psiElement3;
                        KtParameterList ktParameterList = constructor2.getValueParameterList();
                        if (ktParameterList == null) {
                            return PositioningStrategyKt.markElement(constructor2);
                        }
                        KtParameterList valueParameterList = ktParameterList;
                        PsiElement psiElement4 = constructor2.getConstructorKeyword();
                        ktParameterList = valueParameterList.getLastChild();
                        Intrinsics.checkNotNullExpressionValue((Object)ktParameterList, (String)"valueParameterList.lastChild");
                        return PositioningStrategyKt.markRange(psiElement4, (PsiElement)ktParameterList);
                    }
                    KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = ((KtConstructorDelegationCall)element).getCalleeExpression();
                    list2 = PositioningStrategyKt.markElement((PsiElement)(ktConstructorDelegationReferenceExpression == null ? (KtElementImpl)element : (KtElementImpl)ktConstructorDelegationReferenceExpression));
                } else {
                    list2 = PositioningStrategyKt.markElement(element);
                }
                return list2;
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<KtEnumEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtEnumEntry element) {
                KtElementImplStub ktElementImplStub;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Object object = element.getSuperTypeListEntries();
                Intrinsics.checkNotNullExpressionValue(object, (String)"element.superTypeListEntries");
                List<KtSuperTypeListEntry> specifiers = object;
                if (specifiers.isEmpty()) {
                    ktElementImplStub = element;
                } else {
                    object = specifiers.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"specifiers[0]");
                    ktElementImplStub = (KtElementImplStub)object;
                }
                return PositioningStrategyKt.markElement((PsiElement)ktElementImplStub);
            }
        };
        UNUSED_VALUE = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression);
                KtExpression ktExpression2 = ktExpression;
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"element.left!!");
                int n = PsiUtilsKt.getStartOffset((PsiElement)ktExpression2);
                ktExpression2 = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"element.operationReference");
                return CollectionsKt.listOf((Object)new TextRange(n, PsiUtilsKt.getEndOffset((PsiElement)ktExpression2)));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtOperationReferenceExpression ktOperationReferenceExpression = element.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                return CollectionsKt.listOf((Object)new TextRange(PsiUtilsKt.getStartOffset((PsiElement)ktOperationReferenceExpression), PsiUtilsKt.getEndOffset((PsiElement)element)));
            }
        };
        IMPORT_ALIAS = new PositioningStrategy<KtImportDirective>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtImportDirective element) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtElement ktElement = element.getAlias();
                if (ktElement != null && (object = ktElement.getNameIdentifier()) != null) {
                    PsiElement psiElement = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiElement it = psiElement;
                    boolean bl3 = false;
                    return PositioningStrategyKt.markElement(it);
                }
                ktElement = element.getImportedReference();
                if (ktElement != null) {
                    KtExpression ktExpression;
                    object = ktElement;
                    boolean bl = false;
                    boolean bl4 = false;
                    Object it = object;
                    boolean bl5 = false;
                    if (it instanceof KtQualifiedExpression && (ktExpression = ((KtQualifiedExpression)it).getSelectorExpression()) != null) {
                        KtExpression ktExpression2 = ktExpression;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        KtExpression it2 = ktExpression2;
                        boolean bl8 = false;
                        return PositioningStrategyKt.markElement((PsiElement)it2);
                    }
                    return PositioningStrategyKt.markElement(it);
                }
                return PositioningStrategyKt.markElement((PsiElement)element);
            }
        };
        RETURN_WITH_LABEL = new PositioningStrategy<KtReturnExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReturnExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement labeledExpression = element.getLabeledExpression();
                if (labeledExpression != null) {
                    return PositioningStrategyKt.markRange((PsiElement)element, labeledExpression);
                }
                PsiElement psiElement = element.getReturnKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.returnKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        RECEIVER = new DeclarationHeader<KtCallableDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtCallableDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtTypeReference ktTypeReference = element.getReceiverTypeReference();
                if (ktTypeReference != null) {
                    KtTypeReference ktTypeReference2 = ktTypeReference;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtTypeReference it = ktTypeReference2;
                    boolean bl3 = false;
                    return PositioningStrategyKt.markElement(it);
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        OPERATOR = new PositioningStrategy<KtExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtExpression element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element;
                if (ktExpression instanceof KtBinaryExpression) {
                    KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                    list2 = this.mark(ktOperationReferenceExpression);
                } else if (ktExpression instanceof KtUnaryExpression) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KtUnaryExpression)element).getOperationReference();
                    Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"element.operationReference");
                    list2 = this.mark(ktSimpleNameExpression);
                } else {
                    list2 = super.mark((PsiElement)element);
                }
                return list2;
            }
        };
        DOT_BY_QUALIFIED = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken()) && (object = ((KtBinaryExpression)element).getLeft()) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object left = object2;
                    boolean bl3 = false;
                    Object $this$findDescendantOfType_u24default$iv = left;
                    Function1 predicate$iv = DOT_BY_QUALIFIED$1$mark$lambda-1$$inlined$findDescendantOfType$default$1.INSTANCE;
                    boolean $i$f$findDescendantOfType = false;
                    Object $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
                    boolean $i$f$findDescendantOfType2 = false;
                    Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
                    $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Ref.ObjectRef $result;
                        {
                            this.$predicate = $predicate;
                            this.$result = $result;
                        }

                        public void visitElement(@NotNull PsiElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            if (element instanceof KtDotQualifiedExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                                this.$result.element = element;
                                this.stopWalking();
                                return;
                            }
                            PsiElement it = element;
                            boolean bl = false;
                            super.visitElement(element);
                        }
                    });
                    KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)((PsiElement)result$iv$iv.element);
                    if (ktDotQualifiedExpression != null) {
                        KtDotQualifiedExpression ktDotQualifiedExpression2 = ktDotQualifiedExpression;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        KtDotQualifiedExpression it = ktDotQualifiedExpression2;
                        boolean bl6 = false;
                        return this.mark((PsiElement)it);
                    }
                    Void cfr_ignored_0 = (Void)null;
                }
                if (element instanceof KtDotQualifiedExpression) {
                    object = ((KtDotQualifiedExpression)element).getOperationTokenNode().getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.operationTokenNode.psi");
                    return this.mark((PsiElement)object);
                }
                return PositioningStrategies.INSTANCE.getREFERENCE_BY_QUALIFIED().mark(element);
            }
        };
        SELECTOR_BY_QUALIFIED = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                KtExpression selectorExpression;
                KtExpression ktExpression;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken()) && (ktExpression = ((KtBinaryExpression)element).getLeft()) != null) {
                    KtExpression ktExpression2 = ktExpression;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtExpression it = ktExpression2;
                    boolean bl3 = false;
                    return this.mark((PsiElement)it);
                }
                if (element instanceof KtQualifiedExpression && (selectorExpression = ((KtQualifiedExpression)element).getSelectorExpression()) instanceof KtElement) {
                    return this.mark((PsiElement)selectorExpression);
                }
                return super.mark(element);
            }
        };
        RESERVED_UNDERSCORE = new PositioningStrategy<PsiElement>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiNameIdentifierOwner) {
                    PsiElement nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier();
                    if (nameIdentifier != null) {
                        return super.mark(nameIdentifier);
                    }
                } else {
                    if (element instanceof KtImportDirective) {
                        PsiElement psiElement;
                        KtImportAlias nameIdentifier = ((KtImportDirective)element).getAlias();
                        return super.mark(nameIdentifier == null ? element : ((psiElement = nameIdentifier.getNameIdentifier()) == null ? element : psiElement));
                    }
                    if (element instanceof KtReturnExpression) {
                        PsiElement prevSibling = PsiUtilsKt.getPrevSiblingIgnoringWhitespace$default(element, false, 1, null);
                        if (prevSibling instanceof KtContainerNode) {
                            return this.mark(prevSibling);
                        }
                    } else if (!(element instanceof LeafPsiElement)) {
                        void $this$mapTo$iv$iv;
                        void $this$forEachDescendantOfType$iv$iv$iv$iv;
                        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
                        void $this$collectDescendantsOfType$iv;
                        Object object = element;
                        Function1 predicate$iv = RESERVED_UNDERSCORE.mark.ranges.1.INSTANCE;
                        boolean $i$f$collectDescendantsOfType22 = false;
                        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
                        boolean $i$f$collectDescendantsOfType = false;
                        Iterator<T> iterator2 = $this$collectDescendantsOfType$iv$iv;
                        Collection to$iv$iv$iv = new ArrayList<E>();
                        boolean $i$f$collectDescendantsOfTypeTo2 = false;
                        void var11_18 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
                        Function1 action$iv$iv$iv$iv = (Function1)new Function1<LeafPsiElement, Unit>(predicate$iv, to$iv$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Collection $to;
                            {
                                this.$predicate = $predicate;
                                this.$to = $to;
                                super(1);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final void invoke(@NotNull PsiElement it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                    this.$to.add(it);
                                }
                            }
                        };
                        boolean $i$f$forEachDescendantOfType = false;
                        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                            final /* synthetic */ Function1 $action;
                            {
                                this.$action = $action;
                            }

                            public void visitElement(@NotNull PsiElement element) {
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                PsiElement it = element;
                                boolean bl = false;
                                super.visitElement(element);
                                if (element instanceof LeafPsiElement) {
                                    this.$action.invoke((Object)element);
                                }
                            }
                        });
                        Iterable $this$map$iv = (List)to$iv$iv$iv;
                        boolean $i$f$map = false;
                        Iterable $i$f$collectDescendantsOfType22 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            LeafPsiElement $i$f$collectDescendantsOfTypeTo2 = (LeafPsiElement)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            TextRange textRange = PositioningStrategyKt.markSingleElement((PsiElement)it);
                            collection.add(textRange);
                        }
                        List ranges2 = (List)destination$iv$iv;
                        object = ranges2;
                        boolean bl = false;
                        if (!object.isEmpty()) {
                            return ranges2;
                        }
                    }
                }
                return super.mark(element);
            }
        };
        FUN_INTERFACE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtClass) {
                    list2 = PositioningStrategies.FUN_MODIFIER.mark((KtModifierListOwner)((PsiElement)element));
                } else if (ktDeclaration instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.valOrVarKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktDeclaration instanceof KtNamedFunction) {
                    KtTypeParameterList typeParameterList = ((KtNamedFunction)element).getTypeParameterList();
                    if (typeParameterList != null) {
                        list2 = PositioningStrategyKt.markElement((PsiElement)typeParameterList);
                    } else if (element.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                        list2 = PositioningStrategies.SUSPEND_MODIFIER.mark((KtModifierListOwner)((PsiElement)element));
                    } else {
                        PsiElement psiElement = ((KtNamedFunction)element).getFunKeyword();
                        PsiElement psiElement2 = psiElement == null ? (PsiElement)element : psiElement;
                        list2 = PositioningStrategyKt.markElement(psiElement2);
                    }
                } else {
                    list2 = PositioningStrategyKt.markElement(element);
                }
                return list2;
            }
        };
        REFERENCE_BY_QUALIFIED = new FindReferencePositioningStrategy(false);
        REFERENCED_NAME_BY_QUALIFIED = new FindReferencePositioningStrategy(true);
        ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        object = KtTokens.REIFIED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"REIFIED_KEYWORD");
        ktModifierKeywordTokenArray[0] = object;
        REIFIED_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        PROPERTY_INITIALIZER = new PositioningStrategy<KtProperty>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtProperty element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtExpression ktExpression = element.getInitializer();
                KtExpression ktExpression2 = ktExpression == null ? (KtExpression)element : ktExpression;
                return PositioningStrategyKt.markElement((PsiElement)ktExpression2);
            }
        };
        WHOLE_ELEMENT = new PositioningStrategy<KtElement>(){};
        TYPE_PARAMETERS_LIST = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtTypeParameterListOwner) {
                    KtTypeParameterList ktTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList();
                    return PositioningStrategyKt.markElement((PsiElement)(ktTypeParameterList == null ? (KtElement)element : (KtElement)ktTypeParameterList));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        ANNOTATION_USE_SITE = new PositioningStrategy<KtAnnotationEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtAnnotationEntry element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = element.getUseSiteTarget();
                return PositioningStrategyKt.markElement((PsiElement)(ktAnnotationUseSiteTarget == null ? (KtElementImplStub)element : (KtElementImplStub)ktAnnotationUseSiteTarget));
            }
        };
        ASSIGNMENT_LHS = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement psiElement;
                boolean bl;
                boolean bl2;
                KtExpression ktExpression;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken())) {
                    ktExpression = ((KtBinaryExpression)element).getLeft();
                    bl2 = false;
                    bl = false;
                    KtExpression left = ktExpression;
                    boolean bl3 = false;
                    psiElement = PsiUtilsKt.unwrapParenthesesLabelsAndAnnotations((PsiElement)left);
                    if (psiElement != null) {
                        PsiElement psiElement2 = psiElement;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        PsiElement it = psiElement2;
                        boolean bl6 = false;
                        return PositioningStrategyKt.markElement(it);
                    }
                }
                if (element instanceof KtUnaryExpression && KtTokens.INCREMENT_AND_DECREMENT.contains(((KtUnaryExpression)element).getOperationToken())) {
                    ktExpression = ((KtUnaryExpression)element).getBaseExpression();
                    bl2 = false;
                    bl = false;
                    KtExpression arg = ktExpression;
                    boolean bl7 = false;
                    psiElement = PsiUtilsKt.unwrapParenthesesLabelsAndAnnotations((PsiElement)arg);
                    if (psiElement != null) {
                        PsiElement psiElement3 = psiElement;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        PsiElement it = psiElement3;
                        boolean bl10 = false;
                        return PositioningStrategyKt.markElement(it);
                    }
                }
                return super.mark(element);
            }
        };
        IMPORT_LAST_NAME = new PositioningStrategy<PsiElement>(){

            public boolean isValid(@NotNull PsiElement element) {
                boolean bl;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof PsiErrorElement) {
                        return false;
                    }
                    PsiElement[] psiElementArray = element.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"element.children");
                    Object[] $this$any$iv = psiElementArray;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!(!this.isValid(it))) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                return !bl;
            }

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtImportDirective) {
                    KtExpression ktExpression;
                    KtExpression importedReference = ((KtImportDirective)element).getImportedReference();
                    if (importedReference instanceof KtDotQualifiedExpression && (ktExpression = ((KtDotQualifiedExpression)importedReference).getSelectorExpression()) != null) {
                        KtExpression ktExpression2 = ktExpression;
                        boolean bl = false;
                        boolean bl2 = false;
                        KtExpression it = ktExpression2;
                        boolean bl3 = false;
                        return super.mark((PsiElement)it);
                    }
                    ktExpression = ((KtImportDirective)element).getImportedReference();
                    return super.mark((PsiElement)(ktExpression == null ? (KtElement)element : (KtElement)ktExpression));
                }
                return super.mark(element);
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0012\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$DeclarationHeader;", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "()V", "isValid", "", "element", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "frontend"})
    private static class DeclarationHeader<T extends KtDeclaration>
    extends PositioningStrategy<T> {
        @Override
        public boolean isValid(@NotNull T element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            if (element instanceof KtNamedDeclaration && !(element instanceof KtObjectDeclaration) && !(element instanceof KtSecondaryConstructor) && !(element instanceof KtFunction) && ((KtNamedDeclaration)element).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$ModifierSetBasedPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifierSet", "Lcom/intellij/psi/tree/TokenSet;", "(Lcom/intellij/psi/tree/TokenSet;)V", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "element", "frontend"})
    private static final class ModifierSetBasedPositioningStrategy
    extends PositioningStrategy<KtModifierListOwner> {
        @NotNull
        private final TokenSet modifierSet;

        public ModifierSetBasedPositioningStrategy(@NotNull TokenSet modifierSet) {
            Intrinsics.checkNotNullParameter((Object)modifierSet, (String)"modifierSet");
            this.modifierSet = modifierSet;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextRange> mark(@NotNull KtModifierListOwner element) {
            PsiElement psiElement;
            PsiElement nameIdentifier;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            KtModifierList modifierList2 = element.getModifierList();
            IElementType[] iElementTypeArray = this.modifierSet.getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"modifierSet.types");
            Object $this$mapNotNull$iv = (PsiElement)iElementTypeArray;
            boolean $i$f$mapNotNull = false;
            PsiElement psiElement2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var11_11 = $this$forEach$iv$iv$iv;
            int n = ((void)var11_11).length;
            for (int i = 0; i < n; ++i) {
                TextRange textRange;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var11_11[i];
                boolean bl = false;
                IElementType it = (IElementType)element$iv$iv;
                boolean bl2 = false;
                KtModifierList ktModifierList = modifierList2;
                if (ktModifierList == null) {
                    textRange = null;
                } else {
                    if (it == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
                    }
                    PsiElement psiElement3 = ktModifierList.getModifier((KtModifierKeywordToken)it);
                    textRange = psiElement3 == null ? null : psiElement3.getTextRange();
                }
                if (textRange == null) continue;
                TextRange textRange2 = textRange;
                boolean bl3 = false;
                boolean bl4 = false;
                TextRange it$iv$iv = textRange2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List result2 = (List)destination$iv$iv;
            $this$mapNotNull$iv = result2;
            boolean bl = false;
            if (!$this$mapNotNull$iv.isEmpty()) {
                return result2;
            }
            if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
                return PositioningStrategyKt.markElement(nameIdentifier);
            }
            KtModifierListOwner ktModifierListOwner = element;
            if (ktModifierListOwner instanceof KtObjectDeclaration) {
                PsiElement psiElement4 = ((KtObjectDeclaration)element).getObjectKeyword();
                psiElement = psiElement4;
                Intrinsics.checkNotNull((Object)psiElement4);
            } else if (ktModifierListOwner instanceof KtPropertyAccessor) {
                psiElement2 = ((KtPropertyAccessor)element).getNamePlaceholder();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.namePlaceholder");
                psiElement = psiElement2;
            } else if (ktModifierListOwner instanceof KtAnonymousInitializer) {
                psiElement = element;
            } else {
                throw new IllegalArgumentException("Can't find text range for element '" + element.getClass().getCanonicalName() + "' with the text '" + element.getText() + '\'');
            }
            PsiElement elementToMark = psiElement;
            return PositioningStrategyKt.markElement(elementToMark);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$FindReferencePositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lcom/intellij/psi/PsiElement;", "locateReferencedName", "", "(Z)V", "getLocateReferencedName", "()Z", "mark", "", "Lcom/intellij/openapi/util/TextRange;", "element", "frontend"})
    public static final class FindReferencePositioningStrategy
    extends PositioningStrategy<PsiElement> {
        private final boolean locateReferencedName;

        public FindReferencePositioningStrategy(boolean locateReferencedName) {
            this.locateReferencedName = locateReferencedName;
        }

        public final boolean getLocateReferencedName() {
            return this.locateReferencedName;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            PsiElement result2;
            PsiElement psiElement;
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Object object = element;
            if (object instanceof KtQualifiedExpression) {
                KtExpression ktExpression2;
                KtExpression selectorExpression = ((KtQualifiedExpression)element).getSelectorExpression();
                ktExpression = selectorExpression instanceof KtCallExpression ? ((ktExpression2 = ((KtCallExpression)selectorExpression).getCalleeExpression()) == null ? selectorExpression : ktExpression2) : (selectorExpression instanceof KtReferenceExpression ? selectorExpression : (KtExpression)element);
                psiElement = (PsiElement)ktExpression;
            } else if (object instanceof KtCallableReferenceExpression) {
                ktExpression = ((KtCallableReferenceExpression)element).getCallableReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.callableReference");
                psiElement = (PsiElement)ktExpression;
            } else if (object instanceof KtCallExpression) {
                KtExpression ktExpression3 = ((KtCallExpression)element).getCalleeExpression();
                ktExpression = ktExpression3 == null ? (KtExpression)element : ktExpression3;
                psiElement = (PsiElement)ktExpression;
            } else if (object instanceof KtConstructorDelegationCall) {
                ktExpression = ((KtConstructorDelegationCall)element).getCalleeExpression();
                psiElement = (PsiElement)(ktExpression == null ? (KtElementImpl)element : (KtElementImpl)((Object)ktExpression));
            } else if (object instanceof KtSuperTypeCallEntry) {
                ktExpression = ((KtSuperTypeCallEntry)element).getCalleeExpression();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.calleeExpression");
                psiElement = (PsiElement)ktExpression;
            } else if (object instanceof KtOperationExpression) {
                ktExpression = ((KtOperationExpression)element).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.operationReference");
                psiElement = (PsiElement)ktExpression;
            } else if (object instanceof KtWhenConditionInRange) {
                ktExpression = ((KtWhenConditionInRange)element).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.operationReference");
                psiElement = (PsiElement)ktExpression;
            } else {
                psiElement = object instanceof KtAnnotationEntry ? (PsiElement)((ktExpression = ((KtAnnotationEntry)element).getCalleeExpression()) == null ? (KtElementImplStub)element : (KtElementImplStub)((Object)ktExpression)) : (result2 = element);
            }
            while (this.locateReferencedName && result2 instanceof KtParenthesizedExpression && (object = ((KtParenthesizedExpression)result2).getExpression()) != null) {
                result2 = object;
            }
            return super.mark(result2);
        }
    }
}

