/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.codegen.AnnotationCodegenKt;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMapper;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMappingKt;
import org.jetbrains.kotlin.backend.jvm.codegen.MethodSignatureMapper;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.TypeAnnotationCollector;
import org.jetbrains.kotlin.codegen.TypePathInfo;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.TypeSystemCommonBackendContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 ;2\u00020\u0001:\u0002;<B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\"\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"J\"\u0010$\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0&2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(H\u0002J\u001e\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0&H\u0002J\u001f\u0010,\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010-\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0002\b.J\u001a\u0010/\u001a\u00020\u000e2\b\u0010'\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020+H\u0002J\u0018\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020\u0007H&J\"\u0010:\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u00109\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen;", "", "innerClassConsumer", "Lorg/jetbrains/kotlin/backend/jvm/codegen/InnerClassConsumer;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "skipNullabilityAnnotations", "", "(Lorg/jetbrains/kotlin/backend/jvm/codegen/InnerClassConsumer;Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Z)V", "methodSignatureMapper", "Lorg/jetbrains/kotlin/backend/jvm/codegen/MethodSignatureMapper;", "typeMapper", "Lorg/jetbrains/kotlin/backend/jvm/codegen/IrTypeMapper;", "genAnnotation", "", "annotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "path", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "isTypeAnnotation", "genAnnotationArguments", "", "annotationVisitor", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "genAnnotations", "annotated", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "returnType", "Lorg/jetbrains/org/objectweb/asm/Type;", "typeForTypeAnnotations", "Lorg/jetbrains/kotlin/ir/types/IrType;", "genCompileTimeValue", "name", "value", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "generateAnnotationDefaultValue", "generateAnnotationIfNotPresent", "annotationDescriptorsAlreadyPresent", "", "annotationClass", "Ljava/lang/Class;", "generateNullabilityAnnotationForCallable", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "generateTypeAnnotations", "type", "generateTypeAnnotations$backend_jvm", "getAnnotationArgumentJvmName", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "parameterName", "Lorg/jetbrains/kotlin/name/Name;", "isMovedReceiverParameterOfStaticInlineClassReplacement", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parent", "visitAnnotation", "descr", "visible", "visitTypeAnnotation", "Companion", "IrTypeAnnotationCollector", "backend.jvm"})
public abstract class AnnotationCodegen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InnerClassConsumer innerClassConsumer;
    @NotNull
    private final JvmBackendContext context;
    private final boolean skipNullabilityAnnotations;
    @NotNull
    private final IrTypeMapper typeMapper;
    @NotNull
    private final MethodSignatureMapper methodSignatureMapper;
    @NotNull
    private static final Map<KotlinRetention, RetentionPolicy> annotationRetentionMap;
    @NotNull
    private static final Set<FqName> internalAnnotations;

    public AnnotationCodegen(@NotNull InnerClassConsumer innerClassConsumer, @NotNull JvmBackendContext context2, boolean skipNullabilityAnnotations) {
        Intrinsics.checkNotNullParameter((Object)innerClassConsumer, (String)"innerClassConsumer");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.innerClassConsumer = innerClassConsumer;
        this.context = context2;
        this.skipNullabilityAnnotations = skipNullabilityAnnotations;
        this.typeMapper = this.context.getTypeMapper();
        this.methodSignatureMapper = this.context.getMethodSignatureMapper();
    }

    public /* synthetic */ AnnotationCodegen(InnerClassConsumer innerClassConsumer, JvmBackendContext jvmBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(innerClassConsumer, jvmBackendContext, bl);
    }

    public final void genAnnotations(@Nullable IrAnnotationContainer annotated, @Nullable Type returnType2, @Nullable IrType typeForTypeAnnotations) {
        if (annotated == null) {
            return;
        }
        boolean bl = false;
        Set annotationDescriptorsAlreadyPresent = new LinkedHashSet();
        List<IrConstructorCall> annotations2 = annotated.getAnnotations();
        for (IrConstructorCall annotation2 : annotations2) {
            Set<KotlinTarget> applicableTargets = Companion.applicableTargetSet(annotation2);
            if (annotated instanceof IrSimpleFunction && ((IrSimpleFunction)annotated).getOrigin() == IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE && !applicableTargets.contains((Object)KotlinTarget.FUNCTION) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_GETTER) && !applicableTargets.contains((Object)KotlinTarget.PROPERTY_SETTER)) {
                boolean bl2 = applicableTargets.contains((Object)KotlinTarget.EXPRESSION);
                boolean bl3 = false;
                if (!_Assertions.ENABLED || bl2) continue;
                boolean $i$a$-assert-AnnotationCodegen$genAnnotations$32 = false;
                String $i$a$-assert-AnnotationCodegen$genAnnotations$32 = "Inconsistent target list for lambda annotation: " + applicableTargets + " on " + annotated;
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-AnnotationCodegen$genAnnotations$32));
            }
            if (annotated instanceof IrClass && !applicableTargets.contains((Object)KotlinTarget.CLASS) && !applicableTargets.contains((Object)KotlinTarget.ANNOTATION_CLASS) && Intrinsics.areEqual((Object)((IrClass)annotated).getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
                boolean bl4 = applicableTargets.contains((Object)KotlinTarget.EXPRESSION);
                boolean bl5 = false;
                if (!_Assertions.ENABLED || bl4) continue;
                boolean bl6 = false;
                String string2 = "Inconsistent target list for object literal annotation: " + applicableTargets + " on " + annotated;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            String string3 = this.genAnnotation(annotation2, null, false);
            if (string3 == null) continue;
            String string4 = string3;
            boolean bl7 = false;
            boolean bl8 = false;
            String descriptor2 = string4;
            boolean bl9 = false;
            annotationDescriptorsAlreadyPresent.add(descriptor2);
        }
        if (!this.skipNullabilityAnnotations && annotated instanceof IrDeclaration && returnType2 != null && !AsmUtil.isPrimitive(returnType2)) {
            this.generateNullabilityAnnotationForCallable((IrDeclaration)annotated, annotationDescriptorsAlreadyPresent);
        }
        this.generateTypeAnnotations$backend_jvm(annotated, typeForTypeAnnotations);
    }

    @NotNull
    public abstract AnnotationVisitor visitAnnotation(@NotNull String var1, boolean var2);

    @NotNull
    public AnnotationVisitor visitTypeAnnotation(@NotNull String descr, @Nullable TypePath path2, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)descr, (String)"descr");
        throw new RuntimeException("Not implemented");
    }

    private final void generateNullabilityAnnotationForCallable(IrDeclaration declaration2, Set<String> annotationDescriptorsAlreadyPresent) {
        IrType irType;
        if (AnnotationCodegen.Companion.isInvisibleForNullabilityAnalysis(declaration2)) {
            return;
        }
        if (declaration2 instanceof IrValueParameter) {
            IrDeclaration parent2 = (IrDeclaration)((Object)declaration2.getParent());
            if (AnnotationCodegen.Companion.isInvisibleForNullabilityAnalysis(parent2)) {
                return;
            }
            if (this.isMovedReceiverParameterOfStaticInlineClassReplacement((IrValueParameter)declaration2, parent2)) {
                return;
            }
        }
        if (declaration2 instanceof IrSimpleFunction && ((IrSimpleFunction)declaration2).getCorrespondingPropertySymbol() != null && IrUtilsKt.isAnnotationClass(IrUtilsKt.getParentAsClass(declaration2))) {
            return;
        }
        IrDeclaration irDeclaration2 = declaration2;
        if (irDeclaration2 instanceof IrFunction) {
            irType = ((IrFunction)declaration2).getReturnType();
        } else if (irDeclaration2 instanceof IrValueDeclaration) {
            irType = ((IrValueDeclaration)declaration2).getType();
        } else if (irDeclaration2 instanceof IrField) {
            IrProperty irProperty2;
            IrPropertySymbol irPropertySymbol = ((IrField)declaration2).getCorrespondingPropertySymbol();
            if (irPropertySymbol == null ? false : ((irProperty2 = (IrProperty)irPropertySymbol.getOwner()) == null ? false : irProperty2.isLateinit())) {
                return;
            }
            irType = ((IrField)declaration2).getType();
        } else {
            return;
        }
        IrType type2 = irType;
        if (AnnotationCodegenKt.access$isBareTypeParameterWithNullableUpperBound(type2)) {
            return;
        }
        if (AnnotationCodegenKt.access$isNullabilityFlexible(type2)) {
            return;
        }
        Class annotationClass = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(type2) ? Nullable.class : NotNull.class;
        this.generateAnnotationIfNotPresent(annotationDescriptorsAlreadyPresent, annotationClass);
    }

    private final boolean isMovedReceiverParameterOfStaticInlineClassReplacement(IrValueParameter parameter, IrDeclaration parent2) {
        return Intrinsics.areEqual((Object)parent2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.STATIC_INLINE_CLASS_REPLACEMENT.INSTANCE) && Intrinsics.areEqual((Object)parameter.getOrigin(), (Object)IrDeclarationOrigin.MOVED_DISPATCH_RECEIVER.INSTANCE);
    }

    private final void generateAnnotationIfNotPresent(Set<String> annotationDescriptorsAlreadyPresent, Class<?> annotationClass) {
        String descriptor2 = Type.getType(annotationClass).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.contains(descriptor2)) {
            Intrinsics.checkNotNullExpressionValue((Object)descriptor2, (String)"descriptor");
            this.visitAnnotation(descriptor2, false).visitEnd();
        }
    }

    public final void generateAnnotationDefaultValue(@NotNull IrExpression value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        AnnotationVisitor visitor2 = this.visitAnnotation("", false);
        this.genCompileTimeValue(null, value2, visitor2);
        visitor2.visitEnd();
    }

    private final String genAnnotation(IrConstructorCall annotation2, TypePath path2, boolean isTypeAnnotation) {
        AnnotationVisitor annotationVisitor;
        IrClass annotationClass = Companion.getAnnotationClass(annotation2);
        RetentionPolicy retentionPolicy = AnnotationCodegen.Companion.getRetentionPolicy(annotationClass);
        if (retentionPolicy == RetentionPolicy.SOURCE) {
            return null;
        }
        if (internalAnnotations.contains(IrUtilsKt.getFqNameWhenAvailable(annotationClass))) {
            return null;
        }
        if (AnnotationCodegenKt.access$isOptionalAnnotationClass(annotationClass)) {
            return null;
        }
        this.innerClassConsumer.addInnerClassInfoFromAnnotation(annotationClass);
        String asmTypeDescriptor = IrTypeMapper.mapType$default(this.typeMapper, annotation2.getType(), null, null, 6, null).getDescriptor();
        if (!isTypeAnnotation) {
            Intrinsics.checkNotNullExpressionValue((Object)asmTypeDescriptor, (String)"asmTypeDescriptor");
            annotationVisitor = this.visitAnnotation(asmTypeDescriptor, retentionPolicy == RetentionPolicy.RUNTIME);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)asmTypeDescriptor, (String)"asmTypeDescriptor");
            annotationVisitor = this.visitTypeAnnotation(asmTypeDescriptor, path2, retentionPolicy == RetentionPolicy.RUNTIME);
        }
        AnnotationVisitor annotationVisitor2 = annotationVisitor;
        this.genAnnotationArguments(annotation2, annotationVisitor2);
        annotationVisitor2.visitEnd();
        return asmTypeDescriptor;
    }

    private final void genAnnotationArguments(IrConstructorCall annotation2, AnnotationVisitor annotationVisitor) {
        IrClass annotationClass = Companion.getAnnotationClass(annotation2);
        for (IrValueParameter param : ((IrConstructor)annotation2.getSymbol().getOwner()).getValueParameters()) {
            IrExpression value2 = annotation2.getValueArgument(param.getIndex());
            if (value2 != null) {
                this.genCompileTimeValue(this.getAnnotationArgumentJvmName(annotationClass, param.getName()), value2, annotationVisitor);
                continue;
            }
            if (param.getDefaultValue() != null) continue;
            String string2 = Intrinsics.stringPlus((String)"No value for annotation parameter ", (Object)param);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    }

    private final String getAnnotationArgumentJvmName(IrClass annotationClass, Name parameterName) {
        Object object;
        Object object2;
        Object v1;
        block7: {
            if (annotationClass == null) {
                String string2 = parameterName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameterName.asString()");
                return string2;
            }
            Iterable $this$singleOrNull$iv = annotationClass.getDeclarations();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrProperty irProperty2;
                IrPropertySymbol irPropertySymbol;
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                boolean bl2 = it instanceof IrSimpleFunction && Intrinsics.areEqual((irPropertySymbol = ((IrSimpleFunction)it).getCorrespondingPropertySymbol()) == null ? null : ((irProperty2 = (IrProperty)irPropertySymbol.getOwner()) == null ? null : irProperty2.getName()), (Object)parameterName) || it instanceof IrProperty && Intrinsics.areEqual((Object)((IrProperty)it).getName(), (Object)parameterName);
                if (!bl2) continue;
                if (found$iv) {
                    v1 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        IrDeclaration irDeclaration2 = v1;
        if (irDeclaration2 == null) {
            object2 = parameterName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameterName.asString()");
            return object2;
        }
        IrDeclaration propertyOrGetter = irDeclaration2;
        Object object3 = object2 = propertyOrGetter instanceof IrSimpleFunction ? (IrSimpleFunction)propertyOrGetter : null;
        if (object2 == null) {
            IrSimpleFunction irSimpleFunction = ((IrProperty)propertyOrGetter).getGetter();
            if (irSimpleFunction == null) {
                String string3 = Intrinsics.stringPlus((String)"No getter for annotation property: ", (Object)RenderIrElementKt.render(propertyOrGetter));
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            object = irSimpleFunction;
        } else {
            object = object2;
        }
        Object getter2 = object;
        return MethodSignatureMapper.mapFunctionName$default(this.methodSignatureMapper, (IrFunction)getter2, false, 2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void genCompileTimeValue(String name2, IrExpression value2, AnnotationVisitor annotationVisitor) {
        IrExpression irExpression = value2;
        if (irExpression instanceof IrConst) {
            annotationVisitor.visit(name2, ((IrConst)value2).getValue());
            return;
        }
        if (irExpression instanceof IrConstructorCall) {
            IrClass irClass2;
            IrConstructor callee = (IrConstructor)((IrConstructorCall)value2).getSymbol().getOwner();
            if (!IrUtilsKt.isAnnotationClass(IrUtilsKt.getParentAsClass(callee))) {
                String annotationClassType = Intrinsics.stringPlus((String)"Not supported as annotation! ", (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.ir2string(value2));
                boolean internalAnnName = false;
                throw (Throwable)new IllegalStateException(annotationClassType.toString());
            }
            IrType annotationClassType = callee.getReturnType();
            String internalAnnName = IrTypeMapper.mapType$default(this.typeMapper, annotationClassType, null, null, 6, null).getDescriptor();
            AnnotationVisitor visitor2 = annotationVisitor.visitAnnotation(name2, internalAnnName);
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(annotationClassType);
            if (irClassSymbol != null && (irClass2 = (IrClass)irClassSymbol.getOwner()) != null) {
                IrClass irClass3 = irClass2;
                InnerClassConsumer innerClassConsumer = this.innerClassConsumer;
                boolean bl = false;
                boolean bl2 = false;
                IrClass p0 = irClass3;
                boolean bl3 = false;
                innerClassConsumer.addInnerClassInfoFromAnnotation(p0);
            }
            IrConstructorCall irConstructorCall = (IrConstructorCall)value2;
            Intrinsics.checkNotNullExpressionValue((Object)visitor2, (String)"visitor");
            this.genAnnotationArguments(irConstructorCall, visitor2);
            visitor2.visitEnd();
            return;
        }
        if (irExpression instanceof IrGetEnumValue) {
            IrEnumEntry enumEntry = (IrEnumEntry)((IrGetEnumValue)value2).getSymbol().getOwner();
            IrClass enumClass2 = IrUtilsKt.getParentAsClass(enumEntry);
            this.innerClassConsumer.addInnerClassInfoFromAnnotation(enumClass2);
            annotationVisitor.visitEnum(name2, IrTypeMappingKt.mapClass(this.typeMapper, enumClass2).getDescriptor(), enumEntry.getName().asString());
            return;
        }
        if (irExpression instanceof IrVararg) {
            AnnotationVisitor visitor3 = annotationVisitor.visitArray(name2);
            Iterator<IrVarargElement> iterator2 = ((IrVararg)value2).getElements().iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    visitor3.visitEnd();
                    return;
                }
                IrVarargElement element = iterator2.next();
                IrExpression irExpression2 = (IrExpression)element;
                Intrinsics.checkNotNullExpressionValue((Object)visitor3, (String)"visitor");
                this.genCompileTimeValue(null, irExpression2, visitor3);
            }
        }
        if (irExpression instanceof IrClassReference) {
            IrClass irClass4;
            IrType classType = ((IrClassReference)value2).getClassType();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(classType);
            if (irClassSymbol != null && (irClass4 = (IrClass)irClassSymbol.getOwner()) != null) {
                IrClass irClass5 = irClass4;
                InnerClassConsumer innerClassConsumer = this.innerClassConsumer;
                boolean bl = false;
                boolean bl4 = false;
                IrClass p0 = irClass5;
                boolean bl5 = false;
                innerClassConsumer.addInnerClassInfoFromAnnotation(p0);
            }
            if (org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isInlineClassType(classType)) {
                classType = IrTypesKt.makeNullable(classType);
            }
            annotationVisitor.visit(name2, (Object)IrTypeMapper.mapType$default(this.typeMapper, classType, null, null, 6, null));
            return;
        }
        if (irExpression instanceof IrErrorExpression) {
            String string2 = Intrinsics.stringPlus((String)"Don't know how to compile annotation value ", (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.ir2string(value2));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String string3 = Intrinsics.stringPlus((String)"Unsupported compile-time value ", (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.ir2string(value2));
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string3.toString());
    }

    public final void generateTypeAnnotations$backend_jvm(@NotNull IrAnnotationContainer annotated, @Nullable IrType type2) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        IrDeclaration irDeclaration2 = annotated instanceof IrDeclaration ? (IrDeclaration)annotated : null;
        if (Intrinsics.areEqual((Object)(irDeclaration2 == null ? null : irDeclaration2.getOrigin()), (Object)JvmLoweredDeclarationOrigin.SYNTHETIC_ACCESSOR.INSTANCE) || type2 == null || this.context.getState().getTarget() == JvmTarget.JVM_1_6 || !this.context.getState().getConfiguration().getBoolean(JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS)) {
            return;
        }
        Iterable infos = new IrTypeAnnotationCollector(this.context.getTypeMapper().getTypeSystem()).collectTypeAnnotations(type2);
        for (TypePathInfo info : infos) {
            for (IrConstructorCall annotation2 : info.getAnnotations()) {
                this.genAnnotation(annotation2, info.getPath(), true);
            }
        }
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)((Object)KotlinRetention.SOURCE), (Object)((Object)RetentionPolicy.SOURCE)), TuplesKt.to((Object)((Object)KotlinRetention.BINARY), (Object)((Object)RetentionPolicy.CLASS)), TuplesKt.to((Object)((Object)KotlinRetention.RUNTIME), (Object)((Object)RetentionPolicy.RUNTIME))};
        annotationRetentionMap = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new FqName[]{JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION, JvmSymbols.Companion.getRAW_TYPE_ANNOTATION_FQ_NAME()};
        internalAnnotations = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0092\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2b\u0010\u001d\u001a^\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0015\u0012\u0013\u0018\u00010\"\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(#\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(%\u0012\u0013\u0012\u00110&\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b('\u0012\u0004\u0012\u00020(0\u001eJ\u0010\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u000eH\u0002J\u0010\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\b*\u00020\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\r\u001a\u00020\u000e*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen$Companion;", "", "()V", "annotationRetentionMap", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinRetention;", "Ljava/lang/annotation/RetentionPolicy;", "internalAnnotations", "", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.jvm.PlatformType", "getInternalAnnotations$backend_jvm", "()Ljava/util/Set;", "annotationClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "getAnnotationClass", "(Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "genAnnotationsOnTypeParametersAndBounds", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "typeParameterContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "referenceType", "", "boundType", "visitor", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "typeRef", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "typePath", "", "descriptor", "", "visible", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "getRetentionPolicy", "irClass", "isInvisibleForNullabilityAnalysis", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "applicableTargetSet", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "backend.jvm"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void genAnnotationsOnTypeParametersAndBounds(@NotNull JvmBackendContext context2, @NotNull IrTypeParametersContainer typeParameterContainer, @NotNull ClassCodegen classCodegen, int referenceType, int boundType, @NotNull Function4<? super Integer, ? super TypePath, ? super String, ? super Boolean, ? extends AnnotationVisitor> visitor2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)typeParameterContainer, (String)"typeParameterContainer");
            Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
            Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
            if (context2.getState().getTarget() != JvmTarget.JVM_1_6) {
                Iterable $this$forEachIndexed$iv = typeParameterContainer.getTypeParameters();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void typeParameter;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv;
                    int index2 = n;
                    boolean bl2 = false;
                    new AnnotationCodegen(visitor2, referenceType, index2, (IrTypeParameter)typeParameter, typeParameterContainer, classCodegen, context2){
                        final /* synthetic */ Function4<Integer, TypePath, String, Boolean, AnnotationVisitor> $visitor;
                        final /* synthetic */ int $referenceType;
                        final /* synthetic */ int $index;
                        final /* synthetic */ IrTypeParameter $typeParameter;
                        final /* synthetic */ IrTypeParametersContainer $typeParameterContainer;
                        final /* synthetic */ ClassCodegen $classCodegen;
                        final /* synthetic */ JvmBackendContext $context;
                        {
                            this.$visitor = $visitor;
                            this.$referenceType = $referenceType;
                            this.$index = $index;
                            this.$typeParameter = $typeParameter;
                            this.$typeParameterContainer = $typeParameterContainer;
                            this.$classCodegen = $classCodegen;
                            this.$context = $context;
                            super($classCodegen, $context, true);
                        }

                        @NotNull
                        public AnnotationVisitor visitAnnotation(@NotNull String descr, boolean visible) {
                            Intrinsics.checkNotNullParameter((Object)descr, (String)"descr");
                            return (AnnotationVisitor)this.$visitor.invoke((Object)TypeReference.newTypeParameterReference((int)this.$referenceType, (int)this.$index).getValue(), null, (Object)descr, (Object)visible);
                        }

                        @NotNull
                        public AnnotationVisitor visitTypeAnnotation(@NotNull String descr, @Nullable TypePath path2, boolean visible) {
                            Intrinsics.checkNotNullParameter((Object)descr, (String)"descr");
                            throw new RuntimeException("Error during generation: type annotation shouldn't be presented on type parameter: " + org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.ir2string(this.$typeParameter) + " in " + org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.ir2string(this.$typeParameterContainer));
                        }
                    }.genAnnotations((IrAnnotationContainer)typeParameter, null, null);
                    if (!context2.getState().getConfiguration().getBoolean(JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS)) continue;
                    int superInterfaceIndex = 0;
                    superInterfaceIndex = 1;
                    Iterable $this$forEach$iv = typeParameter.getSuperTypes();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        int n2;
                        boolean isClassOrTypeParameter;
                        IrType superType2 = (IrType)element$iv;
                        boolean bl3 = false;
                        boolean bl4 = isClassOrTypeParameter = !IrTypeUtilsKt.isInterface(superType2) && !IrTypeUtilsKt.isAnnotation(superType2);
                        if (isClassOrTypeParameter) {
                            n2 = 0;
                        } else {
                            int n3 = superInterfaceIndex;
                            superInterfaceIndex = n3 + 1;
                            n2 = n3;
                        }
                        int superIndex = n2;
                        new AnnotationCodegen((IrTypeParameter)typeParameter, visitor2, boundType, index2, superIndex, classCodegen, context2){
                            final /* synthetic */ IrTypeParameter $typeParameter;
                            final /* synthetic */ Function4<Integer, TypePath, String, Boolean, AnnotationVisitor> $visitor;
                            final /* synthetic */ int $boundType;
                            final /* synthetic */ int $index;
                            final /* synthetic */ int $superIndex;
                            final /* synthetic */ ClassCodegen $classCodegen;
                            final /* synthetic */ JvmBackendContext $context;
                            {
                                this.$typeParameter = $typeParameter;
                                this.$visitor = $visitor;
                                this.$boundType = $boundType;
                                this.$index = $index;
                                this.$superIndex = $superIndex;
                                this.$classCodegen = $classCodegen;
                                this.$context = $context;
                                super($classCodegen, $context, true);
                            }

                            @NotNull
                            public AnnotationVisitor visitAnnotation(@NotNull String descr, boolean visible) {
                                Intrinsics.checkNotNullParameter((Object)descr, (String)"descr");
                                throw new RuntimeException("Error during generation: only type annotations should be presented on type parameters bounds: " + org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.ir2string(this.$typeParameter) + " in " + org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.ir2string(this.$typeParameter));
                            }

                            @NotNull
                            public AnnotationVisitor visitTypeAnnotation(@NotNull String descr, @Nullable TypePath path2, boolean visible) {
                                Intrinsics.checkNotNullParameter((Object)descr, (String)"descr");
                                return (AnnotationVisitor)this.$visitor.invoke((Object)TypeReference.newTypeParameterBoundReference((int)this.$boundType, (int)this.$index, (int)this.$superIndex).getValue(), (Object)path2, (Object)descr, (Object)visible);
                            }
                        }.generateTypeAnnotations$backend_jvm(typeParameterContainer, superType2);
                    }
                }
            }
        }

        private final boolean isInvisibleForNullabilityAnalysis(IrDeclaration declaration2) {
            return declaration2.getOrigin().isSynthetic() ? true : Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INLINE_CLASS_GENERATED_IMPL_METHOD.INSTANCE) || Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.GENERATED_SAM_IMPLEMENTATION.INSTANCE);
        }

        @NotNull
        public final Set<FqName> getInternalAnnotations$backend_jvm() {
            return internalAnnotations;
        }

        private final RetentionPolicy getRetentionPolicy(IrClass irClass2) {
            KotlinRetention retention = AnnotationCodegenKt.access$getAnnotationRetention(irClass2);
            if (retention != null) {
                Object v = annotationRetentionMap.get((Object)retention);
                Intrinsics.checkNotNull(v);
                return (RetentionPolicy)((Object)v);
            }
            IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation(irClass2, new FqName(Retention.class.getName()));
            if (irConstructorCall != null) {
                IrConstructorCall irConstructorCall2 = irConstructorCall;
                boolean bl = false;
                boolean bl2 = false;
                IrConstructorCall retentionAnnotation = irConstructorCall2;
                boolean bl3 = false;
                IrExpression value2 = retentionAnnotation.getValueArgument(0);
                if (value2 instanceof IrEnumEntry) {
                    Object object;
                    FqName enumClassFqName = IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)((Object)value2)));
                    if (Intrinsics.areEqual((Object)RetentionPolicy.class.getName(), (Object)((object = enumClassFqName) == null ? null : ((FqName)object).asString()))) {
                        object = ((IrEnumEntry)((Object)value2)).getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value.name.asString()");
                        return RetentionPolicy.valueOf((String)object);
                    }
                }
            }
            return RetentionPolicy.RUNTIME;
        }

        @NotNull
        public final Set<KotlinTarget> applicableTargetSet(@NotNull IrConstructorCall $this$applicableTargetSet) {
            Intrinsics.checkNotNullParameter((Object)$this$applicableTargetSet, (String)"<this>");
            Set<KotlinTarget> set = AnnotationCodegenKt.access$applicableTargetSet(this.getAnnotationClass($this$applicableTargetSet));
            return set == null ? KotlinTarget.Companion.getDEFAULT_TARGET_SET() : set;
        }

        @NotNull
        public final IrClass getAnnotationClass(@NotNull IrConstructorCall $this$annotationClass) {
            Intrinsics.checkNotNullParameter((Object)$this$annotationClass, (String)"<this>");
            return IrUtilsKt.getParentAsClass($this$annotationClass.getSymbol().getOwner());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b*\u00020\fH\u0016R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/AnnotationCodegen$IrTypeAnnotationCollector;", "Lorg/jetbrains/kotlin/codegen/TypeAnnotationCollector;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "context", "Lorg/jetbrains/kotlin/types/TypeSystemCommonBackendContext;", "(Lorg/jetbrains/kotlin/types/TypeSystemCommonBackendContext;)V", "isCompiledToJvm8OrHigher", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "extractAnnotations", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "backend.jvm"})
    private static final class IrTypeAnnotationCollector
    extends TypeAnnotationCollector<IrConstructorCall> {
        public IrTypeAnnotationCollector(@NotNull TypeSystemCommonBackendContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<IrConstructorCall> extractAnnotations(@NotNull KotlinTypeMarker $this$extractAnnotations) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$extractAnnotations, (String)"<this>");
            boolean bl = $this$extractAnnotations instanceof IrType;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            Iterable $this$filter$iv = ((IrType)$this$extractAnnotations).getAnnotations();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrConstructorCall it = (IrConstructorCall)element$iv$iv;
                boolean bl6 = false;
                boolean bl7 = !Intrinsics.areEqual((Object)Companion.getAnnotationClass(it).getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE) && !Intrinsics.areEqual((Object)Companion.getAnnotationClass(it).getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) || this.isCompiledToJvm8OrHigher(Companion.getAnnotationClass(it));
                if (!bl7) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isCompiledToJvm8OrHigher(IrClass $this$isCompiledToJvm8OrHigher) {
            return (Intrinsics.areEqual((Object)$this$isCompiledToJvm8OrHigher.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE) || Intrinsics.areEqual((Object)$this$isCompiledToJvm8OrHigher.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE)) && this.isCompiledToJvm8OrHigher($this$isCompiledToJvm8OrHigher.getSource());
        }
    }
}

