/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensionsImpl;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.FilteredAnnotations;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrExternalPackageFragmentImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.StubGeneratorExtensions;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.java.sam.JavaSingleAbstractMethodUtils;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorExtensions;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JdkClassesKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0002BCB\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010'\u001a\u00020+H\u0016J\"\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\b2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u001a\u00108\u001a\u0004\u0018\u00010\b2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010'\u001a\u000200H\u0016J\u0010\u0010?\u001a\u00020\u00042\u0006\u0010'\u001a\u00020+H\u0016J\u0010\u0010@\u001a\u00020\u00042\u0006\u0010'\u001a\u00020AH\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "generateFacades", "", "(Z)V", "classNameOverride", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassNameOverride", "()Ljava/util/Map;", "enhancedNullability", "Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions$EnhancedNullability;", "getEnhancedNullability", "()Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions$EnhancedNullability;", "enhancedNullabilityAnnotationClass", "enhancedNullabilityAnnotationConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getEnhancedNullabilityAnnotationConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "flexibleNullabilityAnnotationClass", "flexibleNullabilityAnnotationConstructor", "getFlexibleNullabilityAnnotationConstructor", "kotlinIrInternalPackage", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrExternalPackageFragmentImpl;", "kotlinJvmInternalPackage", "rawTypeAnnotationClass", "rawTypeAnnotationConstructor", "getRawTypeAnnotationConstructor", "samConversion", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "getSamConversion", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "shouldPreventDeprecatedIntegerValueTypeLiteralConversion", "getShouldPreventDeprecatedIntegerValueTypeLiteralConversion", "()Z", "computeExternalDeclarationOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "computeFieldVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "createCustomSuperConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "ktPureClassOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "createSpecialAnnotationClass", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "generateFacadeClass", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "source", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "getParentClassStaticScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "isPropertyWithPlatformField", "isStaticFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "JvmEnhancedNullability", "JvmSamConversion", "backend.jvm.entrypoint"})
public class JvmGeneratorExtensionsImpl
extends GeneratorExtensions
implements JvmGeneratorExtensions {
    private final boolean generateFacades;
    @NotNull
    private final Map<IrClass, JvmClassName> classNameOverride;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinIrInternalPackage;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinJvmInternalPackage;
    @NotNull
    private final IrClass flexibleNullabilityAnnotationClass;
    @NotNull
    private final IrClass rawTypeAnnotationClass;
    @NotNull
    private final IrClass enhancedNullabilityAnnotationClass;
    @NotNull
    private final IrConstructor flexibleNullabilityAnnotationConstructor;
    @NotNull
    private final IrConstructor enhancedNullabilityAnnotationConstructor;
    @NotNull
    private final IrConstructor rawTypeAnnotationConstructor;

    public JvmGeneratorExtensionsImpl(boolean generateFacades) {
        this.generateFacades = generateFacades;
        boolean bl = false;
        this.classNameOverride = new LinkedHashMap();
        this.kotlinIrInternalPackage = new IrExternalPackageFragmentImpl(new DescriptorlessExternalPackageFragmentSymbol(), IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN());
        IrExternalPackageFragmentSymbol irExternalPackageFragmentSymbol = new DescriptorlessExternalPackageFragmentSymbol();
        FqName fqName2 = JvmAnnotationNames.KOTLIN_JVM_INTERNAL;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"KOTLIN_JVM_INTERNAL");
        this.kotlinJvmInternalPackage = new IrExternalPackageFragmentImpl(irExternalPackageFragmentSymbol, fqName2);
        this.flexibleNullabilityAnnotationClass = this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.rawTypeAnnotationClass = this.createSpecialAnnotationClass(JvmSymbols.Companion.getRAW_TYPE_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ENHANCED_NULLABILITY_ANNOTATION");
        this.enhancedNullabilityAnnotationClass = this.createSpecialAnnotationClass(fqName2, this.kotlinJvmInternalPackage);
        this.flexibleNullabilityAnnotationConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(this.flexibleNullabilityAnnotationClass));
        this.enhancedNullabilityAnnotationConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(this.enhancedNullabilityAnnotationClass));
        this.rawTypeAnnotationConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(this.rawTypeAnnotationClass));
    }

    public /* synthetic */ JvmGeneratorExtensionsImpl(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @Override
    @NotNull
    public Map<IrClass, JvmClassName> getClassNameOverride() {
        return this.classNameOverride;
    }

    @Override
    @NotNull
    public GeneratorExtensions.SamConversion getSamConversion() {
        return JvmSamConversion.Instance;
    }

    @Override
    @Nullable
    public DescriptorVisibility computeFieldVisibility(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2) || descriptor2 instanceof JavaCallableMemberDescriptor ? descriptor2.getVisibility() : null;
    }

    @Override
    @Nullable
    public IrDeclarationOrigin computeExternalDeclarationOrigin(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return descriptor2 instanceof JavaCallableMemberDescriptor || descriptor2 instanceof JavaClassDescriptor ? (IrDeclarationOrigin)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE : (IrDeclarationOrigin)IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE;
    }

    @Override
    @Nullable
    public IrClass generateFacadeClass(@NotNull IrFactory irFactory, @NotNull DeserializedContainerSource source) {
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.generateFacades || !(source instanceof JvmPackagePartSource)) {
            return null;
        }
        Object object = ((JvmPackagePartSource)source).getFacadeClassName();
        JvmClassName facadeName = object == null ? ((JvmPackagePartSource)source).getClassName() : object;
        IrFactory $this$buildClass$iv = irFactory;
        boolean $i$f$buildClass = false;
        IrClassBuilder irClassBuilder = new IrClassBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = irClassBuilder;
        boolean bl3 = false;
        IrClassBuilder $this$generateFacadeClass_u24lambda_u2d0 = $this$buildClass_u24lambda_u2d1$iv;
        boolean bl4 = false;
        $this$generateFacadeClass_u24lambda_u2d0.setOrigin(((JvmPackagePartSource)source).getFacadeClassName() != null ? (IrDeclarationOrigin)IrDeclarationOrigin.JVM_MULTIFILE_CLASS.INSTANCE : (IrDeclarationOrigin)IrDeclarationOrigin.FILE_CLASS.INSTANCE);
        Name name2 = facadeName.getFqNameForTopLevelClassMaybeWithDollars().shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"facadeName.fqNameForTopL\u2026beWithDollars.shortName()");
        $this$generateFacadeClass_u24lambda_u2d0.setName(name2);
        object = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u2d1$iv);
        boolean bl5 = false;
        boolean bl6 = false;
        Object it = object;
        boolean bl7 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createParameterDeclarations((IrClass)it);
        Map<IrClass, JvmClassName> map = this.getClassNameOverride();
        boolean bl8 = false;
        map.put((IrClass)it, facadeName);
        return object;
    }

    @Override
    public boolean isPropertyWithPlatformField(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isStaticFunction(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!DescriptorUtils.isNonCompanionObject(descriptor2.getContainingDeclaration())) return false;
        if (AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2)) return true;
        if (!(descriptor2 instanceof PropertyAccessorDescriptor)) return false;
        PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
        if (!AnnotationUtilKt.hasJvmStaticAnnotation(propertyDescriptor)) return false;
        return true;
    }

    @Override
    @NotNull
    public StubGeneratorExtensions.EnhancedNullability getEnhancedNullability() {
        return JvmEnhancedNullability.Instance;
    }

    @Override
    @Nullable
    public MemberScope getParentClassStaticScope(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return UtilKt.getParentJavaStaticClassScope(descriptor2);
    }

    private final IrClass createSpecialAnnotationClass(FqName fqn, IrPackageFragment parent2) {
        IrFactory $this$buildClass$iv = IrFactoryImpl.INSTANCE;
        boolean $i$f$buildClass = false;
        IrClassBuilder irClassBuilder = new IrClassBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = irClassBuilder;
        boolean bl3 = false;
        IrClassBuilder $this$createSpecialAnnotationClass_u24lambda_u2d2 = $this$buildClass_u24lambda_u2d1$iv;
        boolean bl4 = false;
        $this$createSpecialAnnotationClass_u24lambda_u2d2.setKind(ClassKind.ANNOTATION_CLASS);
        Object object = fqn.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fqn.shortName()");
        $this$createSpecialAnnotationClass_u24lambda_u2d2.setName((Name)object);
        IrClass irClass2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u2d1$iv);
        boolean bl5 = false;
        boolean bl6 = false;
        IrClass $this$createSpecialAnnotationClass_u24lambda_u2d4 = irClass2;
        boolean bl7 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$createSpecialAnnotationClass_u24lambda_u2d4);
        $this$createSpecialAnnotationClass_u24lambda_u2d4.setParent(parent2);
        IrClass $this$addConstructor$iv = $this$createSpecialAnnotationClass_u24lambda_u2d4;
        boolean $i$f$addConstructor = false;
        IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        object = new IrFunctionBuilder();
        boolean bl8 = false;
        boolean bl9 = false;
        Object $this$buildConstructor_u24lambda_u2d18$iv$iv = object;
        boolean bl10 = false;
        Object $this$addConstructor_u24lambda_u2d19$iv = $this$buildConstructor_u24lambda_u2d18$iv$iv;
        boolean bl11 = false;
        Object $this$createSpecialAnnotationClass_u24lambda_u2d4_u24lambda_u2d3 = $this$addConstructor_u24lambda_u2d19$iv;
        boolean bl12 = false;
        ((IrFunctionBuilder)$this$createSpecialAnnotationClass_u24lambda_u2d4_u24lambda_u2d3).setPrimary(true);
        ((IrFunctionBuilder)$this$addConstructor_u24lambda_u2d19$iv).setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
        IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2d18$iv$iv);
        boolean bl13 = false;
        boolean bl14 = false;
        IrConstructor constructor$iv = irConstructor2;
        boolean bl15 = false;
        $this$addConstructor$iv.getDeclarations().add(constructor$iv);
        constructor$iv.setParent($this$addConstructor$iv);
        return irClass2;
    }

    @Override
    @Nullable
    public IrDelegatingConstructorCall createCustomSuperConstructorCall(@NotNull KtPureClassOrObject ktPureClassOrObject, @NotNull ClassDescriptor descriptor2, @NotNull GeneratorContext context2) {
        Intrinsics.checkNotNullParameter((Object)ktPureClassOrObject, (String)"ktPureClassOrObject");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!JvmAnnotationUtilKt.isJvmRecord(descriptor2)) {
            return null;
        }
        ClassDescriptor classDescriptor = DescriptorUtilsKt.resolveTopLevelClass(DescriptorUtilsKt.getModule(descriptor2), JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME(), NoLookupLocation.FROM_BACKEND);
        if (classDescriptor == null) {
            String string2 = Intrinsics.stringPlus((String)"Class not found: ", (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        ClassDescriptor recordClass = classDescriptor;
        Collection<ClassConstructorDescriptor> collection = recordClass.getConstructors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"recordClass.constructors");
        ClassConstructorDescriptor recordConstructor = (ClassConstructorDescriptor)CollectionsKt.single((Iterable)collection);
        int n = PsiUtilsKt.getPureStartOffset(ktPureClassOrObject);
        int n2 = PsiUtilsKt.getPureEndOffset(ktPureClassOrObject);
        IrType irType = context2.getIrBuiltIns().getUnitType();
        SymbolTable symbolTable = context2.getSymbolTable();
        Intrinsics.checkNotNullExpressionValue((Object)recordConstructor, (String)"recordConstructor");
        return IrDelegatingConstructorCallImpl.Companion.fromSymbolDescriptor$default(IrDelegatingConstructorCallImpl.Companion, n, n2, irType, symbolTable.referenceConstructor(recordConstructor), 0, 0, 48, null);
    }

    @Override
    public boolean getShouldPreventDeprecatedIntegerValueTypeLiteralConversion() {
        return true;
    }

    @Override
    @NotNull
    public IrConstructor getFlexibleNullabilityAnnotationConstructor() {
        return this.flexibleNullabilityAnnotationConstructor;
    }

    @Override
    @NotNull
    public IrConstructor getEnhancedNullabilityAnnotationConstructor() {
        return this.enhancedNullabilityAnnotationConstructor;
    }

    @Override
    @NotNull
    public IrConstructor getRawTypeAnnotationConstructor() {
        return this.rawTypeAnnotationConstructor;
    }

    public JvmGeneratorExtensionsImpl() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmSamConversion;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions$SamConversion;", "()V", "isPlatformSamType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "Instance", "backend.jvm.entrypoint"})
    public static class JvmSamConversion
    extends GeneratorExtensions.SamConversion {
        @NotNull
        public static final Instance Instance = new Instance(null);

        @Override
        public boolean isPlatformSamType(@NotNull KotlinType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return JavaSingleAbstractMethodUtils.isSamType(type2);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmSamConversion$Instance;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmSamConversion;", "()V", "backend.jvm.entrypoint"})
        public static final class Instance
        extends JvmSamConversion {
            private Instance() {
            }

            public /* synthetic */ Instance(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmEnhancedNullability;", "Lorg/jetbrains/kotlin/ir/util/StubGeneratorExtensions$EnhancedNullability;", "()V", "hasEnhancedNullability", "", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "stripEnhancedNullability", "Instance", "backend.jvm.entrypoint"})
    public static class JvmEnhancedNullability
    extends StubGeneratorExtensions.EnhancedNullability {
        @NotNull
        public static final Instance Instance = new Instance(null);

        @Override
        public boolean hasEnhancedNullability(@NotNull KotlinType kotlinType) {
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
            return TypeEnhancementKt.hasEnhancedNullability(kotlinType);
        }

        @Override
        @NotNull
        public KotlinType stripEnhancedNullability(@NotNull KotlinType kotlinType) {
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
            return TypeEnhancementKt.hasEnhancedNullability(kotlinType) ? TypeUtilsKt.replaceAnnotations(kotlinType, new FilteredAnnotations(kotlinType.getAnnotations(), true, (Function1<? super FqName, Boolean>)((Function1)stripEnhancedNullability.1.INSTANCE))) : kotlinType;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmEnhancedNullability$Instance;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensionsImpl$JvmEnhancedNullability;", "()V", "backend.jvm.entrypoint"})
        public static final class Instance
        extends JvmEnhancedNullability {
            private Instance() {
            }

            public /* synthetic */ Instance(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

