/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.library;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.MultiMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaLibraryType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.library.JpsLibraryPropertiesSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryRootTypeSerializer;

public final class JpsLibraryTableSerializer {
    private static final JpsLibraryRootTypeSerializer[] PREDEFINED_ROOT_TYPES_SERIALIZERS = new JpsLibraryRootTypeSerializer[]{new JpsLibraryRootTypeSerializer("CLASSES", JpsOrderRootType.COMPILED, true), new JpsLibraryRootTypeSerializer("SOURCES", JpsOrderRootType.SOURCES, true), new JpsLibraryRootTypeSerializer("DOCUMENTATION", JpsOrderRootType.DOCUMENTATION, false)};
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String PROPERTIES_TAG = "properties";
    public static final String JAR_DIRECTORY_TAG = "jarDirectory";
    private static final String URL_ATTRIBUTE = "url";
    public static final String ROOT_TAG = "root";
    public static final String RECURSIVE_ATTRIBUTE = "recursive";
    public static final String LIBRARY_TAG = "library";
    private static final JpsLibraryPropertiesSerializer<JpsDummyElement> JAVA_LIBRARY_PROPERTIES_SERIALIZER = new JpsLibraryPropertiesSerializer<JpsDummyElement>((JpsLibraryType)JpsJavaLibraryType.INSTANCE, null){

        @Override
        public JpsDummyElement loadProperties(@Nullable Element propertiesElement) {
            return JpsElementFactory.getInstance().createDummyElement();
        }
    };
    public static final String MODULE_LEVEL = "module";
    public static final String PROJECT_LEVEL = "project";
    public static final String APPLICATION_LEVEL = "application";

    public static void loadLibraries(@Nullable Element libraryTableElement, @NotNull JpsPathMapper pathMapper, JpsLibraryCollection result2) {
        if (pathMapper == null) {
            JpsLibraryTableSerializer.$$$reportNull$$$0(0);
        }
        for (Element libraryElement : JDOMUtil.getChildren((Element)libraryTableElement, (String)LIBRARY_TAG)) {
            result2.addLibrary(JpsLibraryTableSerializer.loadLibrary(libraryElement, pathMapper));
        }
    }

    public static JpsLibrary loadLibrary(Element libraryElement, @NotNull JpsPathMapper pathMapper) {
        if (pathMapper == null) {
            JpsLibraryTableSerializer.$$$reportNull$$$0(1);
        }
        return JpsLibraryTableSerializer.loadLibrary(libraryElement, libraryElement.getAttributeValue(NAME_ATTRIBUTE), pathMapper);
    }

    public static JpsLibrary loadLibrary(Element libraryElement, String name2, @NotNull JpsPathMapper pathMapper) {
        if (pathMapper == null) {
            JpsLibraryTableSerializer.$$$reportNull$$$0(2);
        }
        String typeId = libraryElement.getAttributeValue(TYPE_ATTRIBUTE);
        JpsLibraryPropertiesSerializer<?> loader = JpsLibraryTableSerializer.getLibraryPropertiesSerializer(typeId);
        JpsLibrary library = JpsLibraryTableSerializer.createLibrary(name2, loader, libraryElement.getChild(PROPERTIES_TAG));
        MultiMap jarDirectories = new MultiMap();
        MultiMap recursiveJarDirectories = new MultiMap();
        for (Element jarDirectory : JDOMUtil.getChildren((Element)libraryElement, (String)JAR_DIRECTORY_TAG)) {
            String url = pathMapper.mapUrl(jarDirectory.getAttributeValue(URL_ATTRIBUTE));
            String rootTypeId = jarDirectory.getAttributeValue(TYPE_ATTRIBUTE);
            JpsOrderRootType rootType = rootTypeId != null ? JpsLibraryTableSerializer.getRootType(rootTypeId) : JpsOrderRootType.COMPILED;
            boolean recursive = Boolean.parseBoolean(jarDirectory.getAttributeValue(RECURSIVE_ATTRIBUTE));
            jarDirectories.putValue((Object)rootType, (Object)url);
            if (!recursive) continue;
            recursiveJarDirectories.putValue((Object)rootType, (Object)url);
        }
        for (Element rootsElement : libraryElement.getChildren()) {
            String rootTypeId = rootsElement.getName();
            if (rootTypeId.equals(JAR_DIRECTORY_TAG) || rootTypeId.equals(PROPERTIES_TAG) || rootTypeId.equals("excluded")) continue;
            JpsOrderRootType rootType = JpsLibraryTableSerializer.getRootType(rootTypeId);
            for (Element rootElement : JDOMUtil.getChildren((Element)rootsElement, (String)ROOT_TAG)) {
                boolean recursive;
                String url = pathMapper.mapUrl(rootElement.getAttributeValue(URL_ATTRIBUTE));
                JpsLibraryRoot.InclusionOptions options = jarDirectories.get((Object)rootType).contains(url) ? ((recursive = recursiveJarDirectories.get((Object)rootType).contains(url)) ? JpsLibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY : JpsLibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT) : JpsLibraryRoot.InclusionOptions.ROOT_ITSELF;
                library.addRoot(url, rootType, options);
            }
        }
        return library;
    }

    private static <P extends JpsElement> JpsLibrary createLibrary(String name2, JpsLibraryPropertiesSerializer<P> loader, Element propertiesElement) {
        return JpsElementFactory.getInstance().createLibrary(name2, (JpsLibraryType)loader.getType(), loader.loadProperties(propertiesElement));
    }

    private static JpsOrderRootType getRootType(String rootTypeId) {
        for (JpsLibraryRootTypeSerializer serializer2 : PREDEFINED_ROOT_TYPES_SERIALIZERS) {
            if (!serializer2.getTypeId().equals(rootTypeId)) continue;
            return serializer2.getType();
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsLibraryRootTypeSerializer serializer2 : extension.getLibraryRootTypeSerializers()) {
                if (!serializer2.getTypeId().equals(rootTypeId)) continue;
                return serializer2.getType();
            }
        }
        return JpsOrderRootType.COMPILED;
    }

    private static JpsLibraryPropertiesSerializer<?> getLibraryPropertiesSerializer(@Nullable String typeId) {
        if (typeId != null) {
            for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
                for (JpsLibraryPropertiesSerializer<?> loader : extension.getLibraryPropertiesSerializers()) {
                    if (!loader.getTypeId().equals(typeId)) continue;
                    return loader;
                }
            }
        }
        return JAVA_LIBRARY_PROPERTIES_SERIALIZER;
    }

    public static JpsElementReference<? extends JpsCompositeElement> createLibraryTableReference(String level) {
        JpsElementFactory elementFactory = JpsElementFactory.getInstance();
        if (level.equals(PROJECT_LEVEL)) {
            return elementFactory.createProjectReference();
        }
        if (level.equals(APPLICATION_LEVEL)) {
            return elementFactory.createGlobalReference();
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            JpsElementReference<? extends JpsCompositeElement> reference = extension.createLibraryTableReference(level);
            if (reference == null) continue;
            return reference;
        }
        throw new UnsupportedOperationException();
    }

    public static String getLevelId(JpsElementReference<? extends JpsCompositeElement> reference) {
        if (reference instanceof JpsModuleReference) {
            return MODULE_LEVEL;
        }
        JpsCompositeElement element = reference.resolve();
        if (element instanceof JpsProject) {
            return PROJECT_LEVEL;
        }
        if (element instanceof JpsGlobal) {
            return APPLICATION_LEVEL;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            String levelId = extension.getLibraryTableLevelId(reference);
            if (levelId == null) continue;
            return levelId;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "pathMapper";
        objectArray2[1] = "org/jetbrains/jps/model/serialization/library/JpsLibraryTableSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadLibraries";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadLibrary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

