/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u001c\u0010\u0003\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "T", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "value", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getFields", "()Ljava/util/List;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "typeArguments", "getTypeArguments", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "equals", "", "other", "", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getState", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "hashCode", "", "toString", "", "ir.interpreter"})
public final class Primitive<T>
implements State {
    private T value;
    @NotNull
    private final IrType type;
    @NotNull
    private final List<Variable> fields;
    @NotNull
    private final List<Variable> typeArguments;
    @NotNull
    private final IrClass irClass;

    public Primitive(T value2, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.value = value2;
        this.type = type2;
        boolean bl = false;
        this.fields = new ArrayList();
        bl = false;
        this.typeArguments = new ArrayList();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.type);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this.irClass = (IrClass)irClassSymbol.getOwner();
    }

    public final T getValue() {
        return this.value;
    }

    public final void setValue(T t) {
        this.value = t;
    }

    @NotNull
    public final IrType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public List<Variable> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public List<Variable> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public State getState(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        State state2 = State.DefaultImpls.getState(this, symbol2);
        return state2 == null ? (State)this : state2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        IrFunction irFunction2;
        Object v0;
        block5: {
            void $this$firstOrNull$iv;
            void $this$filterIsInstanceTo$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrSimpleFunction owner = (IrSimpleFunction)expression2.getSymbol().getOwner();
            Iterable $this$map$iv = this.getIrClass().getDeclarations();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrDeclaration irDeclaration2 = (IrDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var14_21 = it instanceof IrProperty ? (IrDeclaration)((IrProperty)it).getGetter() : it;
                collection.add(var14_21);
            }
            List declarations2 = (List)destination$iv$iv;
            Iterable $this$filterIsInstance$iv = declarations2;
            boolean $i$f$filterIsInstance = false;
            destination$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrFunction)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrFunction it = (IrFunction)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getSymbol(), (Object)owner.getSymbol()) || it instanceof IrSimpleFunction && AdditionalIrUtilsKt.overrides((IrSimpleFunction)it, owner))) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        IrFunction irFunction3 = v0;
        if (irFunction3 == null) {
            irFunction2 = null;
        } else {
            IrFunction irFunction4 = irFunction3;
            boolean bl = false;
            boolean bl2 = false;
            IrFunction it = irFunction4;
            boolean bl3 = false;
            irFunction2 = IrFakeOverrideUtilsKt.isFakeOverride(it) ? UtilsKt.getLastOverridden(it) : it;
        }
        return irFunction2;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
        }
        Primitive cfr_ignored_0 = (Primitive)other;
        if (!Intrinsics.areEqual(this.value, ((Primitive)other).value)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)((Primitive)other).type)) {
            return false;
        }
        return Intrinsics.areEqual(this.getFields(), ((Primitive)other).getFields());
    }

    public int hashCode() {
        int n;
        T t = this.value;
        int result2 = t == null ? 0 : (n = t.hashCode());
        result2 = 31 * result2 + this.type.hashCode();
        result2 = 31 * result2 + ((Object)this.getFields()).hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "Primitive(value=" + this.value + ", type=" + IrUtilsKt.getDefaultType(this.getIrClass()) + ')';
    }

    @Override
    public void addTypeArguments(@NotNull List<Variable> typeArguments2) {
        State.DefaultImpls.addTypeArguments(this, typeArguments2);
    }

    @Override
    public void setField(@NotNull Variable newVar) {
        State.DefaultImpls.setField(this, newVar);
    }
}

