/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.parsing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001\u001a \u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u000b0\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u000f"}, d2={"classesFqNames", "", "", "kotlinFiles", "", "Ljava/io/File;", "disposable", "Lcom/intellij/openapi/Disposable;", "files", "filterClassesTo", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "classes", "Ljava/util/Deque;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "incremental-compilation-impl"})
public final class ParseFileUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> classesFqNames(@NotNull Set<? extends File> files2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
            if (!(StringsKt.endsWith((String)string2, (String)".kt", (boolean)true) && it.isFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingKotlinFiles = (List)destination$iv$iv;
        if (existingKotlinFiles.isEmpty()) {
            return SetsKt.emptySet();
        }
        Object object = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newDisposable()");
        Disposable disposable = object;
        try {
            object = ParseFileUtilsKt.classesFqNames(existingKotlinFiles, disposable);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        return object;
    }

    private static final Set<String> classesFqNames(Collection<? extends File> kotlinFiles, Disposable disposable) {
        CompilerConfiguration config = new CompilerConfiguration();
        config.put(JVMConfigurationKeys.NO_JDK, true);
        config.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.Companion.getNONE());
        EnvironmentConfigFiles configFiles = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        KotlinCoreEnvironment environment2 = KotlinCoreEnvironment.Companion.createForProduction(disposable, config, configFiles);
        PsiManager psiManager2 = PsiManager.getInstance((Project)environment2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(environment.project)");
        PsiManager psiManager3 = psiManager2;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance()");
        VirtualFileManager fileManager = virtualFileManager;
        VirtualFileSystem virtualFileSystem = fileManager.getFileSystem("file");
        if (virtualFileSystem == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vfs.local.CoreLocalFileSystem");
        }
        CoreLocalFileSystem localFS2 = (CoreLocalFileSystem)virtualFileSystem;
        HashSet<String> result2 = new HashSet<String>();
        for (File file2 : kotlinFiles) {
            VirtualFile virtualFile2 = localFS2.findFileByIoFile(file2);
            Intrinsics.checkNotNull((Object)virtualFile2);
            VirtualFile virtualFile3 = virtualFile2;
            VirtualFile virtualFile4 = virtualFile3;
            block1: for (PsiFile psiFile : new SingleRootFileViewProvider(psiManager3, virtualFile4).getAllFiles()) {
                if (!(psiFile instanceof KtFile)) continue;
                ArrayDeque classes2 = new ArrayDeque();
                ParseFileUtilsKt.filterClassesTo((Collection<? extends KtDeclaration>)((KtFile)psiFile).getDeclarations(), classes2);
                while (true) {
                    Collection collection = classes2;
                    boolean bl = false;
                    if (!(!collection.isEmpty())) continue block1;
                    KtClassOrObject klass = (KtClassOrObject)classes2.pollFirst();
                    FqName fqName2 = klass.getFqName();
                    if (fqName2 != null) {
                        FqName fqName3 = fqName2;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        FqName it = fqName3;
                        boolean bl4 = false;
                        result2.add(it.asString());
                    }
                    ParseFileUtilsKt.filterClassesTo((Collection<? extends KtDeclaration>)klass.getDeclarations(), classes2);
                }
            }
        }
        return result2;
    }

    private static final void filterClassesTo(Collection<? extends KtDeclaration> $this$filterClassesTo, Deque<KtClassOrObject> classes2) {
        Iterable $this$filterIsInstanceTo$iv = $this$filterClassesTo;
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv : $this$filterIsInstanceTo$iv) {
            if (!(element$iv instanceof KtClassOrObject)) continue;
            ((Collection)classes2).add(element$iv);
        }
    }
}

