/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.OptimizationMethodVisitor;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.PopBackwardPropagationTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "Transformer", "backend"})
public final class PopBackwardPropagationTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        if (!OptimizationMethodVisitor.Companion.canBeOptimizedUsingSourceInterpreter(methodNode)) {
            return;
        }
        new Transformer(methodNode).transform();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0002G$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010$\u001a\u00020\u00062\u0014\b\u0004\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020'0&H\u0082\bJ\u001d\u0010(\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010)\u001a\u00020'H\u0002J\b\u0010*\u001a\u00020\u001fH\u0002J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0019H\u0002J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020\u0019H\u0002J\u0018\u00102\u001a\u0002012\u0006\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002012\u0006\u0010,\u001a\u00020\u0019H\u0002J\b\u00107\u001a\u00020'H\u0002J%\u00108\u001a\u00020'2\u0016\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f0\u000eH\u0002\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020'2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010;\u001a\u00020/H\u0002J\u001a\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020\u00192\b\u0010>\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010?\u001a\u00020\u0006H\u0002J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/H\u0002J \u0010A\u001a\u00020B2\b\u0010,\u001a\u0004\u0018\u00010\u00192\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0006\u0010D\u001a\u00020'J\u0012\u0010E\u001a\u00020'*\b\u0012\u0004\u0012\u00020\u00190FH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0018\u001a(\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00190\u0019 \u0017*\u0014\u0012\u000e\b\u0001\u0012\n \u0017*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00060\"j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0006`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer$Transformer;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "INSERT_POP1_AFTER", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer$Transformer$Transformation;", "INSERT_POP2_AFTER", "REPLACE_WITH_NOP", "REPLACE_WITH_POP1", "REPLACE_WITH_POP2", "dontTouchInsnIndices", "Ljava/util/BitSet;", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/SourceValue;", "getFrames", "()[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "frames$delegate", "Lkotlin/Lazy;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "insns", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "[Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "removableNops", "Ljava/util/HashSet;", "Lorg/jetbrains/org/objectweb/asm/tree/InsnNode;", "Lkotlin/collections/HashSet;", "transformations", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "Transformation", "body", "Lkotlin/Function1;", "", "analyzeMethodBody", "computeTransformations", "createRemovableNopInsn", "getInputTop", "insn", "insertPopAfterTransformation", "size", "", "isDontTouch", "", "isTransformableCheckcastOperand", "it", "resultType", "", "isTransformablePopOperand", "postprocessNops", "postprocessStackHazards", "([Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "propagatePopBackwards", "poppedValueSize", "removeUnneededNopsInRange", "begin", "end", "replaceWithNopTransformation", "replaceWithPopTransformation", "throwIncorrectBytecode", "", "frame", "transform", "markAsDontTouch", "", "HazardsTrackingInterpreter", "backend"})
    private static final class Transformer {
        @NotNull
        private final MethodNode methodNode;
        @NotNull
        private final Transformation REPLACE_WITH_NOP;
        @NotNull
        private final Transformation REPLACE_WITH_POP1;
        @NotNull
        private final Transformation REPLACE_WITH_POP2;
        @NotNull
        private final Transformation INSERT_POP1_AFTER;
        @NotNull
        private final Transformation INSERT_POP2_AFTER;
        private final InsnList insnList;
        private final AbstractInsnNode[] insns;
        @NotNull
        private final BitSet dontTouchInsnIndices;
        @NotNull
        private final HashMap<AbstractInsnNode, Transformation> transformations;
        @NotNull
        private final HashSet<InsnNode> removableNops;
        @NotNull
        private final Lazy frames$delegate;

        public Transformer(@NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            this.methodNode = methodNode;
            Transformer this_$iv = this;
            boolean $i$f$Transformation = false;
            this.REPLACE_WITH_NOP = new Transformation(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = transformer2;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                    AbstractInsnNode it = insn;
                    boolean bl = false;
                    Transformer.access$getInsnList$p(this.this$0).set(it, (AbstractInsnNode)Transformer.access$createRemovableNopInsn(this.this$0));
                }
            };
            this_$iv = this;
            $i$f$Transformation = false;
            this.REPLACE_WITH_POP1 = new Transformation(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = transformer2;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                    AbstractInsnNode it = insn;
                    boolean bl = false;
                    Transformer.access$getInsnList$p(this.this$0).set(it, (AbstractInsnNode)new InsnNode(87));
                }
            };
            this_$iv = this;
            $i$f$Transformation = false;
            this.REPLACE_WITH_POP2 = new Transformation(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = transformer2;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                    AbstractInsnNode it = insn;
                    boolean bl = false;
                    Transformer.access$getInsnList$p(this.this$0).set(it, (AbstractInsnNode)new InsnNode(88));
                }
            };
            this_$iv = this;
            $i$f$Transformation = false;
            this.INSERT_POP1_AFTER = new Transformation(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = transformer2;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                    AbstractInsnNode it = insn;
                    boolean bl = false;
                    Transformer.access$getInsnList$p(this.this$0).insert(it, (AbstractInsnNode)new InsnNode(87));
                }
            };
            this_$iv = this;
            $i$f$Transformation = false;
            this.INSERT_POP2_AFTER = new Transformation(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = transformer2;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                    AbstractInsnNode it = insn;
                    boolean bl = false;
                    Transformer.access$getInsnList$p(this.this$0).insert(it, (AbstractInsnNode)new InsnNode(88));
                }
            };
            this.insnList = this.methodNode.instructions;
            this.insns = this.insnList.toArray();
            this.dontTouchInsnIndices = new BitSet(this.insns.length);
            boolean bl = false;
            this.transformations = new HashMap();
            bl = false;
            this.removableNops = new HashSet();
            this.frames$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Frame<SourceValue>[]>(this){
                final /* synthetic */ Transformer this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Frame<SourceValue>[] invoke() {
                    return Transformer.access$analyzeMethodBody(this.this$0);
                }
            }));
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        private final Transformation Transformation(Function1<? super AbstractInsnNode, Unit> body2) {
            boolean $i$f$Transformation = false;
            return new Transformation(body2){
                final /* synthetic */ Function1<AbstractInsnNode, Unit> $body;
                {
                    this.$body = $body;
                }

                public void apply(@NotNull AbstractInsnNode insn) {
                    Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                    this.$body.invoke((Object)insn);
                }
            };
        }

        private final Frame<SourceValue>[] getFrames() {
            Lazy lazy = this.frames$delegate;
            boolean bl = false;
            return (Frame[])lazy.getValue();
        }

        public final void transform() {
            boolean bl;
            block3: {
                AbstractInsnNode[] abstractInsnNodeArray = this.insns;
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNodeArray, (String)"insns");
                Object[] $this$none$iv = abstractInsnNodeArray;
                boolean bl2 = false;
                for (Object element$iv : $this$none$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl22 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!(PopBackwardPropagationTransformerKt.isPop(it) || PopBackwardPropagationTransformerKt.isPurePush(it))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
            this.computeTransformations();
            for (Map.Entry entry : this.transformations.entrySet()) {
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"transformations.entries");
                Map.Entry entry2 = entry;
                int n = 0;
                AbstractInsnNode insn = (AbstractInsnNode)entry2.getKey();
                Map.Entry entry3 = entry;
                boolean bl3 = false;
                Transformation transformation = (Transformation)entry3.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                transformation.apply(insn);
            }
            this.postprocessNops();
        }

        private final Frame<SourceValue>[] analyzeMethodBody() {
            Frame[] frames2 = new Analyzer((Interpreter)new HazardsTrackingInterpreter()).analyze("fake", this.methodNode);
            Intrinsics.checkNotNullExpressionValue((Object)frames2, (String)"frames");
            this.postprocessStackHazards(frames2);
            return frames2;
        }

        private final void postprocessStackHazards(Frame<SourceValue>[] frames2) {
            AbstractInsnNode[] insns = this.methodNode.instructions.toArray();
            int n = 0;
            int n2 = frames2.length + -1;
            if (n <= n2) {
                block7: do {
                    int i;
                    Frame<SourceValue> frame;
                    if ((frame = frames2[i = n++]) == null) continue;
                    Frame<SourceValue> frame2 = frame;
                    AbstractInsnNode insn = insns[i];
                    int n3 = insn.getOpcode();
                    switch (n3) {
                        case 88: {
                            Set set;
                            SourceValue it;
                            List<SourceValue> list2 = StackTransformationUtilsKt.peekWords(frame2, 2);
                            if (list2 == null) {
                                this.throwIncorrectBytecode(insn, frame2);
                                throw null;
                            }
                            List<SourceValue> top2 = list2;
                            Iterable<Object> $this$forEach$iv = top2;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (SourceValue)element$iv;
                                boolean bl = false;
                                set = it.insns;
                                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.insns");
                                this.markAsDontTouch(set);
                            }
                            continue block7;
                        }
                        case 90: {
                            Set set;
                            SourceValue it;
                            Iterable<Object> $this$forEach$iv = StackTransformationUtilsKt.peekWords(frame2, 1, 1);
                            if ($this$forEach$iv == null) {
                                this.throwIncorrectBytecode(insn, frame2);
                                throw null;
                            }
                            List<SourceValue> top2 = $this$forEach$iv;
                            $this$forEach$iv = top2;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (SourceValue)element$iv;
                                boolean bl = false;
                                set = it.insns;
                                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.insns");
                                this.markAsDontTouch(set);
                            }
                            continue block7;
                        }
                        case 93: {
                            Set set;
                            SourceValue it;
                            Iterable<Object> $this$forEach$iv = StackTransformationUtilsKt.peekWords(frame2, 2, 1);
                            if ($this$forEach$iv == null) {
                                this.throwIncorrectBytecode(insn, frame2);
                                throw null;
                            }
                            List<SourceValue> top3 = $this$forEach$iv;
                            $this$forEach$iv = top3;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (SourceValue)element$iv;
                                boolean bl = false;
                                set = it.insns;
                                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.insns");
                                this.markAsDontTouch(set);
                            }
                            continue block7;
                        }
                        case 91: {
                            Set set;
                            SourceValue it;
                            Iterable<Object> $this$forEach$iv = StackTransformationUtilsKt.peekWords(frame2, 1, 2);
                            if ($this$forEach$iv == null) {
                                this.throwIncorrectBytecode(insn, frame2);
                                throw null;
                            }
                            List<SourceValue> top3 = $this$forEach$iv;
                            $this$forEach$iv = top3;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (SourceValue)element$iv;
                                boolean bl = false;
                                set = it.insns;
                                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.insns");
                                this.markAsDontTouch(set);
                            }
                            continue block7;
                        }
                        case 94: {
                            Set set;
                            SourceValue it;
                            Iterable<Object> $this$forEach$iv = StackTransformationUtilsKt.peekWords(frame2, 2, 2);
                            if ($this$forEach$iv == null) {
                                this.throwIncorrectBytecode(insn, frame2);
                                throw null;
                            }
                            List<SourceValue> top4 = $this$forEach$iv;
                            $this$forEach$iv = top4;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (SourceValue)element$iv;
                                boolean bl = false;
                                set = it.insns;
                                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.insns");
                                this.markAsDontTouch(set);
                            }
                        }
                    }
                } while (n <= n2);
            }
        }

        private final Void throwIncorrectBytecode(AbstractInsnNode insn, Frame<SourceValue> frame) {
            throw new AssertionError((Object)("Incorrect bytecode at " + this.methodNode.instructions.indexOf(insn) + ": " + UtilKt.getDebugText(insn) + ' ' + frame));
        }

        private final void markAsDontTouch(Collection<? extends AbstractInsnNode> $this$markAsDontTouch) {
            Iterable $this$forEach$iv = $this$markAsDontTouch;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbstractInsnNode it = (AbstractInsnNode)element$iv;
                boolean bl = false;
                this.dontTouchInsnIndices.set(this.insnList.indexOf(it), true);
            }
        }

        private final void computeTransformations() {
            this.transformations.clear();
            int n = 0;
            int n2 = this.insns.length + -1;
            if (n <= n2) {
                do {
                    AbstractInsnNode insn;
                    int i = n++;
                    if (this.getFrames()[i] == null || (insn = this.insns[i]).getOpcode() != 87) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                    this.propagatePopBackwards(insn, 0);
                } while (n <= n2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void propagatePopBackwards(AbstractInsnNode insn, int poppedValueSize) {
            if (this.transformations.containsKey(insn)) {
                return;
            }
            if (insn.getOpcode() == 87) {
                AbstractInsnNode it;
                Object element$iv2;
                boolean bl;
                SourceValue inputTop = this.getInputTop(insn);
                Set sources = inputTop.insns;
                Intrinsics.checkNotNullExpressionValue((Object)sources, (String)"sources");
                Iterable $this$all$iv = sources;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        it = (AbstractInsnNode)element$iv2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (this.isDontTouch(it)) return;
                        boolean bl3 = true;
                        if (bl3) continue;
                        return;
                    }
                    bl = true;
                }
                if (!bl) return;
                Object $this$any$iv = sources;
                boolean $i$f$any22 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return;
                    element$iv2 = iterator2.next();
                    it = (AbstractInsnNode)element$iv2;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                } while (!this.isTransformablePopOperand(it));
                boolean bl5 = true;
                if (!bl5) return;
                $this$any$iv = this.transformations;
                Transformation $i$f$any22 = this.replaceWithNopTransformation();
                boolean bl6 = false;
                $this$any$iv.put(insn, $i$f$any22);
                Iterable $this$forEach$iv = sources;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv.iterator();
                while (iterator3.hasNext()) {
                    element$iv2 = iterator3.next();
                    it = (AbstractInsnNode)element$iv2;
                    boolean bl7 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.propagatePopBackwards(it, inputTop.size);
                }
                return;
            }
            if (insn.getOpcode() == 192) {
                Object $this$forEach$iv;
                AbstractInsnNode it;
                boolean bl;
                String resultType;
                Set sources;
                SourceValue inputTop;
                block26: {
                    inputTop = this.getInputTop(insn);
                    sources = inputTop.insns;
                    resultType = ((TypeInsnNode)insn).desc;
                    Intrinsics.checkNotNullExpressionValue((Object)sources, (String)"sources");
                    Iterable $this$all$iv = sources;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (AbstractInsnNode)element$iv;
                            boolean bl8 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!this.isDontTouch(it)) continue;
                            bl = false;
                            break block26;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    boolean bl9;
                    Object $this$any$iv;
                    Object element$iv;
                    block27: {
                        $this$any$iv = sources;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl9 = false;
                        } else {
                            Iterator element$iv22 = $this$any$iv.iterator();
                            while (element$iv22.hasNext()) {
                                element$iv = element$iv22.next();
                                it = (AbstractInsnNode)element$iv;
                                boolean bl10 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                Intrinsics.checkNotNullExpressionValue((Object)resultType, (String)"resultType");
                                if (!this.isTransformableCheckcastOperand(it, resultType)) continue;
                                bl9 = true;
                                break block27;
                            }
                            bl9 = false;
                        }
                    }
                    if (bl9) {
                        $this$any$iv = this.transformations;
                        Transformation $i$f$any = this.replaceWithNopTransformation();
                        boolean element$iv22 = false;
                        $this$any$iv.put(insn, $i$f$any);
                        $this$forEach$iv = sources;
                        boolean $i$f$forEach = false;
                        Iterator element$iv22 = $this$forEach$iv.iterator();
                        while (element$iv22.hasNext()) {
                            element$iv = element$iv22.next();
                            it = (AbstractInsnNode)element$iv;
                            boolean bl11 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            this.propagatePopBackwards(it, inputTop.size);
                        }
                        return;
                    }
                }
                $this$forEach$iv = this.transformations;
                Transformation transformation = this.insertPopAfterTransformation(poppedValueSize);
                boolean element$iv22 = false;
                $this$forEach$iv.put(insn, transformation);
                return;
            }
            if (BoxingInterpreterKt.isPrimitiveBoxing(insn)) {
                int boxedValueSize = this.getInputTop((AbstractInsnNode)insn).size;
                Map sources = this.transformations;
                Transformation resultType = this.replaceWithPopTransformation(boxedValueSize);
                boolean $this$forEach$iv = false;
                sources.put(insn, resultType);
                return;
            }
            if (PopBackwardPropagationTransformerKt.isPurePush(insn)) {
                Map boxedValueSize = this.transformations;
                Transformation sources = this.replaceWithNopTransformation();
                boolean resultType = false;
                boxedValueSize.put(insn, sources);
                return;
            }
            if (PopBackwardPropagationTransformerKt.isPrimitiveTypeConversion(insn)) {
                AbstractInsnNode it;
                Object element$iv;
                boolean bl;
                Object $this$all$iv;
                Set sources;
                SourceValue inputTop;
                block28: {
                    inputTop = this.getInputTop(insn);
                    sources = inputTop.insns;
                    Intrinsics.checkNotNullExpressionValue((Object)sources, (String)"sources");
                    $this$all$iv = sources;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator iterator4 = $this$all$iv.iterator();
                        while (iterator4.hasNext()) {
                            element$iv = iterator4.next();
                            it = (AbstractInsnNode)element$iv;
                            boolean bl12 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!this.isDontTouch(it)) continue;
                            bl = false;
                            break block28;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    $this$all$iv = this.transformations;
                    Transformation $i$f$all = this.replaceWithNopTransformation();
                    boolean bl13 = false;
                    $this$all$iv.put(insn, $i$f$all);
                    Iterable $this$forEach$iv = sources;
                    boolean $i$f$forEach = false;
                    Iterator iterator5 = $this$forEach$iv.iterator();
                    while (iterator5.hasNext()) {
                        element$iv = iterator5.next();
                        it = (AbstractInsnNode)element$iv;
                        boolean bl14 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        this.propagatePopBackwards(it, inputTop.size);
                    }
                    return;
                }
                Map map = this.transformations;
                Transformation transformation = this.replaceWithPopTransformation(poppedValueSize);
                boolean bl15 = false;
                map.put(insn, transformation);
                return;
            }
            Map map = this.transformations;
            Transformation transformation = this.insertPopAfterTransformation(poppedValueSize);
            boolean bl = false;
            map.put(insn, transformation);
        }

        private final void postprocessNops() {
            AbstractInsnNode abstractInsnNode;
            AbstractInsnNode node = this.insnList.getFirst();
            boolean hasRemovableNops = false;
            while (node != null && (abstractInsnNode = (node = node.getNext())) != null) {
                AbstractInsnNode begin = abstractInsnNode;
                while (node != null && !(node instanceof LabelNode)) {
                    if (CollectionsKt.contains((Iterable)this.removableNops, (Object)node)) {
                        hasRemovableNops = true;
                    }
                    node = node.getNext();
                }
                AbstractInsnNode end = node;
                if (hasRemovableNops) {
                    this.removeUnneededNopsInRange(begin, end);
                }
                hasRemovableNops = false;
            }
        }

        private final void removeUnneededNopsInRange(AbstractInsnNode begin, AbstractInsnNode end) {
            AbstractInsnNode node = begin;
            boolean keepNop = true;
            while (node != null && !Intrinsics.areEqual((Object)node, (Object)end)) {
                if (CollectionsKt.contains((Iterable)this.removableNops, (Object)node) && !keepNop) {
                    InsnList insnList = this.insnList;
                    Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"insnList");
                    node = LabelNormalizationMethodTransformerKt.removeNodeGetNext(insnList, node);
                    continue;
                }
                if (UtilKt.isMeaningful(node)) {
                    keepNop = false;
                }
                node = node.getNext();
            }
        }

        private final Transformation replaceWithPopTransformation(int size) {
            Transformation transformation;
            int n = size;
            switch (n) {
                case 1: {
                    transformation = this.REPLACE_WITH_POP1;
                    break;
                }
                case 2: {
                    transformation = this.REPLACE_WITH_POP2;
                    break;
                }
                default: {
                    throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected pop value size: ", (Object)size));
                }
            }
            return transformation;
        }

        private final Transformation insertPopAfterTransformation(int size) {
            Transformation transformation;
            int n = size;
            switch (n) {
                case 1: {
                    transformation = this.INSERT_POP1_AFTER;
                    break;
                }
                case 2: {
                    transformation = this.INSERT_POP2_AFTER;
                    break;
                }
                default: {
                    throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected pop value size: ", (Object)size));
                }
            }
            return transformation;
        }

        private final Transformation replaceWithNopTransformation() {
            return this.REPLACE_WITH_NOP;
        }

        private final InsnNode createRemovableNopInsn() {
            InsnNode insnNode = new InsnNode(0);
            boolean bl = false;
            boolean bl2 = false;
            InsnNode $this$createRemovableNopInsn_u24lambda_u2d20 = insnNode;
            boolean bl3 = false;
            this.removableNops.add($this$createRemovableNopInsn_u24lambda_u2d20);
            return insnNode;
        }

        private final SourceValue getInputTop(AbstractInsnNode insn) {
            int i = this.insnList.indexOf(insn);
            SourceValue sourceValue = this.getFrames()[i];
            if (sourceValue == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected dead instruction #", (Object)i));
            }
            SourceValue frame = sourceValue;
            if ((sourceValue = StackTransformationUtilsKt.top(frame)) == null) {
                throw new AssertionError((Object)("Instruction #" + i + " has empty stack on input"));
            }
            return sourceValue;
        }

        private final boolean isTransformableCheckcastOperand(AbstractInsnNode it, String resultType) {
            return BoxingInterpreterKt.isPrimitiveBoxing(it) && Intrinsics.areEqual((Object)((MethodInsnNode)it).owner, (Object)resultType);
        }

        private final boolean isTransformablePopOperand(AbstractInsnNode insn) {
            return insn.getOpcode() == 192 || BoxingInterpreterKt.isPrimitiveBoxing(insn) || PopBackwardPropagationTransformerKt.isPurePush(insn);
        }

        private final boolean isDontTouch(AbstractInsnNode insn) {
            return this.dontTouchInsnIndices.get(this.insnList.indexOf(insn));
        }

        public static final /* synthetic */ InsnList access$getInsnList$p(Transformer $this) {
            return $this.insnList;
        }

        public static final /* synthetic */ InsnNode access$createRemovableNopInsn(Transformer $this) {
            return $this.createRemovableNopInsn();
        }

        public static final /* synthetic */ Frame[] access$analyzeMethodBody(Transformer $this) {
            return $this.analyzeMethodBody();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer$Transformer$Transformation;", "", "apply", "", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "backend"})
        private static interface Transformation {
            public void apply(@NotNull AbstractInsnNode var1);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\rH\u0016J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer$Transformer$HazardsTrackingInterpreter;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/SourceInterpreter;", "(Lorg/jetbrains/kotlin/codegen/optimization/boxing/PopBackwardPropagationTransformer$Transformer;)V", "binaryOperation", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/SourceValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "value1", "value2", "copyOperation", "value", "naryOperation", "values", "", "ternaryOperation", "value3", "unaryOperation", "backend"})
        private final class HazardsTrackingInterpreter
        extends SourceInterpreter {
            public HazardsTrackingInterpreter() {
                Intrinsics.checkNotNullParameter((Object)Transformer.this, (String)"this$0");
                super(589824);
            }

            @NotNull
            public SourceValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends SourceValue> values) {
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                Intrinsics.checkNotNullParameter(values, (String)"values");
                for (SourceValue sourceValue : values) {
                    Set set = sourceValue.insns;
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value.insns");
                    Transformer.this.markAsDontTouch(set);
                }
                SourceValue sourceValue = super.naryOperation(insn, values);
                Intrinsics.checkNotNullExpressionValue((Object)sourceValue, (String)"super.naryOperation(insn, values)");
                return sourceValue;
            }

            @NotNull
            public SourceValue copyOperation(@NotNull AbstractInsnNode insn, @NotNull SourceValue value2) {
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Set set = value2.insns;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value.insns");
                Transformer.this.markAsDontTouch(set);
                set = super.copyOperation(insn, value2);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"super.copyOperation(insn, value)");
                return set;
            }

            @NotNull
            public SourceValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull SourceValue value2) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                if (insn.getOpcode() != 192 && !PopBackwardPropagationTransformerKt.isPrimitiveTypeConversion(insn)) {
                    object = value2.insns;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value.insns");
                    Transformer.this.markAsDontTouch((Collection)object);
                }
                object = super.unaryOperation(insn, value2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"super.unaryOperation(insn, value)");
                return object;
            }

            @NotNull
            public SourceValue binaryOperation(@NotNull AbstractInsnNode insn, @NotNull SourceValue value1, @NotNull SourceValue value2) {
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                Intrinsics.checkNotNullParameter((Object)value1, (String)"value1");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value2");
                Set set = value1.insns;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value1.insns");
                Transformer.this.markAsDontTouch(set);
                set = value2.insns;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value2.insns");
                Transformer.this.markAsDontTouch(set);
                set = super.binaryOperation(insn, value1, value2);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"super.binaryOperation(insn, value1, value2)");
                return set;
            }

            @NotNull
            public SourceValue ternaryOperation(@NotNull AbstractInsnNode insn, @NotNull SourceValue value1, @NotNull SourceValue value2, @NotNull SourceValue value3) {
                Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                Intrinsics.checkNotNullParameter((Object)value1, (String)"value1");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value2");
                Intrinsics.checkNotNullParameter((Object)value3, (String)"value3");
                Set set = value1.insns;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value1.insns");
                Transformer.this.markAsDontTouch(set);
                set = value2.insns;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value2.insns");
                Transformer.this.markAsDontTouch(set);
                set = value3.insns;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value3.insns");
                Transformer.this.markAsDontTouch(set);
                set = super.ternaryOperation(insn, value1, value2, value3);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"super.ternaryOperation(insn, value1, value2, value3)");
                return set;
            }
        }
    }
}

