/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdkVendorDetector {
    static final Vendor ORACLE = new Vendor("oracle", null, false);
    static final Vendor CORRETTO = new Vendor("corretto", "Amazon Corretto", true);
    static final Vendor LIBERICA = new Vendor("liberica", "BellSoft Liberica JDK", true);
    static final Vendor SAP = new Vendor("sapmachine", "SAP SapMachine", true);
    static final Vendor AZUL = new Vendor("azul", "Azul Zulu Community\u2122", true);
    private static final VendorCase[] VENDOR_CASES = new VendorCase[]{new VendorCase(CORRETTO, new PropertyPattern("IMPLEMENTOR", "^Amazon([\\s.].*)?$")), new VendorCase(CORRETTO, new PropertyPattern("IMPLEMENTOR_VERSION", "^Corretto-.*$")), new VendorCase(LIBERICA, new PropertyPattern("IMPLEMENTOR", "^.*BellSoft.*$")), new VendorCase(SAP, new PropertyPattern("IMPLEMENTOR", "^SAP(\\s.*)?$")), new VendorCase(SAP, new PropertyPattern("IMPLEMENTOR_VERSION", "^SapMachine.*$")), new VendorCase(AZUL, new PropertyPattern("IMPLEMENTOR", "^Azul(\\s.*)?$")), new VendorCase(ORACLE, new PropertyPattern("SOURCE", "^.*\\shotspot:[0-9A-Fa-f]+.*$"), new PropertyPattern("JAVA_VERSION", "^1\\.7\\..*$")), new VendorCase(ORACLE, new PropertyPattern("SOURCE", "^.*\\shotspot:[0-9A-Fa-f]+.*$"), new PropertyPattern("BUILD_TYPE", "^.*commercial.*$"))};

    @Nullable
    public static Vendor detectJdkVendorByReleaseFile(@NotNull Properties properties2) {
        if (properties2 == null) {
            JdkVendorDetector.$$$reportNull$$$0(0);
        }
        Map<String, String> ps = JdkVendorDetector.normalizeProperties(properties2);
        for (VendorCase vc : VENDOR_CASES) {
            if (!JdkVendorDetector.checkMatching(ps, vc.patterns)) continue;
            return vc.vendor;
        }
        return null;
    }

    private static boolean checkMatching(@NotNull Map<String, String> properties2, @NotNull Collection<PropertyPattern> patterns2) {
        if (properties2 == null) {
            JdkVendorDetector.$$$reportNull$$$0(1);
        }
        if (patterns2 == null) {
            JdkVendorDetector.$$$reportNull$$$0(2);
        }
        for (PropertyPattern pp : patterns2) {
            String propertyValue = properties2.get(pp.name);
            if (propertyValue == null) {
                return false;
            }
            if (pp.pattern.matcher(propertyValue).matches()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, String> normalizeProperties(@NotNull Properties properties2) {
        if (properties2 == null) {
            JdkVendorDetector.$$$reportNull$$$0(3);
        }
        TreeMap<String, String> ps = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<Object, Object> e : properties2.entrySet()) {
            Object val;
            Object key = e.getKey();
            if (key == null || (val = e.getValue()) == null) continue;
            String name2 = key.toString();
            String value2 = StringUtil.unquoteString((String)val.toString());
            ps.put(name2, value2);
        }
        TreeMap<String, String> treeMap = ps;
        if (treeMap == null) {
            JdkVendorDetector.$$$reportNull$$$0(4);
        }
        return treeMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/JdkVendorDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/JdkVendorDetector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectJdkVendorByReleaseFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkMatching";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "normalizeProperties";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PropertyPattern {
        @NotNull
        final String name;
        @NotNull
        final Pattern pattern;

        private PropertyPattern(@NotNull String name2, @NotNull @Language(value="RegExp") String pattern) {
            if (name2 == null) {
                PropertyPattern.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                PropertyPattern.$$$reportNull$$$0(1);
            }
            this.name = name2;
            this.pattern = Pattern.compile(pattern);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pattern";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/model/java/impl/JdkVendorDetector$PropertyPattern";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VendorCase {
        @NotNull
        final Vendor vendor;
        @NotNull
        final @NotNull Collection<@NotNull PropertyPattern> patterns;

        VendorCase(@NotNull Vendor vendor, @NotNull PropertyPattern pattern) {
            if (vendor == null) {
                VendorCase.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                VendorCase.$$$reportNull$$$0(1);
            }
            this.vendor = vendor;
            this.patterns = Collections.singleton(pattern);
        }

        VendorCase(@NotNull Vendor vendor, @NotNull PropertyPattern pattern1, @NotNull PropertyPattern pattern2) {
            if (vendor == null) {
                VendorCase.$$$reportNull$$$0(2);
            }
            if (pattern1 == null) {
                VendorCase.$$$reportNull$$$0(3);
            }
            if (pattern2 == null) {
                VendorCase.$$$reportNull$$$0(4);
            }
            this.vendor = vendor;
            this.patterns = Arrays.asList(pattern1, pattern2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vendor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pattern";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pattern1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pattern2";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/model/java/impl/JdkVendorDetector$VendorCase";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class Vendor {
        @NotNull
        public final String code;
        @Nullable
        public final String displayName;
        public final boolean includeCodeInPrefix;

        Vendor(@NotNull String code, @Nullable String displayName, boolean includeCodeInPrefix) {
            if (code == null) {
                Vendor.$$$reportNull$$$0(0);
            }
            this.code = code;
            this.displayName = displayName;
            this.includeCodeInPrefix = includeCodeInPrefix;
        }

        @Nullable
        public String getPrefix() {
            return this.includeCodeInPrefix ? this.code : null;
        }

        public String toString() {
            String s = (this.includeCodeInPrefix ? (char)'+' : '-') + this.code;
            if (this.displayName != null) {
                s = s + ':' + this.displayName;
            }
            return s;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "org/jetbrains/jps/model/java/impl/JdkVendorDetector$Vendor", "<init>"));
        }
    }
}

