/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLowering;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u0015\u001a\u00020\u000e*\u00020\nH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "buildInitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "createInitFunction", "", "lower", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "openInitializerBox", "addInternalValueParameters", "hasStrictSignature", "", "CallSiteTransformer", "ES6_INIT_BOX_PARAMETER", "ES6_RESULT_TYPE_PARAMETER", "ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION", "backend.js"})
public final class ES6AddInternalParametersToConstructorPhase
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public ES6AddInternalParametersToConstructorPhase(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        if (!this.context.getEs6mode()) {
            return;
        }
        container2.transform(new CallSiteTransformer(), null);
        if (!(container2 instanceof IrConstructor)) {
            return;
        }
        if (!this.hasStrictSignature((IrConstructor)container2)) {
            this.addInternalValueParameters((IrConstructor)container2);
        }
        if (container2.getOrigin() == PrimaryConstructorLowering.SYNTHETIC_PRIMARY_CONSTRUCTOR.INSTANCE) {
            this.createInitFunction((IrConstructor)container2);
            this.openInitializerBox((IrConstructor)container2);
        }
    }

    private final void addInternalValueParameters(IrConstructor $this$addInternalValueParameters) {
        DeclarationBuildersKt.addValueParameter((IrFunction)$this$addInternalValueParameters, "box", (IrType)this.context.getDynamicType(), (IrDeclarationOrigin)ES6_INIT_BOX_PARAMETER.INSTANCE);
        if (!$this$addInternalValueParameters.isPrimary()) {
            DeclarationBuildersKt.addValueParameter((IrFunction)$this$addInternalValueParameters, "resultType", (IrType)this.context.getDynamicType(), (IrDeclarationOrigin)ES6_RESULT_TYPE_PARAMETER.INSTANCE);
        }
    }

    private final void createInitFunction(IrConstructor constructor2) {
        IrClass irClass2 = IrUtilsKt.getParentAsClass(constructor2);
        IrSimpleFunction initFunction = this.buildInitFunction(constructor2, irClass2);
        IrClass irClass3 = irClass2;
        Collection collection = irClass3.getDeclarations();
        boolean bl = false;
        collection.add(initFunction);
        this.context.getMapping().getConstructorToInitFunction().set((IrConstructor)((IrDeclaration)constructor2), initFunction);
        initFunction.transformChildren(new IrElementTransformerVoid(initFunction){
            final /* synthetic */ IrSimpleFunction $initFunction;
            {
                this.$initFunction = $initFunction;
            }

            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                declaration2.setParent(this.$initFunction);
                return declaration2;
            }
        }, null);
    }

    private final void openInitializerBox(IrConstructor constructor2) {
        IrBody irBody = constructor2.getBody();
        if (irBody == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        }
        irBody = (IrBlockBody)irBody;
        boolean bl = false;
        boolean bl2 = false;
        IrBody $this$openInitializerBox_u24lambda_u2d1 = irBody;
        boolean bl3 = false;
        $this$openInitializerBox_u24lambda_u2d1.getStatements().clear();
        IrBody irBody2 = $this$openInitializerBox_u24lambda_u2d1;
        Collection collection = irBody2.getStatements();
        IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.getContext().getIntrinsics().getJsOpenInitializerBox(), null, null, 6, null);
        boolean bl4 = false;
        boolean bl5 = false;
        IrCall it = irCall;
        boolean bl6 = false;
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(constructor2).getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        it.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irValueParameter.getSymbol()));
        it.putValueArgument(1, JsIrBuilder.INSTANCE.buildGetValue(((IrValueParameter)CollectionsKt.last(constructor2.getValueParameters())).getSymbol()));
        bl4 = false;
        collection.add(irCall);
    }

    private final IrSimpleFunction buildInitFunction(IrConstructor constructor2, IrClass irClass2) {
        String functionName = irClass2.getName() + "_init";
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d14$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$buildInitFunction_u24lambda_u2d2 = $this$buildFun_u24lambda_u2d14$iv;
        boolean bl4 = false;
        Object object = Name.identifier(functionName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(functionName)");
        $this$buildInitFunction_u24lambda_u2d2.setName((Name)object);
        $this$buildInitFunction_u24lambda_u2d2.setReturnType(this.getContext().getIrBuiltIns().getUnitType());
        object = DescriptorVisibilities.PROTECTED;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PROTECTED");
        $this$buildInitFunction_u24lambda_u2d2.setVisibility((DescriptorVisibility)object);
        $this$buildInitFunction_u24lambda_u2d2.setModality(Modality.FINAL);
        $this$buildInitFunction_u24lambda_u2d2.setInline(constructor2.isInline());
        $this$buildInitFunction_u24lambda_u2d2.setExternal(constructor2.isExternal());
        $this$buildInitFunction_u24lambda_u2d2.setOrigin(ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION.INSTANCE);
        IrSimpleFunction irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d14$iv);
        boolean bl5 = false;
        boolean bl6 = false;
        IrSimpleFunction $this$buildInitFunction_u24lambda_u2d3 = irSimpleFunction;
        boolean bl7 = false;
        $this$buildInitFunction_u24lambda_u2d3.setParent(irClass2);
        DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$buildInitFunction_u24lambda_u2d3, "$this$", (IrType)this.getContext().getDynamicType(), null, 4, null);
        IrFactory irFactory = this.getContext().getIrFactory();
        Object object2 = constructor2.getBody();
        object2 = object2 == null ? null : IrUtilsKt.getStatements((IrBody)object2);
        boolean bl8 = false;
        Object object3 = object2;
        if (object3 == null) {
            object3 = CollectionsKt.emptyList();
        }
        $this$buildInitFunction_u24lambda_u2d3.setBody(irFactory.createBlockBody(-1, -1, (List<? extends IrStatement>)object3));
        $this$buildInitFunction_u24lambda_u2d3.transformChildren(new IrElementTransformerVoid(constructor2, $this$buildInitFunction_u24lambda_u2d3){
            final /* synthetic */ IrConstructor $constructor;
            final /* synthetic */ IrSimpleFunction $this_apply;
            {
                this.$constructor = $constructor;
                this.$this_apply = $receiver;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                IrDeclarationBase irDeclarationBase = IrUtilsKt.getParentAsClass(this.$constructor).getThisReceiver();
                Intrinsics.checkNotNull((Object)irDeclarationBase);
                if (irValueDeclaration == irDeclarationBase) {
                    irDeclarationBase = this.$this_apply;
                    boolean bl = false;
                    boolean bl2 = false;
                    IrGetValue $this$visitGetValue_u24lambda_u2d0 = expression2;
                    boolean bl3 = false;
                    irExpression = new IrGetValueImpl($this$visitGetValue_u24lambda_u2d0.getStartOffset(), $this$visitGetValue_u24lambda_u2d0.getEndOffset(), $this$visitGetValue_u24lambda_u2d0.getType(), ((IrValueParameter)CollectionsKt.single(((IrFunction)irDeclarationBase).getValueParameters())).getSymbol(), null, 16, null);
                } else {
                    irExpression = expression2;
                }
                return irExpression;
            }
        }, null);
        return irSimpleFunction;
    }

    private final boolean hasStrictSignature(IrConstructor $this$hasStrictSignature) {
        Object object = this.context.getIrBuiltIns();
        boolean bl = false;
        boolean bl2 = false;
        IrBuiltIns $this$hasStrictSignature_u24lambda_u2d4 = object;
        boolean bl3 = false;
        List primitives = CollectionsKt.plus((Collection)$this$hasStrictSignature_u24lambda_u2d4.getPrimitiveArrays(), (Object)$this$hasStrictSignature_u24lambda_u2d4.getStringClass());
        object = IrUtilsKt.getParentAsClass($this$hasStrictSignature);
        bl = false;
        bl2 = false;
        Object $this$hasStrictSignature_u24lambda_u2d5 = object;
        boolean bl4 = false;
        return ((IrClass)$this$hasStrictSignature_u24lambda_u2d5).isExternal() || ((IrClass)$this$hasStrictSignature_u24lambda_u2d5).isInline() || primitives.contains(((IrClass)$this$hasStrictSignature_u24lambda_u2d5).getSymbol());
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
    public static final class ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION
    extends IrDeclarationOriginImpl {
        @NotNull
        public static final ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION INSTANCE = new ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION();

        private ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION() {
            super("ES6_SYNTHETIC_PRIMARY_INIT_FUNCTION", false, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$ES6_INIT_BOX_PARAMETER;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
    public static final class ES6_INIT_BOX_PARAMETER
    extends IrDeclarationOriginImpl {
        @NotNull
        public static final ES6_INIT_BOX_PARAMETER INSTANCE = new ES6_INIT_BOX_PARAMETER();

        private ES6_INIT_BOX_PARAMETER() {
            super("ES6_INIT_BOX_PARAMETER", false, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$ES6_RESULT_TYPE_PARAMETER;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
    public static final class ES6_RESULT_TYPE_PARAMETER
    extends IrDeclarationOriginImpl {
        @NotNull
        public static final ES6_RESULT_TYPE_PARAMETER INSTANCE = new ES6_RESULT_TYPE_PARAMETER();

        private ES6_RESULT_TYPE_PARAMETER() {
            super("ES6_RESULT_TYPE_PARAMETER", false, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase$CallSiteTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddInternalParametersToConstructorPhase;)V", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "backend.js"})
    public final class CallSiteTransformer
    extends IrElementTransformerVoid {
        public CallSiteTransformer() {
            Intrinsics.checkNotNullParameter((Object)ES6AddInternalParametersToConstructorPhase.this, (String)"this$0");
        }

        @Override
        @NotNull
        public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrConstructor constructor2 = (IrConstructor)expression2.getSymbol().getOwner();
            IrClass parent2 = IrUtilsKt.getParentAsClass(constructor2);
            if (ES6AddInternalParametersToConstructorPhase.this.hasStrictSignature(constructor2) || IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(parent2))) {
                return expression2;
            }
            int newArgsCount = constructor2.isPrimary() ? 1 : 2;
            IrConstructorCall irConstructorCall = expression2;
            ES6AddInternalParametersToConstructorPhase eS6AddInternalParametersToConstructorPhase = ES6AddInternalParametersToConstructorPhase.this;
            boolean bl = false;
            boolean bl2 = false;
            IrConstructorCall $this$visitConstructorCall_u24lambda_u2d1 = irConstructorCall;
            boolean bl3 = false;
            IrConstructorCallImpl irConstructorCallImpl = new IrConstructorCallImpl($this$visitConstructorCall_u24lambda_u2d1.getStartOffset(), $this$visitConstructorCall_u24lambda_u2d1.getEndOffset(), $this$visitConstructorCall_u24lambda_u2d1.getType(), $this$visitConstructorCall_u24lambda_u2d1.getSymbol(), $this$visitConstructorCall_u24lambda_u2d1.getTypeArgumentsCount(), $this$visitConstructorCall_u24lambda_u2d1.getConstructorTypeArgumentsCount(), $this$visitConstructorCall_u24lambda_u2d1.getValueArgumentsCount() + newArgsCount, null, 128, null);
            boolean bl4 = false;
            boolean bl5 = false;
            IrConstructorCallImpl it = irConstructorCallImpl;
            boolean bl6 = false;
            int n = 0;
            int n2 = $this$visitConstructorCall_u24lambda_u2d1.getValueArgumentsCount();
            if (n < n2) {
                do {
                    int i = n++;
                    it.putValueArgument(i, $this$visitConstructorCall_u24lambda_u2d1.getValueArgument(i));
                } while (n < n2);
            }
            it.putValueArgument($this$visitConstructorCall_u24lambda_u2d1.getValueArgumentsCount(), JsIrBuilder.INSTANCE.buildNull(eS6AddInternalParametersToConstructorPhase.getContext().getDynamicType()));
            if (!constructor2.isPrimary()) {
                it.putValueArgument($this$visitConstructorCall_u24lambda_u2d1.getValueArgumentsCount() + 1, JsIrBuilder.INSTANCE.buildNull(eS6AddInternalParametersToConstructorPhase.getContext().getDynamicType()));
            }
            return irConstructorCallImpl;
        }

        @Override
        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrConstructor constructor2 = (IrConstructor)expression2.getSymbol().getOwner();
            IrClass parent2 = IrUtilsKt.getParentAsClass(constructor2);
            if (ES6AddInternalParametersToConstructorPhase.this.hasStrictSignature(constructor2) || IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(parent2))) {
                return expression2;
            }
            int newArgsCount = constructor2.isPrimary() ? 1 : 2;
            IrDelegatingConstructorCall irDelegatingConstructorCall = expression2;
            ES6AddInternalParametersToConstructorPhase eS6AddInternalParametersToConstructorPhase = ES6AddInternalParametersToConstructorPhase.this;
            boolean bl = false;
            boolean bl2 = false;
            IrDelegatingConstructorCall $this$visitDelegatingConstructorCall_u24lambda_u2d3 = irDelegatingConstructorCall;
            boolean bl3 = false;
            IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl = new IrDelegatingConstructorCallImpl($this$visitDelegatingConstructorCall_u24lambda_u2d3.getStartOffset(), $this$visitDelegatingConstructorCall_u24lambda_u2d3.getEndOffset(), $this$visitDelegatingConstructorCall_u24lambda_u2d3.getType(), $this$visitDelegatingConstructorCall_u24lambda_u2d3.getSymbol(), $this$visitDelegatingConstructorCall_u24lambda_u2d3.getTypeArgumentsCount(), $this$visitDelegatingConstructorCall_u24lambda_u2d3.getValueArgumentsCount() + newArgsCount);
            boolean bl4 = false;
            boolean bl5 = false;
            IrDelegatingConstructorCallImpl it = irDelegatingConstructorCallImpl;
            boolean bl6 = false;
            int n = 0;
            int n2 = $this$visitDelegatingConstructorCall_u24lambda_u2d3.getValueArgumentsCount();
            if (n < n2) {
                do {
                    int i = n++;
                    it.putValueArgument(i, $this$visitDelegatingConstructorCall_u24lambda_u2d3.getValueArgument(i));
                } while (n < n2);
            }
            it.putValueArgument($this$visitDelegatingConstructorCall_u24lambda_u2d3.getValueArgumentsCount(), JsIrBuilder.INSTANCE.buildNull(eS6AddInternalParametersToConstructorPhase.getContext().getDynamicType()));
            if (!constructor2.isPrimary()) {
                it.putValueArgument($this$visitDelegatingConstructorCall_u24lambda_u2d3.getValueArgumentsCount() + 1, JsIrBuilder.INSTANCE.buildNull(eS6AddInternalParametersToConstructorPhase.getContext().getDynamicType()));
            }
            return irDelegatingConstructorCallImpl;
        }
    }
}

