/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.nullCheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.Nullability;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullabilityInterpreter;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullabilityValuesKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "TransformerPass", "backend"})
public final class RedundantNullCheckMethodTransformer
extends MethodTransformer {
    @NotNull
    private final GenerationState generationState;

    public RedundantNullCheckMethodTransformer(@NotNull GenerationState generationState) {
        Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
        this.generationState = generationState;
    }

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        while (new TransformerPass(internalClassName, methodNode, this.generationState).run()) {
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0002'(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J\u0006\u0010\u0015\u001a\u00020\nJ \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001f\u001a\u00020\u00172\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\nH\u0002J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020$2\u0006\u0010%\u001a\u00020\nH\u0002J\f\u0010&\u001a\u00020\n*\u00020\u0013H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass;", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "changes", "", "getGenerationState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getInternalClassName", "()Ljava/lang/String;", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "analyzeNullabilities", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/kotlin/codegen/optimization/common/StrictBasicValue;", "run", "transformInstanceOf", "", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/TypeInsnNode;", "nullability", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/Nullability;", "value", "transformTrivialCheckExpressionValueIsNotNull", "transformTrivialCheckNotNull", "transformTrivialChecks", "nullabilityMap", "transformTrivialInstanceOf", "constValue", "transformTrivialNullJump", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "alwaysTrue", "isOptimizable", "NullabilityAssumptions", "NullabilityAssumptionsBuilder", "backend"})
    private static final class TransformerPass {
        @NotNull
        private final String internalClassName;
        @NotNull
        private final MethodNode methodNode;
        @NotNull
        private final GenerationState generationState;
        private boolean changes;

        public TransformerPass(@NotNull String internalClassName, @NotNull MethodNode methodNode, @NotNull GenerationState generationState) {
            Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
            this.internalClassName = internalClassName;
            this.methodNode = methodNode;
            this.generationState = generationState;
        }

        @NotNull
        public final String getInternalClassName() {
            return this.internalClassName;
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        @NotNull
        public final GenerationState getGenerationState() {
            return this.generationState;
        }

        public final boolean run() {
            boolean bl;
            block2: {
                AbstractInsnNode[] abstractInsnNodeArray = this.methodNode.instructions.toArray();
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNodeArray, (String)"methodNode.instructions.toArray()");
                Object[] $this$none$iv = abstractInsnNodeArray;
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!this.isOptimizable(it)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (bl) {
                return false;
            }
            NullabilityAssumptions nullabilityAssumptions = new NullabilityAssumptionsBuilder().injectNullabilityAssumptions();
            Map<AbstractInsnNode, StrictBasicValue> nullabilityMap = this.analyzeNullabilities();
            nullabilityAssumptions.revert();
            this.transformTrivialChecks(nullabilityMap);
            return this.changes;
        }

        private final Map<AbstractInsnNode, StrictBasicValue> analyzeNullabilities() {
            Frame<V>[] frameArray = MethodTransformer.analyze(this.internalClassName, this.methodNode, new NullabilityInterpreter(this.generationState));
            Intrinsics.checkNotNullExpressionValue(frameArray, (String)"analyze(internalClassName, methodNode, NullabilityInterpreter(generationState))");
            Frame<V>[] frames2 = frameArray;
            AbstractInsnNode[] insns = this.methodNode.instructions.toArray();
            LinkedHashMap nullabilityMap = new LinkedHashMap();
            int n = 0;
            int n2 = insns.length + -1;
            if (n <= n2) {
                do {
                    StrictBasicValue value2;
                    Nullability nullability;
                    StrictBasicValue strictBasicValue;
                    int i;
                    Frame frame;
                    if ((frame = frames2[i = n++]) == null) continue;
                    Frame frame2 = frame;
                    AbstractInsnNode insn = insns[i];
                    Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                    Object object = RedundantNullCheckMethodTransformerKt.isInstanceOfOrNullCheck(insn) ? (BasicValue)StackTransformationUtilsKt.top(frame2) : (RedundantNullCheckMethodTransformerKt.isCheckNotNull(insn) ? (BasicValue)StackTransformationUtilsKt.top(frame2) : (RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull(insn) ? (BasicValue)StackTransformationUtilsKt.peek(frame2, 1) : null));
                    StrictBasicValue strictBasicValue2 = strictBasicValue = object instanceof StrictBasicValue ? (StrictBasicValue)((Object)object) : null;
                    if (strictBasicValue == null || (nullability = NullabilityValuesKt.getNullability(value2 = strictBasicValue)) == Nullability.NULLABLE) continue;
                    object = nullabilityMap;
                    AbstractInsnNode abstractInsnNode = insn;
                    boolean bl = false;
                    object.put(abstractInsnNode, value2);
                } while (n <= n2);
            }
            return nullabilityMap;
        }

        private final boolean isOptimizable(AbstractInsnNode $this$isOptimizable) {
            return $this$isOptimizable.getOpcode() == 198 || $this$isOptimizable.getOpcode() == 199 || $this$isOptimizable.getOpcode() == 193 || RedundantNullCheckMethodTransformerKt.isCheckNotNull($this$isOptimizable) || RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull($this$isOptimizable);
        }

        private final void transformTrivialChecks(Map<AbstractInsnNode, ? extends StrictBasicValue> nullabilityMap) {
            Object object = nullabilityMap;
            boolean bl = false;
            Iterator<Map.Entry<AbstractInsnNode, ? extends StrictBasicValue>> iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object2 = object = iterator2.next();
                boolean bl2 = false;
                AbstractInsnNode insn = (AbstractInsnNode)object2.getKey();
                Object object3 = object;
                int n = 0;
                StrictBasicValue value2 = (StrictBasicValue)((Object)object3.getValue());
                Nullability nullability = NullabilityValuesKt.getNullability(value2);
                n = insn.getOpcode();
                switch (n) {
                    case 198: {
                        this.transformTrivialNullJump((JumpInsnNode)insn, nullability == Nullability.NULL);
                        break;
                    }
                    case 199: {
                        this.transformTrivialNullJump((JumpInsnNode)insn, nullability == Nullability.NOT_NULL);
                        break;
                    }
                    case 193: {
                        this.transformInstanceOf((TypeInsnNode)insn, nullability, value2);
                        break;
                    }
                    case 184: {
                        if (RedundantNullCheckMethodTransformerKt.isCheckNotNull(insn)) {
                            this.transformTrivialCheckNotNull(insn, nullability);
                        }
                        if (!RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull(insn)) break;
                        this.transformTrivialCheckExpressionValueIsNotNull(insn, nullability);
                    }
                }
            }
        }

        private final void transformTrivialNullJump(JumpInsnNode insn, boolean alwaysTrue) {
            this.changes = true;
            InsnList insnList = this.methodNode.instructions;
            boolean bl = false;
            boolean bl2 = false;
            InsnList $this$transformTrivialNullJump_u24lambda_u2d1 = insnList;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$transformTrivialNullJump_u24lambda_u2d1, (String)"");
            RedundantNullCheckMethodTransformerKt.popReferenceValueBefore($this$transformTrivialNullJump_u24lambda_u2d1, (AbstractInsnNode)insn);
            if (alwaysTrue) {
                $this$transformTrivialNullJump_u24lambda_u2d1.set((AbstractInsnNode)insn, (AbstractInsnNode)new JumpInsnNode(167, insn.label));
            } else {
                $this$transformTrivialNullJump_u24lambda_u2d1.remove((AbstractInsnNode)insn);
            }
        }

        private final void transformInstanceOf(TypeInsnNode insn, Nullability nullability, StrictBasicValue value2) {
            AbstractInsnNode abstractInsnNode = insn.getPrevious();
            Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"insn.previous");
            if (ReifiedTypeInliner.Companion.isOperationReifiedMarker(abstractInsnNode)) {
                return;
            }
            if (nullability == Nullability.NULL) {
                this.changes = true;
                this.transformTrivialInstanceOf((AbstractInsnNode)insn, false);
            } else if (nullability == Nullability.NOT_NULL && Intrinsics.areEqual((Object)value2.getType().getInternalName(), (Object)insn.desc)) {
                this.changes = true;
                this.transformTrivialInstanceOf((AbstractInsnNode)insn, true);
            }
        }

        private final void transformTrivialInstanceOf(AbstractInsnNode insn, boolean constValue) {
            InsnList insnList = this.methodNode.instructions;
            boolean bl = false;
            boolean bl2 = false;
            InsnList $this$transformTrivialInstanceOf_u24lambda_u2d2 = insnList;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$transformTrivialInstanceOf_u24lambda_u2d2, (String)"");
            RedundantNullCheckMethodTransformerKt.popReferenceValueBefore($this$transformTrivialInstanceOf_u24lambda_u2d2, insn);
            $this$transformTrivialInstanceOf_u24lambda_u2d2.set(insn, (AbstractInsnNode)(constValue ? new InsnNode(4) : new InsnNode(3)));
        }

        private final void transformTrivialCheckNotNull(AbstractInsnNode insn, Nullability nullability) {
            InsnList insnList;
            Object object;
            if (nullability != Nullability.NOT_NULL) {
                return;
            }
            AbstractInsnNode abstractInsnNode = insn.getPrevious();
            if (abstractInsnNode == null) {
                object = null;
            } else {
                AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
                boolean bl = false;
                boolean bl2 = false;
                AbstractInsnNode it = abstractInsnNode2;
                boolean bl3 = false;
                object = insnList = it.getOpcode() == 89 || it.getOpcode() == 25 ? abstractInsnNode2 : null;
            }
            if (insnList == null) {
                return;
            }
            InsnList previousInsn = insnList;
            insnList = this.methodNode.instructions;
            boolean bl = false;
            boolean bl4 = false;
            InsnList $this$transformTrivialCheckNotNull_u24lambda_u2d4 = insnList;
            boolean bl5 = false;
            $this$transformTrivialCheckNotNull_u24lambda_u2d4.remove((AbstractInsnNode)previousInsn);
            $this$transformTrivialCheckNotNull_u24lambda_u2d4.remove(insn);
        }

        private final void transformTrivialCheckExpressionValueIsNotNull(AbstractInsnNode insn, Nullability nullability) {
            InsnList insnList;
            Object object;
            if (nullability != Nullability.NOT_NULL) {
                return;
            }
            AbstractInsnNode abstractInsnNode = insn.getPrevious();
            if (abstractInsnNode == null) {
                object = null;
            } else {
                AbstractInsnNode abstractInsnNode2 = abstractInsnNode;
                boolean bl = false;
                boolean bl2 = false;
                AbstractInsnNode it = abstractInsnNode2;
                boolean bl3 = false;
                object = insnList = it.getOpcode() == 18 ? abstractInsnNode2 : null;
            }
            if (insnList == null) {
                return;
            }
            InsnList ldcInsn = insnList;
            insnList = this.methodNode.instructions;
            boolean bl = false;
            boolean bl4 = false;
            InsnList $this$transformTrivialCheckExpressionValueIsNotNull_u24lambda_u2d6 = insnList;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$transformTrivialCheckExpressionValueIsNotNull_u24lambda_u2d6, (String)"");
            RedundantNullCheckMethodTransformerKt.popReferenceValueBefore($this$transformTrivialCheckExpressionValueIsNotNull_u24lambda_u2d6, (AbstractInsnNode)ldcInsn);
            $this$transformTrivialCheckExpressionValueIsNotNull_u24lambda_u2d6.remove((AbstractInsnNode)ldcInsn);
            $this$transformTrivialCheckExpressionValueIsNotNull_u24lambda_u2d6.remove(insn);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\nH\u0002J\f\u0010\u000f\u001a\u00060\u0010R\u00020\u0011H\u0002J\n\u0010\u0012\u001a\u00060\u0010R\u00020\u0011J \u0010\u0013\u001a\u00020\n*\u00060\u0010R\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\u0015\u001a\u00020\n*\u00060\u0010R\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\u0016\u001a\u00020\n*\u00060\u0010R\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\u0017\u001a\u00020\n*\u00060\u0010R\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\n*\u00060\u0010R\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0018\u0010\u001a\u001a\u00020\n*\u00060\u0010R\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptionsBuilder;", "", "(Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass;)V", "checksDependingOnVariable", "Ljava/util/HashMap;", "", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/HashMap;", "addDependentCheck", "", "insn", "aLoadInsn", "Lorg/jetbrains/org/objectweb/asm/tree/VarInsnNode;", "collectVariableDependentChecks", "injectAssumptions", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptions;", "Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass;", "injectNullabilityAssumptions", "injectAssumptionsForInsn", "varIndex", "injectAssumptionsForInstanceOfCheck", "injectAssumptionsForNotNullAssertion", "injectAssumptionsForNullCheck", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "injectCodeForStoreNotNull", "injectCodeForThrowIntrinsic", "backend"})
        private final class NullabilityAssumptionsBuilder {
            @NotNull
            private final HashMap<Integer, List<AbstractInsnNode>> checksDependingOnVariable;

            public NullabilityAssumptionsBuilder() {
                Intrinsics.checkNotNullParameter((Object)TransformerPass.this, (String)"this$0");
                this.checksDependingOnVariable = new HashMap();
            }

            @NotNull
            public final NullabilityAssumptions injectNullabilityAssumptions() {
                this.collectVariableDependentChecks();
                return this.injectAssumptions();
            }

            private final void collectVariableDependentChecks() {
                for (AbstractInsnNode insn : TransformerPass.this.getMethodNode().instructions) {
                    AbstractInsnNode ldcInsn;
                    AbstractInsnNode aLoadInsn;
                    AbstractInsnNode previous2;
                    AbstractInsnNode abstractInsnNode;
                    AbstractInsnNode previous;
                    Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                    if (RedundantNullCheckMethodTransformerKt.isInstanceOfOrNullCheck(insn)) {
                        AbstractInsnNode abstractInsnNode2 = insn.getPrevious();
                        if (abstractInsnNode2 == null) continue;
                        previous = abstractInsnNode2;
                        if (previous.getOpcode() == 25) {
                            this.addDependentCheck(insn, (VarInsnNode)previous);
                            continue;
                        }
                        if (previous.getOpcode() != 89 || (abstractInsnNode = previous.getPrevious()) == null || (previous2 = abstractInsnNode).getOpcode() != 25) continue;
                        this.addDependentCheck(insn, (VarInsnNode)previous2);
                        continue;
                    }
                    if (RedundantNullCheckMethodTransformerKt.isCheckNotNull(insn)) {
                        AbstractInsnNode abstractInsnNode3;
                        previous2 = insn.getPrevious();
                        if (previous2 == null) continue;
                        previous = previous2;
                        if (previous.getOpcode() == 89) {
                            abstractInsnNode = previous.getPrevious();
                            if (abstractInsnNode == null) continue;
                            abstractInsnNode3 = abstractInsnNode;
                        } else {
                            abstractInsnNode3 = aLoadInsn = previous;
                        }
                        if (aLoadInsn.getOpcode() != 25) continue;
                        this.addDependentCheck(insn, (VarInsnNode)aLoadInsn);
                        continue;
                    }
                    if (RedundantNullCheckMethodTransformerKt.isCheckParameterIsNotNull(insn)) {
                        aLoadInsn = insn.getPrevious();
                        if (aLoadInsn == null || (ldcInsn = aLoadInsn).getOpcode() != 18 || (abstractInsnNode = ldcInsn.getPrevious()) == null || (aLoadInsn = abstractInsnNode).getOpcode() != 25) continue;
                        this.addDependentCheck(insn, (VarInsnNode)aLoadInsn);
                        continue;
                    }
                    if (!RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull(insn) || (aLoadInsn = insn.getPrevious()) == null || (ldcInsn = aLoadInsn).getOpcode() != 18) continue;
                    aLoadInsn = null;
                    AbstractInsnNode abstractInsnNode4 = ldcInsn.getPrevious();
                    if (abstractInsnNode4 == null) continue;
                    AbstractInsnNode insn1 = abstractInsnNode4;
                    if (insn1.getOpcode() == 25) {
                        aLoadInsn = (VarInsnNode)insn1;
                    } else if (insn1.getOpcode() == 89) {
                        AbstractInsnNode abstractInsnNode5 = insn1.getPrevious();
                        if (abstractInsnNode5 == null) continue;
                        AbstractInsnNode insn2 = abstractInsnNode5;
                        if (insn2.getOpcode() == 25) {
                            aLoadInsn = (VarInsnNode)insn2;
                        }
                    }
                    if (aLoadInsn == null) continue;
                    this.addDependentCheck(insn, (VarInsnNode)aLoadInsn);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void addDependentCheck(AbstractInsnNode insn, VarInsnNode aLoadInsn) {
                Object object;
                void $this$getOrPut$iv;
                Map map = this.checksDependingOnVariable;
                Integer key$iv = aLoadInsn.var;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new SmartList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(insn);
            }

            private final NullabilityAssumptions injectAssumptions() {
                NullabilityAssumptions nullabilityAssumptions = new NullabilityAssumptions();
                Iterator iterator2 = this.checksDependingOnVariable;
                boolean bl = false;
                ListIterator listIterator = iterator2.entrySet().iterator();
                while (listIterator.hasNext()) {
                    Iterator iterator3 = iterator2 = listIterator.next();
                    boolean bl2 = false;
                    int varIndex = ((Number)iterator3.getKey()).intValue();
                    Iterator iterator4 = iterator2;
                    boolean bl3 = false;
                    List dependentChecks = (List)iterator4.getValue();
                    for (AbstractInsnNode checkInsn : dependentChecks) {
                        this.injectAssumptionsForInsn(nullabilityAssumptions, varIndex, checkInsn);
                    }
                }
                for (AbstractInsnNode insn : TransformerPass.this.getMethodNode().instructions) {
                    Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
                    if (!RedundantNullCheckMethodTransformerKt.isThrowIntrinsic(insn)) continue;
                    this.injectCodeForThrowIntrinsic(nullabilityAssumptions, insn);
                }
                return nullabilityAssumptions;
            }

            private final void injectAssumptionsForInsn(NullabilityAssumptions $this$injectAssumptionsForInsn, int varIndex, AbstractInsnNode insn) {
                int n = insn.getOpcode();
                switch (n) {
                    case 198: 
                    case 199: {
                        this.injectAssumptionsForNullCheck($this$injectAssumptionsForInsn, varIndex, (JumpInsnNode)insn);
                        break;
                    }
                    case 184: {
                        if (RedundantNullCheckMethodTransformerKt.isCheckNotNull(insn) || RedundantNullCheckMethodTransformerKt.isCheckParameterIsNotNull(insn) || RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull(insn)) {
                            this.injectAssumptionsForNotNullAssertion($this$injectAssumptionsForInsn, varIndex, insn);
                            break;
                        }
                        if (PseudoInsnsKt.isPseudo(insn, PseudoInsn.STORE_NOT_NULL)) {
                            this.injectCodeForStoreNotNull($this$injectAssumptionsForInsn, insn);
                            break;
                        }
                        throw new AssertionError((Object)Intrinsics.stringPlus((String)"Expected non-null assertion: ", (Object)UtilKt.getDebugText(insn)));
                    }
                    case 193: {
                        this.injectAssumptionsForInstanceOfCheck($this$injectAssumptionsForInsn, varIndex, insn);
                    }
                }
            }

            private final void injectAssumptionsForNullCheck(NullabilityAssumptions $this$injectAssumptionsForNullCheck, int varIndex, JumpInsnNode insn) {
                NullabilityAssumptions this_$iv;
                boolean jumpsIfNull = insn.getOpcode() == 198;
                Object object = insn.label;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"insn.label");
                LabelNode originalLabel = CodegenUtilKt.linkWithLabel((LabelNode)object);
                object = $this$injectAssumptionsForNullCheck.getOriginalLabels();
                boolean bl = false;
                object.put(insn, originalLabel);
                insn.label = (LabelNode)$this$injectAssumptionsForNullCheck.synthetic((AbstractInsnNode)new LabelNode(new Label()));
                AbstractInsnNode insertAfterNull = jumpsIfNull ? (AbstractInsnNode)insn.label : (AbstractInsnNode)insn;
                AbstractInsnNode insertAfterNonNull = jumpsIfNull ? (AbstractInsnNode)insn : (AbstractInsnNode)insn.label;
                InsnList insnList = TransformerPass.this.getMethodNode().instructions;
                boolean bl2 = false;
                boolean bl3 = false;
                InsnList $this$injectAssumptionsForNullCheck_u24lambda_u2d3 = insnList;
                boolean bl4 = false;
                $this$injectAssumptionsForNullCheck_u24lambda_u2d3.add((AbstractInsnNode)insn.label);
                NullabilityAssumptions nullabilityAssumptions = $this$injectAssumptionsForNullCheck;
                AbstractInsnNode abstractInsnNode = insertAfterNull;
                InsnList insnList2 = $this$injectAssumptionsForNullCheck_u24lambda_u2d3;
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl5 = false;
                boolean bl6 = false;
                InstructionAdapter $this$injectAssumptionsForNullCheck_u24lambda_u2d3_u24lambda_u2d1 = instructionAdapter;
                boolean bl7 = false;
                $this$injectAssumptionsForNullCheck_u24lambda_u2d3_u24lambda_u2d1.aconst(null);
                $this$injectAssumptionsForNullCheck_u24lambda_u2d3_u24lambda_u2d1.store(varIndex, AsmTypes.OBJECT_TYPE);
                if (jumpsIfNull) {
                    $this$injectAssumptionsForNullCheck_u24lambda_u2d3_u24lambda_u2d1.goTo(originalLabel.getLabel());
                }
                instructionAdapter = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)instructionAdapter, (String)"tmpMethodNode.instructions");
                InstructionAdapter insnList$iv = instructionAdapter;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    this_$iv.synthetic(insn$iv);
                }
                InstructionAdapter instructionAdapter2 = insnList$iv;
                insnList2.insert(abstractInsnNode, (InsnList)instructionAdapter2);
                this_$iv = $this$injectAssumptionsForNullCheck;
                abstractInsnNode = insertAfterNonNull;
                insnList2 = $this$injectAssumptionsForNullCheck_u24lambda_u2d3;
                $i$f$listOfSynthetics = false;
                $i$f$withInstructionAdapter = false;
                tmpMethodNode$iv$iv = new MethodNode();
                instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                bl5 = false;
                bl6 = false;
                InstructionAdapter $this$injectAssumptionsForNullCheck_u24lambda_u2d3_u24lambda_u2d2 = instructionAdapter;
                boolean bl8 = false;
                $this$injectAssumptionsForNullCheck_u24lambda_u2d3_u24lambda_u2d2.load(varIndex, AsmTypes.OBJECT_TYPE);
                PseudoInsnsKt.asNotNull($this$injectAssumptionsForNullCheck_u24lambda_u2d3_u24lambda_u2d2);
                $this$injectAssumptionsForNullCheck_u24lambda_u2d3_u24lambda_u2d2.store(varIndex, AsmTypes.OBJECT_TYPE);
                if (!jumpsIfNull) {
                    $this$injectAssumptionsForNullCheck_u24lambda_u2d3_u24lambda_u2d2.goTo(originalLabel.getLabel());
                }
                instructionAdapter = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)instructionAdapter, (String)"tmpMethodNode.instructions");
                insnList$iv = instructionAdapter;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    this_$iv.synthetic(insn$iv);
                }
                instructionAdapter2 = insnList$iv;
                insnList2.insert(abstractInsnNode, (InsnList)instructionAdapter2);
            }

            /*
             * WARNING - void declaration
             */
            private final void injectAssumptionsForNotNullAssertion(NullabilityAssumptions $this$injectAssumptionsForNotNullAssertion, int varIndex, AbstractInsnNode insn) {
                NullabilityAssumptions nullabilityAssumptions = $this$injectAssumptionsForNotNullAssertion;
                AbstractInsnNode abstractInsnNode = insn;
                InsnList insnList = TransformerPass.this.getMethodNode().instructions;
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl = false;
                boolean bl2 = false;
                InstructionAdapter $this$injectAssumptionsForNotNullAssertion_u24lambda_u2d4 = instructionAdapter;
                boolean bl3 = false;
                $this$injectAssumptionsForNotNullAssertion_u24lambda_u2d4.load(varIndex, AsmTypes.OBJECT_TYPE);
                PseudoInsnsKt.asNotNull($this$injectAssumptionsForNotNullAssertion_u24lambda_u2d4);
                $this$injectAssumptionsForNotNullAssertion_u24lambda_u2d4.store(varIndex, AsmTypes.OBJECT_TYPE);
                instructionAdapter = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)instructionAdapter, (String)"tmpMethodNode.instructions");
                InstructionAdapter insnList$iv = instructionAdapter;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    void this_$iv;
                    this_$iv.synthetic(insn$iv);
                }
                InstructionAdapter instructionAdapter2 = insnList$iv;
                insnList.insert(abstractInsnNode, (InsnList)instructionAdapter2);
            }

            /*
             * WARNING - void declaration
             */
            private final void injectAssumptionsForInstanceOfCheck(NullabilityAssumptions $this$injectAssumptionsForInstanceOfCheck, int varIndex, AbstractInsnNode insn) {
                Object object;
                AbstractInsnNode abstractInsnNode = insn.getNext();
                if (abstractInsnNode == null) {
                    return;
                }
                AbstractInsnNode next = abstractInsnNode;
                if (next.getOpcode() != 153 && next.getOpcode() != 154) {
                    return;
                }
                if (!(next instanceof JumpInsnNode)) {
                    return;
                }
                boolean jumpsIfInstance = ((JumpInsnNode)next).getOpcode() == 154;
                LabelNode originalLabel = null;
                AbstractInsnNode insertAfterNotNull = null;
                if (jumpsIfInstance) {
                    object = ((JumpInsnNode)next).label;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next.label");
                    originalLabel = CodegenUtilKt.linkWithLabel((LabelNode)object);
                    object = $this$injectAssumptionsForInstanceOfCheck.getOriginalLabels();
                    AbstractInsnNode abstractInsnNode2 = next;
                    LabelNode labelNode = ((JumpInsnNode)next).label;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"next.label");
                    boolean bl = false;
                    object.put(abstractInsnNode2, labelNode);
                    LabelNode newLabel = (LabelNode)$this$injectAssumptionsForInstanceOfCheck.synthetic((AbstractInsnNode)new LabelNode(new Label()));
                    TransformerPass.this.getMethodNode().instructions.add((AbstractInsnNode)newLabel);
                    ((JumpInsnNode)next).label = newLabel;
                    insertAfterNotNull = (AbstractInsnNode)newLabel;
                } else {
                    originalLabel = null;
                    insertAfterNotNull = next;
                }
                object = TransformerPass.this.getMethodNode().instructions;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$injectAssumptionsForInstanceOfCheck_u24lambda_u2d6 = object;
                boolean bl3 = false;
                NullabilityAssumptions nullabilityAssumptions = $this$injectAssumptionsForInstanceOfCheck;
                AbstractInsnNode abstractInsnNode3 = insertAfterNotNull;
                Object object2 = $this$injectAssumptionsForInstanceOfCheck_u24lambda_u2d6;
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl4 = false;
                boolean bl5 = false;
                InstructionAdapter $this$injectAssumptionsForInstanceOfCheck_u24lambda_u2d6_u24lambda_u2d5 = instructionAdapter;
                boolean bl6 = false;
                $this$injectAssumptionsForInstanceOfCheck_u24lambda_u2d6_u24lambda_u2d5.load(varIndex, AsmTypes.OBJECT_TYPE);
                PseudoInsnsKt.asNotNull($this$injectAssumptionsForInstanceOfCheck_u24lambda_u2d6_u24lambda_u2d5);
                $this$injectAssumptionsForInstanceOfCheck_u24lambda_u2d6_u24lambda_u2d5.store(varIndex, AsmTypes.OBJECT_TYPE);
                if (originalLabel != null) {
                    $this$injectAssumptionsForInstanceOfCheck_u24lambda_u2d6_u24lambda_u2d5.goTo(originalLabel.getLabel());
                }
                instructionAdapter = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)instructionAdapter, (String)"tmpMethodNode.instructions");
                InstructionAdapter insnList$iv = instructionAdapter;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    void this_$iv;
                    this_$iv.synthetic(insn$iv);
                }
                InstructionAdapter instructionAdapter2 = insnList$iv;
                object2.insert(abstractInsnNode3, (InsnList)instructionAdapter2);
            }

            /*
             * WARNING - void declaration
             */
            private final void injectCodeForThrowIntrinsic(NullabilityAssumptions $this$injectCodeForThrowIntrinsic, AbstractInsnNode insn) {
                InsnList insnList = TransformerPass.this.getMethodNode().instructions;
                boolean bl = false;
                boolean bl2 = false;
                InsnList $this$injectCodeForThrowIntrinsic_u24lambda_u2d8 = insnList;
                boolean bl3 = false;
                NullabilityAssumptions nullabilityAssumptions = $this$injectCodeForThrowIntrinsic;
                AbstractInsnNode abstractInsnNode = insn;
                InsnList insnList2 = $this$injectCodeForThrowIntrinsic_u24lambda_u2d8;
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl4 = false;
                boolean bl5 = false;
                InstructionAdapter $this$injectCodeForThrowIntrinsic_u24lambda_u2d8_u24lambda_u2d7 = instructionAdapter;
                boolean bl6 = false;
                $this$injectCodeForThrowIntrinsic_u24lambda_u2d8_u24lambda_u2d7.aconst(null);
                $this$injectCodeForThrowIntrinsic_u24lambda_u2d8_u24lambda_u2d7.athrow();
                instructionAdapter = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)instructionAdapter, (String)"tmpMethodNode.instructions");
                InstructionAdapter insnList$iv = instructionAdapter;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    void this_$iv;
                    this_$iv.synthetic(insn$iv);
                }
                InstructionAdapter instructionAdapter2 = insnList$iv;
                insnList2.insert(abstractInsnNode, (InsnList)instructionAdapter2);
                ++TransformerPass.this.getMethodNode().maxStack;
            }

            /*
             * WARNING - void declaration
             */
            private final void injectCodeForStoreNotNull(NullabilityAssumptions $this$injectCodeForStoreNotNull, AbstractInsnNode insn) {
                AbstractInsnNode previous = insn.getPrevious();
                if (previous.getOpcode() != 58) {
                    return;
                }
                InsnList insnList = TransformerPass.this.getMethodNode().instructions;
                boolean bl = false;
                boolean bl2 = false;
                InsnList $this$injectCodeForStoreNotNull_u24lambda_u2d10 = insnList;
                boolean bl3 = false;
                NullabilityAssumptions nullabilityAssumptions = $this$injectCodeForStoreNotNull;
                AbstractInsnNode abstractInsnNode = insn;
                InsnList insnList2 = $this$injectCodeForStoreNotNull_u24lambda_u2d10;
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv$iv = new MethodNode();
                InstructionAdapter instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv$iv);
                boolean bl4 = false;
                boolean bl5 = false;
                InstructionAdapter $this$injectCodeForStoreNotNull_u24lambda_u2d10_u24lambda_u2d9 = instructionAdapter;
                boolean bl6 = false;
                if (previous == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                }
                int varIndex = ((VarInsnNode)previous).var;
                $this$injectCodeForStoreNotNull_u24lambda_u2d10_u24lambda_u2d9.load(varIndex, AsmTypes.OBJECT_TYPE);
                PseudoInsnsKt.asNotNull($this$injectCodeForStoreNotNull_u24lambda_u2d10_u24lambda_u2d9);
                $this$injectCodeForStoreNotNull_u24lambda_u2d10_u24lambda_u2d9.store(varIndex, AsmTypes.OBJECT_TYPE);
                instructionAdapter = tmpMethodNode$iv$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)instructionAdapter, (String)"tmpMethodNode.instructions");
                InstructionAdapter insnList$iv = instructionAdapter;
                for (AbstractInsnNode insn$iv : insnList$iv) {
                    void this_$iv;
                    this_$iv.synthetic(insn$iv);
                }
                InstructionAdapter instructionAdapter2 = insnList$iv;
                insnList2.insert(abstractInsnNode, (InsnList)instructionAdapter2);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016H\u0086\b\u00f8\u0001\u0000J\u0006\u0010\u0017\u001a\u00020\u0015J\u001d\u0010\u0018\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\f2\u0006\u0010\u001a\u001a\u0002H\u0019\u00a2\u0006\u0002\u0010\u001bR-\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass$NullabilityAssumptions;", "", "(Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/RedundantNullCheckMethodTransformer$TransformerPass;)V", "originalLabels", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lkotlin/collections/HashMap;", "getOriginalLabels", "()Ljava/util/HashMap;", "syntheticInstructions", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/ArrayList;", "getSyntheticInstructions", "()Ljava/util/ArrayList;", "listOfSynthetics", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "block", "Lkotlin/Function1;", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "", "Lkotlin/ExtensionFunctionType;", "revert", "synthetic", "T", "insn", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "backend"})
        public final class NullabilityAssumptions {
            @NotNull
            private final HashMap<JumpInsnNode, LabelNode> originalLabels;
            @NotNull
            private final ArrayList<AbstractInsnNode> syntheticInstructions;

            public NullabilityAssumptions() {
                Intrinsics.checkNotNullParameter((Object)TransformerPass.this, (String)"this$0");
                this.originalLabels = new HashMap();
                this.syntheticInstructions = new ArrayList();
            }

            @NotNull
            public final HashMap<JumpInsnNode, LabelNode> getOriginalLabels() {
                return this.originalLabels;
            }

            @NotNull
            public final ArrayList<AbstractInsnNode> getSyntheticInstructions() {
                return this.syntheticInstructions;
            }

            @NotNull
            public final <T extends AbstractInsnNode> T synthetic(@NotNull T insn) {
                Intrinsics.checkNotNullParameter(insn, (String)"insn");
                this.syntheticInstructions.add(insn);
                return insn;
            }

            @NotNull
            public final InsnList listOfSynthetics(@NotNull Function1<? super InstructionAdapter, Unit> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                boolean $i$f$listOfSynthetics = false;
                boolean $i$f$withInstructionAdapter = false;
                MethodNode tmpMethodNode$iv = new MethodNode();
                InstructionAdapter instructionAdapter = new InstructionAdapter((MethodVisitor)tmpMethodNode$iv);
                boolean bl = false;
                boolean bl2 = false;
                block.invoke((Object)instructionAdapter);
                instructionAdapter = tmpMethodNode$iv.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)instructionAdapter, (String)"tmpMethodNode.instructions");
                InstructionAdapter insnList = instructionAdapter;
                for (AbstractInsnNode insn : insnList) {
                    this.synthetic(insn);
                }
                return insnList;
            }

            public final void revert() {
                Object object = TransformerPass.this.getMethodNode().instructions;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$revert_u24lambda_u2d1 = object;
                boolean bl3 = false;
                Iterable $this$forEach$iv = this.getSyntheticInstructions();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl4 = false;
                    $this$revert_u24lambda_u2d1.remove(it);
                }
                Object object2 = this.originalLabels;
                bl2 = false;
                object = object2.entrySet().iterator();
                while (object.hasNext()) {
                    LabelNode originalLabel;
                    $this$revert_u24lambda_u2d1 = object2 = (Map.Entry)object.next();
                    boolean bl5 = false;
                    JumpInsnNode jumpInsn = (JumpInsnNode)$this$revert_u24lambda_u2d1.getKey();
                    Object object3 = object2;
                    boolean bl6 = false;
                    jumpInsn.label = originalLabel = (LabelNode)object3.getValue();
                }
            }
        }
    }
}

