/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.ConstLoweringKt;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\r*\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\rH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ConstLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "lowerConstRead", "receiver", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "shouldDropConstReceiver", "", "backend.jvm"})
public final class ConstLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public ConstLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.transformChildrenVoid(irFile);
    }

    private final IrExpression lowerConstRead(IrExpression $this$lowerConstRead, IrExpression receiver, IrField field) {
        IrExpression irExpression;
        IrExpression resultExpression;
        IrConst irConst;
        Object[] objectArray = field;
        IrConst irConst2 = irConst = objectArray == null ? null : ConstLoweringKt.constantValue$default((IrField)objectArray, null, 1, null);
        if (irConst == null) {
            return null;
        }
        IrConst value2 = irConst;
        IrExpression irExpression2 = resultExpression = this.context.getState().getShouldInlineConstVals() ? (IrExpression)value2.copyWithOffsets($this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset()) : (IrExpression)new IrGetFieldImpl($this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset(), field.getSymbol(), field.getType(), null, null, 48, null);
        if (receiver == null || this.shouldDropConstReceiver(receiver)) {
            irExpression = resultExpression;
        } else {
            objectArray = new IrExpression[]{receiver, resultExpression};
            irExpression = new IrCompositeImpl($this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset(), resultExpression.getType(), null, CollectionsKt.listOf((Object[])objectArray));
        }
        return irExpression;
    }

    private final boolean shouldDropConstReceiver(IrExpression $this$shouldDropConstReceiver) {
        return $this$shouldDropConstReceiver instanceof IrConst || $this$shouldDropConstReceiver instanceof IrGetValue || $this$shouldDropConstReceiver instanceof IrGetObjectValue;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementBase irElementBase = expression2.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction2 = irSimpleFunction = irElementBase instanceof IrSimpleFunction ? (IrSimpleFunction)irElementBase : null;
        if (irSimpleFunction == null) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction function2 = irSimpleFunction;
        IrPropertySymbol irPropertySymbol = function2.getCorrespondingPropertySymbol();
        IrElementBase irElementBase2 = irElementBase = irPropertySymbol == null ? null : (IrProperty)irPropertySymbol.getOwner();
        if (irElementBase == null) {
            return super.visitCall(expression2);
        }
        IrFunction property2 = irElementBase;
        irElementBase = this.lowerConstRead(expression2, expression2.getDispatchReceiver(), ((IrProperty)((Object)property2)).getBackingField());
        return irElementBase == null ? super.visitCall(expression2) : irElementBase;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrExpression irExpression = this.lowerConstRead(expression2, expression2.getReceiver(), (IrField)expression2.getSymbol().getOwner());
        return irExpression == null ? super.visitGetField(expression2) : irExpression;
    }
}

