/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.impl.JpsProjectElementReference;
import org.jetbrains.jps.model.impl.JpsRootElementBase;
import org.jetbrains.jps.model.impl.runConfiguration.JpsRunConfigurationImpl;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.module.impl.JpsModuleImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleRole;
import org.jetbrains.jps.model.module.impl.JpsSdkReferencesTableImpl;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfiguration;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfigurationType;
import org.jetbrains.jps.model.runConfiguration.JpsTypedRunConfiguration;

public class JpsProjectImpl
extends JpsRootElementBase<JpsProjectImpl>
implements JpsProject {
    private static final JpsElementCollectionRole<JpsElementReference<?>> EXTERNAL_REFERENCES_COLLECTION_ROLE = JpsElementCollectionRole.create(JpsElementChildRoleBase.create("external reference"));
    private static final JpsElementCollectionRole<JpsRunConfiguration> RUN_CONFIGURATIONS_ROLE = JpsElementCollectionRole.create(JpsElementChildRoleBase.create("run configuration"));
    private final JpsLibraryCollection myLibraryCollection;
    private String myName;

    public JpsProjectImpl(@NotNull JpsModel model, JpsEventDispatcher eventDispatcher) {
        if (model == null) {
            JpsProjectImpl.$$$reportNull$$$0(0);
        }
        super(model, eventDispatcher);
        this.myName = "";
        this.myContainer.setChild(JpsModuleRole.MODULE_COLLECTION_ROLE);
        this.myContainer.setChild(EXTERNAL_REFERENCES_COLLECTION_ROLE);
        this.myContainer.setChild(JpsSdkReferencesTableImpl.ROLE);
        this.myContainer.setChild(RUN_CONFIGURATIONS_ROLE);
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE));
    }

    public JpsProjectImpl(JpsProjectImpl original, JpsModel model, JpsEventDispatcher eventDispatcher) {
        super(original, model, eventDispatcher);
        this.myName = "";
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection)((Object)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public void setName(@NotNull String name2) {
        if (name2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(2);
        }
        if (!Objects.equals(this.myName, name2)) {
            this.myName = name2;
            this.fireElementChanged();
        }
    }

    public void addExternalReference(@NotNull JpsElementReference<?> reference) {
        if (reference == null) {
            JpsProjectImpl.$$$reportNull$$$0(3);
        }
        ((JpsElementCollection)((Object)this.myContainer.getChild(EXTERNAL_REFERENCES_COLLECTION_ROLE))).addChild(reference);
    }

    @Override
    @NotNull
    public <P extends JpsElement, ModuleType extends JpsModuleType<P> & JpsElementTypeWithDefaultProperties<P>> JpsModule addModule(@NotNull String name2, @NotNull ModuleType moduleType) {
        if (name2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(4);
        }
        if (moduleType == null) {
            JpsProjectImpl.$$$reportNull$$$0(5);
        }
        JpsElementCollection collection = (JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE));
        JpsModule jpsModule = collection.addChild(new JpsModuleImpl<JpsElement>(moduleType, name2, (JpsElement)((JpsElementTypeWithDefaultProperties<P>)moduleType).createDefaultProperties()));
        if (jpsModule == null) {
            JpsProjectImpl.$$$reportNull$$$0(6);
        }
        return jpsModule;
    }

    @Override
    @NotNull
    public <P extends JpsElement, LibraryType extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addLibrary(@NotNull String name2, @NotNull LibraryType libraryType) {
        if (name2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(7);
        }
        if (libraryType == null) {
            JpsProjectImpl.$$$reportNull$$$0(8);
        }
        JpsLibrary jpsLibrary = this.myLibraryCollection.addLibrary(name2, libraryType);
        if (jpsLibrary == null) {
            JpsProjectImpl.$$$reportNull$$$0(9);
        }
        return jpsLibrary;
    }

    @Override
    @NotNull
    public List<JpsModule> getModules() {
        List<JpsModule> list2 = ((JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE))).getElements();
        if (list2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Override
    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedModule<P>> getModules(JpsModuleType<P> type2) {
        Iterable<JpsTypedModule<P>> iterable = ((JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE))).getElementsOfType(type2);
        if (iterable == null) {
            JpsProjectImpl.$$$reportNull$$$0(11);
        }
        return iterable;
    }

    @Override
    public void addModule(@NotNull JpsModule module2) {
        if (module2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(12);
        }
        ((JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE))).addChild(module2);
    }

    @Override
    public void removeModule(@NotNull JpsModule module2) {
        if (module2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(13);
        }
        ((JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE))).removeChild(module2);
    }

    @Override
    @NotNull
    public JpsLibraryCollection getLibraryCollection() {
        JpsLibraryCollection jpsLibraryCollection = this.myLibraryCollection;
        if (jpsLibraryCollection == null) {
            JpsProjectImpl.$$$reportNull$$$0(14);
        }
        return jpsLibraryCollection;
    }

    @Override
    @NotNull
    public JpsSdkReferencesTable getSdkReferencesTable() {
        JpsSdkReferencesTable jpsSdkReferencesTable = this.myContainer.getChild(JpsSdkReferencesTableImpl.ROLE);
        if (jpsSdkReferencesTable == null) {
            JpsProjectImpl.$$$reportNull$$$0(15);
        }
        return jpsSdkReferencesTable;
    }

    @Override
    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedRunConfiguration<P>> getRunConfigurations(JpsRunConfigurationType<P> type2) {
        Iterable<JpsTypedRunConfiguration<P>> iterable = this.getRunConfigurationsCollection().getElementsOfType(type2);
        if (iterable == null) {
            JpsProjectImpl.$$$reportNull$$$0(16);
        }
        return iterable;
    }

    @Override
    @NotNull
    public List<JpsRunConfiguration> getRunConfigurations() {
        List<JpsRunConfiguration> list2 = this.getRunConfigurationsCollection().getElements();
        if (list2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @Override
    @NotNull
    public <P extends JpsElement> JpsTypedRunConfiguration<P> addRunConfiguration(@NotNull String name2, @NotNull JpsRunConfigurationType<P> type2, @NotNull P properties2) {
        if (name2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(18);
        }
        if (type2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(19);
        }
        if (properties2 == null) {
            JpsProjectImpl.$$$reportNull$$$0(20);
        }
        JpsTypedRunConfiguration jpsTypedRunConfiguration = this.getRunConfigurationsCollection().addChild(new JpsRunConfigurationImpl<P>(name2, type2, properties2));
        if (jpsTypedRunConfiguration == null) {
            JpsProjectImpl.$$$reportNull$$$0(21);
        }
        return jpsTypedRunConfiguration;
    }

    private JpsElementCollection<JpsRunConfiguration> getRunConfigurationsCollection() {
        return (JpsElementCollection)((Object)this.myContainer.getChild(RUN_CONFIGURATIONS_ROLE));
    }

    @Override
    @NotNull
    public JpsElementReference<JpsProject> createReference() {
        return new JpsProjectElementReference();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/impl/JpsProjectImpl";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryType";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/impl/JpsProjectImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addLibrary";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryCollection";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkReferencesTable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurations";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "addRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addExternalReference";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeModule";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addRunConfiguration";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

