/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.FilteredAnnotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.calls.components.BuiltInsProviderKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponeArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.components.ReceiverInfo;
import org.jetbrains.kotlin.resolve.calls.components.ReturnArgumentsAnalysisResult;
import org.jetbrains.kotlin.resolve.calls.components.ReturnArgumentsInfo;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.CoroutinePosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.LambdaArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCollectionLiteralAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.StubTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentListMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ<\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017J\n\u0010\u001a\u001a\u00020\u001b*\u00020\bJ7\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\u0004\b\u0000\u0010\u001d*\u0004\u0018\u00010\u00192\u0019\u0010\u001e\u001a\u0015\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u0001H\u001d0\u0017\u00a2\u0006\u0002\b\u001fH\u0082\b\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u0004\u0018\u00010\u0019*\u0004\u0018\u00010\u0019H\u0002J\u0016\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010#*\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "", "callableReferenceResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;)V", "analyze", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "analyzeLambda", "Lorg/jetbrains/kotlin/resolve/calls/components/ReturnArgumentsAnalysisResult;", "lambda", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "diagnosticHolder", "applyResultsOfAnalyzedLambdaToCandidateSystem", "returnArgumentsAnalysisResult", "substitute", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "createSubstituteFunctorForLambdaAnalysis", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$SubstitutorAndStubsForLambdaAnalysis;", "forFunctionalType", "T", "f", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "receiver", "valueParameters", "", "Context", "SubstitutorAndStubsForLambdaAnalysis", "resolution"})
public final class PostponedArgumentsAnalyzer {
    private final CallableReferenceResolver callableReferenceResolver;

    public final void analyze(@NotNull Context c, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull ResolvedAtom argument, @NotNull KotlinDiagnosticsHolder diagnosticsHolder) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        ResolvedAtom resolvedAtom = argument;
        if (resolvedAtom instanceof ResolvedLambdaAtom) {
            this.analyzeLambda(c, resolutionCallbacks, (ResolvedLambdaAtom)argument, diagnosticsHolder);
        } else if (resolvedAtom instanceof LambdaWithTypeVariableAsExpectedTypeAtom) {
            this.analyzeLambda(c, resolutionCallbacks, PostponeArgumentsChecksKt.transformToResolvedLambda$default((LambdaWithTypeVariableAsExpectedTypeAtom)argument, c.getBuilder(), diagnosticsHolder, null, null, 12, null), diagnosticsHolder);
        } else if (resolvedAtom instanceof ResolvedCallableReferenceAtom) {
            this.callableReferenceResolver.processCallableReferenceArgument(c.getBuilder(), (ResolvedCallableReferenceAtom)argument, diagnosticsHolder, resolutionCallbacks);
        } else {
            if (resolvedAtom instanceof ResolvedCollectionLiteralAtom) {
                String string2 = "Not supported";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
            }
            String string3 = "Unexpected resolved primitive: " + argument.getClass().getCanonicalName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SubstitutorAndStubsForLambdaAnalysis createSubstituteFunctorForLambdaAnalysis(@NotNull Context $this$createSubstituteFunctorForLambdaAnalysis) {
        Map map2;
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map<TypeVariableMarker, StubTypeMarker> stubsForPostponedVariables;
        Intrinsics.checkNotNullParameter((Object)$this$createSubstituteFunctorForLambdaAnalysis, (String)"$this$createSubstituteFunctorForLambdaAnalysis");
        Map<TypeVariableMarker, StubTypeMarker> map3 = stubsForPostponedVariables = $this$createSubstituteFunctorForLambdaAnalysis.bindingStubsForPostponedVariables();
        Context context2 = $this$createSubstituteFunctorForLambdaAnalysis;
        boolean $i$f$mapKeys = false;
        void var6_6 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            TypeConstructorMarker typeConstructorMarker = MarkerExtensionsKt.freshTypeConstructor((TypeVariableMarker)it.getKey(), $this$createSubstituteFunctorForLambdaAnalysis);
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            TypeConstructorMarker typeConstructorMarker2 = typeConstructorMarker;
            Map map4 = map2;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            map4.put(typeConstructorMarker2, v);
        }
        map2 = destination$iv$iv;
        TypeSubstitutorMarker currentSubstitutor2 = context2.buildCurrentSubstitutor(map2);
        return new SubstitutorAndStubsForLambdaAnalysis(stubsForPostponedVariables, (Function1<? super KotlinType, ? extends UnwrappedType>)((Function1)new Function1<KotlinType, UnwrappedType>($this$createSubstituteFunctorForLambdaAnalysis, currentSubstitutor2){
            final /* synthetic */ Context $this_createSubstituteFunctorForLambdaAnalysis;
            final /* synthetic */ TypeSubstitutorMarker $currentSubstitutor;

            @NotNull
            public final UnwrappedType invoke(@NotNull KotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KotlinTypeMarker kotlinTypeMarker = MarkerExtensionsKt.safeSubstitute(this.$currentSubstitutor, this.$this_createSubstituteFunctorForLambdaAnalysis, it);
                if (kotlinTypeMarker == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.types.UnwrappedType");
                }
                return (UnwrappedType)kotlinTypeMarker;
            }
            {
                this.$this_createSubstituteFunctorForLambdaAnalysis = context2;
                this.$currentSubstitutor = typeSubstitutorMarker;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ReturnArgumentsAnalysisResult analyzeLambda(@NotNull Context c, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull ResolvedLambdaAtom lambda2, @NotNull KotlinDiagnosticsHolder diagnosticHolder) {
        Object object;
        UnwrappedType expectedTypeForReturnArguments;
        boolean $i$f$mapTo;
        List list2;
        Iterable $this$mapIndexedTo$iv$iv;
        int index$iv$iv;
        Object destination$iv$iv;
        List expectedParametersToMatchAgainst;
        List list3;
        UnwrappedType unwrappedType;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        SubstitutorAndStubsForLambdaAnalysis substitutorAndStubsForLambdaAnalysis = this.createSubstituteFunctorForLambdaAnalysis(c);
        Function1<KotlinType, UnwrappedType> substitute2 = substitutorAndStubsForLambdaAnalysis.getSubstitute();
        Function2<UnwrappedType, UnwrappedType, UnwrappedType> $fun$expectedOrActualType$1 = new Function2<UnwrappedType, UnwrappedType, UnwrappedType>(substitute2, c){
            final /* synthetic */ Function1 $substitute;
            final /* synthetic */ Context $c;

            @Nullable
            public final UnwrappedType invoke(@Nullable UnwrappedType expected, @Nullable UnwrappedType actual) {
                UnwrappedType unwrappedType;
                UnwrappedType expectedSubstituted;
                UnwrappedType unwrappedType2;
                boolean bl;
                boolean bl2;
                Function1 function1;
                UnwrappedType unwrappedType3;
                UnwrappedType unwrappedType4 = expected;
                if (unwrappedType4 != null) {
                    unwrappedType3 = unwrappedType4;
                    function1 = this.$substitute;
                    bl2 = false;
                    bl = false;
                    unwrappedType2 = (UnwrappedType)function1.invoke((Object)unwrappedType3);
                } else {
                    unwrappedType2 = expectedSubstituted = null;
                }
                if (expectedSubstituted != null && this.$c.canBeProper(expectedSubstituted)) {
                    unwrappedType = expectedSubstituted;
                } else {
                    UnwrappedType unwrappedType5 = actual;
                    if (unwrappedType5 != null) {
                        unwrappedType3 = unwrappedType5;
                        function1 = this.$substitute;
                        bl2 = false;
                        bl = false;
                        unwrappedType = (UnwrappedType)function1.invoke((Object)unwrappedType3);
                    } else {
                        unwrappedType = null;
                    }
                }
                return unwrappedType;
            }
            {
                this.$substitute = function1;
                this.$c = context2;
                super(2);
            }
        };
        KotlinBuiltIns builtIns = BuiltInsProviderKt.getBuiltIns(c.getBuilder());
        List expectedParameters = this.valueParameters(lambda2.getExpectedType());
        UnwrappedType expectedReceiver = this.receiver(lambda2.getExpectedType());
        UnwrappedType unwrappedType2 = lambda2.getReceiver();
        if (unwrappedType2 != null) {
            UnwrappedType unwrappedType3 = unwrappedType2;
            boolean bl = false;
            boolean bl2 = false;
            UnwrappedType it = unwrappedType3;
            boolean bl3 = false;
            UnwrappedType unwrappedType4 = expectedReceiver;
            if (unwrappedType4 == null) {
                List list4 = expectedParameters;
                unwrappedType4 = list4 != null ? (UnwrappedType)CollectionsKt.getOrNull((List)list4, (int)0) : null;
            }
            unwrappedType = $fun$expectedOrActualType$1.invoke(unwrappedType4, lambda2.getReceiver());
        } else {
            unwrappedType = null;
        }
        UnwrappedType receiver = unwrappedType;
        if (receiver == null && expectedReceiver != null && expectedParameters != null) {
            list3 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)expectedReceiver), (Iterable)expectedParameters);
        } else if (receiver == null && expectedReceiver != null) {
            list3 = CollectionsKt.listOf((Object)expectedReceiver);
        } else if (receiver != null && expectedReceiver == null) {
            List list5 = expectedParameters;
            list3 = list5 != null ? CollectionsKt.drop((Iterable)list5, (int)1) : null;
        } else {
            list3 = expectedParameters;
        }
        List list6 = expectedParametersToMatchAgainst = list3;
        if (list6 != null) {
            Iterable $this$mapIndexed$iv = list6;
            boolean $i$f$mapIndexed = false;
            Iterable bl3 = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index2;
                void expected;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                UnwrappedType unwrappedType5 = (UnwrappedType)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                UnwrappedType unwrappedType6 = $fun$expectedOrActualType$1.invoke((UnwrappedType)expected, (UnwrappedType)CollectionsKt.getOrNull(lambda2.getParameters(), (int)index2));
                if (unwrappedType6 == null) {
                    SimpleType simpleType2 = builtIns.getNothingType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"builtIns.nothingType");
                    unwrappedType6 = simpleType2;
                }
                UnwrappedType unwrappedType7 = unwrappedType6;
                collection.add(unwrappedType7);
            }
            list2 = (List)destination$iv$iv;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = lambda2.getParameters();
            boolean $i$f$map = false;
            $this$mapIndexedTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(substitute2.invoke(item$iv$iv));
            }
            list2 = (List)destination$iv$iv;
        }
        List parameters2 = list2;
        UnwrappedType rawReturnType = lambda2.getReturnType();
        UnwrappedType unwrappedType8 = expectedTypeForReturnArguments = c.canBeProper(rawReturnType) ? (UnwrappedType)substitute2.invoke((Object)rawReturnType) : (c.hasUpperOrEqualUnitConstraint(rawReturnType) ? (UnwrappedType)builtIns.getUnitType() : null);
        Object object2 = lambda2.getExpectedType();
        if (object2 != null && (object2 = object2.getAnnotations()) != null) {
            destination$iv$iv = object2;
            $i$f$mapTo = false;
            index$iv$iv = 0;
            Object annotations2 = destination$iv$iv;
            boolean bl = false;
            object = receiver != null || expectedReceiver == null ? annotations2 : (Annotations)new FilteredAnnotations((Annotations)annotations2, true, (Function1<? super FqName, Boolean>)((Function1)analyzeLambda.convertedAnnotations.1.1.INSTANCE));
        } else {
            object = null;
        }
        Object convertedAnnotations2 = object;
        LambdaKotlinCallArgument lambdaKotlinCallArgument = lambda2.getAtom();
        boolean bl = lambda2.isSuspend();
        Object object3 = convertedAnnotations2;
        if (object3 == null) {
            object3 = Annotations.Companion.getEMPTY();
        }
        Map<TypeVariableMarker, StubTypeMarker> $this$cast$iv = substitutorAndStubsForLambdaAnalysis.getStubsForPostponedVariables();
        boolean $i$f$cast = false;
        Map<TypeVariableMarker, StubTypeMarker> map2 = $this$cast$iv;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<org.jetbrains.kotlin.resolve.calls.inference.model.NewTypeVariable, org.jetbrains.kotlin.types.StubType>");
        }
        ReturnArgumentsAnalysisResult returnArgumentsAnalysisResult = resolutionCallbacks.analyzeAndGetLambdaReturnArguments(lambdaKotlinCallArgument, bl, receiver, parameters2, expectedTypeForReturnArguments, (Annotations)object3, map2);
        this.applyResultsOfAnalyzedLambdaToCandidateSystem(c, lambda2, returnArgumentsAnalysisResult, diagnosticHolder, substitute2);
        return returnArgumentsAnalysisResult;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyResultsOfAnalyzedLambdaToCandidateSystem(@NotNull Context c, @NotNull ResolvedLambdaAtom lambda2, @NotNull ReturnArgumentsAnalysisResult returnArgumentsAnalysisResult, @NotNull KotlinDiagnosticsHolder diagnosticHolder, @NotNull Function1<? super KotlinType, ? extends UnwrappedType> substitute2) {
        Object object;
        void inferenceSession;
        void $this$mapTo$iv$iv;
        void returnArgumentsInfo;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)returnArgumentsAnalysisResult, (String)"returnArgumentsAnalysisResult");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter(substitute2, (String)"substitute");
        ReturnArgumentsAnalysisResult returnArgumentsAnalysisResult2 = returnArgumentsAnalysisResult;
        ReturnArgumentsInfo returnArgumentsInfo2 = returnArgumentsAnalysisResult2.component1();
        InferenceSession inferenceSession2 = returnArgumentsAnalysisResult2.component2();
        boolean hasInapplicableCallForBuilderInference = returnArgumentsAnalysisResult2.component3();
        if (hasInapplicableCallForBuilderInference) {
            c.getBuilder().removePostponedVariables();
            return;
        }
        List returnArguments = returnArgumentsInfo.getNonErrorArguments();
        Iterable $this$forEach$iv = returnArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinCallArgument it = (KotlinCallArgument)element$iv;
            boolean bl = false;
            ConstraintSystemBuilderKt.addSubsystemFromArgument(c, it);
        }
        KotlinCallArgument lastExpression = returnArgumentsInfo.getLastExpression();
        List allReturnArguments = lastExpression != null && returnArgumentsInfo.getLastExpressionCoercedToUnit() && ConstraintSystemBuilderKt.addSubsystemFromArgument(c, lastExpression) ? CollectionsKt.plus((Collection)returnArguments, (Object)lastExpression) : returnArguments;
        Iterable $this$map$iv = allReturnArguments;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinCallArgument kotlinCallArgument = (KotlinCallArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            UnwrappedType unwrappedType = lambda2.getReturnType();
            Function1<? super KotlinType, ? extends UnwrappedType> function1 = substitute2;
            boolean bl3 = false;
            boolean bl4 = false;
            ResolvedAtom resolvedAtom = PostponeArgumentsChecksKt.resolveKtPrimitive(c.getBuilder(), (KotlinCallArgument)it, (UnwrappedType)function1.invoke((Object)unwrappedType), diagnosticHolder, ReceiverInfo.Companion.getNotReceiver(), null, (InferenceSession)inferenceSession);
            collection.add(resolvedAtom);
        }
        List subResolvedKtPrimitives = (List)destination$iv$iv;
        if (!returnArgumentsInfo.getReturnArgumentsExist()) {
            SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(lambda2.getReturnType()).getUnitType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"lambda.returnType.builtIns.unitType");
            SimpleType unitType = simpleType2;
            object = lambda2.getReturnType();
            boolean bl5 = false;
            $i$f$mapTo2 = false;
            UnwrappedType lambdaReturnType = (UnwrappedType)substitute2.invoke(object);
            c.getBuilder().addSubtypeConstraint(unitType, lambdaReturnType, new LambdaArgumentConstraintPosition(lambda2));
        }
        lambda2.setAnalyzedResults((ReturnArgumentsInfo)returnArgumentsInfo, subResolvedKtPrimitives);
        if (inferenceSession != null && lambda2.getAtom().getHasBuilderInferenceAnnotation()) {
            ConstraintStorage storageSnapshot = c.getBuilder().currentStorage();
            Map<TypeConstructor, UnwrappedType> postponedVariables = inferenceSession.inferPostponedVariables(lambda2, storageSnapshot, diagnosticHolder);
            if (postponedVariables == null) {
                c.getBuilder().removePostponedVariables();
                return;
            }
            Object $i$f$mapTo2 = postponedVariables;
            boolean bl6 = false;
            Iterator<Map.Entry<TypeConstructor, UnwrappedType>> iterator2 = $i$f$mapTo2.entrySet().iterator();
            while (iterator2.hasNext()) {
                VariableWithConstraints variableWithConstraints;
                void constructor;
                Object item$iv$iv;
                item$iv$iv = object = iterator2.next();
                boolean it = false;
                $i$f$mapTo2 = (TypeConstructor)item$iv$iv.getKey();
                item$iv$iv = object;
                it = false;
                UnwrappedType resultType = (UnwrappedType)item$iv$iv.getValue();
                if (storageSnapshot.getNotFixedTypeVariables().get(constructor) == null) {
                    continue;
                }
                TypeVariableMarker variable2 = variableWithConstraints.getTypeVariable();
                c.getBuilder().unmarkPostponedVariable(variable2);
                c.getBuilder().addEqualityConstraint(MarkerExtensionsKt.defaultType(variable2, c), resultType, new CoroutinePosition());
            }
        }
    }

    public static /* synthetic */ void applyResultsOfAnalyzedLambdaToCandidateSystem$default(PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, Context context2, ResolvedLambdaAtom resolvedLambdaAtom, ReturnArgumentsAnalysisResult returnArgumentsAnalysisResult, KotlinDiagnosticsHolder kotlinDiagnosticsHolder, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = postponedArgumentsAnalyzer.createSubstituteFunctorForLambdaAnalysis(context2).getSubstitute();
        }
        postponedArgumentsAnalyzer.applyResultsOfAnalyzedLambdaToCandidateSystem(context2, resolvedLambdaAtom, returnArgumentsAnalysisResult, kotlinDiagnosticsHolder, function1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final UnwrappedType receiver(UnwrappedType $this$receiver) {
        UnwrappedType $this$forFunctionalType$iv = $this$receiver;
        PostponedArgumentsAnalyzer this_$iv = this;
        boolean $i$f$forFunctionalType = false;
        UnwrappedType unwrappedType = $this$forFunctionalType$iv;
        if (unwrappedType == null) return null;
        if (!FunctionTypesKt.isBuiltinFunctionalType(unwrappedType)) return null;
        UnwrappedType $this$forFunctionalType = $this$forFunctionalType$iv;
        boolean bl = false;
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType($this$forFunctionalType);
        if (kotlinType == null) return null;
        UnwrappedType unwrappedType2 = kotlinType.unwrap();
        return unwrappedType2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<UnwrappedType> valueParameters(UnwrappedType $this$valueParameters) {
        void $this$mapTo$iv$iv;
        UnwrappedType $this$forFunctionalType$iv = $this$valueParameters;
        PostponedArgumentsAnalyzer this_$iv = this;
        boolean $i$f$forFunctionalType = false;
        UnwrappedType unwrappedType = $this$forFunctionalType$iv;
        if (unwrappedType == null) return null;
        if (!FunctionTypesKt.isBuiltinFunctionalType(unwrappedType)) return null;
        UnwrappedType $this$forFunctionalType = $this$forFunctionalType$iv;
        boolean bl = false;
        Iterable $this$map$iv = FunctionTypesKt.getValueParameterTypesFromFunctionType($this$forFunctionalType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            UnwrappedType unwrappedType2 = it.getType().unwrap();
            collection.add(unwrappedType2);
        }
        List list2 = (List)destination$iv$iv;
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <T> T forFunctionalType(UnwrappedType $this$forFunctionalType, Function1<? super UnwrappedType, ? extends T> f) {
        Object object;
        int $i$f$forFunctionalType = 0;
        UnwrappedType unwrappedType = $this$forFunctionalType;
        if (unwrappedType != null) {
            if (FunctionTypesKt.isBuiltinFunctionalType(unwrappedType)) {
                object = f.invoke((Object)$this$forFunctionalType);
                return (T)object;
            }
        }
        object = null;
        return (T)object;
    }

    public PostponedArgumentsAnalyzer(@NotNull CallableReferenceResolver callableReferenceResolver) {
        Intrinsics.checkNotNullParameter((Object)callableReferenceResolver, (String)"callableReferenceResolver");
        this.callableReferenceResolver = callableReferenceResolver;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H&J\u001c\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0007H&J\b\u0010\u000e\u001a\u00020\u000bH&J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\b\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "addOtherSystem", "", "otherSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "bindingStubsForPostponedVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/types/model/StubTypeMarker;", "buildCurrentSubstitutor", "Lorg/jetbrains/kotlin/types/model/TypeSubstitutorMarker;", "additionalBindings", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "buildNotFixedVariablesToStubTypesSubstitutor", "canBeProper", "", "type", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "getBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "hasUpperOrEqualUnitConstraint", "resolution"})
    public static interface Context
    extends TypeSystemInferenceExtensionContext {
        @NotNull
        public TypeSubstitutorMarker buildCurrentSubstitutor(@NotNull Map<TypeConstructorMarker, ? extends StubTypeMarker> var1);

        @NotNull
        public TypeSubstitutorMarker buildNotFixedVariablesToStubTypesSubstitutor();

        @NotNull
        public Map<TypeVariableMarker, StubTypeMarker> bindingStubsForPostponedVariables();

        public boolean canBeProper(@NotNull KotlinTypeMarker var1);

        public boolean hasUpperOrEqualUnitConstraint(@NotNull KotlinTypeMarker var1);

        public void addOtherSystem(@NotNull ConstraintStorage var1);

        @NotNull
        public ConstraintSystemBuilder getBuilder();

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static boolean identicalArguments(@NotNull Context $this, @NotNull SimpleTypeMarker a, @NotNull SimpleTypeMarker b) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return TypeSystemInferenceExtensionContext.DefaultImpls.identicalArguments($this, a, b);
            }

            public static boolean anySuperTypeConstructor(@NotNull Context $this, @NotNull KotlinTypeMarker $this$anySuperTypeConstructor, @NotNull Function1<? super TypeConstructorMarker, Boolean> predicate) {
                Intrinsics.checkNotNullParameter((Object)$this$anySuperTypeConstructor, (String)"$this$anySuperTypeConstructor");
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                return TypeSystemInferenceExtensionContext.DefaultImpls.anySuperTypeConstructor($this, $this$anySuperTypeConstructor, predicate);
            }

            @Nullable
            public static List<SimpleTypeMarker> fastCorrespondingSupertypes(@NotNull Context $this, @NotNull SimpleTypeMarker $this$fastCorrespondingSupertypes, @NotNull TypeConstructorMarker constructor) {
                Intrinsics.checkNotNullParameter((Object)$this$fastCorrespondingSupertypes, (String)"$this$fastCorrespondingSupertypes");
                Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
                return TypeSystemInferenceExtensionContext.DefaultImpls.fastCorrespondingSupertypes($this, $this$fastCorrespondingSupertypes, constructor);
            }

            @NotNull
            public static TypeArgumentMarker get(@NotNull Context $this, @NotNull TypeArgumentListMarker $this$get, int index2) {
                Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
                return TypeSystemInferenceExtensionContext.DefaultImpls.get($this, $this$get, index2);
            }

            @Nullable
            public static TypeArgumentMarker getArgumentOrNull(@NotNull Context $this, @NotNull SimpleTypeMarker $this$getArgumentOrNull, int index2) {
                Intrinsics.checkNotNullParameter((Object)$this$getArgumentOrNull, (String)"$this$getArgumentOrNull");
                return TypeSystemInferenceExtensionContext.DefaultImpls.getArgumentOrNull($this, $this$getArgumentOrNull, index2);
            }

            public static boolean hasFlexibleNullability(@NotNull Context $this, @NotNull KotlinTypeMarker $this$hasFlexibleNullability) {
                Intrinsics.checkNotNullParameter((Object)$this$hasFlexibleNullability, (String)"$this$hasFlexibleNullability");
                return TypeSystemInferenceExtensionContext.DefaultImpls.hasFlexibleNullability($this, $this$hasFlexibleNullability);
            }

            public static boolean isCapturedDynamic(@NotNull Context $this, @NotNull KotlinTypeMarker $this$isCapturedDynamic) {
                Intrinsics.checkNotNullParameter((Object)$this$isCapturedDynamic, (String)"$this$isCapturedDynamic");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedDynamic($this, $this$isCapturedDynamic);
            }

            public static boolean isCapturedType(@NotNull Context $this, @NotNull KotlinTypeMarker $this$isCapturedType) {
                Intrinsics.checkNotNullParameter((Object)$this$isCapturedType, (String)"$this$isCapturedType");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedType($this, $this$isCapturedType);
            }

            public static boolean isClassType(@NotNull Context $this, @NotNull SimpleTypeMarker $this$isClassType) {
                Intrinsics.checkNotNullParameter((Object)$this$isClassType, (String)"$this$isClassType");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isClassType($this, $this$isClassType);
            }

            public static boolean isDefinitelyNotNullType(@NotNull Context $this, @NotNull KotlinTypeMarker $this$isDefinitelyNotNullType) {
                Intrinsics.checkNotNullParameter((Object)$this$isDefinitelyNotNullType, (String)"$this$isDefinitelyNotNullType");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDefinitelyNotNullType($this, $this$isDefinitelyNotNullType);
            }

            public static boolean isDynamic(@NotNull Context $this, @NotNull KotlinTypeMarker $this$isDynamic) {
                Intrinsics.checkNotNullParameter((Object)$this$isDynamic, (String)"$this$isDynamic");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDynamic($this, $this$isDynamic);
            }

            public static boolean isFlexible(@NotNull Context $this, @NotNull KotlinTypeMarker $this$isFlexible) {
                Intrinsics.checkNotNullParameter((Object)$this$isFlexible, (String)"$this$isFlexible");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexible($this, $this$isFlexible);
            }

            public static boolean isFlexibleNothing(@NotNull Context $this, @NotNull KotlinTypeMarker $this$isFlexibleNothing) {
                Intrinsics.checkNotNullParameter((Object)$this$isFlexibleNothing, (String)"$this$isFlexibleNothing");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexibleNothing($this, $this$isFlexibleNothing);
            }

            public static boolean isIntegerLiteralType(@NotNull Context $this, @NotNull SimpleTypeMarker $this$isIntegerLiteralType) {
                Intrinsics.checkNotNullParameter((Object)$this$isIntegerLiteralType, (String)"$this$isIntegerLiteralType");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isIntegerLiteralType($this, $this$isIntegerLiteralType);
            }

            public static boolean isNothing(@NotNull Context $this, @NotNull KotlinTypeMarker $this$isNothing) {
                Intrinsics.checkNotNullParameter((Object)$this$isNothing, (String)"$this$isNothing");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNothing($this, $this$isNothing);
            }

            public static boolean isNullableAny(@NotNull Context $this, @NotNull KotlinTypeMarker $this$isNullableAny) {
                Intrinsics.checkNotNullParameter((Object)$this$isNullableAny, (String)"$this$isNullableAny");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableAny($this, $this$isNullableAny);
            }

            public static boolean isNullableNothing(@NotNull Context $this, @NotNull KotlinTypeMarker $this$isNullableNothing) {
                Intrinsics.checkNotNullParameter((Object)$this$isNullableNothing, (String)"$this$isNullableNothing");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableNothing($this, $this$isNullableNothing);
            }

            public static boolean isSimpleType(@NotNull Context $this, @NotNull KotlinTypeMarker $this$isSimpleType) {
                Intrinsics.checkNotNullParameter((Object)$this$isSimpleType, (String)"$this$isSimpleType");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isSimpleType($this, $this$isSimpleType);
            }

            @NotNull
            public static SimpleTypeMarker lowerBoundIfFlexible(@NotNull Context $this, @NotNull KotlinTypeMarker $this$lowerBoundIfFlexible) {
                Intrinsics.checkNotNullParameter((Object)$this$lowerBoundIfFlexible, (String)"$this$lowerBoundIfFlexible");
                return TypeSystemInferenceExtensionContext.DefaultImpls.lowerBoundIfFlexible($this, $this$lowerBoundIfFlexible);
            }

            public static int size(@NotNull Context $this, @NotNull TypeArgumentListMarker $this$size) {
                Intrinsics.checkNotNullParameter((Object)$this$size, (String)"$this$size");
                return TypeSystemInferenceExtensionContext.DefaultImpls.size($this, $this$size);
            }

            @NotNull
            public static TypeConstructorMarker typeConstructor(@NotNull Context $this, @NotNull KotlinTypeMarker $this$typeConstructor) {
                Intrinsics.checkNotNullParameter((Object)$this$typeConstructor, (String)"$this$typeConstructor");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeConstructor($this, $this$typeConstructor);
            }

            public static int typeDepth(@NotNull Context $this, @NotNull KotlinTypeMarker $this$typeDepth) {
                Intrinsics.checkNotNullParameter((Object)$this$typeDepth, (String)"$this$typeDepth");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeDepth($this, $this$typeDepth);
            }

            @NotNull
            public static SimpleTypeMarker upperBoundIfFlexible(@NotNull Context $this, @NotNull KotlinTypeMarker $this$upperBoundIfFlexible) {
                Intrinsics.checkNotNullParameter((Object)$this$upperBoundIfFlexible, (String)"$this$upperBoundIfFlexible");
                return TypeSystemInferenceExtensionContext.DefaultImpls.upperBoundIfFlexible($this, $this$upperBoundIfFlexible);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J5\u0010\u0011\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$SubstitutorAndStubsForLambdaAnalysis;", "", "stubsForPostponedVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/types/model/StubTypeMarker;", "substitute", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "(Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "getStubsForPostponedVariables", "()Ljava/util/Map;", "getSubstitute", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolution"})
    public static final class SubstitutorAndStubsForLambdaAnalysis {
        @NotNull
        private final Map<TypeVariableMarker, StubTypeMarker> stubsForPostponedVariables;
        @NotNull
        private final Function1<KotlinType, UnwrappedType> substitute;

        @NotNull
        public final Map<TypeVariableMarker, StubTypeMarker> getStubsForPostponedVariables() {
            return this.stubsForPostponedVariables;
        }

        @NotNull
        public final Function1<KotlinType, UnwrappedType> getSubstitute() {
            return this.substitute;
        }

        public SubstitutorAndStubsForLambdaAnalysis(@NotNull Map<TypeVariableMarker, ? extends StubTypeMarker> stubsForPostponedVariables, @NotNull Function1<? super KotlinType, ? extends UnwrappedType> substitute2) {
            Intrinsics.checkNotNullParameter(stubsForPostponedVariables, (String)"stubsForPostponedVariables");
            Intrinsics.checkNotNullParameter(substitute2, (String)"substitute");
            this.stubsForPostponedVariables = stubsForPostponedVariables;
            this.substitute = substitute2;
        }

        @NotNull
        public final Map<TypeVariableMarker, StubTypeMarker> component1() {
            return this.stubsForPostponedVariables;
        }

        @NotNull
        public final Function1<KotlinType, UnwrappedType> component2() {
            return this.substitute;
        }

        @NotNull
        public final SubstitutorAndStubsForLambdaAnalysis copy(@NotNull Map<TypeVariableMarker, ? extends StubTypeMarker> stubsForPostponedVariables, @NotNull Function1<? super KotlinType, ? extends UnwrappedType> substitute2) {
            Intrinsics.checkNotNullParameter(stubsForPostponedVariables, (String)"stubsForPostponedVariables");
            Intrinsics.checkNotNullParameter(substitute2, (String)"substitute");
            return new SubstitutorAndStubsForLambdaAnalysis(stubsForPostponedVariables, substitute2);
        }

        public static /* synthetic */ SubstitutorAndStubsForLambdaAnalysis copy$default(SubstitutorAndStubsForLambdaAnalysis substitutorAndStubsForLambdaAnalysis, Map map2, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = substitutorAndStubsForLambdaAnalysis.stubsForPostponedVariables;
            }
            if ((n & 2) != 0) {
                function1 = substitutorAndStubsForLambdaAnalysis.substitute;
            }
            return substitutorAndStubsForLambdaAnalysis.copy(map2, function1);
        }

        @NotNull
        public String toString() {
            return "SubstitutorAndStubsForLambdaAnalysis(stubsForPostponedVariables=" + this.stubsForPostponedVariables + ", substitute=" + this.substitute + ")";
        }

        public int hashCode() {
            Map<TypeVariableMarker, StubTypeMarker> map2 = this.stubsForPostponedVariables;
            Function1<KotlinType, UnwrappedType> function1 = this.substitute;
            return (map2 != null ? ((Object)map2).hashCode() : 0) * 31 + (function1 != null ? function1.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SubstitutorAndStubsForLambdaAnalysis)) break block3;
                    SubstitutorAndStubsForLambdaAnalysis substitutorAndStubsForLambdaAnalysis = (SubstitutorAndStubsForLambdaAnalysis)object;
                    if (!Intrinsics.areEqual(this.stubsForPostponedVariables, substitutorAndStubsForLambdaAnalysis.stubsForPostponedVariables) || !Intrinsics.areEqual(this.substitute, substitutorAndStubsForLambdaAnalysis.substitute)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

