/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.PersistentApiKt;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "lowerConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irConstructor", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "ir.backend.common"})
public final class InnerClassesLowering
implements DeclarationTransformer {
    @NotNull
    private final BackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.toFileLoweringPass(LowerKt.runPostfix(this, true)).lower(irFile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof IrClass && ((IrClass)declaration2).isInner()) {
            PersistentApiKt.getStageController().unrestrictDeclarationListsAccess((Function0)new Function0<Unit>(this, declaration2){
                final /* synthetic */ InnerClassesLowering this$0;
                final /* synthetic */ IrDeclaration $declaration;

                public final void invoke() {
                    Collection collection = ((IrClass)this.$declaration).getDeclarations();
                    IrField irField = this.this$0.getContext().getDeclarationFactory().getOuterThisField((IrClass)this.$declaration);
                    boolean bl = false;
                    collection.add(irField);
                }
                {
                    this.this$0 = innerClassesLowering;
                    this.$declaration = irDeclaration2;
                    super(0);
                }
            });
        } else if (declaration2 instanceof IrConstructor) {
            IrClass irClass2 = IrUtilsKt.getParentAsClass(declaration2);
            if (!irClass2.isInner()) {
                return null;
            }
            IrConstructor newConstructor2 = this.lowerConstructor((IrConstructor)declaration2);
            Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(this.context, (IrConstructor)declaration2);
            for (Map.Entry entry : oldConstructorParameterToNew.entrySet()) {
                IrExpressionBodyImpl irExpressionBodyImpl;
                void oldParam;
                IrValueParameter newParam;
                Object object = entry;
                boolean bl = false;
                IrValueParameter irValueParameter = (IrValueParameter)object.getKey();
                object = entry;
                bl = false;
                IrValueParameter irValueParameter2 = newParam = (IrValueParameter)object.getValue();
                IrExpressionBody irExpressionBody = oldParam.getDefaultValue();
                if (irExpressionBody != null) {
                    void oldDefault;
                    object = irExpressionBody;
                    bl = false;
                    boolean bl2 = false;
                    Object object2 = object;
                    IrValueParameter irValueParameter3 = irValueParameter2;
                    boolean bl3 = false;
                    IrExpressionBodyImpl irExpressionBodyImpl2 = new IrExpressionBodyImpl(oldDefault.getStartOffset(), oldDefault.getEndOffset(), (Function1<? super IrExpressionBodyImpl, Unit>)((Function1)new Function1<IrExpressionBodyImpl, Unit>((IrExpressionBody)oldDefault, newConstructor2){
                        final /* synthetic */ IrExpressionBody $oldDefault;
                        final /* synthetic */ IrConstructor $newConstructor$inlined;
                        {
                            this.$oldDefault = irExpressionBody;
                            this.$newConstructor$inlined = irConstructor;
                            super(1);
                        }

                        public final void invoke(@NotNull IrExpressionBodyImpl $receiver) {
                            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                            $receiver.setExpression((IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)this.$oldDefault.getExpression(), this.$newConstructor$inlined));
                        }
                    }));
                    irValueParameter2 = irValueParameter3;
                    irExpressionBodyImpl = irExpressionBodyImpl2;
                } else {
                    irExpressionBodyImpl = null;
                }
                irValueParameter2.setDefaultValue(irExpressionBodyImpl);
            }
            return CollectionsKt.listOf((Object)newConstructor2);
        }
        return null;
    }

    private final IrConstructor lowerConstructor(IrConstructor irConstructor) {
        IrConstructor loweredConstructor = this.context.getDeclarationFactory().getInnerClassConstructorWithOuterThisParameter(irConstructor);
        IrValueParameter outerThisParameter = loweredConstructor.getValueParameters().get(0);
        IrClass irClass2 = IrUtilsKt.getParentAsClass(irConstructor);
        IrField parentThisField = this.context.getDeclarationFactory().getOuterThisField(irClass2);
        IrBody irBody = irConstructor.getBody();
        if (!(irBody instanceof IrBlockBody)) {
            irBody = null;
        }
        IrBlockBody irBlockBody2 = (IrBlockBody)irBody;
        if (irBlockBody2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected constructor body: " + irConstructor.getBody())));
        }
        IrBlockBody blockBody = irBlockBody2;
        loweredConstructor.setBody(new IrBlockBodyImpl(blockBody.getStartOffset(), blockBody.getEndOffset(), (Function1<? super IrBlockBodyImpl, Unit>)((Function1)new Function1<IrBlockBodyImpl, Unit>(this, irConstructor, irClass2, parentThisField, outerThisParameter, blockBody, loweredConstructor){
            final /* synthetic */ InnerClassesLowering this$0;
            final /* synthetic */ IrConstructor $irConstructor;
            final /* synthetic */ IrClass $irClass;
            final /* synthetic */ IrField $parentThisField;
            final /* synthetic */ IrValueParameter $outerThisParameter;
            final /* synthetic */ IrBlockBody $blockBody;
            final /* synthetic */ IrConstructor $loweredConstructor;

            public final void invoke(@NotNull IrBlockBodyImpl $receiver) {
                Object v4;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                    Object object = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), this.$irConstructor.getSymbol(), this.$irConstructor.getStartOffset(), this.$irConstructor.getEndOffset());
                    boolean bl = false;
                    boolean bl2 = false;
                    DeclarationIrBuilder $this$apply = object;
                    boolean $i$a$-apply-InnerClassesLowering$lowerConstructor$1$22 = false;
                    List<IrStatement> list2 = $receiver.getStatements();
                    IrBuilderWithScope irBuilderWithScope = $this$apply;
                    IrBuilderWithScope irBuilderWithScope2 = $this$apply;
                    IrValueParameter irValueParameter = this.$irClass.getThisReceiver();
                    Intrinsics.checkNotNull((Object)irValueParameter);
                    list2.add(0, ExpressionHelpersKt.irSetField(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), this.$parentThisField, ExpressionHelpersKt.irGet($this$apply, this.$outerThisParameter)));
                    $receiver.getStatements().addAll((Collection<IrStatement>)this.$blockBody.getStatements());
                    object = $receiver.getStatements();
                    bl = false;
                    Object object2 = object;
                    boolean bl3 = false;
                    Iterator<T> $i$a$-apply-InnerClassesLowering$lowerConstructor$1$22 = object2.iterator();
                    while ($i$a$-apply-InnerClassesLowering$lowerConstructor$1$22.hasNext()) {
                        T t = $i$a$-apply-InnerClassesLowering$lowerConstructor$1$22.next();
                        IrStatement it = (IrStatement)t;
                        boolean bl4 = false;
                        if (!(it instanceof IrInstanceInitializerCall)) continue;
                        v4 = t;
                        break block4;
                    }
                    v4 = null;
                }
                if (v4 == null) {
                    Object v5;
                    boolean bl;
                    Object object;
                    block5: {
                        object = $receiver.getStatements();
                        bl = false;
                        Iterable iterable = object;
                        boolean $i$a$-apply-InnerClassesLowering$lowerConstructor$1$22 = false;
                        for (E e : iterable) {
                            IrStatement it = (IrStatement)e;
                            boolean bl5 = false;
                            if (!(it instanceof IrDelegatingConstructorCall)) continue;
                            v5 = e;
                            break block5;
                        }
                        v5 = null;
                    }
                    IrDelegatingConstructorCall irDelegatingConstructorCall = v5;
                    if (irDelegatingConstructorCall == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Delegating constructor call expected: " + DumpIrTreeKt.dump$default(this.$irConstructor, false, 1, null))));
                    }
                    IrDelegatingConstructorCall delegatingConstructorCall = irDelegatingConstructorCall;
                    object = delegatingConstructorCall;
                    bl = false;
                    boolean bl6 = false;
                    Object $this$apply = object;
                    boolean bl7 = false;
                    $this$apply.setDispatchReceiver(new IrGetValueImpl($this$apply.getStartOffset(), $this$apply.getEndOffset(), this.$outerThisParameter.getSymbol(), null, 8, null));
                }
                PatchDeclarationParentsKt.patchDeclarationParents((IrElement)$receiver, this.$loweredConstructor);
                Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(this.this$0.getContext(), this.$irConstructor);
                IrElementTransformerVoidKt.transformChildrenVoid($receiver, new VariableRemapper(oldConstructorParameterToNew));
            }
            {
                this.this$0 = innerClassesLowering;
                this.$irConstructor = irConstructor;
                this.$irClass = irClass2;
                this.$parentThisField = irField;
                this.$outerThisParameter = irValueParameter;
                this.$blockBody = irBlockBody2;
                this.$loweredConstructor = irConstructor2;
                super(1);
            }
        })));
        return loweredConstructor;
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public InnerClassesLowering(@NotNull BackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }
}

