/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class JavaModuleIndexImpl
extends JpsElementBase<JavaModuleIndexImpl>
implements JavaModuleIndex {
    private static final String SOURCE_SUFFIX = ":S";
    private static final String TEST_SUFFIX = ":T";
    private static final String MODULE_INFO_FILE = "module-info.java";
    private final Map<String, File> myMapping;
    private final JpsCompilerExcludes myExcludes;

    public JavaModuleIndexImpl(@NotNull JpsCompilerExcludes excludes) {
        if (excludes == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(0);
        }
        this.myMapping = new HashMap<String, File>();
        this.myExcludes = excludes;
    }

    @Override
    @NotNull
    public JavaModuleIndexImpl createCopy() {
        JavaModuleIndexImpl copy2 = new JavaModuleIndexImpl(this.myExcludes);
        copy2.myMapping.putAll(this.myMapping);
        JavaModuleIndexImpl javaModuleIndexImpl = copy2;
        if (javaModuleIndexImpl == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(1);
        }
        return javaModuleIndexImpl;
    }

    @Override
    public void applyChanges(@NotNull JavaModuleIndexImpl modified) {
        if (modified == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(2);
        }
    }

    @Override
    @Nullable
    public File getModuleInfoFile(@NotNull JpsModule module2, boolean forTests) {
        String key;
        if (module2 == null) {
            JavaModuleIndexImpl.$$$reportNull$$$0(3);
        }
        if (this.myMapping.containsKey(key = module2.getName() + (forTests ? TEST_SUFFIX : SOURCE_SUFFIX))) {
            return this.myMapping.get(key);
        }
        File file2 = this.findModuleInfoFile(module2, forTests ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
        this.myMapping.put(key, file2);
        return file2;
    }

    private File findModuleInfoFile(JpsModule module2, JavaSourceRootType rootType) {
        for (JpsModuleSourceRoot root2 : module2.getSourceRoots()) {
            File file2;
            if (!rootType.equals(root2.getRootType()) || !(file2 = new File(JpsPathUtil.urlToOsPath((String)root2.getUrl()), MODULE_INFO_FILE)).isFile() || this.myExcludes.isExcluded(file2)) continue;
            return file2;
        }
        return null;
    }

    public void dropCache() {
        this.myMapping.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/JavaModuleIndexImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInfoFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

