/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImpl;
import org.jetbrains.kotlin.fir.deserialization.FirTypeDeserializer$WhenMappings;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlags;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0019H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010!\u001a\u00020\"H\u0002J\f\u0010.\u001a\u00020/*\u000200H\u0002J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00100\t*\u0006\u0012\u0002\b\u000302R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00100\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "typeParameterProtos", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "parent", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;Ljava/util/List;Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;)V", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "ownTypeParameters", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getOwnTypeParameters", "()Ljava/util/List;", "getParent", "()Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "typeParameterDescriptors", "", "", "getTypeTable", "()Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "computeClassifier", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "fqNameIndex", "simpleType", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "typeArgument", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinTypeProjection;", "typeArgumentProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument;", "typeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeTypeParameterLookupTag;", "typeParameterId", "typeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassifierLookupTag;", "convertVariance", "Lorg/jetbrains/kotlin/types/Variance;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Variance;", "typeParameters", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "resolve"})
public final class FirTypeDeserializer {
    private final Map<Integer, FirTypeParameterSymbol> typeParameterDescriptors;
    @NotNull
    private final FirSession session;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;
    @Nullable
    private final FirTypeDeserializer parent;

    private final ConeClassLikeLookupTag computeClassifier(int fqNameIndex) {
        try {
            ClassId id = NameResolverUtilKt.getClassId(this.nameResolver, fqNameIndex);
            return new ConeClassLikeLookupTagImpl(id);
        }
        catch (Throwable e) {
            throw (Throwable)new RuntimeException("Looking up for " + NameResolverUtilKt.getClassId(this.nameResolver, fqNameIndex), e);
        }
    }

    @NotNull
    public final ConeKotlinType type(@NotNull ProtoBuf.Type proto) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.nameResolver.getString(proto.getFlexibleTypeCapabilitiesId());
            ConeLookupTagBasedType lowerBound = this.simpleType(proto);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.typeTable);
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            ConeLookupTagBasedType upperBound = this.simpleType(type2);
            ConeLookupTagBasedType coneLookupTagBasedType = lowerBound;
            if (coneLookupTagBasedType == null) {
                Intrinsics.throwNpe();
            }
            ConeKotlinType coneKotlinType = coneLookupTagBasedType;
            ConeLookupTagBasedType coneLookupTagBasedType2 = upperBound;
            if (coneLookupTagBasedType2 == null) {
                Intrinsics.throwNpe();
            }
            return new ConeFlexibleType(coneKotlinType, coneLookupTagBasedType2);
        }
        ConeLookupTagBasedType coneLookupTagBasedType = this.simpleType(proto);
        return coneLookupTagBasedType != null ? (ConeKotlinType)coneLookupTagBasedType : (ConeKotlinType)new ConeClassErrorType("?!id:0");
    }

    private final ConeTypeParameterLookupTag typeParameterSymbol(int typeParameterId) {
        Object object = this.typeParameterDescriptors.get(typeParameterId);
        if (object == null || (object = ((FirTypeParameterSymbol)object).toLookupTag()) == null) {
            FirTypeDeserializer firTypeDeserializer = this.parent;
            object = firTypeDeserializer != null ? firTypeDeserializer.typeParameterSymbol(typeParameterId) : null;
        }
        return object;
    }

    private final Variance convertVariance(@NotNull ProtoBuf.TypeParameter.Variance $this$convertVariance) {
        Variance variance;
        switch (FirTypeDeserializer$WhenMappings.$EnumSwitchMapping$0[$this$convertVariance.ordinal()]) {
            case 1: {
                variance = Variance.IN_VARIANCE;
                break;
            }
            case 2: {
                variance = Variance.OUT_VARIANCE;
                break;
            }
            case 3: {
                variance = Variance.INVARIANT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return variance;
    }

    @NotNull
    public final List<FirTypeParameterSymbol> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameterSymbol> typeParameters(@NotNull FirClassLikeSymbol<?> $this$typeParameters) {
        List list2;
        Object object;
        Intrinsics.checkParameterIsNotNull($this$typeParameters, (String)"$this$typeParameters");
        Object e = $this$typeParameters.getFir();
        if (!(e instanceof FirTypeParametersOwner)) {
            e = null;
        }
        if ((object = (FirTypeParametersOwner)e) != null && (object = object.getTypeParameters()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirTypeParameterSymbol firTypeParameterSymbol = it.getSymbol();
                collection.add(firTypeParameterSymbol);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        List list3 = list2;
        boolean bl = false;
        List list4 = list3;
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        return list4;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConeLookupTagBasedType simpleType(@NotNull ProtoBuf.Type proto) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        ConeClassifierLookupTag coneClassifierLookupTag = this.typeSymbol(proto);
        if (coneClassifierLookupTag == null) {
            return null;
        }
        ConeClassifierLookupTag constructor = coneClassifierLookupTag;
        if (constructor instanceof ConeTypeParameterLookupTag) {
            return new ConeTypeParameterTypeImpl((ConeTypeParameterLookupTag)constructor, proto.getNullable());
        }
        if (!(constructor instanceof ConeClassLikeLookupTag)) {
            return null;
        }
        Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>> $fun$collectAllArguments$1 = new Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>>(this){
            final /* synthetic */ FirTypeDeserializer this$0;

            @NotNull
            public final List<ProtoBuf.Type.Argument> invoke(@NotNull ProtoBuf.Type $this$collectAllArguments) {
                Intrinsics.checkParameterIsNotNull((Object)$this$collectAllArguments, (String)"$this$collectAllArguments");
                List<ProtoBuf.Type.Argument> list2 = $this$collectAllArguments.getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"argumentList");
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.outerType($this$collectAllArguments, this.this$0.getTypeTable());
                List list3 = type2 != null ? this.invoke(type2) : null;
                Collection collection = list2;
                boolean bl = false;
                List list4 = list3;
                if (list4 == null) {
                    list4 = CollectionsKt.emptyList();
                }
                List list5 = list4;
                return CollectionsKt.plus((Collection)collection, (Iterable)list5);
            }
            {
                this.this$0 = firTypeDeserializer;
                super(1);
            }
        };
        Iterable iterable = $fun$collectAllArguments$1.invoke(proto);
        FirTypeDeserializer firTypeDeserializer = this;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeKotlinTypeProjection coneKotlinTypeProjection = firTypeDeserializer.typeArgument((ProtoBuf.Type.Argument)p1);
            collection.add(coneKotlinTypeProjection);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = thisCollection$iv.toArray(new ConeKotlinTypeProjection[0]);
        if (coneKotlinTypeProjectionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ConeKotlinTypeProjection[] arguments2 = coneKotlinTypeProjectionArray;
        Boolean bl = Flags.SUSPEND_TYPE.get(proto.getFlags());
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"Flags.SUSPEND_TYPE.get(proto.flags)");
        ConeClassLikeType simpleType2 = bl != false ? (ConeClassLikeType)new ConeClassErrorType("createSuspendFunctionType not supported") : (ConeClassLikeType)new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)constructor, arguments2, proto.getNullable());
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.abbreviatedType(proto, this.typeTable);
        if (type2 == null) {
            return simpleType2;
        }
        ProtoBuf.Type abbreviatedTypeProto = type2;
        ConeClassifierLookupTag coneClassifierLookupTag2 = this.typeSymbol(abbreviatedTypeProto);
        if (coneClassifierLookupTag2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag");
        }
        return new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)coneClassifierLookupTag2, arguments2, false);
    }

    private final ConeClassifierLookupTag typeSymbol(ProtoBuf.Type proto) {
        ConeClassifierLookupTag coneClassifierLookupTag;
        if (proto.hasClassName()) {
            coneClassifierLookupTag = this.computeClassifier(proto.getClassName());
        } else if (proto.hasTypeAliasName()) {
            coneClassifierLookupTag = this.computeClassifier(proto.getTypeAliasName());
        } else if (proto.hasTypeParameter()) {
            coneClassifierLookupTag = this.typeParameterSymbol(proto.getTypeParameter());
        } else if (proto.hasTypeParameterName()) {
            Object v1;
            block9: {
                String name2 = this.nameResolver.getString(proto.getTypeParameterName());
                Iterable iterable = this.getOwnTypeParameters();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    FirTypeParameterSymbol it = (FirTypeParameterSymbol)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name2)) continue;
                    v1 = t;
                    break block9;
                }
                v1 = null;
            }
            FirTypeParameterSymbol firTypeParameterSymbol = v1;
            coneClassifierLookupTag = firTypeParameterSymbol != null ? firTypeParameterSymbol.toLookupTag() : null;
        } else {
            coneClassifierLookupTag = null;
        }
        return coneClassifierLookupTag;
    }

    private final ConeKotlinTypeProjection typeArgument(ProtoBuf.Type.Argument typeArgumentProto) {
        if (typeArgumentProto.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            return ConeStarProjection.INSTANCE;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull((Object)projection, (String)"typeArgumentProto.projection");
        Variance variance = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.typeTable);
        if (type2 == null) {
            return new ConeClassErrorType("No type recorded");
        }
        ProtoBuf.Type type3 = type2;
        ConeKotlinType coneType = this.type(type3);
        return ResolveUtilsKt.toTypeProjection(coneType, variance);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    @Nullable
    public final FirTypeDeserializer getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public FirTypeDeserializer(@NotNull FirSession session, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @Nullable FirTypeDeserializer parent2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver2, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, (String)"typeParameterProtos");
        this.session = session;
        this.nameResolver = nameResolver2;
        this.typeTable = typeTable;
        this.parent = parent2;
        FirTypeDeserializer firTypeDeserializer = this;
        if (typeParameterProtos.isEmpty()) {
            FirTypeDeserializer firTypeDeserializer2 = firTypeDeserializer;
            boolean bl = false;
            Map map3 = MapsKt.emptyMap();
            firTypeDeserializer = firTypeDeserializer2;
            map2 = map3;
        } else {
            LinkedHashMap result2 = new LinkedHashMap();
            boolean bl = false;
            for (ProtoBuf.TypeParameter proto : (Iterable)typeParameterProtos) {
                void index2;
                if (proto.hasId()) {
                    Name name2 = NameResolverUtilKt.getName(this.nameResolver, proto.getName());
                    FirTypeParameterSymbol symbol2 = new FirTypeParameterSymbol();
                    ProtoBuf.TypeParameter.Variance variance = proto.getVariance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)variance, (String)"proto.variance");
                    new FirTypeParameterImpl(null, this.session, name2, symbol2, this.convertVariance(variance), proto.getReified());
                    ((Map)result2).put(proto.getId(), symbol2);
                }
                ++index2;
            }
            map2 = result2;
        }
        firTypeDeserializer.typeParameterDescriptors = map2;
        boolean result2 = false;
        for (ProtoBuf.TypeParameter proto : (Iterable)typeParameterProtos) {
            void index3;
            if (proto.hasId()) {
                void $this$mapTo$iv;
                FirTypeParameterImpl declaration2;
                FirTypeParameterSymbol symbol3;
                if (this.typeParameterDescriptors.get(proto.getId()) == null) {
                    Intrinsics.throwNpe();
                }
                Object e = symbol3.getFir();
                if (e == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImpl");
                }
                FirTypeParameterImpl firTypeParameterImpl = declaration2 = (FirTypeParameterImpl)e;
                boolean bl = false;
                boolean bl2 = false;
                FirTypeParameterImpl $this$apply = firTypeParameterImpl;
                boolean bl3 = false;
                List<ProtoBuf.Type> list2 = proto.getUpperBoundList();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"proto.upperBoundList");
                Iterable iterable = list2;
                Collection destination$iv = $this$apply.getBounds();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv;
                    Collection collection = destination$iv;
                    boolean bl4 = false;
                    void v5 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                    FirResolvedTypeRefImpl firResolvedTypeRefImpl = new FirResolvedTypeRefImpl(null, this.type((ProtoBuf.Type)v5));
                    collection.add(firResolvedTypeRefImpl);
                }
                FirDeclarationUtilKt.addDefaultBoundIfNecessary($this$apply);
            }
            ++index3;
        }
    }
}

