/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a#\u0010\u001c\u001a\u00020\u001d*\u00020\u001d2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u001f\"\u00020\f\u00a2\u0006\u0002\u0010 \"!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\f\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\"\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u000b*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0015\u0010\u0019\u001a\u00020\u0016*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"allParameters", "", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "allParameters$annotations", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)V", "getAllParameters", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/List;", "explicitParameters", "getExplicitParameters", "isFunctionOrKFunctionType", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isSuspend", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Z", "propertyIfAccessor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getPropertyIfAccessor", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "synthesizedName", "Lorg/jetbrains/kotlin/name/Name;", "", "getSynthesizedName", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/name/Name;", "synthesizedString", "getSynthesizedString", "(Ljava/lang/String;)Ljava/lang/String;", "substitute", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "types", "", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;[Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "ir.backend.common"})
public final class DescriptorUtilsKt {
    @NotNull
    public static final Name getSynthesizedName(@NotNull String $this$synthesizedName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$synthesizedName, (String)"$this$synthesizedName");
        Name name2 = Name.identifier(DescriptorUtilsKt.getSynthesizedString($this$synthesizedName));
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(this.synthesizedString)");
        return name2;
    }

    @NotNull
    public static final String getSynthesizedString(@NotNull String $this$synthesizedString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$synthesizedString, (String)"$this$synthesizedString");
        return '$' + $this$synthesizedString;
    }

    @NotNull
    public static final DeclarationDescriptor getPropertyIfAccessor(@NotNull DeclarationDescriptor $this$propertyIfAccessor) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$this$propertyIfAccessor, (String)"$this$propertyIfAccessor");
        if ($this$propertyIfAccessor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$propertyIfAccessor).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"this.correspondingProperty");
            declarationDescriptor = propertyDescriptor;
        } else {
            declarationDescriptor = $this$propertyIfAccessor;
        }
        return declarationDescriptor;
    }

    public static final boolean isSuspend(@NotNull CallableDescriptor $this$isSuspend) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isSuspend, (String)"$this$isSuspend");
        return $this$isSuspend instanceof FunctionDescriptor && ((FunctionDescriptor)$this$isSuspend).isSuspend();
    }

    public static /* synthetic */ void allParameters$annotations(CallableDescriptor callableDescriptor) {
    }

    @NotNull
    public static final List<ParameterDescriptor> getAllParameters(@NotNull CallableDescriptor $this$allParameters) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)$this$allParameters, (String)"$this$allParameters");
        if ($this$allParameters instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)$this$allParameters).getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"this.constructedClass");
            list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)classDescriptor2.getThisAsReceiverParameter()), (Iterable)DescriptorUtilsKt.getExplicitParameters($this$allParameters));
        } else {
            list2 = DescriptorUtilsKt.getExplicitParameters($this$allParameters);
        }
        return list2;
    }

    @NotNull
    public static final List<ParameterDescriptor> getExplicitParameters(@NotNull CallableDescriptor $this$explicitParameters) {
        ReceiverParameterDescriptor it;
        boolean bl;
        boolean bl2;
        ReceiverParameterDescriptor receiverParameterDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$this$explicitParameters, (String)"$this$explicitParameters");
        ArrayList<ReceiverParameterDescriptor> result2 = new ArrayList<ReceiverParameterDescriptor>($this$explicitParameters.getValueParameters().size() + 2);
        ReceiverParameterDescriptor receiverParameterDescriptor2 = $this$explicitParameters.getDispatchReceiverParameter();
        if (receiverParameterDescriptor2 != null) {
            receiverParameterDescriptor = receiverParameterDescriptor2;
            bl2 = false;
            bl = false;
            it = receiverParameterDescriptor;
            boolean bl3 = false;
            result2.add(it);
        }
        ReceiverParameterDescriptor receiverParameterDescriptor3 = $this$explicitParameters.getExtensionReceiverParameter();
        if (receiverParameterDescriptor3 != null) {
            receiverParameterDescriptor = receiverParameterDescriptor3;
            bl2 = false;
            bl = false;
            it = receiverParameterDescriptor;
            boolean bl4 = false;
            result2.add(it);
        }
        result2.addAll((Collection)$this$explicitParameters.getValueParameters());
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FunctionDescriptor substitute(@NotNull FunctionDescriptor $this$substitute, KotlinType ... types2) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$substitute, (String)"$this$substitute");
        Intrinsics.checkParameterIsNotNull((Object)types2, (String)"types");
        List<TypeParameterDescriptor> list2 = $this$substitute.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeParameters");
        Iterable $this$associateBy$iv = CollectionsKt.withIndex((Iterable)list2);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            IndexedValue it;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object object = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.value");
            TypeConstructor typeConstructor2 = ((TypeParameterDescriptor)object).getTypeConstructor();
            it = (IndexedValue)element$iv$iv;
            boolean bl2 = false;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(types2[it.getIndex()]);
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(destination$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(\n\u2026types[it.index]) })\n    )");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        FunctionDescriptor functionDescriptor = $this$substitute.substitute(typeSubstitutor3);
        if (functionDescriptor == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor;
    }

    public static final boolean isFunctionOrKFunctionType(@NotNull KotlinType $this$isFunctionOrKFunctionType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFunctionOrKFunctionType, (String)"$this$isFunctionOrKFunctionType");
        ClassifierDescriptor classifierDescriptor = $this$isFunctionOrKFunctionType.getConstructor().getDeclarationDescriptor();
        FunctionClassDescriptor.Kind kind = classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null;
        return kind == FunctionClassDescriptor.Kind.Function || kind == FunctionClassDescriptor.Kind.KFunction;
    }
}

