/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class JpsEncodingModelSerializerExtension
extends JpsModelSerializerExtension {
    @Override
    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List<JpsEncodingConfigurationSerializer> list2 = Collections.singletonList(new JpsEncodingConfigurationSerializer());
        if (list2 == null) {
            JpsEncodingModelSerializerExtension.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends JpsGlobalExtensionSerializer> getGlobalExtensionSerializers() {
        List<JpsGlobalEncodingSerializer> list2 = Collections.singletonList(new JpsGlobalEncodingSerializer());
        if (list2 == null) {
            JpsEncodingModelSerializerExtension.$$$reportNull$$$0(1);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectExtensionSerializers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalExtensionSerializers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class JpsGlobalEncodingSerializer
    extends JpsGlobalExtensionSerializer {
        public static final String ENCODING_ATTRIBUTE = "default_encoding";

        private JpsGlobalEncodingSerializer() {
            super("encoding.xml", "Encoding");
        }

        @Override
        public void loadExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                JpsGlobalEncodingSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                JpsGlobalEncodingSerializer.$$$reportNull$$$0(1);
            }
            String encoding = componentTag.getAttributeValue(ENCODING_ATTRIBUTE);
            JpsEncodingConfigurationService.getInstance().setGlobalEncoding(global, StringUtil.nullize((String)encoding));
        }

        @Override
        public void loadExtensionWithDefaultSettings(@NotNull JpsGlobal global) {
            if (global == null) {
                JpsGlobalEncodingSerializer.$$$reportNull$$$0(2);
            }
            JpsEncodingConfigurationService.getInstance().setGlobalEncoding(global, "UTF-8");
        }

        @Override
        public void saveExtension(@NotNull JpsGlobal global, @NotNull Element componentTag) {
            if (global == null) {
                JpsGlobalEncodingSerializer.$$$reportNull$$$0(3);
            }
            if (componentTag == null) {
                JpsGlobalEncodingSerializer.$$$reportNull$$$0(4);
            }
            componentTag.setAttribute(ENCODING_ATTRIBUTE, JpsEncodingConfigurationService.getInstance().getGlobalEncoding(global));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "global";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentTag";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension$JpsGlobalEncodingSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadExtension";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadExtensionWithDefaultSettings";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveExtension";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JpsEncodingConfigurationSerializer
    extends JpsProjectExtensionSerializer {
        private JpsEncodingConfigurationSerializer() {
            super("encodings.xml", "Encoding");
        }

        @Override
        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                JpsEncodingConfigurationSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                JpsEncodingConfigurationSerializer.$$$reportNull$$$0(1);
            }
            String projectEncoding = null;
            HashMap<String, String> urlToEncoding = new HashMap<String, String>();
            for (Element fileTag : JDOMUtil.getChildren((Element)componentTag, (String)"file")) {
                String url = fileTag.getAttributeValue("url");
                String encoding = fileTag.getAttributeValue("charset");
                if (url.equals("PROJECT")) {
                    projectEncoding = encoding;
                    continue;
                }
                urlToEncoding.put(url, encoding);
            }
            JpsEncodingConfigurationService.getInstance().setEncodingConfiguration(project, projectEncoding, urlToEncoding);
        }

        @Override
        public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                JpsEncodingConfigurationSerializer.$$$reportNull$$$0(2);
            }
            if (componentTag == null) {
                JpsEncodingConfigurationSerializer.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentTag";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsEncodingModelSerializerExtension$JpsEncodingConfigurationSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadExtension";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveExtension";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

