/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class Printer {
    private static final String DEFAULT_INDENTATION_UNIT = "    ";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Appendable out;
    private final int maxBlankLines;
    private String indent;
    private final String indentUnit;
    private int blankLineCountIncludingCurrent;
    private boolean withholdIndentOnce;
    private int length;

    public Printer(@NotNull Appendable out) {
        if (out == null) {
            Printer.$$$reportNull$$$0(0);
        }
        this(out, Integer.MAX_VALUE);
    }

    public Printer(@NotNull Appendable out, @NotNull String indentUnit) {
        if (out == null) {
            Printer.$$$reportNull$$$0(1);
        }
        if (indentUnit == null) {
            Printer.$$$reportNull$$$0(2);
        }
        this(out, Integer.MAX_VALUE, indentUnit);
    }

    public Printer(@NotNull Appendable out, int maxBlankLines) {
        if (out == null) {
            Printer.$$$reportNull$$$0(3);
        }
        this(out, maxBlankLines, DEFAULT_INDENTATION_UNIT);
    }

    public Printer(@NotNull Appendable out, int maxBlankLines, @NotNull String indentUnit) {
        if (out == null) {
            Printer.$$$reportNull$$$0(4);
        }
        if (indentUnit == null) {
            Printer.$$$reportNull$$$0(5);
        }
        this(out, maxBlankLines, indentUnit, "");
    }

    private Printer(@NotNull Appendable out, int maxBlankLines, @NotNull String indentUnit, @NotNull String indent) {
        if (out == null) {
            Printer.$$$reportNull$$$0(6);
        }
        if (indentUnit == null) {
            Printer.$$$reportNull$$$0(7);
        }
        if (indent == null) {
            Printer.$$$reportNull$$$0(8);
        }
        this.blankLineCountIncludingCurrent = 0;
        this.withholdIndentOnce = false;
        this.length = 0;
        this.out = out;
        this.maxBlankLines = maxBlankLines;
        this.indentUnit = indentUnit;
        this.indent = indent;
    }

    public Printer(@NotNull Appendable out, @NotNull Printer parent2) {
        if (out == null) {
            Printer.$$$reportNull$$$0(9);
        }
        if (parent2 == null) {
            Printer.$$$reportNull$$$0(10);
        }
        this(out, parent2.maxBlankLines, parent2.indentUnit, parent2.indent);
    }

    private void append(Object o) {
        try {
            String string = o.toString();
            this.out.append(string);
            this.length += string.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public Printer println(Object ... objects) {
        this.print(objects);
        this.printLineSeparator();
        Printer printer = this;
        if (printer == null) {
            Printer.$$$reportNull$$$0(11);
        }
        return printer;
    }

    private void printLineSeparator() {
        if (this.blankLineCountIncludingCurrent <= this.maxBlankLines) {
            ++this.blankLineCountIncludingCurrent;
            this.append(LINE_SEPARATOR);
        }
    }

    @NotNull
    public Printer print(Object ... objects) {
        if (this.withholdIndentOnce) {
            this.withholdIndentOnce = false;
        } else if (objects.length > 0) {
            this.printIndent();
        }
        this.printWithNoIndent(objects);
        Printer printer = this;
        if (printer == null) {
            Printer.$$$reportNull$$$0(12);
        }
        return printer;
    }

    public void printIndent() {
        this.append(this.indent);
    }

    @NotNull
    public Printer printWithNoIndent(Object ... objects) {
        for (Object object : objects) {
            this.blankLineCountIncludingCurrent = 0;
            this.append(object);
        }
        Printer printer = this;
        if (printer == null) {
            Printer.$$$reportNull$$$0(13);
        }
        return printer;
    }

    @NotNull
    public Printer withholdIndentOnce() {
        this.withholdIndentOnce = true;
        Printer printer = this;
        if (printer == null) {
            Printer.$$$reportNull$$$0(14);
        }
        return printer;
    }

    @NotNull
    public Printer printlnWithNoIndent(Object ... objects) {
        this.printWithNoIndent(objects);
        this.printLineSeparator();
        Printer printer = this;
        if (printer == null) {
            Printer.$$$reportNull$$$0(15);
        }
        return printer;
    }

    @NotNull
    public Printer pushIndent() {
        this.indent = this.indent + this.indentUnit;
        Printer printer = this;
        if (printer == null) {
            Printer.$$$reportNull$$$0(16);
        }
        return printer;
    }

    @NotNull
    public Printer popIndent() {
        if (this.indent.length() < this.indentUnit.length()) {
            throw new IllegalStateException("No indentation to pop");
        }
        this.indent = this.indent.substring(this.indentUnit.length());
        Printer printer = this;
        if (printer == null) {
            Printer.$$$reportNull$$$0(17);
        }
        return printer;
    }

    @NotNull
    public Printer separated(Object separator, Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                this.printlnWithNoIndent(separator);
            }
            this.printlnWithNoIndent(items[i]);
        }
        Printer printer = this;
        if (printer == null) {
            Printer.$$$reportNull$$$0(18);
        }
        return printer;
    }

    @NotNull
    public Printer separated(Object separator, Collection<?> items) {
        Iterator<?> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            this.printlnWithNoIndent(iterator2.next());
            if (!iterator2.hasNext()) continue;
            this.printlnWithNoIndent(separator);
        }
        Printer printer = this;
        if (printer == null) {
            Printer.$$$reportNull$$$0(19);
        }
        return printer;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        return this.out.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentUnit";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/utils/Printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/utils/Printer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "println";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "print";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "printWithNoIndent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withholdIndentOnce";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "printlnWithNoIndent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "pushIndent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "popIndent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "separated";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

