/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.Check;
import org.jetbrains.kotlin.util.CheckResult;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B8\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u0012\u001b\b\u0002\u0010\u0005\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nB@\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u0012\u001b\b\u0002\u0010\u0005\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\rB@\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u0012\u001b\b\u0002\u0010\u0005\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\u0010BF\b\u0016\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u0012\u001b\b\u0002\u0010\u0005\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\u0013BU\b\u0002\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012\u0012\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u0007R\u001f\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/util/Checks;", "", "checks", "", "Lorg/jetbrains/kotlin/util/Check;", "additionalChecks", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "", "Lkotlin/ExtensionFunctionType;", "([Lorg/jetbrains/kotlin/util/Check;Lkotlin/jvm/functions/Function1;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/Name;[Lorg/jetbrains/kotlin/util/Check;Lkotlin/jvm/functions/Function1;)V", "regex", "Lkotlin/text/Regex;", "(Lkotlin/text/Regex;[Lorg/jetbrains/kotlin/util/Check;Lkotlin/jvm/functions/Function1;)V", "nameList", "", "(Ljava/util/Collection;[Lorg/jetbrains/kotlin/util/Check;Lkotlin/jvm/functions/Function1;)V", "additionalCheck", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/text/Regex;Ljava/util/Collection;Lkotlin/jvm/functions/Function1;[Lorg/jetbrains/kotlin/util/Check;)V", "getAdditionalCheck", "()Lkotlin/jvm/functions/Function1;", "getChecks", "()[Lorg/jetbrains/kotlin/util/Check;", "[Lorg/jetbrains/kotlin/util/Check;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getNameList", "()Ljava/util/Collection;", "getRegex", "()Lkotlin/text/Regex;", "checkAll", "Lorg/jetbrains/kotlin/util/CheckResult;", "functionDescriptor", "isApplicable", "", "descriptors"})
public final class Checks {
    @Nullable
    private final Name name;
    @Nullable
    private final Regex regex;
    @Nullable
    private final Collection<Name> nameList;
    @NotNull
    private final Function1<FunctionDescriptor, String> additionalCheck;
    @NotNull
    private final Check[] checks;

    public final boolean isApplicable(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        if (this.name != null && Intrinsics.areEqual((Object)functionDescriptor.getName(), (Object)this.name) ^ true) {
            return false;
        }
        if (this.regex != null) {
            String string = functionDescriptor.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"functionDescriptor.name.asString()");
            CharSequence charSequence = string;
            Regex regex = this.regex;
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                return false;
            }
        }
        return this.nameList == null || this.nameList.contains(functionDescriptor.getName());
    }

    @NotNull
    public final CheckResult checkAll(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        for (Check check2 : this.checks) {
            String checkResult = check2.invoke(functionDescriptor);
            if (checkResult == null) continue;
            return new CheckResult.IllegalSignature(checkResult);
        }
        String additionalCheckResult = (String)this.additionalCheck.invoke((Object)functionDescriptor);
        if (additionalCheckResult != null) {
            return new CheckResult.IllegalSignature(additionalCheckResult);
        }
        return CheckResult.SuccessCheck.INSTANCE;
    }

    @Nullable
    public final Name getName() {
        return this.name;
    }

    @Nullable
    public final Regex getRegex() {
        return this.regex;
    }

    @Nullable
    public final Collection<Name> getNameList() {
        return this.nameList;
    }

    @NotNull
    public final Function1<FunctionDescriptor, String> getAdditionalCheck() {
        return this.additionalCheck;
    }

    @NotNull
    public final Check[] getChecks() {
        return this.checks;
    }

    private Checks(Name name2, Regex regex, Collection<Name> nameList, Function1<? super FunctionDescriptor, String> additionalCheck, Check ... checks2) {
        this.name = name2;
        this.regex = regex;
        this.nameList = nameList;
        this.additionalCheck = additionalCheck;
        this.checks = checks2;
    }

    public Checks(@NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkParameterIsNotNull((Object)checks2, (String)"checks");
        Intrinsics.checkParameterIsNotNull(additionalChecks, (String)"additionalChecks");
        this(null, null, null, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    public Checks(@NotNull Name name2, @NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)checks2, (String)"checks");
        Intrinsics.checkParameterIsNotNull(additionalChecks, (String)"additionalChecks");
        this(name2, null, null, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Name name2, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            function1 = 2.INSTANCE;
        }
        this(name2, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    public Checks(@NotNull Regex regex, @NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        Intrinsics.checkParameterIsNotNull((Object)checks2, (String)"checks");
        Intrinsics.checkParameterIsNotNull(additionalChecks, (String)"additionalChecks");
        this(null, regex, null, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Regex regex, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            function1 = 3.INSTANCE;
        }
        this(regex, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    public Checks(@NotNull Collection<Name> nameList, @NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkParameterIsNotNull(nameList, (String)"nameList");
        Intrinsics.checkParameterIsNotNull((Object)checks2, (String)"checks");
        Intrinsics.checkParameterIsNotNull(additionalChecks, (String)"additionalChecks");
        this(null, null, nameList, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Collection collection, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            function1 = 4.INSTANCE;
        }
        this(collection, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }
}

