/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.SignatureUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"escape", "", "s", "generateSignature", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "js.translator"})
public final class SignatureUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String generateSignature(@NotNull DeclarationDescriptor descriptor2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            return null;
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility && Intrinsics.areEqual((Object)((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), (Object)Visibilities.PRIVATE) && !AnnotationsUtils.isNativeObject(descriptor2) && !AnnotationsUtils.isLibraryObject(descriptor2)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof CallableDescriptor) {
            if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
                ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)descriptor2).getConstructedClass();
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"descriptor.constructedClass");
                return SignatureUtilsKt.generateSignature(classDescriptor2);
            }
            DeclarationDescriptor declarationDescriptor2 = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"descriptor.containingDeclaration");
            String string2 = SignatureUtilsKt.generateSignature(declarationDescriptor2);
            if (string2 == null) {
                return null;
            }
            String parent2 = string2;
            if (!(descriptor2 instanceof VariableAccessorDescriptor) && !(descriptor2 instanceof ConstructorDescriptor)) {
                Name name2 = ((CallableDescriptor)descriptor2).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"descriptor.name");
                if (name2.isSpecial()) {
                    return null;
                }
            }
            String separator = descriptor2 instanceof FunctionDescriptor ? "#" : "!";
            StringBuilder stringBuilder = new StringBuilder().append(parent2).append(separator);
            String string3 = ((CallableDescriptor)descriptor2).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"descriptor.name.asString()");
            string = stringBuilder.append(SignatureUtilsKt.escape(string3)).append("|").append(EncodeSignatureKt.encodeSignature((CallableDescriptor)descriptor2)).toString();
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string4 = DescriptorUtilsKt.getModule(descriptor2).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"descriptor.module.name.asString()");
            String module2 = string4;
            Sequence sequence2 = SequencesKt.sequenceOf((Object[])new String[]{module2});
            List<Name> list2 = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.fqName.pathSegments()");
            Iterable iterable = list2;
            Sequence sequence3 = sequence2;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Name name3 = (Name)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v10 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
                String string5 = v10.getIdentifier();
                collection.add(string5);
            }
            collection = (List)destination$iv$iv;
            Sequence parts = SequencesKt.plus((Sequence)sequence3, (Iterable)collection);
            string = SequencesKt.joinToString$default((Sequence)parts, (CharSequence)".", null, null, (int)0, null, (Function1)generateSignature.1.INSTANCE, (int)30, null);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((ClassDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor3, (String)"descriptor.containingDeclaration");
            String string6 = SignatureUtilsKt.generateSignature(declarationDescriptor3);
            if (string6 == null) {
                return null;
            }
            String parent3 = string6;
            Name name4 = ((ClassDescriptor)descriptor2).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"descriptor.name");
            if (name4.isSpecial()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder().append(parent3).append("$");
            String string7 = ((ClassDescriptor)descriptor2).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"descriptor.name.asString()");
            string = stringBuilder.append(SignatureUtilsKt.escape(string7)).toString();
        } else {
            return null;
        }
        return string;
    }

    private static final String escape(String s) {
        StringBuilder sb = new StringBuilder();
        String string = s;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    string2 = "" + '\\' + c;
                    break;
                }
                default: {
                    string2 = String.valueOf(c);
                }
            }
            String escapedChar = string2;
            sb.append(escapedChar);
        }
        String string3 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sb.toString()");
        return string3;
    }

    public static final /* synthetic */ String access$escape(String s) {
        return SignatureUtilsKt.escape(s);
    }
}

