/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIr;
import org.jetbrains.kotlin.backend.common.serialization.KotlinMangler;
import org.jetbrains.kotlin.backend.common.serialization.UniqId;
import org.jetbrains.kotlin.backend.common.serialization.UniqIdKt;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0017J\r\u0010&\u001a\u00020\u001b*\u00020\u0017H\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u0006*\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u0013*\u00020\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u0013*\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u001b*\u00020\u001cX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001d\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorReferenceSerializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinMangler;", "declarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "serializeString", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIr$String;", "mangler", "(Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/backend/common/serialization/KotlinMangler;)V", "getDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "getSerializeString", "()Lkotlin/jvm/functions/Function1;", "functionName", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getFunctionName", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Ljava/lang/String;", "hashMangle", "", "getHashMangle", "(Ljava/lang/String;)J", "hashedMangle", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getHashedMangle", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)J", "isInlined", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "extractPackageAndClassFqns", "Lkotlin/Pair;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isEnumSpecialMember", "serializeDescriptorReference", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIr$DescriptorReference;", "declaration", "isExported", "ir.serialization.common"})
public class DescriptorReferenceSerializer
implements KotlinMangler {
    @NotNull
    private final DeclarationTable declarationTable;
    @NotNull
    private final Function1<String, KotlinIr.String> serializeString;
    private final /* synthetic */ KotlinMangler $$delegate_0;

    private final boolean isEnumSpecialMember(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        return DescriptorFactory.isEnumValueOfMethod((FunctionDescriptor)descriptor2) || DescriptorFactory.isEnumValuesMethod((FunctionDescriptor)descriptor2);
    }

    @Nullable
    public final Pair<String, String> extractPackageAndClassFqns(@NotNull DeclarationDescriptor descriptor2) {
        Object object;
        DeclarationDescriptor containingDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor declarationDescriptor = containingDeclaration = descriptor2.getContainingDeclaration();
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)containingDeclaration);
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            String string = classId2.getPackageFqName().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classId.packageFqName.toString()");
            String string2 = classId2.getRelativeClassName().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"classId.relativeClassName.toString()");
            object = new Pair((Object)string, (Object)string2);
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            String string = ((PackageFragmentDescriptor)containingDeclaration).getFqName().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"containingDeclaration.fqName.toString()");
            object = new Pair((Object)string, (Object)"");
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            object = !(descriptor2 instanceof TypeParameterDescriptor) ? null : this.extractPackageAndClassFqns(containingDeclaration);
        } else {
            return null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public final KotlinIr.DescriptorReference serializeDescriptorReference(@NotNull IrDeclaration declaration2) {
        void packageFqName;
        UniqId uniqId;
        UniqId uniqId2;
        boolean bl;
        String string;
        IrDeclaration discoverableDescriptorsDeclaration;
        IrDeclaration irDeclaration;
        IrDeclaration realDeclaration;
        IrDeclaration irDeclaration2;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        DeclarationDescriptor descriptor2 = declaration2.getDescriptor();
        if (!this.isExported(declaration2)) {
            IrDeclaration irDeclaration3 = declaration2;
            if (!(irDeclaration3 instanceof IrDeclarationWithVisibility)) {
                irDeclaration3 = null;
            }
            IrDeclarationWithVisibility irDeclarationWithVisibility = (IrDeclarationWithVisibility)irDeclaration3;
            if (!Intrinsics.areEqual((Object)(irDeclarationWithVisibility != null ? irDeclarationWithVisibility.getVisibility() : null), (Object)Visibilities.INVISIBLE_FAKE)) {
                return null;
            }
        }
        if (declaration2 instanceof IrAnonymousInitializer) {
            return null;
        }
        if (descriptor2 instanceof ParameterDescriptor) return null;
        if (descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (declarationDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration!!");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        Pair<String, String> pair = this.extractPackageAndClassFqns(descriptor2);
        if (pair == null) return null;
        Pair<String, String> pair2 = pair;
        String string2 = (String)pair2.component1();
        String classFqName = (String)pair2.component2();
        boolean isAccessor = AdditionalIrUtilsKt.isAccessor(declaration2);
        boolean isBackingField = declaration2 instanceof IrField && ((IrField)declaration2).getCorrespondingProperty() != null;
        boolean isFakeOverride = Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE);
        boolean isDefaultConstructor = descriptor2 instanceof ClassConstructorDescriptor && containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.OBJECT;
        boolean isEnumEntry = descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY;
        boolean isEnumSpecial = this.isEnumSpecialMember(descriptor2);
        boolean isTypeParameter = declaration2 instanceof IrTypeParameter;
        if (containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.ENUM_ENTRY && !isFakeOverride) {
            return null;
        }
        if (isFakeOverride) {
            IrElement irElement;
            IrDeclaration irDeclaration4 = declaration2;
            if (irDeclaration4 instanceof IrSimpleFunction) {
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrSimpleFunction)declaration2);
            } else if (irDeclaration4 instanceof IrField) {
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrField)declaration2);
            } else {
                if (!(irDeclaration4 instanceof IrProperty)) {
                    String string3 = "Unexpected fake override declaration";
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrProperty)declaration2);
            }
            irDeclaration2 = (IrDeclaration)irElement;
        } else {
            irDeclaration2 = realDeclaration = declaration2;
        }
        if (isAccessor) {
            IrDeclaration irDeclaration5 = realDeclaration;
            if (irDeclaration5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            }
            IrProperty irProperty = ((IrSimpleFunction)irDeclaration5).getCorrespondingProperty();
            if (irProperty == null) {
                Intrinsics.throwNpe();
            }
            irDeclaration = irProperty;
        } else if (isBackingField) {
            IrDeclaration irDeclaration6 = realDeclaration;
            if (irDeclaration6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrField");
            }
            IrProperty irProperty = ((IrField)irDeclaration6).getCorrespondingProperty();
            if (irProperty == null) {
                Intrinsics.throwNpe();
            }
            irDeclaration = irProperty;
        } else {
            irDeclaration = discoverableDescriptorsDeclaration = isDefaultConstructor || isEnumEntry ? null : realDeclaration;
        }
        if (isTypeParameter) {
            IrElement irElement;
            IrDeclarationParent parent2 = declaration2.getParent();
            IrDeclarationParent irDeclarationParent = parent2;
            if (irDeclarationParent instanceof IrClass) {
                irElement = (IrElement)((Object)parent2);
            } else if (irDeclarationParent instanceof IrSimpleFunction) {
                Object object = ((IrSimpleFunction)parent2).getCorrespondingPropertySymbol();
                irElement = object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (IrElement)((Object)parent2);
            } else {
                if (!(irDeclarationParent instanceof IrConstructor)) {
                    String string4 = "unknown type parameter container type";
                    boolean bl3 = false;
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
                irElement = (IrElement)((Object)parent2);
            }
            IrElement irElement2 = irElement;
            string = ((IrDeclarationWithName)irElement2).getDescriptor().getName().asString();
        } else {
            string = descriptor2.getName().toString();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (isTypeParameter) {\n \u2026escriptor.name.toString()");
        String nameString = string;
        IrDeclaration irDeclaration7 = discoverableDescriptorsDeclaration;
        if (irDeclaration7 != null) {
            IrDeclaration irDeclaration8 = irDeclaration7;
            boolean bl4 = false;
            bl = false;
            IrDeclaration irDeclaration9 = irDeclaration8;
            boolean bl5 = false;
            uniqId2 = this.declarationTable.uniqIdByDeclaration(irDeclaration9);
        } else {
            uniqId2 = null;
        }
        UniqId uniqId3 = uniqId = uniqId2;
        if (uniqId3 != null) {
            UniqId uniqId4 = uniqId3;
            boolean bl6 = false;
            bl = false;
            UniqId uniqId5 = uniqId4;
            boolean bl7 = false;
            this.declarationTable.getDescriptors().put(discoverableDescriptorsDeclaration.getDescriptor(), uniqId5);
        }
        KotlinIr.DescriptorReference.Builder builder = KotlinIr.DescriptorReference.newBuilder().setPackageFqName((KotlinIr.String)this.serializeString.invoke((Object)packageFqName)).setClassFqName((KotlinIr.String)this.serializeString.invoke((Object)classFqName)).setName((KotlinIr.String)this.serializeString.invoke((Object)nameString));
        if (uniqId != null) {
            builder.setUniqId(UniqIdKt.protoUniqId(uniqId));
        }
        if (isFakeOverride) {
            builder.setIsFakeOverride(true);
        }
        if (isBackingField) {
            builder.setIsBackingField(true);
        }
        if (isAccessor) {
            if (AdditionalIrUtilsKt.isGetter(declaration2)) {
                builder.setIsGetter(true);
                return builder.build();
            }
            if (AdditionalIrUtilsKt.isSetter(declaration2)) {
                builder.setIsSetter(true);
                return builder.build();
            }
            String string5 = "A property accessor which is neither a getter, nor a setter: " + descriptor2;
            bl = false;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        if (isDefaultConstructor) {
            builder.setIsDefaultConstructor(true);
            return builder.build();
        }
        if (isEnumEntry) {
            builder.setIsEnumEntry(true);
            return builder.build();
        }
        if (isEnumSpecial) {
            builder.setIsEnumSpecial(true);
            return builder.build();
        }
        if (!isTypeParameter) return builder.build();
        builder.setIsTypeParameter(true);
        return builder.build();
    }

    @NotNull
    public final DeclarationTable getDeclarationTable() {
        return this.declarationTable;
    }

    @NotNull
    public final Function1<String, KotlinIr.String> getSerializeString() {
        return this.serializeString;
    }

    public DescriptorReferenceSerializer(@NotNull DeclarationTable declarationTable, @NotNull Function1<? super String, KotlinIr.String> serializeString, @NotNull KotlinMangler mangler) {
        Intrinsics.checkParameterIsNotNull((Object)declarationTable, (String)"declarationTable");
        Intrinsics.checkParameterIsNotNull(serializeString, (String)"serializeString");
        Intrinsics.checkParameterIsNotNull((Object)mangler, (String)"mangler");
        this.$$delegate_0 = mangler;
        this.declarationTable = declarationTable;
        this.serializeString = serializeString;
    }

    @Override
    @NotNull
    public String getFunctionName(@NotNull IrFunction $this$functionName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$functionName, (String)"$this$functionName");
        return this.$$delegate_0.getFunctionName($this$functionName);
    }

    @Override
    public long getHashMangle(@NotNull String $this$hashMangle) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hashMangle, (String)"$this$hashMangle");
        return this.$$delegate_0.getHashMangle($this$hashMangle);
    }

    @Override
    public long getHashedMangle(@NotNull IrDeclaration $this$hashedMangle) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hashedMangle, (String)"$this$hashedMangle");
        return this.$$delegate_0.getHashedMangle($this$hashedMangle);
    }

    @Override
    public boolean isInlined(@NotNull IrType $this$isInlined) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isInlined, (String)"$this$isInlined");
        return this.$$delegate_0.isInlined($this$isInlined);
    }

    @Override
    public boolean isExported(@NotNull IrDeclaration $this$isExported) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isExported, (String)"$this$isExported");
        return this.$$delegate_0.isExported($this$isExported);
    }
}

