/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.backend.common.ir.SetDeclarationsParentVisitor;
import org.jetbrains.kotlin.backend.common.lower.InitializersLowering;
import org.jetbrains.kotlin.backend.common.lower.SYNTHESIZED_INIT_BLOCK;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.DescriptorsRemapper;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InitializersLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "declarationOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "clinitNeeded", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;Z)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getDeclarationOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "createStaticInitializationMethod", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "staticInitializerStatements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "handleAnonymousInitializer", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "handleDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "handleField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "handleNonStatics", "handleStatics", "lower", "transformInstanceInitializerCallsInConstructors", "instanceInitializerStatements", "Companion", "ir.backend.common"})
public final class InitializersLowering
implements ClassLoweringPass {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrDeclarationOrigin declarationOrigin;
    private final boolean clinitNeeded;
    @NotNull
    private static final Name clinitName;
    public static final Companion Companion;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        List<IrStatement> instanceInitializerStatements = this.handleNonStatics(irClass);
        this.transformInstanceInitializerCallsInConstructors(irClass, instanceInitializerStatements);
        List<IrStatement> staticInitializerStatements = this.handleStatics(irClass);
        if (this.clinitNeeded) {
            Collection collection = staticInitializerStatements;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.createStaticInitializationMethod(irClass, staticInitializerStatements);
            }
        }
        CollectionsKt.removeAll(irClass.getDeclarations(), (Function1)lower.1.INSTANCE);
        PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irClass, irClass.getParent());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrStatement> handleNonStatics(@NotNull IrClass irClass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        Iterable $this$filter$iv = irClass.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof IrField && !((IrField)it).isStatic() || it instanceof IrAnonymousInitializer && !((IrAnonymousInitializer)it).isStatic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrStatement irStatement;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (this.handleDeclaration(irClass, it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            IrStatement it$iv$iv = irStatement;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrStatement> handleStatics(@NotNull IrClass irClass) {
        void $this$mapNotNullTo$iv$iv;
        IrDeclaration it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        Iterable $this$filter$iv = irClass.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof IrField && Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_ENUM_ENTRY.INSTANCE))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = irClass.getDeclarations();
        Collection collection = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof IrField && Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_ENUM_VALUES.INSTANCE))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filter$iv = irClass.getDeclarations();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof IrField && Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_OBJECT_INSTANCE.INSTANCE))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        $this$filter$iv = irClass.getDeclarations();
        collection = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof IrField && ((IrField)it).isStatic() && !CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])new IrDeclarationOriginImpl[]{IrDeclarationOrigin.FIELD_FOR_ENUM_ENTRY.INSTANCE, IrDeclarationOrigin.FIELD_FOR_ENUM_VALUES.INSTANCE, IrDeclarationOrigin.FIELD_FOR_OBJECT_INSTANCE.INSTANCE}), (Object)it.getOrigin()) || it instanceof IrAnonymousInitializer && ((IrAnonymousInitializer)it).isStatic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrStatement irStatement;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration it2 = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (this.handleDeclaration(irClass, it2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            IrStatement it$iv$iv = irStatement;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final IrStatement handleDeclaration(@NotNull IrClass irClass, @NotNull IrDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrDeclaration irDeclaration = declaration2;
        return irDeclaration instanceof IrField ? this.handleField(irClass, (IrField)declaration2) : (irDeclaration instanceof IrAnonymousInitializer ? this.handleAnonymousInitializer((IrAnonymousInitializer)declaration2) : null);
    }

    @Nullable
    public final IrStatement handleField(@NotNull IrClass irClass, @NotNull IrField declaration2) {
        IrGetValueImpl irGetValueImpl;
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElement irElement = declaration2.getInitializer();
        if (irElement == null || (irElement = irElement.getExpression()) == null) {
            return null;
        }
        IrElement irFieldInitializer = irElement;
        if (!declaration2.isStatic()) {
            int n = irFieldInitializer.getStartOffset();
            int n2 = irFieldInitializer.getEndOffset();
            IrValueParameter irValueParameter = irClass.getThisReceiver();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            IrType irType = irValueParameter.getType();
            IrValueParameter irValueParameter2 = irClass.getThisReceiver();
            if (irValueParameter2 == null) {
                Intrinsics.throwNpe();
            }
            irGetValueImpl = new IrGetValueImpl(n, n2, irType, irValueParameter2.getSymbol(), null, 16, null);
        } else {
            irGetValueImpl = null;
        }
        IrGetValueImpl receiver = irGetValueImpl;
        return new IrSetFieldImpl(irFieldInitializer.getStartOffset(), irFieldInitializer.getEndOffset(), (IrFieldSymbol)declaration2.getSymbol(), receiver, (IrExpression)irFieldInitializer, this.context.getIrBuiltIns().getUnitType(), null, null);
    }

    @NotNull
    public final IrStatement handleAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return new IrBlockImpl(declaration2.getStartOffset(), declaration2.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), SYNTHESIZED_INIT_BLOCK.INSTANCE, declaration2.getBody().getStatements());
    }

    public final void transformInstanceInitializerCallsInConstructors(@NotNull IrClass irClass, @NotNull List<? extends IrStatement> instanceInitializerStatements) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        Intrinsics.checkParameterIsNotNull(instanceInitializerStatements, (String)"instanceInitializerStatements");
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, new IrElementTransformerVoid(this, instanceInitializerStatements, irClass){
            final /* synthetic */ InitializersLowering this$0;
            final /* synthetic */ List $instanceInitializerStatements;
            final /* synthetic */ IrClass $irClass;

            @NotNull
            public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrExpression irExpression = InitializersLowering.Companion.copy(new IrBlockImpl(-1, -1, this.this$0.getContext().getIrBuiltIns().getUnitType(), null, this.$instanceInitializerStatements), (IrDeclarationParent)this.$irClass);
                if (irExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlock");
                }
                IrBlock copiedBlock = (IrBlock)irExpression;
                return new IrBlockImpl(this.$irClass.getStartOffset(), this.$irClass.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getUnitType(), null, copiedBlock.getStatements());
            }
            {
                this.this$0 = $outer;
                this.$instanceInitializerStatements = $captured_local_variable$1;
                this.$irClass = $captured_local_variable$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void createStaticInitializationMethod(@NotNull IrClass irClass, @NotNull List<? extends IrStatement> staticInitializerStatements) {
        Collection<IrStatement> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        Intrinsics.checkParameterIsNotNull(staticInitializerStatements, (String)"staticInitializerStatements");
        WrappedSimpleFunctionDescriptor staticInitializerDescriptor = new WrappedSimpleFunctionDescriptor(null, null, 3, null);
        int n = irClass.getStartOffset();
        int n2 = irClass.getEndOffset();
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = new IrSimpleFunctionSymbolImpl(staticInitializerDescriptor);
        Visibility visibility = Visibilities.PUBLIC;
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.PUBLIC");
        IrFunctionImpl irFunctionImpl = new IrFunctionImpl(n, n2, this.declarationOrigin, irSimpleFunctionSymbol, clinitName, visibility, Modality.FINAL, this.context.getIrBuiltIns().getUnitType(), false, false, false, false);
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionImpl $this$apply = irFunctionImpl;
        boolean bl3 = false;
        staticInitializerDescriptor.bind((IrDeclaration)$this$apply);
        Iterable iterable = staticInitializerStatements;
        int n3 = irClass.getEndOffset();
        int n4 = irClass.getStartOffset();
        IrFunctionImpl irFunctionImpl2 = $this$apply;
        boolean $i$f$map = false;
        void var17_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            IrStatement irStatement2 = Companion.copy((IrStatement)it, (IrDeclarationParent)irClass);
            collection.add(irStatement2);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        int n5 = n3;
        int n6 = n4;
        irFunctionImpl2.setBody(new IrBlockBodyImpl(n6, n5, list2));
        $this$apply.accept(SetDeclarationsParentVisitor.INSTANCE, $this$apply);
        $this$apply.setParent(irClass);
        IrFunctionImpl staticInitializer = irFunctionImpl;
        irClass.getDeclarations().add(staticInitializer);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrDeclarationOrigin getDeclarationOrigin() {
        return this.declarationOrigin;
    }

    public InitializersLowering(@NotNull CommonBackendContext context2, @NotNull IrDeclarationOrigin declarationOrigin, boolean clinitNeeded) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)declarationOrigin, (String)"declarationOrigin");
        this.context = context2;
        this.declarationOrigin = declarationOrigin;
        this.clinitNeeded = clinitNeeded;
    }

    static {
        Companion = new Companion(null);
        Name name2 = Name.special("<clinit>");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(\"<clinit>\")");
        clinitName = name2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u0007\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InitializersLowering$Companion;", "", "()V", "clinitName", "Lorg/jetbrains/kotlin/name/Name;", "getClinitName", "()Lorg/jetbrains/kotlin/name/Name;", "copy", "Lorg/jetbrains/kotlin/ir/IrStatement;", "containingDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
    public static final class Companion {
        @NotNull
        public final Name getClinitName() {
            return clinitName;
        }

        @NotNull
        public final IrStatement copy(@NotNull IrStatement $this$copy, @NotNull IrDeclarationParent containingDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)$this$copy, (String)"$this$copy");
            Intrinsics.checkParameterIsNotNull((Object)containingDeclaration, (String)"containingDeclaration");
            IrElement $this$deepCopyWithSymbols$iv = $this$copy;
            DescriptorsRemapper descriptorRemapper$iv = DescriptorsRemapper.Default.INSTANCE;
            boolean $i$f$deepCopyWithSymbols = false;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(descriptorRemapper$iv);
            IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols$iv, symbolRemapper$iv);
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
            IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents($this$deepCopyWithSymbols$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv, typeRemapper$iv, null, 4, null), null), containingDeclaration);
            if (irElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
            }
            return (IrStatement)irElement;
        }

        @NotNull
        public final IrExpression copy(@NotNull IrExpression $this$copy, @NotNull IrDeclarationParent containingDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)$this$copy, (String)"$this$copy");
            Intrinsics.checkParameterIsNotNull((Object)containingDeclaration, (String)"containingDeclaration");
            IrElement $this$deepCopyWithSymbols$iv = $this$copy;
            DescriptorsRemapper descriptorRemapper$iv = DescriptorsRemapper.Default.INSTANCE;
            boolean $i$f$deepCopyWithSymbols = false;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(descriptorRemapper$iv);
            IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols$iv, symbolRemapper$iv);
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
            IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents($this$deepCopyWithSymbols$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv, typeRemapper$iv, null, 4, null), null), containingDeclaration);
            if (irElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            }
            return (IrExpression)irElement;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

