/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.ex;

import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementContainer;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.JpsElementParameterizedCreator;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementContainerEx;

public class JpsElementContainerImpl
extends JpsElementContainerEx
implements JpsElementContainer {
    private final Map<JpsElementChildRole<?>, JpsElement> myElements;
    @NotNull
    private final JpsCompositeElementBase<?> myParent;

    public JpsElementContainerImpl(@NotNull JpsCompositeElementBase<?> parent2) {
        if (parent2 == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(0);
        }
        this.myElements = new THashMap(1);
        this.myParent = parent2;
    }

    public JpsElementContainerImpl(@NotNull JpsElementContainerEx original, @NotNull JpsCompositeElementBase<?> parent2) {
        if (original == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(1);
        }
        if (parent2 == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(2);
        }
        this.myElements = new THashMap(1);
        this.myParent = parent2;
        for (Map.Entry<JpsElementChildRole<?>, JpsElement> entry : original.getElementsMap().entrySet()) {
            JpsElementChildRole<?> role = entry.getKey();
            Object copy2 = entry.getValue().getBulkModificationSupport().createCopy();
            JpsElementBase.setParent(copy2, this.myParent);
            this.myElements.put(role, (JpsElement)copy2);
        }
    }

    @Override
    public <T extends JpsElement> T getChild(@NotNull JpsElementChildRole<T> role) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(3);
        }
        return (T)this.myElements.get(role);
    }

    @Override
    @NotNull
    public <T extends JpsElement, P, K extends JpsElementChildRole<T>> T setChild(@NotNull K role, @NotNull P param) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(4);
        }
        if (param == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(5);
        }
        Object child = ((JpsElementParameterizedCreator)((Object)role)).create(param);
        Object e = this.setChild((JpsElementChildRole<T>)role, (T)child);
        if (e == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(6);
        }
        return (T)e;
    }

    @Override
    @NotNull
    public <T extends JpsElement, K extends JpsElementChildRole<T>> T setChild(@NotNull K role) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(7);
        }
        Object child = ((JpsElementCreator)((Object)role)).create();
        Object e = this.setChild((JpsElementChildRole<T>)role, (T)child);
        if (e == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(8);
        }
        return (T)e;
    }

    @Override
    @NotNull
    public <T extends JpsElement, K extends JpsElementChildRole<T>> T getOrSetChild(@NotNull K role) {
        T child;
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(9);
        }
        if ((child = this.getChild(role)) == null) {
            T t = this.setChild(role);
            if (t == null) {
                JpsElementContainerImpl.$$$reportNull$$$0(10);
            }
            return t;
        }
        T t = child;
        if (t == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(11);
        }
        return t;
    }

    @Override
    public <T extends JpsElement> T setChild(JpsElementChildRole<T> role, T child) {
        this.myElements.put(role, child);
        JpsElementBase.setParent(child, this.myParent);
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementAdded(child, role);
        }
        return child;
    }

    @Override
    public <T extends JpsElement> void removeChild(@NotNull JpsElementChildRole<T> role) {
        JpsElement removed2;
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(12);
        }
        if ((removed2 = this.myElements.remove(role)) == null) {
            return;
        }
        JpsEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.fireElementRemoved(removed2, role);
        }
        JpsElementBase.setParent(removed2, null);
    }

    @Override
    protected Map<JpsElementChildRole<?>, JpsElement> getElementsMap() {
        return this.myElements;
    }

    @Override
    public void applyChanges(@NotNull JpsElementContainerEx modified) {
        if (modified == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(13);
        }
        for (JpsElementChildRole<?> role : this.myElements.keySet()) {
            this.applyChanges(role, modified);
        }
        for (JpsElementChildRole<?> role : modified.getElementsMap().keySet()) {
            if (this.myElements.containsKey(role)) continue;
            this.applyChanges(role, modified);
        }
    }

    private <T extends JpsElement> void applyChanges(JpsElementChildRole<T> role, JpsElementContainerEx modified) {
        T child = this.getChild(role);
        T modifiedChild = modified.getChild(role);
        if (child != null && modifiedChild != null) {
            JpsElement.BulkModificationSupport<?> modificationSupport = child.getBulkModificationSupport();
            modificationSupport.applyChanges(modifiedChild);
        } else if (modifiedChild == null) {
            this.removeChild(role);
        } else {
            this.setChild(role, (T)modifiedChild.getBulkModificationSupport().createCopy());
        }
    }

    @Nullable
    private JpsEventDispatcher getEventDispatcher() {
        return this.myParent.getEventDispatcher();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/ex/JpsElementContainerImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/ex/JpsElementContainerImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setChild";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrSetChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setChild";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrSetChild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

