/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.data;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;

public abstract class KtClassOrObjectInfo<E extends KtClassOrObject>
implements KtClassLikeInfo {
    protected final E element;

    protected KtClassOrObjectInfo(@NotNull E element) {
        this.element = element;
    }

    @Nullable
    public Name getName() {
        return ((KtTypeParameterListOwnerStub)this.element).getNameAsName();
    }

    @Override
    @NotNull
    public KtClassOrObject getCorrespondingClassOrObject() {
        return this.element;
    }

    @Override
    @Nullable
    public KtModifierList getModifierList() {
        return ((KtModifierListOwnerStub)this.element).getModifierList();
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        return ((KtClassOrObject)this.element).getDeclarations();
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        KtClassBody body = ((KtClassOrObject)this.element).getBody();
        if (body == null) {
            return Collections.emptyList();
        }
        return body.getAllCompanionObjects();
    }

    @Override
    @NotNull
    public PsiElement getScopeAnchor() {
        return this.element;
    }

    @Override
    @NotNull
    public FqName getContainingPackageFqName() {
        PsiFile file2 = this.element.getContainingFile();
        if (file2 instanceof KtFile) {
            KtFile jetFile = (KtFile)file2;
            return jetFile.getPackageFqName();
        }
        throw new IllegalArgumentException("Not in a KtFile: " + this.element);
    }

    @Override
    @NotNull
    public List<KtAnnotationEntry> getDanglingAnnotations() {
        KtClassBody body = ((KtClassOrObject)this.element).getBody();
        return body == null ? Collections.emptyList() : body.getDanglingAnnotations();
    }

    @Override
    @NotNull
    public List<? extends KtParameter> getPrimaryConstructorParameters() {
        return ((KtClassOrObject)this.element).getPrimaryConstructorParameters();
    }

    public String toString() {
        return "info for " + this.element.getText();
    }
}

