/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaArrayTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPrimitiveTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaWildcardTypeImpl;
import org.jetbrains.kotlin.name.FqName;

public abstract class JavaTypeImpl<Psi extends PsiType>
implements JavaType,
JavaAnnotationOwnerImpl {
    private final Psi psiType;

    public JavaTypeImpl(@NotNull Psi psiType) {
        this.psiType = psiType;
    }

    @NotNull
    public Psi getPsi() {
        return this.psiType;
    }

    @Override
    @Nullable
    public PsiAnnotationOwner getAnnotationOwnerPsi() {
        return this.getPsi();
    }

    @NotNull
    public static JavaTypeImpl<?> create(@NotNull PsiType psiType) {
        return (JavaTypeImpl)psiType.accept(new PsiTypeVisitor<JavaTypeImpl<?>>(){

            @Nullable
            public JavaTypeImpl<?> visitType(@NotNull PsiType type2) {
                throw new UnsupportedOperationException("Unsupported PsiType: " + type2);
            }

            @Nullable
            public JavaTypeImpl<?> visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                return new JavaPrimitiveTypeImpl(primitiveType);
            }

            @Nullable
            public JavaTypeImpl<?> visitArrayType(@NotNull PsiArrayType arrayType) {
                return new JavaArrayTypeImpl(arrayType);
            }

            @Nullable
            public JavaTypeImpl<?> visitClassType(@NotNull PsiClassType classType) {
                return new JavaClassifierTypeImpl(classType);
            }

            @Nullable
            public JavaTypeImpl<?> visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                return new JavaWildcardTypeImpl(wildcardType);
            }
        });
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        return JavaElementUtil.getAnnotations(this);
    }

    @Override
    @Nullable
    public JavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        return JavaElementUtil.findAnnotation(this, fqName2);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }

    public int hashCode() {
        return this.getPsi().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaTypeImpl && this.getPsi().equals(((JavaTypeImpl)obj).getPsi());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getPsi();
    }
}

