/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class JsAstUtils {
    private static final JsNameRef DEFINE_PROPERTY = JsAstUtils.pureFqn("defineProperty", null);
    private static final JsNameRef VALUE = new JsNameRef("value");
    private static final JsPropertyInitializer WRITABLE = new JsPropertyInitializer(JsAstUtils.pureFqn("writable", null), new JsBooleanLiteral(true));
    private static final JsPropertyInitializer ENUMERABLE = new JsPropertyInitializer(JsAstUtils.pureFqn("enumerable", null), new JsBooleanLiteral(false));

    private JsAstUtils() {
    }

    @NotNull
    public static JsStatement convertToStatement(@NotNull JsNode jsNode) {
        assert (jsNode instanceof JsExpression || jsNode instanceof JsStatement) : "Unexpected node of type: " + jsNode.getClass().toString();
        if (jsNode instanceof JsExpression) {
            JsExpression expression2 = (JsExpression)jsNode;
            JsExpressionStatement statement2 = new JsExpressionStatement(expression2);
            if (expression2 instanceof JsNullLiteral || MetadataProperties.getSynthetic(expression2)) {
                MetadataProperties.setSynthetic(statement2, true);
            }
            return statement2;
        }
        return (JsStatement)jsNode;
    }

    @NotNull
    public static JsBlock convertToBlock(@NotNull JsNode jsNode) {
        if (jsNode instanceof JsBlock) {
            return (JsBlock)jsNode;
        }
        JsBlock block = new JsBlock();
        block.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        return block;
    }

    @NotNull
    private static JsStatement deBlockIfPossible(@NotNull JsStatement statement2) {
        if (statement2 instanceof JsBlock && ((JsBlock)statement2).getStatements().size() == 1) {
            return ((JsBlock)statement2).getStatements().get(0);
        }
        return statement2;
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement, @Nullable JsStatement elseStatement) {
        elseStatement = elseStatement != null ? JsAstUtils.deBlockIfPossible(elseStatement) : null;
        return new JsIf(ifExpression, JsAstUtils.deBlockIfPossible(thenStatement), elseStatement);
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement) {
        return JsAstUtils.newJsIf(ifExpression, thenStatement, null);
    }

    @Nullable
    public static JsExpression extractExpressionFromStatement(@Nullable JsStatement statement2) {
        return statement2 instanceof JsExpressionStatement ? ((JsExpressionStatement)statement2).getExpression() : null;
    }

    @NotNull
    public static JsStatement mergeStatementInBlockIfNeeded(@NotNull JsStatement statement2, @NotNull JsBlock block) {
        if (block.isEmpty()) {
            return statement2;
        }
        if (JsAstUtils.isEmptyStatement(statement2)) {
            return JsAstUtils.deBlockIfPossible(block);
        }
        block.getStatements().add(statement2);
        return block;
    }

    public static boolean isEmptyStatement(@NotNull JsStatement statement2) {
        return statement2 instanceof JsEmpty;
    }

    @NotNull
    public static JsInvocation invokeKotlinFunction(@NotNull String name, JsExpression ... argument) {
        return JsAstUtils.invokeMethod(Namer.kotlinObject(), name, argument);
    }

    @NotNull
    public static JsInvocation invokeMethod(@NotNull JsExpression thisObject, @NotNull String name, JsExpression ... arguments2) {
        return new JsInvocation((JsExpression)JsAstUtils.pureFqn(name, thisObject), arguments2);
    }

    @NotNull
    public static JsExpression toInt32(@NotNull JsExpression expression2) {
        return new JsBinaryOperation(JsBinaryOperator.BIT_OR, expression2, new JsIntLiteral(0));
    }

    @Nullable
    public static JsExpression extractToInt32Argument(@NotNull JsExpression expression2) {
        if (!(expression2 instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expression2;
        if (binary.getOperator() != JsBinaryOperator.BIT_OR) {
            return null;
        }
        if (!(binary.getArg2() instanceof JsIntLiteral)) {
            return null;
        }
        JsIntLiteral arg2 = (JsIntLiteral)binary.getArg2();
        return arg2.value == 0 ? binary.getArg1() : null;
    }

    @NotNull
    public static JsExpression charToInt(@NotNull JsExpression expression2) {
        return JsAstUtils.toInt32(expression2);
    }

    @NotNull
    public static JsExpression charToString(@NotNull JsExpression expression2) {
        return new JsInvocation((JsExpression)new JsNameRef("fromCharCode", (JsExpression)new JsNameRef("String")), expression2);
    }

    @NotNull
    public static JsExpression compareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        return JsAstUtils.invokeKotlinFunction(OperatorNameConventions.COMPARE_TO.getIdentifier(), left, right);
    }

    @NotNull
    public static JsExpression primitiveCompareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        return JsAstUtils.invokeKotlinFunction("primitiveCompareTo", left, right);
    }

    public static JsExpression newLong(long value) {
        JsExpression result2;
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            if (value == Long.MAX_VALUE) {
                return new JsNameRef("MAX_VALUE", (JsExpression)Namer.kotlinLong());
            }
            if (value == Long.MIN_VALUE) {
                return new JsNameRef("MIN_VALUE", (JsExpression)Namer.kotlinLong());
            }
            int low = (int)value;
            int high = (int)(value >> 32);
            SmartList args = new SmartList();
            args.add(new JsIntLiteral(low));
            args.add(new JsIntLiteral(high));
            result2 = new JsNew(Namer.kotlinLong(), (List<? extends JsExpression>)args);
        } else {
            result2 = value == 0L ? new JsNameRef("ZERO", (JsExpression)Namer.kotlinLong()) : (value == 1L ? new JsNameRef("ONE", (JsExpression)Namer.kotlinLong()) : (value == -1L ? new JsNameRef("NEG_ONE", (JsExpression)Namer.kotlinLong()) : JsAstUtils.longFromInt(new JsIntLiteral((int)value))));
        }
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        return result2;
    }

    @NotNull
    public static JsExpression longFromInt(@NotNull JsExpression expression2) {
        return JsAstUtils.invokeMethod(Namer.kotlinLong(), "fromInt", expression2);
    }

    @NotNull
    public static JsExpression longFromNumber(@NotNull JsExpression expression2) {
        return JsAstUtils.invokeMethod(Namer.kotlinLong(), "fromNumber", expression2);
    }

    @NotNull
    public static JsExpression longToNumber(@NotNull JsExpression expression2) {
        return JsAstUtils.invokeMethod(expression2, "toNumber", new JsExpression[0]);
    }

    @NotNull
    public static JsExpression compareForObject(@NotNull JsExpression left, @NotNull JsExpression right) {
        return JsAstUtils.invokeMethod(left, Namer.COMPARE_TO_METHOD_NAME, right);
    }

    @NotNull
    public static JsExpression notOptimized(@NotNull JsExpression expression2) {
        if (expression2 instanceof JsUnaryOperation) {
            JsUnaryOperation unary = (JsUnaryOperation)expression2;
            if (unary.getOperator() == JsUnaryOperator.NOT) {
                return unary.getArg();
            }
        } else if (expression2 instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)expression2;
            switch (binary.getOperator()) {
                case AND: {
                    return JsAstUtils.or(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                }
                case OR: {
                    return JsAstUtils.and(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                }
                case EQ: {
                    return new JsBinaryOperation(JsBinaryOperator.NEQ, binary.getArg1(), binary.getArg2());
                }
                case NEQ: {
                    return new JsBinaryOperation(JsBinaryOperator.EQ, binary.getArg1(), binary.getArg2());
                }
                case REF_EQ: {
                    return JsAstUtils.inequality(binary.getArg1(), binary.getArg2());
                }
                case REF_NEQ: {
                    return JsAstUtils.equality(binary.getArg1(), binary.getArg2());
                }
                case LT: {
                    return JsAstUtils.greaterThanEq(binary.getArg1(), binary.getArg2());
                }
                case LTE: {
                    return JsAstUtils.greaterThan(binary.getArg1(), binary.getArg2());
                }
                case GT: {
                    return JsAstUtils.lessThanEq(binary.getArg1(), binary.getArg2());
                }
                case GTE: {
                    return JsAstUtils.lessThan(binary.getArg1(), binary.getArg2());
                }
            }
        }
        return JsAstUtils.not(expression2);
    }

    @NotNull
    public static JsBinaryOperation and(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        return new JsBinaryOperation(JsBinaryOperator.AND, op1, op2);
    }

    @NotNull
    public static JsBinaryOperation or(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        return new JsBinaryOperation(JsBinaryOperator.OR, op1, op2);
    }

    private static void setQualifier(@NotNull JsExpression selector, @Nullable JsExpression receiver) {
        assert (selector instanceof JsInvocation || selector instanceof JsNameRef);
        if (selector instanceof JsInvocation) {
            JsAstUtils.setQualifier(((JsInvocation)selector).getQualifier(), receiver);
            return;
        }
        JsAstUtils.setQualifierForNameRef((JsNameRef)selector, receiver);
    }

    private static void setQualifierForNameRef(@NotNull JsNameRef selector, @Nullable JsExpression receiver) {
        JsExpression qualifier = selector.getQualifier();
        if (qualifier == null) {
            selector.setQualifier(receiver);
        } else {
            JsAstUtils.setQualifier(qualifier, receiver);
        }
    }

    @NotNull
    public static JsBinaryOperation equality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        return new JsBinaryOperation(JsBinaryOperator.REF_EQ, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation inequality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        return new JsBinaryOperation(JsBinaryOperator.REF_NEQ, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation lessThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        return new JsBinaryOperation(JsBinaryOperator.LTE, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation lessThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        return new JsBinaryOperation(JsBinaryOperator.LT, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation greaterThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        return new JsBinaryOperation(JsBinaryOperator.GT, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation greaterThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        return new JsBinaryOperation(JsBinaryOperator.GTE, arg1, arg2);
    }

    @NotNull
    public static JsBinaryOperation assignment(@NotNull JsExpression left, @NotNull JsExpression right) {
        return new JsBinaryOperation(JsBinaryOperator.ASG, left, right);
    }

    @NotNull
    public static JsStatement assignmentToThisField(@NotNull String fieldName, @NotNull JsExpression right) {
        return JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), right).source(right.getSource()).makeStmt();
    }

    public static JsStatement asSyntheticStatement(@NotNull JsExpression expression2) {
        JsExpressionStatement statement2 = new JsExpressionStatement(expression2);
        MetadataProperties.setSynthetic(statement2, true);
        return statement2;
    }

    @Nullable
    public static Pair<JsExpression, JsExpression> decomposeAssignment(@NotNull JsExpression expr) {
        if (!(expr instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expr;
        if (binary.getOperator() != JsBinaryOperator.ASG) {
            return null;
        }
        return new Pair((Object)binary.getArg1(), (Object)binary.getArg2());
    }

    @Nullable
    public static Pair<JsName, JsExpression> decomposeAssignmentToVariable(@NotNull JsExpression expr) {
        Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(expr);
        if (assignment == null || !(assignment.getFirst() instanceof JsNameRef)) {
            return null;
        }
        JsNameRef nameRef = (JsNameRef)assignment.getFirst();
        if (nameRef.getName() == null || nameRef.getQualifier() != null) {
            return null;
        }
        return new Pair((Object)nameRef.getName(), assignment.getSecond());
    }

    @NotNull
    public static JsBinaryOperation sum(@NotNull JsExpression left, @NotNull JsExpression right) {
        return new JsBinaryOperation(JsBinaryOperator.ADD, left, right);
    }

    @NotNull
    public static JsBinaryOperation addAssign(@NotNull JsExpression left, @NotNull JsExpression right) {
        return new JsBinaryOperation(JsBinaryOperator.ASG_ADD, left, right);
    }

    @NotNull
    public static JsBinaryOperation subtract(@NotNull JsExpression left, @NotNull JsExpression right) {
        return new JsBinaryOperation(JsBinaryOperator.SUB, left, right);
    }

    @NotNull
    public static JsBinaryOperation mul(@NotNull JsExpression left, @NotNull JsExpression right) {
        return new JsBinaryOperation(JsBinaryOperator.MUL, left, right);
    }

    @NotNull
    public static JsBinaryOperation div(@NotNull JsExpression left, @NotNull JsExpression right) {
        return new JsBinaryOperation(JsBinaryOperator.DIV, left, right);
    }

    @NotNull
    public static JsBinaryOperation mod(@NotNull JsExpression left, @NotNull JsExpression right) {
        return new JsBinaryOperation(JsBinaryOperator.MOD, left, right);
    }

    @NotNull
    public static JsPrefixOperation not(@NotNull JsExpression expression2) {
        return new JsPrefixOperation(JsUnaryOperator.NOT, expression2);
    }

    @NotNull
    public static JsBinaryOperation typeOfIs(@NotNull JsExpression expression2, @NotNull JsStringLiteral string) {
        return JsAstUtils.equality(new JsPrefixOperation(JsUnaryOperator.TYPEOF, expression2), string);
    }

    @NotNull
    public static JsVars newVar(@NotNull JsName name, @Nullable JsExpression expr) {
        return new JsVars(new JsVars.JsVar(name, expr));
    }

    @NotNull
    public static JsExpression newSequence(@NotNull List<JsExpression> expressions) {
        assert (!expressions.isEmpty());
        if (expressions.size() == 1) {
            return expressions.get(0);
        }
        JsExpression result2 = expressions.get(0);
        for (int i = 1; i < expressions.size(); ++i) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, result2, expressions.get(i));
        }
        return result2;
    }

    @NotNull
    public static JsFunction createFunctionWithEmptyBody(@NotNull JsScope parent2) {
        return new JsFunction(parent2, new JsBlock(), "<anonymous>");
    }

    @NotNull
    public static List<JsExpression> toStringLiteralList(@NotNull List<String> strings) {
        if (strings.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        for (String str : strings) {
            result2.add(new JsStringLiteral(str));
        }
        return result2;
    }

    @NotNull
    public static JsInvocation defineProperty(@NotNull JsExpression receiver, @NotNull String name, @NotNull JsExpression value) {
        return new JsInvocation((JsExpression)DEFINE_PROPERTY.deepCopy(), receiver, new JsStringLiteral(name), value);
    }

    @NotNull
    public static JsStatement defineSimpleProperty(@NotNull JsName name, @NotNull JsExpression value, @Nullable SourceElement source) {
        JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef(name, (JsExpression)new JsThisRef()), value);
        if (source != null) {
            assignment.setSource(KotlinSourceElementKt.getPsi(source));
        }
        return assignment.makeStmt();
    }

    @NotNull
    public static JsObjectLiteral createDataDescriptor(@NotNull JsExpression value, boolean writable, boolean enumerable) {
        JsObjectLiteral dataDescriptor = new JsObjectLiteral();
        dataDescriptor.getPropertyInitializers().add(new JsPropertyInitializer(VALUE.deepCopy(), value));
        if (writable) {
            dataDescriptor.getPropertyInitializers().add(WRITABLE.deepCopy());
        }
        if (enumerable) {
            dataDescriptor.getPropertyInitializers().add(ENUMERABLE.deepCopy());
        }
        return dataDescriptor;
    }

    @NotNull
    public static JsObjectLiteral wrapValue(@NotNull JsExpression label, @NotNull JsExpression value) {
        return new JsObjectLiteral(Collections.singletonList(new JsPropertyInitializer(label, value)));
    }

    @NotNull
    public static List<JsStatement> flattenStatement(@NotNull JsStatement statement2) {
        if (statement2 instanceof JsBlock) {
            return ((JsBlock)statement2).getStatements();
        }
        return new SmartList((Object)statement2);
    }

    @NotNull
    public static JsNameRef pureFqn(@NotNull String identifier, @Nullable JsExpression qualifier) {
        JsNameRef result2 = new JsNameRef(identifier, qualifier);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        return result2;
    }

    @NotNull
    public static JsNameRef pureFqn(@NotNull JsName identifier, @Nullable JsExpression qualifier) {
        JsNameRef result2 = new JsNameRef(identifier, qualifier);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        return result2;
    }

    @NotNull
    public static JsInvocation invokeBind(@NotNull JsExpression receiver, @NotNull JsExpression method) {
        return JsAstUtils.invokeMethod(method, "bind", receiver);
    }

    public static boolean isUndefinedExpression(JsExpression expression2) {
        if (!(expression2 instanceof JsUnaryOperation)) {
            return false;
        }
        JsUnaryOperation unary = (JsUnaryOperation)expression2;
        return unary.getOperator() == JsUnaryOperator.VOID;
    }

    @NotNull
    public static JsExpression defineGetter(@NotNull JsExpression receiver, @NotNull String name, @NotNull JsExpression body) {
        JsObjectLiteral propertyLiteral = new JsObjectLiteral(true);
        propertyLiteral.getPropertyInitializers().add(new JsPropertyInitializer(new JsNameRef("get"), body));
        return JsAstUtils.defineProperty(receiver, name, propertyLiteral);
    }

    @NotNull
    public static JsExpression prototypeOf(@NotNull JsExpression expression2) {
        return JsAstUtils.pureFqn("prototype", expression2);
    }

    @NotNull
    public static JsExpression stateMachineReceiver() {
        JsNameRef result2 = JsAstUtils.pureFqn("$this$", null);
        MetadataProperties.setCoroutineReceiver(result2, true);
        return result2;
    }

    static {
        JsNameRef globalObjectReference = new JsNameRef("Object");
        DEFINE_PROPERTY.setQualifier(globalObjectReference);
    }
}

